package com.hashicorp.cdktf.providers.google;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-12T00:46:06.077Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.HealthcareFhirStoreConfig")
@software.amazon.jsii.Jsii.Proxy(HealthcareFhirStoreConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HealthcareFhirStoreConfig extends software.amazon.jsii.JsiiSerializable, com.hashicorp.cdktf.TerraformMetaArguments {

    /**
     * Identifies the dataset addressed by this request. Must be in the format 'projects/{project}/locations/{location}/datasets/{dataset}'.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#dataset HealthcareFhirStore#dataset}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDataset();

    /**
     * The resource name for the FhirStore.
     * <p>
     * <ul>
     * <li>Changing this property may recreate the FHIR store (removing all data) **</li>
     * </ul>
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#name HealthcareFhirStore#name}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The FHIR specification version. Possible values: ["DSTU2", "STU3", "R4"].
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#version HealthcareFhirStore#version}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVersion();

    /**
     * Whether to disable referential integrity in this FHIR store.
     * <p>
     * This field is immutable after FHIR store
     * creation. The default value is false, meaning that the API will enforce referential integrity and fail the
     * requests that will result in inconsistent state in the FHIR store. When this field is set to true, the API
     * will skip referential integrity check. Consequently, operations that rely on references, such as
     * Patient.get$everything, will not return all the results if broken references exist.
     * <p>
     * <ul>
     * <li>Changing this property may recreate the FHIR store (removing all data) **</li>
     * </ul>
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#disable_referential_integrity HealthcareFhirStore#disable_referential_integrity}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDisableReferentialIntegrity() {
        return null;
    }

    /**
     * Whether to disable resource versioning for this FHIR store.
     * <p>
     * This field can not be changed after the creation
     * of FHIR store. If set to false, which is the default behavior, all write operations will cause historical
     * versions to be recorded automatically. The historical versions can be fetched through the history APIs, but
     * cannot be updated. If set to true, no historical versions will be kept. The server will send back errors for
     * attempts to read the historical versions.
     * <p>
     * <ul>
     * <li>Changing this property may recreate the FHIR store (removing all data) **</li>
     * </ul>
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#disable_resource_versioning HealthcareFhirStore#disable_resource_versioning}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDisableResourceVersioning() {
        return null;
    }

    /**
     * Whether to allow the bulk import API to accept history bundles and directly insert historical resource versions into the FHIR store.
     * <p>
     * Importing resource histories creates resource interactions that appear to have
     * occurred in the past, which clients may not want to allow. If set to false, history bundles within an import
     * will fail with an error.
     * <p>
     * <ul>
     * <li>Changing this property may recreate the FHIR store (removing all data) **</li>
     * <li>This property can be changed manually in the Google Cloud Healthcare admin console without recreating the FHIR store **</li>
     * </ul>
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#enable_history_import HealthcareFhirStore#enable_history_import}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableHistoryImport() {
        return null;
    }

    /**
     * Whether this FHIR store has the updateCreate capability.
     * <p>
     * This determines if the client can use an Update
     * operation to create a new resource with a client-specified ID. If false, all IDs are server-assigned through
     * the Create operation and attempts to Update a non-existent resource will return errors. Please treat the audit
     * logs with appropriate levels of care if client-specified resource IDs contain sensitive data such as patient
     * identifiers, those IDs will be part of the FHIR resource path recorded in Cloud audit logs and Cloud Pub/Sub
     * notifications.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#enable_update_create HealthcareFhirStore#enable_update_create}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableUpdateCreate() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#id HealthcareFhirStore#id}.
     * <p>
     * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
     * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getId() {
        return null;
    }

    /**
     * User-supplied key-value pairs used to organize FHIR stores.
     * <p>
     * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
     * conform to the following PCRE regular expression: [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
     * <p>
     * Label values are optional, must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128
     * bytes, and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}
     * <p>
     * No more than 64 labels can be associated with a given store.
     * <p>
     * An object containing a list of "key": value pairs.
     * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#labels HealthcareFhirStore#labels}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getLabels() {
        return null;
    }

    /**
     * notification_config block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#notification_config HealthcareFhirStore#notification_config}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.HealthcareFhirStoreNotificationConfig getNotificationConfig() {
        return null;
    }

    /**
     * stream_configs block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#stream_configs HealthcareFhirStore#stream_configs}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStreamConfigs() {
        return null;
    }

    /**
     * timeouts block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#timeouts HealthcareFhirStore#timeouts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.HealthcareFhirStoreTimeouts getTimeouts() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HealthcareFhirStoreConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HealthcareFhirStoreConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HealthcareFhirStoreConfig> {
        java.lang.String dataset;
        java.lang.String name;
        java.lang.String version;
        java.lang.Object disableReferentialIntegrity;
        java.lang.Object disableResourceVersioning;
        java.lang.Object enableHistoryImport;
        java.lang.Object enableUpdateCreate;
        java.lang.String id;
        java.util.Map<java.lang.String, java.lang.String> labels;
        com.hashicorp.cdktf.providers.google.HealthcareFhirStoreNotificationConfig notificationConfig;
        java.lang.Object streamConfigs;
        com.hashicorp.cdktf.providers.google.HealthcareFhirStoreTimeouts timeouts;
        java.lang.Object connection;
        java.lang.Number count;
        java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        com.hashicorp.cdktf.ITerraformIterator forEach;
        com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        com.hashicorp.cdktf.TerraformProvider provider;
        java.util.List<java.lang.Object> provisioners;

        /**
         * Sets the value of {@link HealthcareFhirStoreConfig#getDataset}
         * @param dataset Identifies the dataset addressed by this request. Must be in the format 'projects/{project}/locations/{location}/datasets/{dataset}'. This parameter is required.
         *                Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#dataset HealthcareFhirStore#dataset}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataset(java.lang.String dataset) {
            this.dataset = dataset;
            return this;
        }

        /**
         * Sets the value of {@link HealthcareFhirStoreConfig#getName}
         * @param name The resource name for the FhirStore. This parameter is required.
         *             <ul>
         *             <li>Changing this property may recreate the FHIR store (removing all data) **</li>
         *             </ul>
         *             <p>
         *             Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#name HealthcareFhirStore#name}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link HealthcareFhirStoreConfig#getVersion}
         * @param version The FHIR specification version. Possible values: ["DSTU2", "STU3", "R4"]. This parameter is required.
         *                Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#version HealthcareFhirStore#version}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(java.lang.String version) {
            this.version = version;
            return this;
        }

        /**
         * Sets the value of {@link HealthcareFhirStoreConfig#getDisableReferentialIntegrity}
         * @param disableReferentialIntegrity Whether to disable referential integrity in this FHIR store.
         *                                    This field is immutable after FHIR store
         *                                    creation. The default value is false, meaning that the API will enforce referential integrity and fail the
         *                                    requests that will result in inconsistent state in the FHIR store. When this field is set to true, the API
         *                                    will skip referential integrity check. Consequently, operations that rely on references, such as
         *                                    Patient.get$everything, will not return all the results if broken references exist.
         *                                    <p>
         *                                    <ul>
         *                                    <li>Changing this property may recreate the FHIR store (removing all data) **</li>
         *                                    </ul>
         *                                    <p>
         *                                    Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#disable_referential_integrity HealthcareFhirStore#disable_referential_integrity}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableReferentialIntegrity(java.lang.Boolean disableReferentialIntegrity) {
            this.disableReferentialIntegrity = disableReferentialIntegrity;
            return this;
        }

        /**
         * Sets the value of {@link HealthcareFhirStoreConfig#getDisableReferentialIntegrity}
         * @param disableReferentialIntegrity Whether to disable referential integrity in this FHIR store.
         *                                    This field is immutable after FHIR store
         *                                    creation. The default value is false, meaning that the API will enforce referential integrity and fail the
         *                                    requests that will result in inconsistent state in the FHIR store. When this field is set to true, the API
         *                                    will skip referential integrity check. Consequently, operations that rely on references, such as
         *                                    Patient.get$everything, will not return all the results if broken references exist.
         *                                    <p>
         *                                    <ul>
         *                                    <li>Changing this property may recreate the FHIR store (removing all data) **</li>
         *                                    </ul>
         *                                    <p>
         *                                    Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#disable_referential_integrity HealthcareFhirStore#disable_referential_integrity}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableReferentialIntegrity(com.hashicorp.cdktf.IResolvable disableReferentialIntegrity) {
            this.disableReferentialIntegrity = disableReferentialIntegrity;
            return this;
        }

        /**
         * Sets the value of {@link HealthcareFhirStoreConfig#getDisableResourceVersioning}
         * @param disableResourceVersioning Whether to disable resource versioning for this FHIR store.
         *                                  This field can not be changed after the creation
         *                                  of FHIR store. If set to false, which is the default behavior, all write operations will cause historical
         *                                  versions to be recorded automatically. The historical versions can be fetched through the history APIs, but
         *                                  cannot be updated. If set to true, no historical versions will be kept. The server will send back errors for
         *                                  attempts to read the historical versions.
         *                                  <p>
         *                                  <ul>
         *                                  <li>Changing this property may recreate the FHIR store (removing all data) **</li>
         *                                  </ul>
         *                                  <p>
         *                                  Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#disable_resource_versioning HealthcareFhirStore#disable_resource_versioning}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableResourceVersioning(java.lang.Boolean disableResourceVersioning) {
            this.disableResourceVersioning = disableResourceVersioning;
            return this;
        }

        /**
         * Sets the value of {@link HealthcareFhirStoreConfig#getDisableResourceVersioning}
         * @param disableResourceVersioning Whether to disable resource versioning for this FHIR store.
         *                                  This field can not be changed after the creation
         *                                  of FHIR store. If set to false, which is the default behavior, all write operations will cause historical
         *                                  versions to be recorded automatically. The historical versions can be fetched through the history APIs, but
         *                                  cannot be updated. If set to true, no historical versions will be kept. The server will send back errors for
         *                                  attempts to read the historical versions.
         *                                  <p>
         *                                  <ul>
         *                                  <li>Changing this property may recreate the FHIR store (removing all data) **</li>
         *                                  </ul>
         *                                  <p>
         *                                  Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#disable_resource_versioning HealthcareFhirStore#disable_resource_versioning}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableResourceVersioning(com.hashicorp.cdktf.IResolvable disableResourceVersioning) {
            this.disableResourceVersioning = disableResourceVersioning;
            return this;
        }

        /**
         * Sets the value of {@link HealthcareFhirStoreConfig#getEnableHistoryImport}
         * @param enableHistoryImport Whether to allow the bulk import API to accept history bundles and directly insert historical resource versions into the FHIR store.
         *                            Importing resource histories creates resource interactions that appear to have
         *                            occurred in the past, which clients may not want to allow. If set to false, history bundles within an import
         *                            will fail with an error.
         *                            <p>
         *                            <ul>
         *                            <li>Changing this property may recreate the FHIR store (removing all data) **</li>
         *                            <li>This property can be changed manually in the Google Cloud Healthcare admin console without recreating the FHIR store **</li>
         *                            </ul>
         *                            <p>
         *                            Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#enable_history_import HealthcareFhirStore#enable_history_import}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableHistoryImport(java.lang.Boolean enableHistoryImport) {
            this.enableHistoryImport = enableHistoryImport;
            return this;
        }

        /**
         * Sets the value of {@link HealthcareFhirStoreConfig#getEnableHistoryImport}
         * @param enableHistoryImport Whether to allow the bulk import API to accept history bundles and directly insert historical resource versions into the FHIR store.
         *                            Importing resource histories creates resource interactions that appear to have
         *                            occurred in the past, which clients may not want to allow. If set to false, history bundles within an import
         *                            will fail with an error.
         *                            <p>
         *                            <ul>
         *                            <li>Changing this property may recreate the FHIR store (removing all data) **</li>
         *                            <li>This property can be changed manually in the Google Cloud Healthcare admin console without recreating the FHIR store **</li>
         *                            </ul>
         *                            <p>
         *                            Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#enable_history_import HealthcareFhirStore#enable_history_import}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableHistoryImport(com.hashicorp.cdktf.IResolvable enableHistoryImport) {
            this.enableHistoryImport = enableHistoryImport;
            return this;
        }

        /**
         * Sets the value of {@link HealthcareFhirStoreConfig#getEnableUpdateCreate}
         * @param enableUpdateCreate Whether this FHIR store has the updateCreate capability.
         *                           This determines if the client can use an Update
         *                           operation to create a new resource with a client-specified ID. If false, all IDs are server-assigned through
         *                           the Create operation and attempts to Update a non-existent resource will return errors. Please treat the audit
         *                           logs with appropriate levels of care if client-specified resource IDs contain sensitive data such as patient
         *                           identifiers, those IDs will be part of the FHIR resource path recorded in Cloud audit logs and Cloud Pub/Sub
         *                           notifications.
         *                           <p>
         *                           Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#enable_update_create HealthcareFhirStore#enable_update_create}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableUpdateCreate(java.lang.Boolean enableUpdateCreate) {
            this.enableUpdateCreate = enableUpdateCreate;
            return this;
        }

        /**
         * Sets the value of {@link HealthcareFhirStoreConfig#getEnableUpdateCreate}
         * @param enableUpdateCreate Whether this FHIR store has the updateCreate capability.
         *                           This determines if the client can use an Update
         *                           operation to create a new resource with a client-specified ID. If false, all IDs are server-assigned through
         *                           the Create operation and attempts to Update a non-existent resource will return errors. Please treat the audit
         *                           logs with appropriate levels of care if client-specified resource IDs contain sensitive data such as patient
         *                           identifiers, those IDs will be part of the FHIR resource path recorded in Cloud audit logs and Cloud Pub/Sub
         *                           notifications.
         *                           <p>
         *                           Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#enable_update_create HealthcareFhirStore#enable_update_create}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableUpdateCreate(com.hashicorp.cdktf.IResolvable enableUpdateCreate) {
            this.enableUpdateCreate = enableUpdateCreate;
            return this;
        }

        /**
         * Sets the value of {@link HealthcareFhirStoreConfig#getId}
         * @param id Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#id HealthcareFhirStore#id}.
         *           Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
         *           If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link HealthcareFhirStoreConfig#getLabels}
         * @param labels User-supplied key-value pairs used to organize FHIR stores.
         *               Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
         *               conform to the following PCRE regular expression: [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
         *               <p>
         *               Label values are optional, must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128
         *               bytes, and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}
         *               <p>
         *               No more than 64 labels can be associated with a given store.
         *               <p>
         *               An object containing a list of "key": value pairs.
         *               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
         *               <p>
         *               Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#labels HealthcareFhirStore#labels}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(java.util.Map<java.lang.String, java.lang.String> labels) {
            this.labels = labels;
            return this;
        }

        /**
         * Sets the value of {@link HealthcareFhirStoreConfig#getNotificationConfig}
         * @param notificationConfig notification_config block.
         *                           Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#notification_config HealthcareFhirStore#notification_config}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationConfig(com.hashicorp.cdktf.providers.google.HealthcareFhirStoreNotificationConfig notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        /**
         * Sets the value of {@link HealthcareFhirStoreConfig#getStreamConfigs}
         * @param streamConfigs stream_configs block.
         *                      Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#stream_configs HealthcareFhirStore#stream_configs}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamConfigs(com.hashicorp.cdktf.IResolvable streamConfigs) {
            this.streamConfigs = streamConfigs;
            return this;
        }

        /**
         * Sets the value of {@link HealthcareFhirStoreConfig#getStreamConfigs}
         * @param streamConfigs stream_configs block.
         *                      Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#stream_configs HealthcareFhirStore#stream_configs}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamConfigs(java.util.List<? extends com.hashicorp.cdktf.providers.google.HealthcareFhirStoreStreamConfigs> streamConfigs) {
            this.streamConfigs = streamConfigs;
            return this;
        }

        /**
         * Sets the value of {@link HealthcareFhirStoreConfig#getTimeouts}
         * @param timeouts timeouts block.
         *                 Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store#timeouts HealthcareFhirStore#timeouts}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeouts(com.hashicorp.cdktf.providers.google.HealthcareFhirStoreTimeouts timeouts) {
            this.timeouts = timeouts;
            return this;
        }

        /**
         * Sets the value of {@link HealthcareFhirStoreConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.SSHProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link HealthcareFhirStoreConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.WinrmProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link HealthcareFhirStoreConfig#getCount}
         * @param count the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder count(java.lang.Number count) {
            this.count = count;
            return this;
        }

        /**
         * Sets the value of {@link HealthcareFhirStoreConfig#getDependsOn}
         * @param dependsOn the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder dependsOn(java.util.List<? extends com.hashicorp.cdktf.ITerraformDependable> dependsOn) {
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)dependsOn;
            return this;
        }

        /**
         * Sets the value of {@link HealthcareFhirStoreConfig#getForEach}
         * @param forEach the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder forEach(com.hashicorp.cdktf.ITerraformIterator forEach) {
            this.forEach = forEach;
            return this;
        }

        /**
         * Sets the value of {@link HealthcareFhirStoreConfig#getLifecycle}
         * @param lifecycle the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lifecycle(com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        /**
         * Sets the value of {@link HealthcareFhirStoreConfig#getProvider}
         * @param provider the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder provider(com.hashicorp.cdktf.TerraformProvider provider) {
            this.provider = provider;
            return this;
        }

        /**
         * Sets the value of {@link HealthcareFhirStoreConfig#getProvisioners}
         * @param provisioners the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder provisioners(java.util.List<? extends java.lang.Object> provisioners) {
            this.provisioners = (java.util.List<java.lang.Object>)provisioners;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HealthcareFhirStoreConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HealthcareFhirStoreConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HealthcareFhirStoreConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HealthcareFhirStoreConfig {
        private final java.lang.String dataset;
        private final java.lang.String name;
        private final java.lang.String version;
        private final java.lang.Object disableReferentialIntegrity;
        private final java.lang.Object disableResourceVersioning;
        private final java.lang.Object enableHistoryImport;
        private final java.lang.Object enableUpdateCreate;
        private final java.lang.String id;
        private final java.util.Map<java.lang.String, java.lang.String> labels;
        private final com.hashicorp.cdktf.providers.google.HealthcareFhirStoreNotificationConfig notificationConfig;
        private final java.lang.Object streamConfigs;
        private final com.hashicorp.cdktf.providers.google.HealthcareFhirStoreTimeouts timeouts;
        private final java.lang.Object connection;
        private final java.lang.Number count;
        private final java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        private final com.hashicorp.cdktf.ITerraformIterator forEach;
        private final com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        private final com.hashicorp.cdktf.TerraformProvider provider;
        private final java.util.List<java.lang.Object> provisioners;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataset = software.amazon.jsii.Kernel.get(this, "dataset", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.disableReferentialIntegrity = software.amazon.jsii.Kernel.get(this, "disableReferentialIntegrity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.disableResourceVersioning = software.amazon.jsii.Kernel.get(this, "disableResourceVersioning", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enableHistoryImport = software.amazon.jsii.Kernel.get(this, "enableHistoryImport", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enableUpdateCreate = software.amazon.jsii.Kernel.get(this, "enableUpdateCreate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.labels = software.amazon.jsii.Kernel.get(this, "labels", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.notificationConfig = software.amazon.jsii.Kernel.get(this, "notificationConfig", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.HealthcareFhirStoreNotificationConfig.class));
            this.streamConfigs = software.amazon.jsii.Kernel.get(this, "streamConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.timeouts = software.amazon.jsii.Kernel.get(this, "timeouts", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.HealthcareFhirStoreTimeouts.class));
            this.connection = software.amazon.jsii.Kernel.get(this, "connection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.dependsOn = software.amazon.jsii.Kernel.get(this, "dependsOn", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformDependable.class)));
            this.forEach = software.amazon.jsii.Kernel.get(this, "forEach", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformIterator.class));
            this.lifecycle = software.amazon.jsii.Kernel.get(this, "lifecycle", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformResourceLifecycle.class));
            this.provider = software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformProvider.class));
            this.provisioners = software.amazon.jsii.Kernel.get(this, "provisioners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataset = java.util.Objects.requireNonNull(builder.dataset, "dataset is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.version = java.util.Objects.requireNonNull(builder.version, "version is required");
            this.disableReferentialIntegrity = builder.disableReferentialIntegrity;
            this.disableResourceVersioning = builder.disableResourceVersioning;
            this.enableHistoryImport = builder.enableHistoryImport;
            this.enableUpdateCreate = builder.enableUpdateCreate;
            this.id = builder.id;
            this.labels = builder.labels;
            this.notificationConfig = builder.notificationConfig;
            this.streamConfigs = builder.streamConfigs;
            this.timeouts = builder.timeouts;
            this.connection = builder.connection;
            this.count = builder.count;
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)builder.dependsOn;
            this.forEach = builder.forEach;
            this.lifecycle = builder.lifecycle;
            this.provider = builder.provider;
            this.provisioners = (java.util.List<java.lang.Object>)builder.provisioners;
        }

        @Override
        public final java.lang.String getDataset() {
            return this.dataset;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getVersion() {
            return this.version;
        }

        @Override
        public final java.lang.Object getDisableReferentialIntegrity() {
            return this.disableReferentialIntegrity;
        }

        @Override
        public final java.lang.Object getDisableResourceVersioning() {
            return this.disableResourceVersioning;
        }

        @Override
        public final java.lang.Object getEnableHistoryImport() {
            return this.enableHistoryImport;
        }

        @Override
        public final java.lang.Object getEnableUpdateCreate() {
            return this.enableUpdateCreate;
        }

        @Override
        public final java.lang.String getId() {
            return this.id;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getLabels() {
            return this.labels;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.HealthcareFhirStoreNotificationConfig getNotificationConfig() {
            return this.notificationConfig;
        }

        @Override
        public final java.lang.Object getStreamConfigs() {
            return this.streamConfigs;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.HealthcareFhirStoreTimeouts getTimeouts() {
            return this.timeouts;
        }

        @Override
        public final java.lang.Object getConnection() {
            return this.connection;
        }

        @Override
        public final java.lang.Number getCount() {
            return this.count;
        }

        @Override
        public final java.util.List<com.hashicorp.cdktf.ITerraformDependable> getDependsOn() {
            return this.dependsOn;
        }

        @Override
        public final com.hashicorp.cdktf.ITerraformIterator getForEach() {
            return this.forEach;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformResourceLifecycle getLifecycle() {
            return this.lifecycle;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformProvider getProvider() {
            return this.provider;
        }

        @Override
        public final java.util.List<java.lang.Object> getProvisioners() {
            return this.provisioners;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dataset", om.valueToTree(this.getDataset()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("version", om.valueToTree(this.getVersion()));
            if (this.getDisableReferentialIntegrity() != null) {
                data.set("disableReferentialIntegrity", om.valueToTree(this.getDisableReferentialIntegrity()));
            }
            if (this.getDisableResourceVersioning() != null) {
                data.set("disableResourceVersioning", om.valueToTree(this.getDisableResourceVersioning()));
            }
            if (this.getEnableHistoryImport() != null) {
                data.set("enableHistoryImport", om.valueToTree(this.getEnableHistoryImport()));
            }
            if (this.getEnableUpdateCreate() != null) {
                data.set("enableUpdateCreate", om.valueToTree(this.getEnableUpdateCreate()));
            }
            if (this.getId() != null) {
                data.set("id", om.valueToTree(this.getId()));
            }
            if (this.getLabels() != null) {
                data.set("labels", om.valueToTree(this.getLabels()));
            }
            if (this.getNotificationConfig() != null) {
                data.set("notificationConfig", om.valueToTree(this.getNotificationConfig()));
            }
            if (this.getStreamConfigs() != null) {
                data.set("streamConfigs", om.valueToTree(this.getStreamConfigs()));
            }
            if (this.getTimeouts() != null) {
                data.set("timeouts", om.valueToTree(this.getTimeouts()));
            }
            if (this.getConnection() != null) {
                data.set("connection", om.valueToTree(this.getConnection()));
            }
            if (this.getCount() != null) {
                data.set("count", om.valueToTree(this.getCount()));
            }
            if (this.getDependsOn() != null) {
                data.set("dependsOn", om.valueToTree(this.getDependsOn()));
            }
            if (this.getForEach() != null) {
                data.set("forEach", om.valueToTree(this.getForEach()));
            }
            if (this.getLifecycle() != null) {
                data.set("lifecycle", om.valueToTree(this.getLifecycle()));
            }
            if (this.getProvider() != null) {
                data.set("provider", om.valueToTree(this.getProvider()));
            }
            if (this.getProvisioners() != null) {
                data.set("provisioners", om.valueToTree(this.getProvisioners()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.HealthcareFhirStoreConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HealthcareFhirStoreConfig.Jsii$Proxy that = (HealthcareFhirStoreConfig.Jsii$Proxy) o;

            if (!dataset.equals(that.dataset)) return false;
            if (!name.equals(that.name)) return false;
            if (!version.equals(that.version)) return false;
            if (this.disableReferentialIntegrity != null ? !this.disableReferentialIntegrity.equals(that.disableReferentialIntegrity) : that.disableReferentialIntegrity != null) return false;
            if (this.disableResourceVersioning != null ? !this.disableResourceVersioning.equals(that.disableResourceVersioning) : that.disableResourceVersioning != null) return false;
            if (this.enableHistoryImport != null ? !this.enableHistoryImport.equals(that.enableHistoryImport) : that.enableHistoryImport != null) return false;
            if (this.enableUpdateCreate != null ? !this.enableUpdateCreate.equals(that.enableUpdateCreate) : that.enableUpdateCreate != null) return false;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
            if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) return false;
            if (this.notificationConfig != null ? !this.notificationConfig.equals(that.notificationConfig) : that.notificationConfig != null) return false;
            if (this.streamConfigs != null ? !this.streamConfigs.equals(that.streamConfigs) : that.streamConfigs != null) return false;
            if (this.timeouts != null ? !this.timeouts.equals(that.timeouts) : that.timeouts != null) return false;
            if (this.connection != null ? !this.connection.equals(that.connection) : that.connection != null) return false;
            if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
            if (this.dependsOn != null ? !this.dependsOn.equals(that.dependsOn) : that.dependsOn != null) return false;
            if (this.forEach != null ? !this.forEach.equals(that.forEach) : that.forEach != null) return false;
            if (this.lifecycle != null ? !this.lifecycle.equals(that.lifecycle) : that.lifecycle != null) return false;
            if (this.provider != null ? !this.provider.equals(that.provider) : that.provider != null) return false;
            return this.provisioners != null ? this.provisioners.equals(that.provisioners) : that.provisioners == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dataset.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.version.hashCode());
            result = 31 * result + (this.disableReferentialIntegrity != null ? this.disableReferentialIntegrity.hashCode() : 0);
            result = 31 * result + (this.disableResourceVersioning != null ? this.disableResourceVersioning.hashCode() : 0);
            result = 31 * result + (this.enableHistoryImport != null ? this.enableHistoryImport.hashCode() : 0);
            result = 31 * result + (this.enableUpdateCreate != null ? this.enableUpdateCreate.hashCode() : 0);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
            result = 31 * result + (this.notificationConfig != null ? this.notificationConfig.hashCode() : 0);
            result = 31 * result + (this.streamConfigs != null ? this.streamConfigs.hashCode() : 0);
            result = 31 * result + (this.timeouts != null ? this.timeouts.hashCode() : 0);
            result = 31 * result + (this.connection != null ? this.connection.hashCode() : 0);
            result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
            result = 31 * result + (this.dependsOn != null ? this.dependsOn.hashCode() : 0);
            result = 31 * result + (this.forEach != null ? this.forEach.hashCode() : 0);
            result = 31 * result + (this.lifecycle != null ? this.lifecycle.hashCode() : 0);
            result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
            result = 31 * result + (this.provisioners != null ? this.provisioners.hashCode() : 0);
            return result;
        }
    }
}
