package com.hashicorp.cdktf.providers.google;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-12T00:46:06.525Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.PubsubSubscriptionConfig")
@software.amazon.jsii.Jsii.Proxy(PubsubSubscriptionConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PubsubSubscriptionConfig extends software.amazon.jsii.JsiiSerializable, com.hashicorp.cdktf.TerraformMetaArguments {

    /**
     * Name of the subscription.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#name PubsubSubscription#name}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * A reference to a Topic resource.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#topic PubsubSubscription#topic}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTopic();

    /**
     * This value is the maximum time after a subscriber receives a message before the subscriber should acknowledge the message.
     * <p>
     * After message
     * delivery but before the ack deadline expires and before the message is
     * acknowledged, it is an outstanding message and will not be delivered
     * again during that time (on a best-effort basis).
     * <p>
     * For pull subscriptions, this value is used as the initial value for
     * the ack deadline. To override this value for a given message, call
     * subscriptions.modifyAckDeadline with the corresponding ackId if using
     * pull. The minimum custom deadline you can specify is 10 seconds. The
     * maximum custom deadline you can specify is 600 seconds (10 minutes).
     * If this parameter is 0, a default value of 10 seconds is used.
     * <p>
     * For push delivery, this value is also used to set the request timeout
     * for the call to the push endpoint.
     * <p>
     * If the subscriber never acknowledges the message, the Pub/Sub system
     * will eventually redeliver the message.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#ack_deadline_seconds PubsubSubscription#ack_deadline_seconds}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAckDeadlineSeconds() {
        return null;
    }

    /**
     * bigquery_config block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#bigquery_config PubsubSubscription#bigquery_config}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.PubsubSubscriptionBigqueryConfig getBigqueryConfig() {
        return null;
    }

    /**
     * dead_letter_policy block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#dead_letter_policy PubsubSubscription#dead_letter_policy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.PubsubSubscriptionDeadLetterPolicy getDeadLetterPolicy() {
        return null;
    }

    /**
     * If 'true', Pub/Sub provides the following guarantees for the delivery of a message with a given value of messageId on this Subscriptions':  - The message sent to a subscriber is guaranteed not to be resent before the message's acknowledgement deadline expires.
     * <p>
     * <ul>
     * <li>An acknowledged message will not be resent to a subscriber.</li>
     * </ul>
     * <p>
     * Note that subscribers may still receive multiple copies of a message when 'enable_exactly_once_delivery'
     * is true if the message was published multiple times by a publisher client. These copies are considered distinct by Pub/Sub and have distinct messageId values
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#enable_exactly_once_delivery PubsubSubscription#enable_exactly_once_delivery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableExactlyOnceDelivery() {
        return null;
    }

    /**
     * If 'true', messages published with the same orderingKey in PubsubMessage will be delivered to the subscribers in the order in which they are received by the Pub/Sub system.
     * <p>
     * Otherwise, they
     * may be delivered in any order.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#enable_message_ordering PubsubSubscription#enable_message_ordering}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableMessageOrdering() {
        return null;
    }

    /**
     * expiration_policy block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#expiration_policy PubsubSubscription#expiration_policy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.PubsubSubscriptionExpirationPolicy getExpirationPolicy() {
        return null;
    }

    /**
     * The subscription only delivers the messages that match the filter.
     * <p>
     * Pub/Sub automatically acknowledges the messages that don't match the filter. You can filter messages
     * by their attributes. The maximum length of a filter is 256 bytes. After creating the subscription,
     * you can't modify the filter.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#filter PubsubSubscription#filter}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFilter() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#id PubsubSubscription#id}.
     * <p>
     * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
     * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getId() {
        return null;
    }

    /**
     * A set of key/value label pairs to assign to this Subscription.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#labels PubsubSubscription#labels}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getLabels() {
        return null;
    }

    /**
     * How long to retain unacknowledged messages in the subscription's backlog, from the moment a message is published.
     * <p>
     * If
     * retain_acked_messages is true, then this also configures the retention
     * of acknowledged messages, and thus configures how far back in time a
     * subscriptions.seek can be done. Defaults to 7 days. Cannot be more
     * than 7 days ('"604800s"') or less than 10 minutes ('"600s"').
     * <p>
     * A duration in seconds with up to nine fractional digits, terminated
     * by 's'. Example: '"600.5s"'.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#message_retention_duration PubsubSubscription#message_retention_duration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMessageRetentionDuration() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#project PubsubSubscription#project}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProject() {
        return null;
    }

    /**
     * push_config block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#push_config PubsubSubscription#push_config}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.PubsubSubscriptionPushConfig getPushConfig() {
        return null;
    }

    /**
     * Indicates whether to retain acknowledged messages.
     * <p>
     * If 'true', then
     * messages are not expunged from the subscription's backlog, even if
     * they are acknowledged, until they fall out of the
     * messageRetentionDuration window.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#retain_acked_messages PubsubSubscription#retain_acked_messages}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRetainAckedMessages() {
        return null;
    }

    /**
     * retry_policy block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#retry_policy PubsubSubscription#retry_policy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.PubsubSubscriptionRetryPolicy getRetryPolicy() {
        return null;
    }

    /**
     * timeouts block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#timeouts PubsubSubscription#timeouts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.PubsubSubscriptionTimeouts getTimeouts() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PubsubSubscriptionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PubsubSubscriptionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PubsubSubscriptionConfig> {
        java.lang.String name;
        java.lang.String topic;
        java.lang.Number ackDeadlineSeconds;
        com.hashicorp.cdktf.providers.google.PubsubSubscriptionBigqueryConfig bigqueryConfig;
        com.hashicorp.cdktf.providers.google.PubsubSubscriptionDeadLetterPolicy deadLetterPolicy;
        java.lang.Object enableExactlyOnceDelivery;
        java.lang.Object enableMessageOrdering;
        com.hashicorp.cdktf.providers.google.PubsubSubscriptionExpirationPolicy expirationPolicy;
        java.lang.String filter;
        java.lang.String id;
        java.util.Map<java.lang.String, java.lang.String> labels;
        java.lang.String messageRetentionDuration;
        java.lang.String project;
        com.hashicorp.cdktf.providers.google.PubsubSubscriptionPushConfig pushConfig;
        java.lang.Object retainAckedMessages;
        com.hashicorp.cdktf.providers.google.PubsubSubscriptionRetryPolicy retryPolicy;
        com.hashicorp.cdktf.providers.google.PubsubSubscriptionTimeouts timeouts;
        java.lang.Object connection;
        java.lang.Number count;
        java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        com.hashicorp.cdktf.ITerraformIterator forEach;
        com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        com.hashicorp.cdktf.TerraformProvider provider;
        java.util.List<java.lang.Object> provisioners;

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getName}
         * @param name Name of the subscription. This parameter is required.
         *             Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#name PubsubSubscription#name}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getTopic}
         * @param topic A reference to a Topic resource. This parameter is required.
         *              Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#topic PubsubSubscription#topic}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topic(java.lang.String topic) {
            this.topic = topic;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getAckDeadlineSeconds}
         * @param ackDeadlineSeconds This value is the maximum time after a subscriber receives a message before the subscriber should acknowledge the message.
         *                           After message
         *                           delivery but before the ack deadline expires and before the message is
         *                           acknowledged, it is an outstanding message and will not be delivered
         *                           again during that time (on a best-effort basis).
         *                           <p>
         *                           For pull subscriptions, this value is used as the initial value for
         *                           the ack deadline. To override this value for a given message, call
         *                           subscriptions.modifyAckDeadline with the corresponding ackId if using
         *                           pull. The minimum custom deadline you can specify is 10 seconds. The
         *                           maximum custom deadline you can specify is 600 seconds (10 minutes).
         *                           If this parameter is 0, a default value of 10 seconds is used.
         *                           <p>
         *                           For push delivery, this value is also used to set the request timeout
         *                           for the call to the push endpoint.
         *                           <p>
         *                           If the subscriber never acknowledges the message, the Pub/Sub system
         *                           will eventually redeliver the message.
         *                           <p>
         *                           Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#ack_deadline_seconds PubsubSubscription#ack_deadline_seconds}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ackDeadlineSeconds(java.lang.Number ackDeadlineSeconds) {
            this.ackDeadlineSeconds = ackDeadlineSeconds;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getBigqueryConfig}
         * @param bigqueryConfig bigquery_config block.
         *                       Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#bigquery_config PubsubSubscription#bigquery_config}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bigqueryConfig(com.hashicorp.cdktf.providers.google.PubsubSubscriptionBigqueryConfig bigqueryConfig) {
            this.bigqueryConfig = bigqueryConfig;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getDeadLetterPolicy}
         * @param deadLetterPolicy dead_letter_policy block.
         *                         Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#dead_letter_policy PubsubSubscription#dead_letter_policy}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterPolicy(com.hashicorp.cdktf.providers.google.PubsubSubscriptionDeadLetterPolicy deadLetterPolicy) {
            this.deadLetterPolicy = deadLetterPolicy;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getEnableExactlyOnceDelivery}
         * @param enableExactlyOnceDelivery If 'true', Pub/Sub provides the following guarantees for the delivery of a message with a given value of messageId on this Subscriptions':  - The message sent to a subscriber is guaranteed not to be resent before the message's acknowledgement deadline expires.
         *                                  <ul>
         *                                  <li>An acknowledged message will not be resent to a subscriber.</li>
         *                                  </ul>
         *                                  <p>
         *                                  Note that subscribers may still receive multiple copies of a message when 'enable_exactly_once_delivery'
         *                                  is true if the message was published multiple times by a publisher client. These copies are considered distinct by Pub/Sub and have distinct messageId values
         *                                  <p>
         *                                  Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#enable_exactly_once_delivery PubsubSubscription#enable_exactly_once_delivery}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableExactlyOnceDelivery(java.lang.Boolean enableExactlyOnceDelivery) {
            this.enableExactlyOnceDelivery = enableExactlyOnceDelivery;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getEnableExactlyOnceDelivery}
         * @param enableExactlyOnceDelivery If 'true', Pub/Sub provides the following guarantees for the delivery of a message with a given value of messageId on this Subscriptions':  - The message sent to a subscriber is guaranteed not to be resent before the message's acknowledgement deadline expires.
         *                                  <ul>
         *                                  <li>An acknowledged message will not be resent to a subscriber.</li>
         *                                  </ul>
         *                                  <p>
         *                                  Note that subscribers may still receive multiple copies of a message when 'enable_exactly_once_delivery'
         *                                  is true if the message was published multiple times by a publisher client. These copies are considered distinct by Pub/Sub and have distinct messageId values
         *                                  <p>
         *                                  Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#enable_exactly_once_delivery PubsubSubscription#enable_exactly_once_delivery}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableExactlyOnceDelivery(com.hashicorp.cdktf.IResolvable enableExactlyOnceDelivery) {
            this.enableExactlyOnceDelivery = enableExactlyOnceDelivery;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getEnableMessageOrdering}
         * @param enableMessageOrdering If 'true', messages published with the same orderingKey in PubsubMessage will be delivered to the subscribers in the order in which they are received by the Pub/Sub system.
         *                              Otherwise, they
         *                              may be delivered in any order.
         *                              <p>
         *                              Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#enable_message_ordering PubsubSubscription#enable_message_ordering}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableMessageOrdering(java.lang.Boolean enableMessageOrdering) {
            this.enableMessageOrdering = enableMessageOrdering;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getEnableMessageOrdering}
         * @param enableMessageOrdering If 'true', messages published with the same orderingKey in PubsubMessage will be delivered to the subscribers in the order in which they are received by the Pub/Sub system.
         *                              Otherwise, they
         *                              may be delivered in any order.
         *                              <p>
         *                              Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#enable_message_ordering PubsubSubscription#enable_message_ordering}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableMessageOrdering(com.hashicorp.cdktf.IResolvable enableMessageOrdering) {
            this.enableMessageOrdering = enableMessageOrdering;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getExpirationPolicy}
         * @param expirationPolicy expiration_policy block.
         *                         Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#expiration_policy PubsubSubscription#expiration_policy}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expirationPolicy(com.hashicorp.cdktf.providers.google.PubsubSubscriptionExpirationPolicy expirationPolicy) {
            this.expirationPolicy = expirationPolicy;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getFilter}
         * @param filter The subscription only delivers the messages that match the filter.
         *               Pub/Sub automatically acknowledges the messages that don't match the filter. You can filter messages
         *               by their attributes. The maximum length of a filter is 256 bytes. After creating the subscription,
         *               you can't modify the filter.
         *               <p>
         *               Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#filter PubsubSubscription#filter}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filter(java.lang.String filter) {
            this.filter = filter;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getId}
         * @param id Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#id PubsubSubscription#id}.
         *           Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
         *           If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getLabels}
         * @param labels A set of key/value label pairs to assign to this Subscription.
         *               Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#labels PubsubSubscription#labels}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(java.util.Map<java.lang.String, java.lang.String> labels) {
            this.labels = labels;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getMessageRetentionDuration}
         * @param messageRetentionDuration How long to retain unacknowledged messages in the subscription's backlog, from the moment a message is published.
         *                                 If
         *                                 retain_acked_messages is true, then this also configures the retention
         *                                 of acknowledged messages, and thus configures how far back in time a
         *                                 subscriptions.seek can be done. Defaults to 7 days. Cannot be more
         *                                 than 7 days ('"604800s"') or less than 10 minutes ('"600s"').
         *                                 <p>
         *                                 A duration in seconds with up to nine fractional digits, terminated
         *                                 by 's'. Example: '"600.5s"'.
         *                                 <p>
         *                                 Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#message_retention_duration PubsubSubscription#message_retention_duration}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageRetentionDuration(java.lang.String messageRetentionDuration) {
            this.messageRetentionDuration = messageRetentionDuration;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getProject}
         * @param project Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#project PubsubSubscription#project}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder project(java.lang.String project) {
            this.project = project;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getPushConfig}
         * @param pushConfig push_config block.
         *                   Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#push_config PubsubSubscription#push_config}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pushConfig(com.hashicorp.cdktf.providers.google.PubsubSubscriptionPushConfig pushConfig) {
            this.pushConfig = pushConfig;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getRetainAckedMessages}
         * @param retainAckedMessages Indicates whether to retain acknowledged messages.
         *                            If 'true', then
         *                            messages are not expunged from the subscription's backlog, even if
         *                            they are acknowledged, until they fall out of the
         *                            messageRetentionDuration window.
         *                            <p>
         *                            Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#retain_acked_messages PubsubSubscription#retain_acked_messages}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retainAckedMessages(java.lang.Boolean retainAckedMessages) {
            this.retainAckedMessages = retainAckedMessages;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getRetainAckedMessages}
         * @param retainAckedMessages Indicates whether to retain acknowledged messages.
         *                            If 'true', then
         *                            messages are not expunged from the subscription's backlog, even if
         *                            they are acknowledged, until they fall out of the
         *                            messageRetentionDuration window.
         *                            <p>
         *                            Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#retain_acked_messages PubsubSubscription#retain_acked_messages}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retainAckedMessages(com.hashicorp.cdktf.IResolvable retainAckedMessages) {
            this.retainAckedMessages = retainAckedMessages;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getRetryPolicy}
         * @param retryPolicy retry_policy block.
         *                    Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#retry_policy PubsubSubscription#retry_policy}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryPolicy(com.hashicorp.cdktf.providers.google.PubsubSubscriptionRetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getTimeouts}
         * @param timeouts timeouts block.
         *                 Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#timeouts PubsubSubscription#timeouts}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeouts(com.hashicorp.cdktf.providers.google.PubsubSubscriptionTimeouts timeouts) {
            this.timeouts = timeouts;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.SSHProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.WinrmProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getCount}
         * @param count the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder count(java.lang.Number count) {
            this.count = count;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getDependsOn}
         * @param dependsOn the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder dependsOn(java.util.List<? extends com.hashicorp.cdktf.ITerraformDependable> dependsOn) {
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)dependsOn;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getForEach}
         * @param forEach the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder forEach(com.hashicorp.cdktf.ITerraformIterator forEach) {
            this.forEach = forEach;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getLifecycle}
         * @param lifecycle the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lifecycle(com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getProvider}
         * @param provider the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder provider(com.hashicorp.cdktf.TerraformProvider provider) {
            this.provider = provider;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionConfig#getProvisioners}
         * @param provisioners the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder provisioners(java.util.List<? extends java.lang.Object> provisioners) {
            this.provisioners = (java.util.List<java.lang.Object>)provisioners;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PubsubSubscriptionConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PubsubSubscriptionConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PubsubSubscriptionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PubsubSubscriptionConfig {
        private final java.lang.String name;
        private final java.lang.String topic;
        private final java.lang.Number ackDeadlineSeconds;
        private final com.hashicorp.cdktf.providers.google.PubsubSubscriptionBigqueryConfig bigqueryConfig;
        private final com.hashicorp.cdktf.providers.google.PubsubSubscriptionDeadLetterPolicy deadLetterPolicy;
        private final java.lang.Object enableExactlyOnceDelivery;
        private final java.lang.Object enableMessageOrdering;
        private final com.hashicorp.cdktf.providers.google.PubsubSubscriptionExpirationPolicy expirationPolicy;
        private final java.lang.String filter;
        private final java.lang.String id;
        private final java.util.Map<java.lang.String, java.lang.String> labels;
        private final java.lang.String messageRetentionDuration;
        private final java.lang.String project;
        private final com.hashicorp.cdktf.providers.google.PubsubSubscriptionPushConfig pushConfig;
        private final java.lang.Object retainAckedMessages;
        private final com.hashicorp.cdktf.providers.google.PubsubSubscriptionRetryPolicy retryPolicy;
        private final com.hashicorp.cdktf.providers.google.PubsubSubscriptionTimeouts timeouts;
        private final java.lang.Object connection;
        private final java.lang.Number count;
        private final java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        private final com.hashicorp.cdktf.ITerraformIterator forEach;
        private final com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        private final com.hashicorp.cdktf.TerraformProvider provider;
        private final java.util.List<java.lang.Object> provisioners;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.topic = software.amazon.jsii.Kernel.get(this, "topic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ackDeadlineSeconds = software.amazon.jsii.Kernel.get(this, "ackDeadlineSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.bigqueryConfig = software.amazon.jsii.Kernel.get(this, "bigqueryConfig", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.PubsubSubscriptionBigqueryConfig.class));
            this.deadLetterPolicy = software.amazon.jsii.Kernel.get(this, "deadLetterPolicy", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.PubsubSubscriptionDeadLetterPolicy.class));
            this.enableExactlyOnceDelivery = software.amazon.jsii.Kernel.get(this, "enableExactlyOnceDelivery", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enableMessageOrdering = software.amazon.jsii.Kernel.get(this, "enableMessageOrdering", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.expirationPolicy = software.amazon.jsii.Kernel.get(this, "expirationPolicy", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.PubsubSubscriptionExpirationPolicy.class));
            this.filter = software.amazon.jsii.Kernel.get(this, "filter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.labels = software.amazon.jsii.Kernel.get(this, "labels", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.messageRetentionDuration = software.amazon.jsii.Kernel.get(this, "messageRetentionDuration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.project = software.amazon.jsii.Kernel.get(this, "project", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pushConfig = software.amazon.jsii.Kernel.get(this, "pushConfig", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.PubsubSubscriptionPushConfig.class));
            this.retainAckedMessages = software.amazon.jsii.Kernel.get(this, "retainAckedMessages", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.retryPolicy = software.amazon.jsii.Kernel.get(this, "retryPolicy", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.PubsubSubscriptionRetryPolicy.class));
            this.timeouts = software.amazon.jsii.Kernel.get(this, "timeouts", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.PubsubSubscriptionTimeouts.class));
            this.connection = software.amazon.jsii.Kernel.get(this, "connection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.dependsOn = software.amazon.jsii.Kernel.get(this, "dependsOn", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformDependable.class)));
            this.forEach = software.amazon.jsii.Kernel.get(this, "forEach", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformIterator.class));
            this.lifecycle = software.amazon.jsii.Kernel.get(this, "lifecycle", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformResourceLifecycle.class));
            this.provider = software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformProvider.class));
            this.provisioners = software.amazon.jsii.Kernel.get(this, "provisioners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.topic = java.util.Objects.requireNonNull(builder.topic, "topic is required");
            this.ackDeadlineSeconds = builder.ackDeadlineSeconds;
            this.bigqueryConfig = builder.bigqueryConfig;
            this.deadLetterPolicy = builder.deadLetterPolicy;
            this.enableExactlyOnceDelivery = builder.enableExactlyOnceDelivery;
            this.enableMessageOrdering = builder.enableMessageOrdering;
            this.expirationPolicy = builder.expirationPolicy;
            this.filter = builder.filter;
            this.id = builder.id;
            this.labels = builder.labels;
            this.messageRetentionDuration = builder.messageRetentionDuration;
            this.project = builder.project;
            this.pushConfig = builder.pushConfig;
            this.retainAckedMessages = builder.retainAckedMessages;
            this.retryPolicy = builder.retryPolicy;
            this.timeouts = builder.timeouts;
            this.connection = builder.connection;
            this.count = builder.count;
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)builder.dependsOn;
            this.forEach = builder.forEach;
            this.lifecycle = builder.lifecycle;
            this.provider = builder.provider;
            this.provisioners = (java.util.List<java.lang.Object>)builder.provisioners;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getTopic() {
            return this.topic;
        }

        @Override
        public final java.lang.Number getAckDeadlineSeconds() {
            return this.ackDeadlineSeconds;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.PubsubSubscriptionBigqueryConfig getBigqueryConfig() {
            return this.bigqueryConfig;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.PubsubSubscriptionDeadLetterPolicy getDeadLetterPolicy() {
            return this.deadLetterPolicy;
        }

        @Override
        public final java.lang.Object getEnableExactlyOnceDelivery() {
            return this.enableExactlyOnceDelivery;
        }

        @Override
        public final java.lang.Object getEnableMessageOrdering() {
            return this.enableMessageOrdering;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.PubsubSubscriptionExpirationPolicy getExpirationPolicy() {
            return this.expirationPolicy;
        }

        @Override
        public final java.lang.String getFilter() {
            return this.filter;
        }

        @Override
        public final java.lang.String getId() {
            return this.id;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getLabels() {
            return this.labels;
        }

        @Override
        public final java.lang.String getMessageRetentionDuration() {
            return this.messageRetentionDuration;
        }

        @Override
        public final java.lang.String getProject() {
            return this.project;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.PubsubSubscriptionPushConfig getPushConfig() {
            return this.pushConfig;
        }

        @Override
        public final java.lang.Object getRetainAckedMessages() {
            return this.retainAckedMessages;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.PubsubSubscriptionRetryPolicy getRetryPolicy() {
            return this.retryPolicy;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.PubsubSubscriptionTimeouts getTimeouts() {
            return this.timeouts;
        }

        @Override
        public final java.lang.Object getConnection() {
            return this.connection;
        }

        @Override
        public final java.lang.Number getCount() {
            return this.count;
        }

        @Override
        public final java.util.List<com.hashicorp.cdktf.ITerraformDependable> getDependsOn() {
            return this.dependsOn;
        }

        @Override
        public final com.hashicorp.cdktf.ITerraformIterator getForEach() {
            return this.forEach;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformResourceLifecycle getLifecycle() {
            return this.lifecycle;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformProvider getProvider() {
            return this.provider;
        }

        @Override
        public final java.util.List<java.lang.Object> getProvisioners() {
            return this.provisioners;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("topic", om.valueToTree(this.getTopic()));
            if (this.getAckDeadlineSeconds() != null) {
                data.set("ackDeadlineSeconds", om.valueToTree(this.getAckDeadlineSeconds()));
            }
            if (this.getBigqueryConfig() != null) {
                data.set("bigqueryConfig", om.valueToTree(this.getBigqueryConfig()));
            }
            if (this.getDeadLetterPolicy() != null) {
                data.set("deadLetterPolicy", om.valueToTree(this.getDeadLetterPolicy()));
            }
            if (this.getEnableExactlyOnceDelivery() != null) {
                data.set("enableExactlyOnceDelivery", om.valueToTree(this.getEnableExactlyOnceDelivery()));
            }
            if (this.getEnableMessageOrdering() != null) {
                data.set("enableMessageOrdering", om.valueToTree(this.getEnableMessageOrdering()));
            }
            if (this.getExpirationPolicy() != null) {
                data.set("expirationPolicy", om.valueToTree(this.getExpirationPolicy()));
            }
            if (this.getFilter() != null) {
                data.set("filter", om.valueToTree(this.getFilter()));
            }
            if (this.getId() != null) {
                data.set("id", om.valueToTree(this.getId()));
            }
            if (this.getLabels() != null) {
                data.set("labels", om.valueToTree(this.getLabels()));
            }
            if (this.getMessageRetentionDuration() != null) {
                data.set("messageRetentionDuration", om.valueToTree(this.getMessageRetentionDuration()));
            }
            if (this.getProject() != null) {
                data.set("project", om.valueToTree(this.getProject()));
            }
            if (this.getPushConfig() != null) {
                data.set("pushConfig", om.valueToTree(this.getPushConfig()));
            }
            if (this.getRetainAckedMessages() != null) {
                data.set("retainAckedMessages", om.valueToTree(this.getRetainAckedMessages()));
            }
            if (this.getRetryPolicy() != null) {
                data.set("retryPolicy", om.valueToTree(this.getRetryPolicy()));
            }
            if (this.getTimeouts() != null) {
                data.set("timeouts", om.valueToTree(this.getTimeouts()));
            }
            if (this.getConnection() != null) {
                data.set("connection", om.valueToTree(this.getConnection()));
            }
            if (this.getCount() != null) {
                data.set("count", om.valueToTree(this.getCount()));
            }
            if (this.getDependsOn() != null) {
                data.set("dependsOn", om.valueToTree(this.getDependsOn()));
            }
            if (this.getForEach() != null) {
                data.set("forEach", om.valueToTree(this.getForEach()));
            }
            if (this.getLifecycle() != null) {
                data.set("lifecycle", om.valueToTree(this.getLifecycle()));
            }
            if (this.getProvider() != null) {
                data.set("provider", om.valueToTree(this.getProvider()));
            }
            if (this.getProvisioners() != null) {
                data.set("provisioners", om.valueToTree(this.getProvisioners()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.PubsubSubscriptionConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PubsubSubscriptionConfig.Jsii$Proxy that = (PubsubSubscriptionConfig.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!topic.equals(that.topic)) return false;
            if (this.ackDeadlineSeconds != null ? !this.ackDeadlineSeconds.equals(that.ackDeadlineSeconds) : that.ackDeadlineSeconds != null) return false;
            if (this.bigqueryConfig != null ? !this.bigqueryConfig.equals(that.bigqueryConfig) : that.bigqueryConfig != null) return false;
            if (this.deadLetterPolicy != null ? !this.deadLetterPolicy.equals(that.deadLetterPolicy) : that.deadLetterPolicy != null) return false;
            if (this.enableExactlyOnceDelivery != null ? !this.enableExactlyOnceDelivery.equals(that.enableExactlyOnceDelivery) : that.enableExactlyOnceDelivery != null) return false;
            if (this.enableMessageOrdering != null ? !this.enableMessageOrdering.equals(that.enableMessageOrdering) : that.enableMessageOrdering != null) return false;
            if (this.expirationPolicy != null ? !this.expirationPolicy.equals(that.expirationPolicy) : that.expirationPolicy != null) return false;
            if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) return false;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
            if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) return false;
            if (this.messageRetentionDuration != null ? !this.messageRetentionDuration.equals(that.messageRetentionDuration) : that.messageRetentionDuration != null) return false;
            if (this.project != null ? !this.project.equals(that.project) : that.project != null) return false;
            if (this.pushConfig != null ? !this.pushConfig.equals(that.pushConfig) : that.pushConfig != null) return false;
            if (this.retainAckedMessages != null ? !this.retainAckedMessages.equals(that.retainAckedMessages) : that.retainAckedMessages != null) return false;
            if (this.retryPolicy != null ? !this.retryPolicy.equals(that.retryPolicy) : that.retryPolicy != null) return false;
            if (this.timeouts != null ? !this.timeouts.equals(that.timeouts) : that.timeouts != null) return false;
            if (this.connection != null ? !this.connection.equals(that.connection) : that.connection != null) return false;
            if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
            if (this.dependsOn != null ? !this.dependsOn.equals(that.dependsOn) : that.dependsOn != null) return false;
            if (this.forEach != null ? !this.forEach.equals(that.forEach) : that.forEach != null) return false;
            if (this.lifecycle != null ? !this.lifecycle.equals(that.lifecycle) : that.lifecycle != null) return false;
            if (this.provider != null ? !this.provider.equals(that.provider) : that.provider != null) return false;
            return this.provisioners != null ? this.provisioners.equals(that.provisioners) : that.provisioners == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.topic.hashCode());
            result = 31 * result + (this.ackDeadlineSeconds != null ? this.ackDeadlineSeconds.hashCode() : 0);
            result = 31 * result + (this.bigqueryConfig != null ? this.bigqueryConfig.hashCode() : 0);
            result = 31 * result + (this.deadLetterPolicy != null ? this.deadLetterPolicy.hashCode() : 0);
            result = 31 * result + (this.enableExactlyOnceDelivery != null ? this.enableExactlyOnceDelivery.hashCode() : 0);
            result = 31 * result + (this.enableMessageOrdering != null ? this.enableMessageOrdering.hashCode() : 0);
            result = 31 * result + (this.expirationPolicy != null ? this.expirationPolicy.hashCode() : 0);
            result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
            result = 31 * result + (this.messageRetentionDuration != null ? this.messageRetentionDuration.hashCode() : 0);
            result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
            result = 31 * result + (this.pushConfig != null ? this.pushConfig.hashCode() : 0);
            result = 31 * result + (this.retainAckedMessages != null ? this.retainAckedMessages.hashCode() : 0);
            result = 31 * result + (this.retryPolicy != null ? this.retryPolicy.hashCode() : 0);
            result = 31 * result + (this.timeouts != null ? this.timeouts.hashCode() : 0);
            result = 31 * result + (this.connection != null ? this.connection.hashCode() : 0);
            result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
            result = 31 * result + (this.dependsOn != null ? this.dependsOn.hashCode() : 0);
            result = 31 * result + (this.forEach != null ? this.forEach.hashCode() : 0);
            result = 31 * result + (this.lifecycle != null ? this.lifecycle.hashCode() : 0);
            result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
            result = 31 * result + (this.provisioners != null ? this.provisioners.hashCode() : 0);
            return result;
        }
    }
}
