package com.hashicorp.cdktf.providers.google;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-12T00:46:06.526Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.PubsubSubscriptionDeadLetterPolicy")
@software.amazon.jsii.Jsii.Proxy(PubsubSubscriptionDeadLetterPolicy.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PubsubSubscriptionDeadLetterPolicy extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the topic to which dead letter messages should be published. Format is 'projects/{project}/topics/{topic}'.
     * <p>
     * The Cloud Pub/Sub service account associated with the enclosing subscription's
     * parent project (i.e.,
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
     * permission to Publish() to this topic.
     * <p>
     * The operation will fail if the topic does not exist.
     * Users should ensure that there is a subscription attached to this topic
     * since messages published to a topic with no subscriptions are lost.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#dead_letter_topic PubsubSubscription#dead_letter_topic}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeadLetterTopic() {
        return null;
    }

    /**
     * The maximum number of delivery attempts for any message. The value must be between 5 and 100.
     * <p>
     * The number of delivery attempts is defined as 1 + (the sum of number of
     * NACKs and number of times the acknowledgement deadline has been exceeded for the message).
     * <p>
     * A NACK is any call to ModifyAckDeadline with a 0 deadline. Note that
     * client libraries may automatically extend ack_deadlines.
     * <p>
     * This field will be honored on a best effort basis.
     * <p>
     * If this parameter is 0, a default value of 5 is used.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#max_delivery_attempts PubsubSubscription#max_delivery_attempts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxDeliveryAttempts() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PubsubSubscriptionDeadLetterPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PubsubSubscriptionDeadLetterPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PubsubSubscriptionDeadLetterPolicy> {
        java.lang.String deadLetterTopic;
        java.lang.Number maxDeliveryAttempts;

        /**
         * Sets the value of {@link PubsubSubscriptionDeadLetterPolicy#getDeadLetterTopic}
         * @param deadLetterTopic The name of the topic to which dead letter messages should be published. Format is 'projects/{project}/topics/{topic}'.
         *                        The Cloud Pub/Sub service account associated with the enclosing subscription's
         *                        parent project (i.e.,
         *                        service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
         *                        permission to Publish() to this topic.
         *                        <p>
         *                        The operation will fail if the topic does not exist.
         *                        Users should ensure that there is a subscription attached to this topic
         *                        since messages published to a topic with no subscriptions are lost.
         *                        <p>
         *                        Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#dead_letter_topic PubsubSubscription#dead_letter_topic}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterTopic(java.lang.String deadLetterTopic) {
            this.deadLetterTopic = deadLetterTopic;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionDeadLetterPolicy#getMaxDeliveryAttempts}
         * @param maxDeliveryAttempts The maximum number of delivery attempts for any message. The value must be between 5 and 100.
         *                            The number of delivery attempts is defined as 1 + (the sum of number of
         *                            NACKs and number of times the acknowledgement deadline has been exceeded for the message).
         *                            <p>
         *                            A NACK is any call to ModifyAckDeadline with a 0 deadline. Note that
         *                            client libraries may automatically extend ack_deadlines.
         *                            <p>
         *                            This field will be honored on a best effort basis.
         *                            <p>
         *                            If this parameter is 0, a default value of 5 is used.
         *                            <p>
         *                            Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#max_delivery_attempts PubsubSubscription#max_delivery_attempts}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxDeliveryAttempts(java.lang.Number maxDeliveryAttempts) {
            this.maxDeliveryAttempts = maxDeliveryAttempts;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PubsubSubscriptionDeadLetterPolicy}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PubsubSubscriptionDeadLetterPolicy build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PubsubSubscriptionDeadLetterPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PubsubSubscriptionDeadLetterPolicy {
        private final java.lang.String deadLetterTopic;
        private final java.lang.Number maxDeliveryAttempts;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deadLetterTopic = software.amazon.jsii.Kernel.get(this, "deadLetterTopic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxDeliveryAttempts = software.amazon.jsii.Kernel.get(this, "maxDeliveryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deadLetterTopic = builder.deadLetterTopic;
            this.maxDeliveryAttempts = builder.maxDeliveryAttempts;
        }

        @Override
        public final java.lang.String getDeadLetterTopic() {
            return this.deadLetterTopic;
        }

        @Override
        public final java.lang.Number getMaxDeliveryAttempts() {
            return this.maxDeliveryAttempts;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDeadLetterTopic() != null) {
                data.set("deadLetterTopic", om.valueToTree(this.getDeadLetterTopic()));
            }
            if (this.getMaxDeliveryAttempts() != null) {
                data.set("maxDeliveryAttempts", om.valueToTree(this.getMaxDeliveryAttempts()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.PubsubSubscriptionDeadLetterPolicy"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PubsubSubscriptionDeadLetterPolicy.Jsii$Proxy that = (PubsubSubscriptionDeadLetterPolicy.Jsii$Proxy) o;

            if (this.deadLetterTopic != null ? !this.deadLetterTopic.equals(that.deadLetterTopic) : that.deadLetterTopic != null) return false;
            return this.maxDeliveryAttempts != null ? this.maxDeliveryAttempts.equals(that.maxDeliveryAttempts) : that.maxDeliveryAttempts == null;
        }

        @Override
        public final int hashCode() {
            int result = this.deadLetterTopic != null ? this.deadLetterTopic.hashCode() : 0;
            result = 31 * result + (this.maxDeliveryAttempts != null ? this.maxDeliveryAttempts.hashCode() : 0);
            return result;
        }
    }
}
