package com.hashicorp.cdktf.providers.google;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-12T00:46:06.547Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.RedisInstanceConfig")
@software.amazon.jsii.Jsii.Proxy(RedisInstanceConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RedisInstanceConfig extends software.amazon.jsii.JsiiSerializable, com.hashicorp.cdktf.TerraformMetaArguments {

    /**
     * Redis memory size in GiB.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#memory_size_gb RedisInstance#memory_size_gb}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMemorySizeGb();

    /**
     * The ID of the instance or a fully qualified identifier for the instance.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#name RedisInstance#name}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Only applicable to STANDARD_HA tier which protects the instance against zonal failures by provisioning it across two zones.
     * <p>
     * If provided, it must be a different zone from the one provided in
     * [locationId].
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#alternative_location_id RedisInstance#alternative_location_id}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAlternativeLocationId() {
        return null;
    }

    /**
     * Optional.
     * <p>
     * Indicates whether OSS Redis AUTH is enabled for the
     * instance. If set to "true" AUTH is enabled on the instance.
     * Default value is "false" meaning AUTH is disabled.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#auth_enabled RedisInstance#auth_enabled}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAuthEnabled() {
        return null;
    }

    /**
     * The full name of the Google Compute Engine network to which the instance is connected.
     * <p>
     * If left unspecified, the default network
     * will be used.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#authorized_network RedisInstance#authorized_network}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizedNetwork() {
        return null;
    }

    /**
     * The connection mode of the Redis instance. Default value: "DIRECT_PEERING" Possible values: ["DIRECT_PEERING", "PRIVATE_SERVICE_ACCESS"].
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#connect_mode RedisInstance#connect_mode}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConnectMode() {
        return null;
    }

    /**
     * Optional.
     * <p>
     * The KMS key reference that you want to use to encrypt the data at rest for this Redis
     * instance. If this is provided, CMEK is enabled.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#customer_managed_key RedisInstance#customer_managed_key}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomerManagedKey() {
        return null;
    }

    /**
     * An arbitrary and optional user-provided name for the instance.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#display_name RedisInstance#display_name}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#id RedisInstance#id}.
     * <p>
     * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
     * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getId() {
        return null;
    }

    /**
     * Resource labels to represent user provided metadata.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#labels RedisInstance#labels}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getLabels() {
        return null;
    }

    /**
     * The zone where the instance will be provisioned.
     * <p>
     * If not provided,
     * the service will choose a zone for the instance. For STANDARD_HA tier,
     * instances will be created across two zones for protection against
     * zonal failures. If [alternativeLocationId] is also provided, it must
     * be different from [locationId].
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#location_id RedisInstance#location_id}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLocationId() {
        return null;
    }

    /**
     * maintenance_policy block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#maintenance_policy RedisInstance#maintenance_policy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.RedisInstanceMaintenancePolicy getMaintenancePolicy() {
        return null;
    }

    /**
     * maintenance_schedule block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#maintenance_schedule RedisInstance#maintenance_schedule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.RedisInstanceMaintenanceSchedule getMaintenanceSchedule() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#project RedisInstance#project}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProject() {
        return null;
    }

    /**
     * Optional.
     * <p>
     * Read replica mode. Can only be specified when trying to create the instance.
     * If not set, Memorystore Redis backend will default to READ_REPLICAS_DISABLED.
     * <p>
     * <ul>
     * <li>READ_REPLICAS_DISABLED: If disabled, read endpoint will not be provided and the
     * instance cannot scale up or down the number of replicas.</li>
     * <li>READ_REPLICAS_ENABLED: If enabled, read endpoint will be provided and the instance
     * can scale up and down the number of replicas. Possible values: ["READ_REPLICAS_DISABLED", "READ_REPLICAS_ENABLED"]</li>
     * </ul>
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#read_replicas_mode RedisInstance#read_replicas_mode}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReadReplicasMode() {
        return null;
    }

    /**
     * Redis configuration parameters, according to http://redis.io/topics/config. Please check Memorystore documentation for the list of supported parameters: https://cloud.google.com/memorystore/docs/redis/reference/rest/v1/projects.locations.instances#Instance.FIELDS.redis_configs.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#redis_configs RedisInstance#redis_configs}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getRedisConfigs() {
        return null;
    }

    /**
     * The version of Redis software.
     * <p>
     * If not provided, latest supported
     * version will be used. Please check the API documentation linked
     * at the top for the latest valid values.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#redis_version RedisInstance#redis_version}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRedisVersion() {
        return null;
    }

    /**
     * The name of the Redis region of the instance.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#region RedisInstance#region}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * Optional.
     * <p>
     * The number of replica nodes. The valid range for the Standard Tier with
     * read replicas enabled is [1-5] and defaults to 2. If read replicas are not enabled
     * for a Standard Tier instance, the only valid value is 1 and the default is 1.
     * The valid value for basic tier is 0 and the default is also 0.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#replica_count RedisInstance#replica_count}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getReplicaCount() {
        return null;
    }

    /**
     * The CIDR range of internal addresses that are reserved for this instance.
     * <p>
     * If not provided, the service will choose an unused /29
     * block, for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be
     * unique and non-overlapping with existing subnets in an authorized
     * network.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#reserved_ip_range RedisInstance#reserved_ip_range}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReservedIpRange() {
        return null;
    }

    /**
     * Optional.
     * <p>
     * Additional IP range for node placement. Required when enabling read replicas on
     * an existing instance. For DIRECT_PEERING mode value must be a CIDR range of size /28, or
     * "auto". For PRIVATE_SERVICE_ACCESS mode value must be the name of an allocated address
     * range associated with the private service access connection, or "auto".
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#secondary_ip_range RedisInstance#secondary_ip_range}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecondaryIpRange() {
        return null;
    }

    /**
     * The service tier of the instance. Must be one of these values:.
     * <p>
     * <ul>
     * <li>BASIC: standalone instance</li>
     * <li>STANDARD_HA: highly available primary/replica instances Default value: "BASIC" Possible values: ["BASIC", "STANDARD_HA"]</li>
     * </ul>
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#tier RedisInstance#tier}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTier() {
        return null;
    }

    /**
     * timeouts block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#timeouts RedisInstance#timeouts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.RedisInstanceTimeouts getTimeouts() {
        return null;
    }

    /**
     * The TLS mode of the Redis instance, If not provided, TLS is disabled for the instance.
     * <p>
     * <ul>
     * <li>SERVER_AUTHENTICATION: Client to Server traffic encryption enabled with server authentication Default value: "DISABLED" Possible values: ["SERVER_AUTHENTICATION", "DISABLED"]</li>
     * </ul>
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#transit_encryption_mode RedisInstance#transit_encryption_mode}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTransitEncryptionMode() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RedisInstanceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RedisInstanceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RedisInstanceConfig> {
        java.lang.Number memorySizeGb;
        java.lang.String name;
        java.lang.String alternativeLocationId;
        java.lang.Object authEnabled;
        java.lang.String authorizedNetwork;
        java.lang.String connectMode;
        java.lang.String customerManagedKey;
        java.lang.String displayName;
        java.lang.String id;
        java.util.Map<java.lang.String, java.lang.String> labels;
        java.lang.String locationId;
        com.hashicorp.cdktf.providers.google.RedisInstanceMaintenancePolicy maintenancePolicy;
        com.hashicorp.cdktf.providers.google.RedisInstanceMaintenanceSchedule maintenanceSchedule;
        java.lang.String project;
        java.lang.String readReplicasMode;
        java.util.Map<java.lang.String, java.lang.String> redisConfigs;
        java.lang.String redisVersion;
        java.lang.String region;
        java.lang.Number replicaCount;
        java.lang.String reservedIpRange;
        java.lang.String secondaryIpRange;
        java.lang.String tier;
        com.hashicorp.cdktf.providers.google.RedisInstanceTimeouts timeouts;
        java.lang.String transitEncryptionMode;
        java.lang.Object connection;
        java.lang.Number count;
        java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        com.hashicorp.cdktf.ITerraformIterator forEach;
        com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        com.hashicorp.cdktf.TerraformProvider provider;
        java.util.List<java.lang.Object> provisioners;

        /**
         * Sets the value of {@link RedisInstanceConfig#getMemorySizeGb}
         * @param memorySizeGb Redis memory size in GiB. This parameter is required.
         *                     Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#memory_size_gb RedisInstance#memory_size_gb}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memorySizeGb(java.lang.Number memorySizeGb) {
            this.memorySizeGb = memorySizeGb;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getName}
         * @param name The ID of the instance or a fully qualified identifier for the instance. This parameter is required.
         *             Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#name RedisInstance#name}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getAlternativeLocationId}
         * @param alternativeLocationId Only applicable to STANDARD_HA tier which protects the instance against zonal failures by provisioning it across two zones.
         *                              If provided, it must be a different zone from the one provided in
         *                              [locationId].
         *                              <p>
         *                              Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#alternative_location_id RedisInstance#alternative_location_id}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alternativeLocationId(java.lang.String alternativeLocationId) {
            this.alternativeLocationId = alternativeLocationId;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getAuthEnabled}
         * @param authEnabled Optional.
         *                    Indicates whether OSS Redis AUTH is enabled for the
         *                    instance. If set to "true" AUTH is enabled on the instance.
         *                    Default value is "false" meaning AUTH is disabled.
         *                    <p>
         *                    Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#auth_enabled RedisInstance#auth_enabled}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authEnabled(java.lang.Boolean authEnabled) {
            this.authEnabled = authEnabled;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getAuthEnabled}
         * @param authEnabled Optional.
         *                    Indicates whether OSS Redis AUTH is enabled for the
         *                    instance. If set to "true" AUTH is enabled on the instance.
         *                    Default value is "false" meaning AUTH is disabled.
         *                    <p>
         *                    Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#auth_enabled RedisInstance#auth_enabled}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authEnabled(com.hashicorp.cdktf.IResolvable authEnabled) {
            this.authEnabled = authEnabled;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getAuthorizedNetwork}
         * @param authorizedNetwork The full name of the Google Compute Engine network to which the instance is connected.
         *                          If left unspecified, the default network
         *                          will be used.
         *                          <p>
         *                          Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#authorized_network RedisInstance#authorized_network}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizedNetwork(java.lang.String authorizedNetwork) {
            this.authorizedNetwork = authorizedNetwork;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getConnectMode}
         * @param connectMode The connection mode of the Redis instance. Default value: "DIRECT_PEERING" Possible values: ["DIRECT_PEERING", "PRIVATE_SERVICE_ACCESS"].
         *                    Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#connect_mode RedisInstance#connect_mode}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectMode(java.lang.String connectMode) {
            this.connectMode = connectMode;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getCustomerManagedKey}
         * @param customerManagedKey Optional.
         *                           The KMS key reference that you want to use to encrypt the data at rest for this Redis
         *                           instance. If this is provided, CMEK is enabled.
         *                           <p>
         *                           Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#customer_managed_key RedisInstance#customer_managed_key}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerManagedKey(java.lang.String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getDisplayName}
         * @param displayName An arbitrary and optional user-provided name for the instance.
         *                    Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#display_name RedisInstance#display_name}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getId}
         * @param id Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#id RedisInstance#id}.
         *           Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
         *           If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getLabels}
         * @param labels Resource labels to represent user provided metadata.
         *               Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#labels RedisInstance#labels}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(java.util.Map<java.lang.String, java.lang.String> labels) {
            this.labels = labels;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getLocationId}
         * @param locationId The zone where the instance will be provisioned.
         *                   If not provided,
         *                   the service will choose a zone for the instance. For STANDARD_HA tier,
         *                   instances will be created across two zones for protection against
         *                   zonal failures. If [alternativeLocationId] is also provided, it must
         *                   be different from [locationId].
         *                   <p>
         *                   Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#location_id RedisInstance#location_id}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locationId(java.lang.String locationId) {
            this.locationId = locationId;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getMaintenancePolicy}
         * @param maintenancePolicy maintenance_policy block.
         *                          Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#maintenance_policy RedisInstance#maintenance_policy}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenancePolicy(com.hashicorp.cdktf.providers.google.RedisInstanceMaintenancePolicy maintenancePolicy) {
            this.maintenancePolicy = maintenancePolicy;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getMaintenanceSchedule}
         * @param maintenanceSchedule maintenance_schedule block.
         *                            Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#maintenance_schedule RedisInstance#maintenance_schedule}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceSchedule(com.hashicorp.cdktf.providers.google.RedisInstanceMaintenanceSchedule maintenanceSchedule) {
            this.maintenanceSchedule = maintenanceSchedule;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getProject}
         * @param project Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#project RedisInstance#project}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder project(java.lang.String project) {
            this.project = project;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getReadReplicasMode}
         * @param readReplicasMode Optional.
         *                         Read replica mode. Can only be specified when trying to create the instance.
         *                         If not set, Memorystore Redis backend will default to READ_REPLICAS_DISABLED.
         *                         <p>
         *                         <ul>
         *                         <li>READ_REPLICAS_DISABLED: If disabled, read endpoint will not be provided and the
         *                         instance cannot scale up or down the number of replicas.</li>
         *                         <li>READ_REPLICAS_ENABLED: If enabled, read endpoint will be provided and the instance
         *                         can scale up and down the number of replicas. Possible values: ["READ_REPLICAS_DISABLED", "READ_REPLICAS_ENABLED"]</li>
         *                         </ul>
         *                         <p>
         *                         Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#read_replicas_mode RedisInstance#read_replicas_mode}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readReplicasMode(java.lang.String readReplicasMode) {
            this.readReplicasMode = readReplicasMode;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getRedisConfigs}
         * @param redisConfigs Redis configuration parameters, according to http://redis.io/topics/config. Please check Memorystore documentation for the list of supported parameters: https://cloud.google.com/memorystore/docs/redis/reference/rest/v1/projects.locations.instances#Instance.FIELDS.redis_configs.
         *                     Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#redis_configs RedisInstance#redis_configs}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redisConfigs(java.util.Map<java.lang.String, java.lang.String> redisConfigs) {
            this.redisConfigs = redisConfigs;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getRedisVersion}
         * @param redisVersion The version of Redis software.
         *                     If not provided, latest supported
         *                     version will be used. Please check the API documentation linked
         *                     at the top for the latest valid values.
         *                     <p>
         *                     Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#redis_version RedisInstance#redis_version}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redisVersion(java.lang.String redisVersion) {
            this.redisVersion = redisVersion;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getRegion}
         * @param region The name of the Redis region of the instance.
         *               Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#region RedisInstance#region}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getReplicaCount}
         * @param replicaCount Optional.
         *                     The number of replica nodes. The valid range for the Standard Tier with
         *                     read replicas enabled is [1-5] and defaults to 2. If read replicas are not enabled
         *                     for a Standard Tier instance, the only valid value is 1 and the default is 1.
         *                     The valid value for basic tier is 0 and the default is also 0.
         *                     <p>
         *                     Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#replica_count RedisInstance#replica_count}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicaCount(java.lang.Number replicaCount) {
            this.replicaCount = replicaCount;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getReservedIpRange}
         * @param reservedIpRange The CIDR range of internal addresses that are reserved for this instance.
         *                        If not provided, the service will choose an unused /29
         *                        block, for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be
         *                        unique and non-overlapping with existing subnets in an authorized
         *                        network.
         *                        <p>
         *                        Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#reserved_ip_range RedisInstance#reserved_ip_range}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reservedIpRange(java.lang.String reservedIpRange) {
            this.reservedIpRange = reservedIpRange;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getSecondaryIpRange}
         * @param secondaryIpRange Optional.
         *                         Additional IP range for node placement. Required when enabling read replicas on
         *                         an existing instance. For DIRECT_PEERING mode value must be a CIDR range of size /28, or
         *                         "auto". For PRIVATE_SERVICE_ACCESS mode value must be the name of an allocated address
         *                         range associated with the private service access connection, or "auto".
         *                         <p>
         *                         Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#secondary_ip_range RedisInstance#secondary_ip_range}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secondaryIpRange(java.lang.String secondaryIpRange) {
            this.secondaryIpRange = secondaryIpRange;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getTier}
         * @param tier The service tier of the instance. Must be one of these values:.
         *             <ul>
         *             <li>BASIC: standalone instance</li>
         *             <li>STANDARD_HA: highly available primary/replica instances Default value: "BASIC" Possible values: ["BASIC", "STANDARD_HA"]</li>
         *             </ul>
         *             <p>
         *             Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#tier RedisInstance#tier}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tier(java.lang.String tier) {
            this.tier = tier;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getTimeouts}
         * @param timeouts timeouts block.
         *                 Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#timeouts RedisInstance#timeouts}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeouts(com.hashicorp.cdktf.providers.google.RedisInstanceTimeouts timeouts) {
            this.timeouts = timeouts;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getTransitEncryptionMode}
         * @param transitEncryptionMode The TLS mode of the Redis instance, If not provided, TLS is disabled for the instance.
         *                              <ul>
         *                              <li>SERVER_AUTHENTICATION: Client to Server traffic encryption enabled with server authentication Default value: "DISABLED" Possible values: ["SERVER_AUTHENTICATION", "DISABLED"]</li>
         *                              </ul>
         *                              <p>
         *                              Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#transit_encryption_mode RedisInstance#transit_encryption_mode}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitEncryptionMode(java.lang.String transitEncryptionMode) {
            this.transitEncryptionMode = transitEncryptionMode;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.SSHProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.WinrmProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getCount}
         * @param count the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder count(java.lang.Number count) {
            this.count = count;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getDependsOn}
         * @param dependsOn the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder dependsOn(java.util.List<? extends com.hashicorp.cdktf.ITerraformDependable> dependsOn) {
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)dependsOn;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getForEach}
         * @param forEach the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder forEach(com.hashicorp.cdktf.ITerraformIterator forEach) {
            this.forEach = forEach;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getLifecycle}
         * @param lifecycle the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lifecycle(com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getProvider}
         * @param provider the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder provider(com.hashicorp.cdktf.TerraformProvider provider) {
            this.provider = provider;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstanceConfig#getProvisioners}
         * @param provisioners the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder provisioners(java.util.List<? extends java.lang.Object> provisioners) {
            this.provisioners = (java.util.List<java.lang.Object>)provisioners;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RedisInstanceConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RedisInstanceConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RedisInstanceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedisInstanceConfig {
        private final java.lang.Number memorySizeGb;
        private final java.lang.String name;
        private final java.lang.String alternativeLocationId;
        private final java.lang.Object authEnabled;
        private final java.lang.String authorizedNetwork;
        private final java.lang.String connectMode;
        private final java.lang.String customerManagedKey;
        private final java.lang.String displayName;
        private final java.lang.String id;
        private final java.util.Map<java.lang.String, java.lang.String> labels;
        private final java.lang.String locationId;
        private final com.hashicorp.cdktf.providers.google.RedisInstanceMaintenancePolicy maintenancePolicy;
        private final com.hashicorp.cdktf.providers.google.RedisInstanceMaintenanceSchedule maintenanceSchedule;
        private final java.lang.String project;
        private final java.lang.String readReplicasMode;
        private final java.util.Map<java.lang.String, java.lang.String> redisConfigs;
        private final java.lang.String redisVersion;
        private final java.lang.String region;
        private final java.lang.Number replicaCount;
        private final java.lang.String reservedIpRange;
        private final java.lang.String secondaryIpRange;
        private final java.lang.String tier;
        private final com.hashicorp.cdktf.providers.google.RedisInstanceTimeouts timeouts;
        private final java.lang.String transitEncryptionMode;
        private final java.lang.Object connection;
        private final java.lang.Number count;
        private final java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        private final com.hashicorp.cdktf.ITerraformIterator forEach;
        private final com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        private final com.hashicorp.cdktf.TerraformProvider provider;
        private final java.util.List<java.lang.Object> provisioners;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.memorySizeGb = software.amazon.jsii.Kernel.get(this, "memorySizeGb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.alternativeLocationId = software.amazon.jsii.Kernel.get(this, "alternativeLocationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authEnabled = software.amazon.jsii.Kernel.get(this, "authEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.authorizedNetwork = software.amazon.jsii.Kernel.get(this, "authorizedNetwork", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectMode = software.amazon.jsii.Kernel.get(this, "connectMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customerManagedKey = software.amazon.jsii.Kernel.get(this, "customerManagedKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.labels = software.amazon.jsii.Kernel.get(this, "labels", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.locationId = software.amazon.jsii.Kernel.get(this, "locationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maintenancePolicy = software.amazon.jsii.Kernel.get(this, "maintenancePolicy", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.RedisInstanceMaintenancePolicy.class));
            this.maintenanceSchedule = software.amazon.jsii.Kernel.get(this, "maintenanceSchedule", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.RedisInstanceMaintenanceSchedule.class));
            this.project = software.amazon.jsii.Kernel.get(this, "project", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.readReplicasMode = software.amazon.jsii.Kernel.get(this, "readReplicasMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.redisConfigs = software.amazon.jsii.Kernel.get(this, "redisConfigs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.redisVersion = software.amazon.jsii.Kernel.get(this, "redisVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.replicaCount = software.amazon.jsii.Kernel.get(this, "replicaCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.reservedIpRange = software.amazon.jsii.Kernel.get(this, "reservedIpRange", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.secondaryIpRange = software.amazon.jsii.Kernel.get(this, "secondaryIpRange", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tier = software.amazon.jsii.Kernel.get(this, "tier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeouts = software.amazon.jsii.Kernel.get(this, "timeouts", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.RedisInstanceTimeouts.class));
            this.transitEncryptionMode = software.amazon.jsii.Kernel.get(this, "transitEncryptionMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connection = software.amazon.jsii.Kernel.get(this, "connection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.dependsOn = software.amazon.jsii.Kernel.get(this, "dependsOn", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformDependable.class)));
            this.forEach = software.amazon.jsii.Kernel.get(this, "forEach", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformIterator.class));
            this.lifecycle = software.amazon.jsii.Kernel.get(this, "lifecycle", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformResourceLifecycle.class));
            this.provider = software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformProvider.class));
            this.provisioners = software.amazon.jsii.Kernel.get(this, "provisioners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.memorySizeGb = java.util.Objects.requireNonNull(builder.memorySizeGb, "memorySizeGb is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.alternativeLocationId = builder.alternativeLocationId;
            this.authEnabled = builder.authEnabled;
            this.authorizedNetwork = builder.authorizedNetwork;
            this.connectMode = builder.connectMode;
            this.customerManagedKey = builder.customerManagedKey;
            this.displayName = builder.displayName;
            this.id = builder.id;
            this.labels = builder.labels;
            this.locationId = builder.locationId;
            this.maintenancePolicy = builder.maintenancePolicy;
            this.maintenanceSchedule = builder.maintenanceSchedule;
            this.project = builder.project;
            this.readReplicasMode = builder.readReplicasMode;
            this.redisConfigs = builder.redisConfigs;
            this.redisVersion = builder.redisVersion;
            this.region = builder.region;
            this.replicaCount = builder.replicaCount;
            this.reservedIpRange = builder.reservedIpRange;
            this.secondaryIpRange = builder.secondaryIpRange;
            this.tier = builder.tier;
            this.timeouts = builder.timeouts;
            this.transitEncryptionMode = builder.transitEncryptionMode;
            this.connection = builder.connection;
            this.count = builder.count;
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)builder.dependsOn;
            this.forEach = builder.forEach;
            this.lifecycle = builder.lifecycle;
            this.provider = builder.provider;
            this.provisioners = (java.util.List<java.lang.Object>)builder.provisioners;
        }

        @Override
        public final java.lang.Number getMemorySizeGb() {
            return this.memorySizeGb;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getAlternativeLocationId() {
            return this.alternativeLocationId;
        }

        @Override
        public final java.lang.Object getAuthEnabled() {
            return this.authEnabled;
        }

        @Override
        public final java.lang.String getAuthorizedNetwork() {
            return this.authorizedNetwork;
        }

        @Override
        public final java.lang.String getConnectMode() {
            return this.connectMode;
        }

        @Override
        public final java.lang.String getCustomerManagedKey() {
            return this.customerManagedKey;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.lang.String getId() {
            return this.id;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getLabels() {
            return this.labels;
        }

        @Override
        public final java.lang.String getLocationId() {
            return this.locationId;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.RedisInstanceMaintenancePolicy getMaintenancePolicy() {
            return this.maintenancePolicy;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.RedisInstanceMaintenanceSchedule getMaintenanceSchedule() {
            return this.maintenanceSchedule;
        }

        @Override
        public final java.lang.String getProject() {
            return this.project;
        }

        @Override
        public final java.lang.String getReadReplicasMode() {
            return this.readReplicasMode;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getRedisConfigs() {
            return this.redisConfigs;
        }

        @Override
        public final java.lang.String getRedisVersion() {
            return this.redisVersion;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.lang.Number getReplicaCount() {
            return this.replicaCount;
        }

        @Override
        public final java.lang.String getReservedIpRange() {
            return this.reservedIpRange;
        }

        @Override
        public final java.lang.String getSecondaryIpRange() {
            return this.secondaryIpRange;
        }

        @Override
        public final java.lang.String getTier() {
            return this.tier;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.RedisInstanceTimeouts getTimeouts() {
            return this.timeouts;
        }

        @Override
        public final java.lang.String getTransitEncryptionMode() {
            return this.transitEncryptionMode;
        }

        @Override
        public final java.lang.Object getConnection() {
            return this.connection;
        }

        @Override
        public final java.lang.Number getCount() {
            return this.count;
        }

        @Override
        public final java.util.List<com.hashicorp.cdktf.ITerraformDependable> getDependsOn() {
            return this.dependsOn;
        }

        @Override
        public final com.hashicorp.cdktf.ITerraformIterator getForEach() {
            return this.forEach;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformResourceLifecycle getLifecycle() {
            return this.lifecycle;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformProvider getProvider() {
            return this.provider;
        }

        @Override
        public final java.util.List<java.lang.Object> getProvisioners() {
            return this.provisioners;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("memorySizeGb", om.valueToTree(this.getMemorySizeGb()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getAlternativeLocationId() != null) {
                data.set("alternativeLocationId", om.valueToTree(this.getAlternativeLocationId()));
            }
            if (this.getAuthEnabled() != null) {
                data.set("authEnabled", om.valueToTree(this.getAuthEnabled()));
            }
            if (this.getAuthorizedNetwork() != null) {
                data.set("authorizedNetwork", om.valueToTree(this.getAuthorizedNetwork()));
            }
            if (this.getConnectMode() != null) {
                data.set("connectMode", om.valueToTree(this.getConnectMode()));
            }
            if (this.getCustomerManagedKey() != null) {
                data.set("customerManagedKey", om.valueToTree(this.getCustomerManagedKey()));
            }
            if (this.getDisplayName() != null) {
                data.set("displayName", om.valueToTree(this.getDisplayName()));
            }
            if (this.getId() != null) {
                data.set("id", om.valueToTree(this.getId()));
            }
            if (this.getLabels() != null) {
                data.set("labels", om.valueToTree(this.getLabels()));
            }
            if (this.getLocationId() != null) {
                data.set("locationId", om.valueToTree(this.getLocationId()));
            }
            if (this.getMaintenancePolicy() != null) {
                data.set("maintenancePolicy", om.valueToTree(this.getMaintenancePolicy()));
            }
            if (this.getMaintenanceSchedule() != null) {
                data.set("maintenanceSchedule", om.valueToTree(this.getMaintenanceSchedule()));
            }
            if (this.getProject() != null) {
                data.set("project", om.valueToTree(this.getProject()));
            }
            if (this.getReadReplicasMode() != null) {
                data.set("readReplicasMode", om.valueToTree(this.getReadReplicasMode()));
            }
            if (this.getRedisConfigs() != null) {
                data.set("redisConfigs", om.valueToTree(this.getRedisConfigs()));
            }
            if (this.getRedisVersion() != null) {
                data.set("redisVersion", om.valueToTree(this.getRedisVersion()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getReplicaCount() != null) {
                data.set("replicaCount", om.valueToTree(this.getReplicaCount()));
            }
            if (this.getReservedIpRange() != null) {
                data.set("reservedIpRange", om.valueToTree(this.getReservedIpRange()));
            }
            if (this.getSecondaryIpRange() != null) {
                data.set("secondaryIpRange", om.valueToTree(this.getSecondaryIpRange()));
            }
            if (this.getTier() != null) {
                data.set("tier", om.valueToTree(this.getTier()));
            }
            if (this.getTimeouts() != null) {
                data.set("timeouts", om.valueToTree(this.getTimeouts()));
            }
            if (this.getTransitEncryptionMode() != null) {
                data.set("transitEncryptionMode", om.valueToTree(this.getTransitEncryptionMode()));
            }
            if (this.getConnection() != null) {
                data.set("connection", om.valueToTree(this.getConnection()));
            }
            if (this.getCount() != null) {
                data.set("count", om.valueToTree(this.getCount()));
            }
            if (this.getDependsOn() != null) {
                data.set("dependsOn", om.valueToTree(this.getDependsOn()));
            }
            if (this.getForEach() != null) {
                data.set("forEach", om.valueToTree(this.getForEach()));
            }
            if (this.getLifecycle() != null) {
                data.set("lifecycle", om.valueToTree(this.getLifecycle()));
            }
            if (this.getProvider() != null) {
                data.set("provider", om.valueToTree(this.getProvider()));
            }
            if (this.getProvisioners() != null) {
                data.set("provisioners", om.valueToTree(this.getProvisioners()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.RedisInstanceConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RedisInstanceConfig.Jsii$Proxy that = (RedisInstanceConfig.Jsii$Proxy) o;

            if (!memorySizeGb.equals(that.memorySizeGb)) return false;
            if (!name.equals(that.name)) return false;
            if (this.alternativeLocationId != null ? !this.alternativeLocationId.equals(that.alternativeLocationId) : that.alternativeLocationId != null) return false;
            if (this.authEnabled != null ? !this.authEnabled.equals(that.authEnabled) : that.authEnabled != null) return false;
            if (this.authorizedNetwork != null ? !this.authorizedNetwork.equals(that.authorizedNetwork) : that.authorizedNetwork != null) return false;
            if (this.connectMode != null ? !this.connectMode.equals(that.connectMode) : that.connectMode != null) return false;
            if (this.customerManagedKey != null ? !this.customerManagedKey.equals(that.customerManagedKey) : that.customerManagedKey != null) return false;
            if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) return false;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
            if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) return false;
            if (this.locationId != null ? !this.locationId.equals(that.locationId) : that.locationId != null) return false;
            if (this.maintenancePolicy != null ? !this.maintenancePolicy.equals(that.maintenancePolicy) : that.maintenancePolicy != null) return false;
            if (this.maintenanceSchedule != null ? !this.maintenanceSchedule.equals(that.maintenanceSchedule) : that.maintenanceSchedule != null) return false;
            if (this.project != null ? !this.project.equals(that.project) : that.project != null) return false;
            if (this.readReplicasMode != null ? !this.readReplicasMode.equals(that.readReplicasMode) : that.readReplicasMode != null) return false;
            if (this.redisConfigs != null ? !this.redisConfigs.equals(that.redisConfigs) : that.redisConfigs != null) return false;
            if (this.redisVersion != null ? !this.redisVersion.equals(that.redisVersion) : that.redisVersion != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.replicaCount != null ? !this.replicaCount.equals(that.replicaCount) : that.replicaCount != null) return false;
            if (this.reservedIpRange != null ? !this.reservedIpRange.equals(that.reservedIpRange) : that.reservedIpRange != null) return false;
            if (this.secondaryIpRange != null ? !this.secondaryIpRange.equals(that.secondaryIpRange) : that.secondaryIpRange != null) return false;
            if (this.tier != null ? !this.tier.equals(that.tier) : that.tier != null) return false;
            if (this.timeouts != null ? !this.timeouts.equals(that.timeouts) : that.timeouts != null) return false;
            if (this.transitEncryptionMode != null ? !this.transitEncryptionMode.equals(that.transitEncryptionMode) : that.transitEncryptionMode != null) return false;
            if (this.connection != null ? !this.connection.equals(that.connection) : that.connection != null) return false;
            if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
            if (this.dependsOn != null ? !this.dependsOn.equals(that.dependsOn) : that.dependsOn != null) return false;
            if (this.forEach != null ? !this.forEach.equals(that.forEach) : that.forEach != null) return false;
            if (this.lifecycle != null ? !this.lifecycle.equals(that.lifecycle) : that.lifecycle != null) return false;
            if (this.provider != null ? !this.provider.equals(that.provider) : that.provider != null) return false;
            return this.provisioners != null ? this.provisioners.equals(that.provisioners) : that.provisioners == null;
        }

        @Override
        public final int hashCode() {
            int result = this.memorySizeGb.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.alternativeLocationId != null ? this.alternativeLocationId.hashCode() : 0);
            result = 31 * result + (this.authEnabled != null ? this.authEnabled.hashCode() : 0);
            result = 31 * result + (this.authorizedNetwork != null ? this.authorizedNetwork.hashCode() : 0);
            result = 31 * result + (this.connectMode != null ? this.connectMode.hashCode() : 0);
            result = 31 * result + (this.customerManagedKey != null ? this.customerManagedKey.hashCode() : 0);
            result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
            result = 31 * result + (this.locationId != null ? this.locationId.hashCode() : 0);
            result = 31 * result + (this.maintenancePolicy != null ? this.maintenancePolicy.hashCode() : 0);
            result = 31 * result + (this.maintenanceSchedule != null ? this.maintenanceSchedule.hashCode() : 0);
            result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
            result = 31 * result + (this.readReplicasMode != null ? this.readReplicasMode.hashCode() : 0);
            result = 31 * result + (this.redisConfigs != null ? this.redisConfigs.hashCode() : 0);
            result = 31 * result + (this.redisVersion != null ? this.redisVersion.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.replicaCount != null ? this.replicaCount.hashCode() : 0);
            result = 31 * result + (this.reservedIpRange != null ? this.reservedIpRange.hashCode() : 0);
            result = 31 * result + (this.secondaryIpRange != null ? this.secondaryIpRange.hashCode() : 0);
            result = 31 * result + (this.tier != null ? this.tier.hashCode() : 0);
            result = 31 * result + (this.timeouts != null ? this.timeouts.hashCode() : 0);
            result = 31 * result + (this.transitEncryptionMode != null ? this.transitEncryptionMode.hashCode() : 0);
            result = 31 * result + (this.connection != null ? this.connection.hashCode() : 0);
            result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
            result = 31 * result + (this.dependsOn != null ? this.dependsOn.hashCode() : 0);
            result = 31 * result + (this.forEach != null ? this.forEach.hashCode() : 0);
            result = 31 * result + (this.lifecycle != null ? this.lifecycle.hashCode() : 0);
            result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
            result = 31 * result + (this.provisioners != null ? this.provisioners.hashCode() : 0);
            return result;
        }
    }
}
