/**
 * <h1>Terraform CDK google Provider ~&gt; 4.0</h1>
 * <p>
 * This repo builds and publishes the Terraform google Provider bindings for <a href="https://cdk.tf">CDK for Terraform</a>.
 * <p>
 * <h2>Available Packages</h2>
 * <p>
 * <h3>NPM</h3>
 * <p>
 * The npm package is available at <a href="https://www.npmjs.com/package/&#64;cdktf/provider-google">https://www.npmjs.com/package/&#64;cdktf/provider-google</a>.
 * <p>
 * <code>npm install &#64;cdktf/provider-google</code>
 * <p>
 * <h3>PyPI</h3>
 * <p>
 * The PyPI package is available at <a href="https://pypi.org/project/cdktf-cdktf-provider-google">https://pypi.org/project/cdktf-cdktf-provider-google</a>.
 * <p>
 * <code>pipenv install cdktf-cdktf-provider-google</code>
 * <p>
 * <h3>Nuget</h3>
 * <p>
 * The Nuget package is available at <a href="https://www.nuget.org/packages/HashiCorp.Cdktf.Providers.Google">https://www.nuget.org/packages/HashiCorp.Cdktf.Providers.Google</a>.
 * <p>
 * <code>dotnet add package HashiCorp.Cdktf.Providers.Google</code>
 * <p>
 * <h3>Maven</h3>
 * <p>
 * The Maven package is available at <a href="https://mvnrepository.com/artifact/com.hashicorp/cdktf-provider-google">https://mvnrepository.com/artifact/com.hashicorp/cdktf-provider-google</a>.
 * <p>
 * <blockquote><pre>
 * &lt;dependency&gt;
 *     &lt;groupId&gt;com.hashicorp&lt;/groupId&gt;
 *     &lt;artifactId&gt;cdktf-provider-google&lt;/artifactId&gt;
 *     &lt;version&gt;[REPLACE WITH DESIRED VERSION]&lt;/version&gt;
 * &lt;/dependency&gt;
 * </pre></blockquote>
 * <p>
 * <h3>Go</h3>
 * <p>
 * The go package is generated into the <a href="https://github.com/hashicorp/cdktf-provider-google-go"><code>github.com/hashicorp/cdktf-provider-google-go</code></a> package.
 * <p>
 * <code>go get github.com/hashicorp/cdktf-provider-google-go/google</code>
 * <p>
 * <h2>Docs</h2>
 * <p>
 * Find auto-generated docs for this provider here: <a href="./API.md">./API.md</a>
 * You can also visit a hosted version of the documentation on <a href="https://constructs.dev/packages/&#64;cdktf/provider-google">constructs.dev</a>.
 * <p>
 * <h2>Versioning</h2>
 * <p>
 * This project is explicitly not tracking the Terraform google Provider version 1:1. In fact, it always tracks <code>latest</code> of <code>~&gt; 4.0</code> with every release. If there are scenarios where you explicitly have to pin your provider version, you can do so by generating the <a href="https://cdk.tf/imports">provider constructs manually</a>.
 * <p>
 * These are the upstream dependencies:
 * <p>
 * <ul>
 * <li><a href="https://cdk.tf">Terraform CDK</a></li>
 * <li><a href="https://github.com/terraform-providers/terraform-provider-google">Terraform google Provider</a></li>
 * <li><a href="https://terraform.io">Terraform Engine</a></li>
 * </ul>
 * <p>
 * If there are breaking changes (backward incompatible) in any of the above, the major version of this project will be bumped.
 * <p>
 * <h2>Features / Issues / Bugs</h2>
 * <p>
 * Please report bugs and issues to the <a href="https://cdk.tf">terraform cdk</a> project:
 * <p>
 * <ul>
 * <li><a href="https://cdk.tf/bug">Create bug report</a></li>
 * <li><a href="https://cdk.tf/feature">Create feature request</a></li>
 * </ul>
 * <p>
 * <h2>Contributing</h2>
 * <p>
 * <h3>projen</h3>
 * <p>
 * This is mostly based on <a href="https://github.com/eladb/projen">projen</a>, which takes care of generating the entire repository.
 * <p>
 * <h3>cdktf-provider-project based on projen</h3>
 * <p>
 * There's a custom <a href="https://github.com/hashicorp/cdktf-provider-project">project builder</a> which encapsulate the common settings for all <code>cdktf</code> providers.
 * <p>
 * <h3>Provider Version</h3>
 * <p>
 * The provider version can be adjusted in <a href="./.projenrc.js">./.projenrc.js</a>.
 * <p>
 * <h3>Repository Management</h3>
 * <p>
 * The repository is managed by <a href="https://github.com/hashicorp/cdktf-repository-manager/">Repository Manager</a>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package com.hashicorp.cdktf.providers.google;
