package com.hashicorp.cdktf.providers.google;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-10-03T00:49:21.333Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.ComputeFirewallConfig")
@software.amazon.jsii.Jsii.Proxy(ComputeFirewallConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ComputeFirewallConfig extends software.amazon.jsii.JsiiSerializable, com.hashicorp.cdktf.TerraformMetaArguments {

    /**
     * Name of the resource.
     * <p>
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '<a href="%5B-a-z0-9%5D*%5Ba-z0-9%5D">a-z</a>?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#name ComputeFirewall#name}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The name or self_link of the network to attach this firewall to.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#network ComputeFirewall#network}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNetwork();

    /**
     * allow block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#allow ComputeFirewall#allow}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAllow() {
        return null;
    }

    /**
     * deny block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#deny ComputeFirewall#deny}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeny() {
        return null;
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#description ComputeFirewall#description}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * If destination ranges are specified, the firewall will apply only to traffic that has destination IP address in these ranges.
     * <p>
     * These ranges
     * must be expressed in CIDR format. Only IPv4 is supported.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#destination_ranges ComputeFirewall#destination_ranges}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDestinationRanges() {
        return null;
    }

    /**
     * Direction of traffic to which this firewall applies;
     * <p>
     * default is
     * INGRESS. Note: For INGRESS traffic, it is NOT supported to specify
     * destinationRanges; For EGRESS traffic, it is NOT supported to specify
     * 'source_ranges' OR 'source_tags'. For INGRESS traffic, one of 'source_ranges',
     * 'source_tags' or 'source_service_accounts' is required. Possible values: ["INGRESS", "EGRESS"]
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#direction ComputeFirewall#direction}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDirection() {
        return null;
    }

    /**
     * Denotes whether the firewall rule is disabled, i.e not applied to the network it is associated with. When set to true, the firewall rule is not enforced and the network behaves as if it did not exist. If this is unspecified, the firewall rule will be enabled.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#disabled ComputeFirewall#disabled}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDisabled() {
        return null;
    }

    /**
     * This field denotes whether to enable logging for a particular firewall rule.
     * <p>
     * If logging is enabled, logs will be exported to Stackdriver.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#enable_logging ComputeFirewall#enable_logging}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableLogging() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#id ComputeFirewall#id}.
     * <p>
     * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
     * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getId() {
        return null;
    }

    /**
     * log_config block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#log_config ComputeFirewall#log_config}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.ComputeFirewallLogConfig getLogConfig() {
        return null;
    }

    /**
     * Priority for this rule.
     * <p>
     * This is an integer between 0 and 65535, both
     * inclusive. When not specified, the value assumed is 1000. Relative
     * priorities determine precedence of conflicting rules. Lower value of
     * priority implies higher precedence (eg, a rule with priority 0 has
     * higher precedence than a rule with priority 1). DENY rules take
     * precedence over ALLOW rules having equal priority.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#priority ComputeFirewall#priority}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#project ComputeFirewall#project}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProject() {
        return null;
    }

    /**
     * If source ranges are specified, the firewall will apply only to traffic that has source IP address in these ranges.
     * <p>
     * These ranges must
     * be expressed in CIDR format. One or both of sourceRanges and
     * sourceTags may be set. If both properties are set, the firewall will
     * apply to traffic that has source IP address within sourceRanges OR the
     * source IP that belongs to a tag listed in the sourceTags property. The
     * connection does not need to match both properties for the firewall to
     * apply. Only IPv4 is supported. For INGRESS traffic, one of 'source_ranges',
     * 'source_tags' or 'source_service_accounts' is required.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#source_ranges ComputeFirewall#source_ranges}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSourceRanges() {
        return null;
    }

    /**
     * If source service accounts are specified, the firewall will apply only to traffic originating from an instance with a service account in this list.
     * <p>
     * Source service accounts cannot be used to control traffic to an
     * instance's external IP address because service accounts are associated
     * with an instance, not an IP address. sourceRanges can be set at the
     * same time as sourceServiceAccounts. If both are set, the firewall will
     * apply to traffic that has source IP address within sourceRanges OR the
     * source IP belongs to an instance with service account listed in
     * sourceServiceAccount. The connection does not need to match both
     * properties for the firewall to apply. sourceServiceAccounts cannot be
     * used at the same time as sourceTags or targetTags. For INGRESS traffic,
     * one of 'source_ranges', 'source_tags' or 'source_service_accounts' is required.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#source_service_accounts ComputeFirewall#source_service_accounts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSourceServiceAccounts() {
        return null;
    }

    /**
     * If source tags are specified, the firewall will apply only to traffic with source IP that belongs to a tag listed in source tags.
     * <p>
     * Source
     * tags cannot be used to control traffic to an instance's external IP
     * address. Because tags are associated with an instance, not an IP
     * address. One or both of sourceRanges and sourceTags may be set. If
     * both properties are set, the firewall will apply to traffic that has
     * source IP address within sourceRanges OR the source IP that belongs to
     * a tag listed in the sourceTags property. The connection does not need
     * to match both properties for the firewall to apply. For INGRESS traffic,
     * one of 'source_ranges', 'source_tags' or 'source_service_accounts' is required.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#source_tags ComputeFirewall#source_tags}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSourceTags() {
        return null;
    }

    /**
     * A list of service accounts indicating sets of instances located in the network that may make network connections as specified in allowed[].
     * <p>
     * targetServiceAccounts cannot be used at the same time as targetTags or
     * sourceTags. If neither targetServiceAccounts nor targetTags are
     * specified, the firewall rule applies to all instances on the specified
     * network.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#target_service_accounts ComputeFirewall#target_service_accounts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTargetServiceAccounts() {
        return null;
    }

    /**
     * A list of instance tags indicating sets of instances located in the network that may make network connections as specified in allowed[].
     * <p>
     * If no targetTags are specified, the firewall rule applies to all
     * instances on the specified network.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#target_tags ComputeFirewall#target_tags}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTargetTags() {
        return null;
    }

    /**
     * timeouts block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#timeouts ComputeFirewall#timeouts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.ComputeFirewallTimeouts getTimeouts() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ComputeFirewallConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ComputeFirewallConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ComputeFirewallConfig> {
        java.lang.String name;
        java.lang.String network;
        java.lang.Object allow;
        java.lang.Object deny;
        java.lang.String description;
        java.util.List<java.lang.String> destinationRanges;
        java.lang.String direction;
        java.lang.Object disabled;
        java.lang.Object enableLogging;
        java.lang.String id;
        com.hashicorp.cdktf.providers.google.ComputeFirewallLogConfig logConfig;
        java.lang.Number priority;
        java.lang.String project;
        java.util.List<java.lang.String> sourceRanges;
        java.util.List<java.lang.String> sourceServiceAccounts;
        java.util.List<java.lang.String> sourceTags;
        java.util.List<java.lang.String> targetServiceAccounts;
        java.util.List<java.lang.String> targetTags;
        com.hashicorp.cdktf.providers.google.ComputeFirewallTimeouts timeouts;
        java.lang.Object connection;
        java.lang.Number count;
        java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        com.hashicorp.cdktf.ITerraformIterator forEach;
        com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        com.hashicorp.cdktf.TerraformProvider provider;
        java.util.List<java.lang.Object> provisioners;

        /**
         * Sets the value of {@link ComputeFirewallConfig#getName}
         * @param name Name of the resource. This parameter is required.
         *             Provided by the client when the resource is
         *             created. The name must be 1-63 characters long, and comply with
         *             RFC1035. Specifically, the name must be 1-63 characters long and match
         *             the regular expression '<a href="%5B-a-z0-9%5D*%5Ba-z0-9%5D">a-z</a>?' which means the
         *             first character must be a lowercase letter, and all following
         *             characters must be a dash, lowercase letter, or digit, except the last
         *             character, which cannot be a dash.
         *             <p>
         *             Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#name ComputeFirewall#name}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getNetwork}
         * @param network The name or self_link of the network to attach this firewall to. This parameter is required.
         *                Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#network ComputeFirewall#network}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder network(java.lang.String network) {
            this.network = network;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getAllow}
         * @param allow allow block.
         *              Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#allow ComputeFirewall#allow}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allow(com.hashicorp.cdktf.IResolvable allow) {
            this.allow = allow;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getAllow}
         * @param allow allow block.
         *              Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#allow ComputeFirewall#allow}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allow(java.util.List<? extends com.hashicorp.cdktf.providers.google.ComputeFirewallAllow> allow) {
            this.allow = allow;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getDeny}
         * @param deny deny block.
         *             Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#deny ComputeFirewall#deny}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deny(com.hashicorp.cdktf.IResolvable deny) {
            this.deny = deny;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getDeny}
         * @param deny deny block.
         *             Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#deny ComputeFirewall#deny}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deny(java.util.List<? extends com.hashicorp.cdktf.providers.google.ComputeFirewallDeny> deny) {
            this.deny = deny;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getDescription}
         * @param description An optional description of this resource. Provide this property when you create the resource.
         *                    Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#description ComputeFirewall#description}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getDestinationRanges}
         * @param destinationRanges If destination ranges are specified, the firewall will apply only to traffic that has destination IP address in these ranges.
         *                          These ranges
         *                          must be expressed in CIDR format. Only IPv4 is supported.
         *                          <p>
         *                          Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#destination_ranges ComputeFirewall#destination_ranges}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationRanges(java.util.List<java.lang.String> destinationRanges) {
            this.destinationRanges = destinationRanges;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getDirection}
         * @param direction Direction of traffic to which this firewall applies;.
         *                  default is
         *                  INGRESS. Note: For INGRESS traffic, it is NOT supported to specify
         *                  destinationRanges; For EGRESS traffic, it is NOT supported to specify
         *                  'source_ranges' OR 'source_tags'. For INGRESS traffic, one of 'source_ranges',
         *                  'source_tags' or 'source_service_accounts' is required. Possible values: ["INGRESS", "EGRESS"]
         *                  <p>
         *                  Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#direction ComputeFirewall#direction}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder direction(java.lang.String direction) {
            this.direction = direction;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getDisabled}
         * @param disabled Denotes whether the firewall rule is disabled, i.e not applied to the network it is associated with. When set to true, the firewall rule is not enforced and the network behaves as if it did not exist. If this is unspecified, the firewall rule will be enabled.
         *                 Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#disabled ComputeFirewall#disabled}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disabled(java.lang.Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getDisabled}
         * @param disabled Denotes whether the firewall rule is disabled, i.e not applied to the network it is associated with. When set to true, the firewall rule is not enforced and the network behaves as if it did not exist. If this is unspecified, the firewall rule will be enabled.
         *                 Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#disabled ComputeFirewall#disabled}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disabled(com.hashicorp.cdktf.IResolvable disabled) {
            this.disabled = disabled;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getEnableLogging}
         * @param enableLogging This field denotes whether to enable logging for a particular firewall rule.
         *                      If logging is enabled, logs will be exported to Stackdriver.
         *                      <p>
         *                      Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#enable_logging ComputeFirewall#enable_logging}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableLogging(java.lang.Boolean enableLogging) {
            this.enableLogging = enableLogging;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getEnableLogging}
         * @param enableLogging This field denotes whether to enable logging for a particular firewall rule.
         *                      If logging is enabled, logs will be exported to Stackdriver.
         *                      <p>
         *                      Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#enable_logging ComputeFirewall#enable_logging}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableLogging(com.hashicorp.cdktf.IResolvable enableLogging) {
            this.enableLogging = enableLogging;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getId}
         * @param id Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#id ComputeFirewall#id}.
         *           Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
         *           If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getLogConfig}
         * @param logConfig log_config block.
         *                  Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#log_config ComputeFirewall#log_config}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfig(com.hashicorp.cdktf.providers.google.ComputeFirewallLogConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getPriority}
         * @param priority Priority for this rule.
         *                 This is an integer between 0 and 65535, both
         *                 inclusive. When not specified, the value assumed is 1000. Relative
         *                 priorities determine precedence of conflicting rules. Lower value of
         *                 priority implies higher precedence (eg, a rule with priority 0 has
         *                 higher precedence than a rule with priority 1). DENY rules take
         *                 precedence over ALLOW rules having equal priority.
         *                 <p>
         *                 Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#priority ComputeFirewall#priority}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getProject}
         * @param project Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#project ComputeFirewall#project}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder project(java.lang.String project) {
            this.project = project;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getSourceRanges}
         * @param sourceRanges If source ranges are specified, the firewall will apply only to traffic that has source IP address in these ranges.
         *                     These ranges must
         *                     be expressed in CIDR format. One or both of sourceRanges and
         *                     sourceTags may be set. If both properties are set, the firewall will
         *                     apply to traffic that has source IP address within sourceRanges OR the
         *                     source IP that belongs to a tag listed in the sourceTags property. The
         *                     connection does not need to match both properties for the firewall to
         *                     apply. Only IPv4 is supported. For INGRESS traffic, one of 'source_ranges',
         *                     'source_tags' or 'source_service_accounts' is required.
         *                     <p>
         *                     Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#source_ranges ComputeFirewall#source_ranges}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceRanges(java.util.List<java.lang.String> sourceRanges) {
            this.sourceRanges = sourceRanges;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getSourceServiceAccounts}
         * @param sourceServiceAccounts If source service accounts are specified, the firewall will apply only to traffic originating from an instance with a service account in this list.
         *                              Source service accounts cannot be used to control traffic to an
         *                              instance's external IP address because service accounts are associated
         *                              with an instance, not an IP address. sourceRanges can be set at the
         *                              same time as sourceServiceAccounts. If both are set, the firewall will
         *                              apply to traffic that has source IP address within sourceRanges OR the
         *                              source IP belongs to an instance with service account listed in
         *                              sourceServiceAccount. The connection does not need to match both
         *                              properties for the firewall to apply. sourceServiceAccounts cannot be
         *                              used at the same time as sourceTags or targetTags. For INGRESS traffic,
         *                              one of 'source_ranges', 'source_tags' or 'source_service_accounts' is required.
         *                              <p>
         *                              Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#source_service_accounts ComputeFirewall#source_service_accounts}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceServiceAccounts(java.util.List<java.lang.String> sourceServiceAccounts) {
            this.sourceServiceAccounts = sourceServiceAccounts;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getSourceTags}
         * @param sourceTags If source tags are specified, the firewall will apply only to traffic with source IP that belongs to a tag listed in source tags.
         *                   Source
         *                   tags cannot be used to control traffic to an instance's external IP
         *                   address. Because tags are associated with an instance, not an IP
         *                   address. One or both of sourceRanges and sourceTags may be set. If
         *                   both properties are set, the firewall will apply to traffic that has
         *                   source IP address within sourceRanges OR the source IP that belongs to
         *                   a tag listed in the sourceTags property. The connection does not need
         *                   to match both properties for the firewall to apply. For INGRESS traffic,
         *                   one of 'source_ranges', 'source_tags' or 'source_service_accounts' is required.
         *                   <p>
         *                   Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#source_tags ComputeFirewall#source_tags}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceTags(java.util.List<java.lang.String> sourceTags) {
            this.sourceTags = sourceTags;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getTargetServiceAccounts}
         * @param targetServiceAccounts A list of service accounts indicating sets of instances located in the network that may make network connections as specified in allowed[].
         *                              targetServiceAccounts cannot be used at the same time as targetTags or
         *                              sourceTags. If neither targetServiceAccounts nor targetTags are
         *                              specified, the firewall rule applies to all instances on the specified
         *                              network.
         *                              <p>
         *                              Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#target_service_accounts ComputeFirewall#target_service_accounts}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetServiceAccounts(java.util.List<java.lang.String> targetServiceAccounts) {
            this.targetServiceAccounts = targetServiceAccounts;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getTargetTags}
         * @param targetTags A list of instance tags indicating sets of instances located in the network that may make network connections as specified in allowed[].
         *                   If no targetTags are specified, the firewall rule applies to all
         *                   instances on the specified network.
         *                   <p>
         *                   Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#target_tags ComputeFirewall#target_tags}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetTags(java.util.List<java.lang.String> targetTags) {
            this.targetTags = targetTags;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getTimeouts}
         * @param timeouts timeouts block.
         *                 Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_firewall#timeouts ComputeFirewall#timeouts}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeouts(com.hashicorp.cdktf.providers.google.ComputeFirewallTimeouts timeouts) {
            this.timeouts = timeouts;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.SSHProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.WinrmProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getCount}
         * @param count the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder count(java.lang.Number count) {
            this.count = count;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getDependsOn}
         * @param dependsOn the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder dependsOn(java.util.List<? extends com.hashicorp.cdktf.ITerraformDependable> dependsOn) {
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)dependsOn;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getForEach}
         * @param forEach the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder forEach(com.hashicorp.cdktf.ITerraformIterator forEach) {
            this.forEach = forEach;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getLifecycle}
         * @param lifecycle the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lifecycle(com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getProvider}
         * @param provider the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder provider(com.hashicorp.cdktf.TerraformProvider provider) {
            this.provider = provider;
            return this;
        }

        /**
         * Sets the value of {@link ComputeFirewallConfig#getProvisioners}
         * @param provisioners the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder provisioners(java.util.List<? extends java.lang.Object> provisioners) {
            this.provisioners = (java.util.List<java.lang.Object>)provisioners;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ComputeFirewallConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ComputeFirewallConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ComputeFirewallConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComputeFirewallConfig {
        private final java.lang.String name;
        private final java.lang.String network;
        private final java.lang.Object allow;
        private final java.lang.Object deny;
        private final java.lang.String description;
        private final java.util.List<java.lang.String> destinationRanges;
        private final java.lang.String direction;
        private final java.lang.Object disabled;
        private final java.lang.Object enableLogging;
        private final java.lang.String id;
        private final com.hashicorp.cdktf.providers.google.ComputeFirewallLogConfig logConfig;
        private final java.lang.Number priority;
        private final java.lang.String project;
        private final java.util.List<java.lang.String> sourceRanges;
        private final java.util.List<java.lang.String> sourceServiceAccounts;
        private final java.util.List<java.lang.String> sourceTags;
        private final java.util.List<java.lang.String> targetServiceAccounts;
        private final java.util.List<java.lang.String> targetTags;
        private final com.hashicorp.cdktf.providers.google.ComputeFirewallTimeouts timeouts;
        private final java.lang.Object connection;
        private final java.lang.Number count;
        private final java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        private final com.hashicorp.cdktf.ITerraformIterator forEach;
        private final com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        private final com.hashicorp.cdktf.TerraformProvider provider;
        private final java.util.List<java.lang.Object> provisioners;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.network = software.amazon.jsii.Kernel.get(this, "network", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.allow = software.amazon.jsii.Kernel.get(this, "allow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deny = software.amazon.jsii.Kernel.get(this, "deny", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destinationRanges = software.amazon.jsii.Kernel.get(this, "destinationRanges", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.direction = software.amazon.jsii.Kernel.get(this, "direction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.disabled = software.amazon.jsii.Kernel.get(this, "disabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enableLogging = software.amazon.jsii.Kernel.get(this, "enableLogging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logConfig = software.amazon.jsii.Kernel.get(this, "logConfig", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.ComputeFirewallLogConfig.class));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.project = software.amazon.jsii.Kernel.get(this, "project", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceRanges = software.amazon.jsii.Kernel.get(this, "sourceRanges", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.sourceServiceAccounts = software.amazon.jsii.Kernel.get(this, "sourceServiceAccounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.sourceTags = software.amazon.jsii.Kernel.get(this, "sourceTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.targetServiceAccounts = software.amazon.jsii.Kernel.get(this, "targetServiceAccounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.targetTags = software.amazon.jsii.Kernel.get(this, "targetTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.timeouts = software.amazon.jsii.Kernel.get(this, "timeouts", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.ComputeFirewallTimeouts.class));
            this.connection = software.amazon.jsii.Kernel.get(this, "connection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.dependsOn = software.amazon.jsii.Kernel.get(this, "dependsOn", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformDependable.class)));
            this.forEach = software.amazon.jsii.Kernel.get(this, "forEach", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformIterator.class));
            this.lifecycle = software.amazon.jsii.Kernel.get(this, "lifecycle", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformResourceLifecycle.class));
            this.provider = software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformProvider.class));
            this.provisioners = software.amazon.jsii.Kernel.get(this, "provisioners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.network = java.util.Objects.requireNonNull(builder.network, "network is required");
            this.allow = builder.allow;
            this.deny = builder.deny;
            this.description = builder.description;
            this.destinationRanges = builder.destinationRanges;
            this.direction = builder.direction;
            this.disabled = builder.disabled;
            this.enableLogging = builder.enableLogging;
            this.id = builder.id;
            this.logConfig = builder.logConfig;
            this.priority = builder.priority;
            this.project = builder.project;
            this.sourceRanges = builder.sourceRanges;
            this.sourceServiceAccounts = builder.sourceServiceAccounts;
            this.sourceTags = builder.sourceTags;
            this.targetServiceAccounts = builder.targetServiceAccounts;
            this.targetTags = builder.targetTags;
            this.timeouts = builder.timeouts;
            this.connection = builder.connection;
            this.count = builder.count;
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)builder.dependsOn;
            this.forEach = builder.forEach;
            this.lifecycle = builder.lifecycle;
            this.provider = builder.provider;
            this.provisioners = (java.util.List<java.lang.Object>)builder.provisioners;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getNetwork() {
            return this.network;
        }

        @Override
        public final java.lang.Object getAllow() {
            return this.allow;
        }

        @Override
        public final java.lang.Object getDeny() {
            return this.deny;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<java.lang.String> getDestinationRanges() {
            return this.destinationRanges;
        }

        @Override
        public final java.lang.String getDirection() {
            return this.direction;
        }

        @Override
        public final java.lang.Object getDisabled() {
            return this.disabled;
        }

        @Override
        public final java.lang.Object getEnableLogging() {
            return this.enableLogging;
        }

        @Override
        public final java.lang.String getId() {
            return this.id;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.ComputeFirewallLogConfig getLogConfig() {
            return this.logConfig;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public final java.lang.String getProject() {
            return this.project;
        }

        @Override
        public final java.util.List<java.lang.String> getSourceRanges() {
            return this.sourceRanges;
        }

        @Override
        public final java.util.List<java.lang.String> getSourceServiceAccounts() {
            return this.sourceServiceAccounts;
        }

        @Override
        public final java.util.List<java.lang.String> getSourceTags() {
            return this.sourceTags;
        }

        @Override
        public final java.util.List<java.lang.String> getTargetServiceAccounts() {
            return this.targetServiceAccounts;
        }

        @Override
        public final java.util.List<java.lang.String> getTargetTags() {
            return this.targetTags;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.ComputeFirewallTimeouts getTimeouts() {
            return this.timeouts;
        }

        @Override
        public final java.lang.Object getConnection() {
            return this.connection;
        }

        @Override
        public final java.lang.Number getCount() {
            return this.count;
        }

        @Override
        public final java.util.List<com.hashicorp.cdktf.ITerraformDependable> getDependsOn() {
            return this.dependsOn;
        }

        @Override
        public final com.hashicorp.cdktf.ITerraformIterator getForEach() {
            return this.forEach;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformResourceLifecycle getLifecycle() {
            return this.lifecycle;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformProvider getProvider() {
            return this.provider;
        }

        @Override
        public final java.util.List<java.lang.Object> getProvisioners() {
            return this.provisioners;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("network", om.valueToTree(this.getNetwork()));
            if (this.getAllow() != null) {
                data.set("allow", om.valueToTree(this.getAllow()));
            }
            if (this.getDeny() != null) {
                data.set("deny", om.valueToTree(this.getDeny()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDestinationRanges() != null) {
                data.set("destinationRanges", om.valueToTree(this.getDestinationRanges()));
            }
            if (this.getDirection() != null) {
                data.set("direction", om.valueToTree(this.getDirection()));
            }
            if (this.getDisabled() != null) {
                data.set("disabled", om.valueToTree(this.getDisabled()));
            }
            if (this.getEnableLogging() != null) {
                data.set("enableLogging", om.valueToTree(this.getEnableLogging()));
            }
            if (this.getId() != null) {
                data.set("id", om.valueToTree(this.getId()));
            }
            if (this.getLogConfig() != null) {
                data.set("logConfig", om.valueToTree(this.getLogConfig()));
            }
            if (this.getPriority() != null) {
                data.set("priority", om.valueToTree(this.getPriority()));
            }
            if (this.getProject() != null) {
                data.set("project", om.valueToTree(this.getProject()));
            }
            if (this.getSourceRanges() != null) {
                data.set("sourceRanges", om.valueToTree(this.getSourceRanges()));
            }
            if (this.getSourceServiceAccounts() != null) {
                data.set("sourceServiceAccounts", om.valueToTree(this.getSourceServiceAccounts()));
            }
            if (this.getSourceTags() != null) {
                data.set("sourceTags", om.valueToTree(this.getSourceTags()));
            }
            if (this.getTargetServiceAccounts() != null) {
                data.set("targetServiceAccounts", om.valueToTree(this.getTargetServiceAccounts()));
            }
            if (this.getTargetTags() != null) {
                data.set("targetTags", om.valueToTree(this.getTargetTags()));
            }
            if (this.getTimeouts() != null) {
                data.set("timeouts", om.valueToTree(this.getTimeouts()));
            }
            if (this.getConnection() != null) {
                data.set("connection", om.valueToTree(this.getConnection()));
            }
            if (this.getCount() != null) {
                data.set("count", om.valueToTree(this.getCount()));
            }
            if (this.getDependsOn() != null) {
                data.set("dependsOn", om.valueToTree(this.getDependsOn()));
            }
            if (this.getForEach() != null) {
                data.set("forEach", om.valueToTree(this.getForEach()));
            }
            if (this.getLifecycle() != null) {
                data.set("lifecycle", om.valueToTree(this.getLifecycle()));
            }
            if (this.getProvider() != null) {
                data.set("provider", om.valueToTree(this.getProvider()));
            }
            if (this.getProvisioners() != null) {
                data.set("provisioners", om.valueToTree(this.getProvisioners()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.ComputeFirewallConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ComputeFirewallConfig.Jsii$Proxy that = (ComputeFirewallConfig.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!network.equals(that.network)) return false;
            if (this.allow != null ? !this.allow.equals(that.allow) : that.allow != null) return false;
            if (this.deny != null ? !this.deny.equals(that.deny) : that.deny != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.destinationRanges != null ? !this.destinationRanges.equals(that.destinationRanges) : that.destinationRanges != null) return false;
            if (this.direction != null ? !this.direction.equals(that.direction) : that.direction != null) return false;
            if (this.disabled != null ? !this.disabled.equals(that.disabled) : that.disabled != null) return false;
            if (this.enableLogging != null ? !this.enableLogging.equals(that.enableLogging) : that.enableLogging != null) return false;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
            if (this.logConfig != null ? !this.logConfig.equals(that.logConfig) : that.logConfig != null) return false;
            if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) return false;
            if (this.project != null ? !this.project.equals(that.project) : that.project != null) return false;
            if (this.sourceRanges != null ? !this.sourceRanges.equals(that.sourceRanges) : that.sourceRanges != null) return false;
            if (this.sourceServiceAccounts != null ? !this.sourceServiceAccounts.equals(that.sourceServiceAccounts) : that.sourceServiceAccounts != null) return false;
            if (this.sourceTags != null ? !this.sourceTags.equals(that.sourceTags) : that.sourceTags != null) return false;
            if (this.targetServiceAccounts != null ? !this.targetServiceAccounts.equals(that.targetServiceAccounts) : that.targetServiceAccounts != null) return false;
            if (this.targetTags != null ? !this.targetTags.equals(that.targetTags) : that.targetTags != null) return false;
            if (this.timeouts != null ? !this.timeouts.equals(that.timeouts) : that.timeouts != null) return false;
            if (this.connection != null ? !this.connection.equals(that.connection) : that.connection != null) return false;
            if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
            if (this.dependsOn != null ? !this.dependsOn.equals(that.dependsOn) : that.dependsOn != null) return false;
            if (this.forEach != null ? !this.forEach.equals(that.forEach) : that.forEach != null) return false;
            if (this.lifecycle != null ? !this.lifecycle.equals(that.lifecycle) : that.lifecycle != null) return false;
            if (this.provider != null ? !this.provider.equals(that.provider) : that.provider != null) return false;
            return this.provisioners != null ? this.provisioners.equals(that.provisioners) : that.provisioners == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.network.hashCode());
            result = 31 * result + (this.allow != null ? this.allow.hashCode() : 0);
            result = 31 * result + (this.deny != null ? this.deny.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.destinationRanges != null ? this.destinationRanges.hashCode() : 0);
            result = 31 * result + (this.direction != null ? this.direction.hashCode() : 0);
            result = 31 * result + (this.disabled != null ? this.disabled.hashCode() : 0);
            result = 31 * result + (this.enableLogging != null ? this.enableLogging.hashCode() : 0);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.logConfig != null ? this.logConfig.hashCode() : 0);
            result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
            result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
            result = 31 * result + (this.sourceRanges != null ? this.sourceRanges.hashCode() : 0);
            result = 31 * result + (this.sourceServiceAccounts != null ? this.sourceServiceAccounts.hashCode() : 0);
            result = 31 * result + (this.sourceTags != null ? this.sourceTags.hashCode() : 0);
            result = 31 * result + (this.targetServiceAccounts != null ? this.targetServiceAccounts.hashCode() : 0);
            result = 31 * result + (this.targetTags != null ? this.targetTags.hashCode() : 0);
            result = 31 * result + (this.timeouts != null ? this.timeouts.hashCode() : 0);
            result = 31 * result + (this.connection != null ? this.connection.hashCode() : 0);
            result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
            result = 31 * result + (this.dependsOn != null ? this.dependsOn.hashCode() : 0);
            result = 31 * result + (this.forEach != null ? this.forEach.hashCode() : 0);
            result = 31 * result + (this.lifecycle != null ? this.lifecycle.hashCode() : 0);
            result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
            result = 31 * result + (this.provisioners != null ? this.provisioners.hashCode() : 0);
            return result;
        }
    }
}
