package com.hashicorp.cdktf.providers.google;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-10-03T00:49:21.760Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.ComputeRouterNatConfig")
@software.amazon.jsii.Jsii.Proxy(ComputeRouterNatConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ComputeRouterNatConfig extends software.amazon.jsii.JsiiSerializable, com.hashicorp.cdktf.TerraformMetaArguments {

    /**
     * Name of the NAT service. The name must be 1-63 characters long and comply with RFC1035.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#name ComputeRouterNat#name}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * How external IPs should be allocated for this NAT.
     * <p>
     * Valid values are
     * 'AUTO_ONLY' for only allowing NAT IPs allocated by Google Cloud
     * Platform, or 'MANUAL_ONLY' for only user-allocated NAT IP addresses. Possible values: ["MANUAL_ONLY", "AUTO_ONLY"]
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#nat_ip_allocate_option ComputeRouterNat#nat_ip_allocate_option}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNatIpAllocateOption();

    /**
     * The name of the Cloud Router in which this NAT will be configured.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#router ComputeRouterNat#router}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRouter();

    /**
     * How NAT should be configured per Subnetwork.
     * <p>
     * If 'ALL_SUBNETWORKS_ALL_IP_RANGES', all of the
     * IP ranges in every Subnetwork are allowed to Nat.
     * If 'ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES', all of the primary IP
     * ranges in every Subnetwork are allowed to Nat.
     * 'LIST_OF_SUBNETWORKS': A list of Subnetworks are allowed to Nat
     * (specified in the field subnetwork below). Note that if this field
     * contains ALL_SUBNETWORKS_ALL_IP_RANGES or
     * ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any
     * other RouterNat section in any Router for this network in this region. Possible values: ["ALL_SUBNETWORKS_ALL_IP_RANGES", "ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES", "LIST_OF_SUBNETWORKS"]
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#source_subnetwork_ip_ranges_to_nat ComputeRouterNat#source_subnetwork_ip_ranges_to_nat}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceSubnetworkIpRangesToNat();

    /**
     * A list of URLs of the IP resources to be drained.
     * <p>
     * These IPs must be
     * valid static external IPs that have been assigned to the NAT.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#drain_nat_ips ComputeRouterNat#drain_nat_ips}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDrainNatIps() {
        return null;
    }

    /**
     * Enable Dynamic Port Allocation.
     * <p>
     * If minPortsPerVm is set, minPortsPerVm must be set to a power of two greater than or equal to 32.
     * If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config.
     * If maxPortsPerVm is set, maxPortsPerVm must be set to a power of two greater than minPortsPerVm.
     * If maxPortsPerVm is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
     * <p>
     * Mutually exclusive with enableEndpointIndependentMapping.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#enable_dynamic_port_allocation ComputeRouterNat#enable_dynamic_port_allocation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableDynamicPortAllocation() {
        return null;
    }

    /**
     * Specifies if endpoint independent mapping is enabled. This is enabled by default. For more information see the [official documentation](https://cloud.google.com/nat/docs/overview#specs-rfcs).
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#enable_endpoint_independent_mapping ComputeRouterNat#enable_endpoint_independent_mapping}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableEndpointIndependentMapping() {
        return null;
    }

    /**
     * Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#icmp_idle_timeout_sec ComputeRouterNat#icmp_idle_timeout_sec}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIcmpIdleTimeoutSec() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat#id ComputeRouterNat#id}.
     * <p>
     * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
     * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getId() {
        return null;
    }

    /**
     * log_config block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#log_config ComputeRouterNat#log_config}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.ComputeRouterNatLogConfig getLogConfig() {
        return null;
    }

    /**
     * Maximum number of ports allocated to a VM from this NAT.
     * <p>
     * This field can only be set when enableDynamicPortAllocation is enabled.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#max_ports_per_vm ComputeRouterNat#max_ports_per_vm}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxPortsPerVm() {
        return null;
    }

    /**
     * Minimum number of ports allocated to a VM from this NAT.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#min_ports_per_vm ComputeRouterNat#min_ports_per_vm}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinPortsPerVm() {
        return null;
    }

    /**
     * Self-links of NAT IPs. Only valid if natIpAllocateOption is set to MANUAL_ONLY.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#nat_ips ComputeRouterNat#nat_ips}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNatIps() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat#project ComputeRouterNat#project}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProject() {
        return null;
    }

    /**
     * Region where the router and NAT reside.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#region ComputeRouterNat#region}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * subnetwork block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#subnetwork ComputeRouterNat#subnetwork}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSubnetwork() {
        return null;
    }

    /**
     * Timeout (in seconds) for TCP established connections. Defaults to 1200s if not set.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#tcp_established_idle_timeout_sec ComputeRouterNat#tcp_established_idle_timeout_sec}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTcpEstablishedIdleTimeoutSec() {
        return null;
    }

    /**
     * Timeout (in seconds) for TCP transitory connections. Defaults to 30s if not set.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#tcp_transitory_idle_timeout_sec ComputeRouterNat#tcp_transitory_idle_timeout_sec}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTcpTransitoryIdleTimeoutSec() {
        return null;
    }

    /**
     * timeouts block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#timeouts ComputeRouterNat#timeouts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.ComputeRouterNatTimeouts getTimeouts() {
        return null;
    }

    /**
     * Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#udp_idle_timeout_sec ComputeRouterNat#udp_idle_timeout_sec}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getUdpIdleTimeoutSec() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ComputeRouterNatConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ComputeRouterNatConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ComputeRouterNatConfig> {
        java.lang.String name;
        java.lang.String natIpAllocateOption;
        java.lang.String router;
        java.lang.String sourceSubnetworkIpRangesToNat;
        java.util.List<java.lang.String> drainNatIps;
        java.lang.Object enableDynamicPortAllocation;
        java.lang.Object enableEndpointIndependentMapping;
        java.lang.Number icmpIdleTimeoutSec;
        java.lang.String id;
        com.hashicorp.cdktf.providers.google.ComputeRouterNatLogConfig logConfig;
        java.lang.Number maxPortsPerVm;
        java.lang.Number minPortsPerVm;
        java.util.List<java.lang.String> natIps;
        java.lang.String project;
        java.lang.String region;
        java.lang.Object subnetwork;
        java.lang.Number tcpEstablishedIdleTimeoutSec;
        java.lang.Number tcpTransitoryIdleTimeoutSec;
        com.hashicorp.cdktf.providers.google.ComputeRouterNatTimeouts timeouts;
        java.lang.Number udpIdleTimeoutSec;
        java.lang.Object connection;
        java.lang.Number count;
        java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        com.hashicorp.cdktf.ITerraformIterator forEach;
        com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        com.hashicorp.cdktf.TerraformProvider provider;
        java.util.List<java.lang.Object> provisioners;

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getName}
         * @param name Name of the NAT service. The name must be 1-63 characters long and comply with RFC1035. This parameter is required.
         *             Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#name ComputeRouterNat#name}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getNatIpAllocateOption}
         * @param natIpAllocateOption How external IPs should be allocated for this NAT. This parameter is required.
         *                            Valid values are
         *                            'AUTO_ONLY' for only allowing NAT IPs allocated by Google Cloud
         *                            Platform, or 'MANUAL_ONLY' for only user-allocated NAT IP addresses. Possible values: ["MANUAL_ONLY", "AUTO_ONLY"]
         *                            <p>
         *                            Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#nat_ip_allocate_option ComputeRouterNat#nat_ip_allocate_option}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder natIpAllocateOption(java.lang.String natIpAllocateOption) {
            this.natIpAllocateOption = natIpAllocateOption;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getRouter}
         * @param router The name of the Cloud Router in which this NAT will be configured. This parameter is required.
         *               Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#router ComputeRouterNat#router}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder router(java.lang.String router) {
            this.router = router;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getSourceSubnetworkIpRangesToNat}
         * @param sourceSubnetworkIpRangesToNat How NAT should be configured per Subnetwork. This parameter is required.
         *                                      If 'ALL_SUBNETWORKS_ALL_IP_RANGES', all of the
         *                                      IP ranges in every Subnetwork are allowed to Nat.
         *                                      If 'ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES', all of the primary IP
         *                                      ranges in every Subnetwork are allowed to Nat.
         *                                      'LIST_OF_SUBNETWORKS': A list of Subnetworks are allowed to Nat
         *                                      (specified in the field subnetwork below). Note that if this field
         *                                      contains ALL_SUBNETWORKS_ALL_IP_RANGES or
         *                                      ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any
         *                                      other RouterNat section in any Router for this network in this region. Possible values: ["ALL_SUBNETWORKS_ALL_IP_RANGES", "ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES", "LIST_OF_SUBNETWORKS"]
         *                                      <p>
         *                                      Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#source_subnetwork_ip_ranges_to_nat ComputeRouterNat#source_subnetwork_ip_ranges_to_nat}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceSubnetworkIpRangesToNat(java.lang.String sourceSubnetworkIpRangesToNat) {
            this.sourceSubnetworkIpRangesToNat = sourceSubnetworkIpRangesToNat;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getDrainNatIps}
         * @param drainNatIps A list of URLs of the IP resources to be drained.
         *                    These IPs must be
         *                    valid static external IPs that have been assigned to the NAT.
         *                    <p>
         *                    Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#drain_nat_ips ComputeRouterNat#drain_nat_ips}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder drainNatIps(java.util.List<java.lang.String> drainNatIps) {
            this.drainNatIps = drainNatIps;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getEnableDynamicPortAllocation}
         * @param enableDynamicPortAllocation Enable Dynamic Port Allocation.
         *                                    If minPortsPerVm is set, minPortsPerVm must be set to a power of two greater than or equal to 32.
         *                                    If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config.
         *                                    If maxPortsPerVm is set, maxPortsPerVm must be set to a power of two greater than minPortsPerVm.
         *                                    If maxPortsPerVm is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
         *                                    <p>
         *                                    Mutually exclusive with enableEndpointIndependentMapping.
         *                                    <p>
         *                                    Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#enable_dynamic_port_allocation ComputeRouterNat#enable_dynamic_port_allocation}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableDynamicPortAllocation(java.lang.Boolean enableDynamicPortAllocation) {
            this.enableDynamicPortAllocation = enableDynamicPortAllocation;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getEnableDynamicPortAllocation}
         * @param enableDynamicPortAllocation Enable Dynamic Port Allocation.
         *                                    If minPortsPerVm is set, minPortsPerVm must be set to a power of two greater than or equal to 32.
         *                                    If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config.
         *                                    If maxPortsPerVm is set, maxPortsPerVm must be set to a power of two greater than minPortsPerVm.
         *                                    If maxPortsPerVm is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
         *                                    <p>
         *                                    Mutually exclusive with enableEndpointIndependentMapping.
         *                                    <p>
         *                                    Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#enable_dynamic_port_allocation ComputeRouterNat#enable_dynamic_port_allocation}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableDynamicPortAllocation(com.hashicorp.cdktf.IResolvable enableDynamicPortAllocation) {
            this.enableDynamicPortAllocation = enableDynamicPortAllocation;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getEnableEndpointIndependentMapping}
         * @param enableEndpointIndependentMapping Specifies if endpoint independent mapping is enabled. This is enabled by default. For more information see the [official documentation](https://cloud.google.com/nat/docs/overview#specs-rfcs).
         *                                         Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#enable_endpoint_independent_mapping ComputeRouterNat#enable_endpoint_independent_mapping}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableEndpointIndependentMapping(java.lang.Boolean enableEndpointIndependentMapping) {
            this.enableEndpointIndependentMapping = enableEndpointIndependentMapping;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getEnableEndpointIndependentMapping}
         * @param enableEndpointIndependentMapping Specifies if endpoint independent mapping is enabled. This is enabled by default. For more information see the [official documentation](https://cloud.google.com/nat/docs/overview#specs-rfcs).
         *                                         Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#enable_endpoint_independent_mapping ComputeRouterNat#enable_endpoint_independent_mapping}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableEndpointIndependentMapping(com.hashicorp.cdktf.IResolvable enableEndpointIndependentMapping) {
            this.enableEndpointIndependentMapping = enableEndpointIndependentMapping;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getIcmpIdleTimeoutSec}
         * @param icmpIdleTimeoutSec Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
         *                           Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#icmp_idle_timeout_sec ComputeRouterNat#icmp_idle_timeout_sec}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder icmpIdleTimeoutSec(java.lang.Number icmpIdleTimeoutSec) {
            this.icmpIdleTimeoutSec = icmpIdleTimeoutSec;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getId}
         * @param id Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat#id ComputeRouterNat#id}.
         *           Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
         *           If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getLogConfig}
         * @param logConfig log_config block.
         *                  Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#log_config ComputeRouterNat#log_config}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfig(com.hashicorp.cdktf.providers.google.ComputeRouterNatLogConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getMaxPortsPerVm}
         * @param maxPortsPerVm Maximum number of ports allocated to a VM from this NAT.
         *                      This field can only be set when enableDynamicPortAllocation is enabled.
         *                      <p>
         *                      Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#max_ports_per_vm ComputeRouterNat#max_ports_per_vm}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxPortsPerVm(java.lang.Number maxPortsPerVm) {
            this.maxPortsPerVm = maxPortsPerVm;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getMinPortsPerVm}
         * @param minPortsPerVm Minimum number of ports allocated to a VM from this NAT.
         *                      Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#min_ports_per_vm ComputeRouterNat#min_ports_per_vm}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minPortsPerVm(java.lang.Number minPortsPerVm) {
            this.minPortsPerVm = minPortsPerVm;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getNatIps}
         * @param natIps Self-links of NAT IPs. Only valid if natIpAllocateOption is set to MANUAL_ONLY.
         *               Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#nat_ips ComputeRouterNat#nat_ips}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder natIps(java.util.List<java.lang.String> natIps) {
            this.natIps = natIps;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getProject}
         * @param project Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat#project ComputeRouterNat#project}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder project(java.lang.String project) {
            this.project = project;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getRegion}
         * @param region Region where the router and NAT reside.
         *               Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#region ComputeRouterNat#region}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getSubnetwork}
         * @param subnetwork subnetwork block.
         *                   Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#subnetwork ComputeRouterNat#subnetwork}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetwork(com.hashicorp.cdktf.IResolvable subnetwork) {
            this.subnetwork = subnetwork;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getSubnetwork}
         * @param subnetwork subnetwork block.
         *                   Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#subnetwork ComputeRouterNat#subnetwork}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetwork(java.util.List<? extends com.hashicorp.cdktf.providers.google.ComputeRouterNatSubnetwork> subnetwork) {
            this.subnetwork = subnetwork;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getTcpEstablishedIdleTimeoutSec}
         * @param tcpEstablishedIdleTimeoutSec Timeout (in seconds) for TCP established connections. Defaults to 1200s if not set.
         *                                     Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#tcp_established_idle_timeout_sec ComputeRouterNat#tcp_established_idle_timeout_sec}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tcpEstablishedIdleTimeoutSec(java.lang.Number tcpEstablishedIdleTimeoutSec) {
            this.tcpEstablishedIdleTimeoutSec = tcpEstablishedIdleTimeoutSec;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getTcpTransitoryIdleTimeoutSec}
         * @param tcpTransitoryIdleTimeoutSec Timeout (in seconds) for TCP transitory connections. Defaults to 30s if not set.
         *                                    Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#tcp_transitory_idle_timeout_sec ComputeRouterNat#tcp_transitory_idle_timeout_sec}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tcpTransitoryIdleTimeoutSec(java.lang.Number tcpTransitoryIdleTimeoutSec) {
            this.tcpTransitoryIdleTimeoutSec = tcpTransitoryIdleTimeoutSec;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getTimeouts}
         * @param timeouts timeouts block.
         *                 Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#timeouts ComputeRouterNat#timeouts}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeouts(com.hashicorp.cdktf.providers.google.ComputeRouterNatTimeouts timeouts) {
            this.timeouts = timeouts;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getUdpIdleTimeoutSec}
         * @param udpIdleTimeoutSec Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
         *                          Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_nat#udp_idle_timeout_sec ComputeRouterNat#udp_idle_timeout_sec}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder udpIdleTimeoutSec(java.lang.Number udpIdleTimeoutSec) {
            this.udpIdleTimeoutSec = udpIdleTimeoutSec;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.SSHProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.WinrmProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getCount}
         * @param count the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder count(java.lang.Number count) {
            this.count = count;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getDependsOn}
         * @param dependsOn the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder dependsOn(java.util.List<? extends com.hashicorp.cdktf.ITerraformDependable> dependsOn) {
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)dependsOn;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getForEach}
         * @param forEach the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder forEach(com.hashicorp.cdktf.ITerraformIterator forEach) {
            this.forEach = forEach;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getLifecycle}
         * @param lifecycle the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lifecycle(com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getProvider}
         * @param provider the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder provider(com.hashicorp.cdktf.TerraformProvider provider) {
            this.provider = provider;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterNatConfig#getProvisioners}
         * @param provisioners the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder provisioners(java.util.List<? extends java.lang.Object> provisioners) {
            this.provisioners = (java.util.List<java.lang.Object>)provisioners;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ComputeRouterNatConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ComputeRouterNatConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ComputeRouterNatConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComputeRouterNatConfig {
        private final java.lang.String name;
        private final java.lang.String natIpAllocateOption;
        private final java.lang.String router;
        private final java.lang.String sourceSubnetworkIpRangesToNat;
        private final java.util.List<java.lang.String> drainNatIps;
        private final java.lang.Object enableDynamicPortAllocation;
        private final java.lang.Object enableEndpointIndependentMapping;
        private final java.lang.Number icmpIdleTimeoutSec;
        private final java.lang.String id;
        private final com.hashicorp.cdktf.providers.google.ComputeRouterNatLogConfig logConfig;
        private final java.lang.Number maxPortsPerVm;
        private final java.lang.Number minPortsPerVm;
        private final java.util.List<java.lang.String> natIps;
        private final java.lang.String project;
        private final java.lang.String region;
        private final java.lang.Object subnetwork;
        private final java.lang.Number tcpEstablishedIdleTimeoutSec;
        private final java.lang.Number tcpTransitoryIdleTimeoutSec;
        private final com.hashicorp.cdktf.providers.google.ComputeRouterNatTimeouts timeouts;
        private final java.lang.Number udpIdleTimeoutSec;
        private final java.lang.Object connection;
        private final java.lang.Number count;
        private final java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        private final com.hashicorp.cdktf.ITerraformIterator forEach;
        private final com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        private final com.hashicorp.cdktf.TerraformProvider provider;
        private final java.util.List<java.lang.Object> provisioners;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.natIpAllocateOption = software.amazon.jsii.Kernel.get(this, "natIpAllocateOption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.router = software.amazon.jsii.Kernel.get(this, "router", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceSubnetworkIpRangesToNat = software.amazon.jsii.Kernel.get(this, "sourceSubnetworkIpRangesToNat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.drainNatIps = software.amazon.jsii.Kernel.get(this, "drainNatIps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.enableDynamicPortAllocation = software.amazon.jsii.Kernel.get(this, "enableDynamicPortAllocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enableEndpointIndependentMapping = software.amazon.jsii.Kernel.get(this, "enableEndpointIndependentMapping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.icmpIdleTimeoutSec = software.amazon.jsii.Kernel.get(this, "icmpIdleTimeoutSec", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logConfig = software.amazon.jsii.Kernel.get(this, "logConfig", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.ComputeRouterNatLogConfig.class));
            this.maxPortsPerVm = software.amazon.jsii.Kernel.get(this, "maxPortsPerVm", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minPortsPerVm = software.amazon.jsii.Kernel.get(this, "minPortsPerVm", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.natIps = software.amazon.jsii.Kernel.get(this, "natIps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.project = software.amazon.jsii.Kernel.get(this, "project", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnetwork = software.amazon.jsii.Kernel.get(this, "subnetwork", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tcpEstablishedIdleTimeoutSec = software.amazon.jsii.Kernel.get(this, "tcpEstablishedIdleTimeoutSec", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tcpTransitoryIdleTimeoutSec = software.amazon.jsii.Kernel.get(this, "tcpTransitoryIdleTimeoutSec", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.timeouts = software.amazon.jsii.Kernel.get(this, "timeouts", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.ComputeRouterNatTimeouts.class));
            this.udpIdleTimeoutSec = software.amazon.jsii.Kernel.get(this, "udpIdleTimeoutSec", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.connection = software.amazon.jsii.Kernel.get(this, "connection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.dependsOn = software.amazon.jsii.Kernel.get(this, "dependsOn", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformDependable.class)));
            this.forEach = software.amazon.jsii.Kernel.get(this, "forEach", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformIterator.class));
            this.lifecycle = software.amazon.jsii.Kernel.get(this, "lifecycle", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformResourceLifecycle.class));
            this.provider = software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformProvider.class));
            this.provisioners = software.amazon.jsii.Kernel.get(this, "provisioners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.natIpAllocateOption = java.util.Objects.requireNonNull(builder.natIpAllocateOption, "natIpAllocateOption is required");
            this.router = java.util.Objects.requireNonNull(builder.router, "router is required");
            this.sourceSubnetworkIpRangesToNat = java.util.Objects.requireNonNull(builder.sourceSubnetworkIpRangesToNat, "sourceSubnetworkIpRangesToNat is required");
            this.drainNatIps = builder.drainNatIps;
            this.enableDynamicPortAllocation = builder.enableDynamicPortAllocation;
            this.enableEndpointIndependentMapping = builder.enableEndpointIndependentMapping;
            this.icmpIdleTimeoutSec = builder.icmpIdleTimeoutSec;
            this.id = builder.id;
            this.logConfig = builder.logConfig;
            this.maxPortsPerVm = builder.maxPortsPerVm;
            this.minPortsPerVm = builder.minPortsPerVm;
            this.natIps = builder.natIps;
            this.project = builder.project;
            this.region = builder.region;
            this.subnetwork = builder.subnetwork;
            this.tcpEstablishedIdleTimeoutSec = builder.tcpEstablishedIdleTimeoutSec;
            this.tcpTransitoryIdleTimeoutSec = builder.tcpTransitoryIdleTimeoutSec;
            this.timeouts = builder.timeouts;
            this.udpIdleTimeoutSec = builder.udpIdleTimeoutSec;
            this.connection = builder.connection;
            this.count = builder.count;
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)builder.dependsOn;
            this.forEach = builder.forEach;
            this.lifecycle = builder.lifecycle;
            this.provider = builder.provider;
            this.provisioners = (java.util.List<java.lang.Object>)builder.provisioners;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getNatIpAllocateOption() {
            return this.natIpAllocateOption;
        }

        @Override
        public final java.lang.String getRouter() {
            return this.router;
        }

        @Override
        public final java.lang.String getSourceSubnetworkIpRangesToNat() {
            return this.sourceSubnetworkIpRangesToNat;
        }

        @Override
        public final java.util.List<java.lang.String> getDrainNatIps() {
            return this.drainNatIps;
        }

        @Override
        public final java.lang.Object getEnableDynamicPortAllocation() {
            return this.enableDynamicPortAllocation;
        }

        @Override
        public final java.lang.Object getEnableEndpointIndependentMapping() {
            return this.enableEndpointIndependentMapping;
        }

        @Override
        public final java.lang.Number getIcmpIdleTimeoutSec() {
            return this.icmpIdleTimeoutSec;
        }

        @Override
        public final java.lang.String getId() {
            return this.id;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.ComputeRouterNatLogConfig getLogConfig() {
            return this.logConfig;
        }

        @Override
        public final java.lang.Number getMaxPortsPerVm() {
            return this.maxPortsPerVm;
        }

        @Override
        public final java.lang.Number getMinPortsPerVm() {
            return this.minPortsPerVm;
        }

        @Override
        public final java.util.List<java.lang.String> getNatIps() {
            return this.natIps;
        }

        @Override
        public final java.lang.String getProject() {
            return this.project;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.lang.Object getSubnetwork() {
            return this.subnetwork;
        }

        @Override
        public final java.lang.Number getTcpEstablishedIdleTimeoutSec() {
            return this.tcpEstablishedIdleTimeoutSec;
        }

        @Override
        public final java.lang.Number getTcpTransitoryIdleTimeoutSec() {
            return this.tcpTransitoryIdleTimeoutSec;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.ComputeRouterNatTimeouts getTimeouts() {
            return this.timeouts;
        }

        @Override
        public final java.lang.Number getUdpIdleTimeoutSec() {
            return this.udpIdleTimeoutSec;
        }

        @Override
        public final java.lang.Object getConnection() {
            return this.connection;
        }

        @Override
        public final java.lang.Number getCount() {
            return this.count;
        }

        @Override
        public final java.util.List<com.hashicorp.cdktf.ITerraformDependable> getDependsOn() {
            return this.dependsOn;
        }

        @Override
        public final com.hashicorp.cdktf.ITerraformIterator getForEach() {
            return this.forEach;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformResourceLifecycle getLifecycle() {
            return this.lifecycle;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformProvider getProvider() {
            return this.provider;
        }

        @Override
        public final java.util.List<java.lang.Object> getProvisioners() {
            return this.provisioners;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("natIpAllocateOption", om.valueToTree(this.getNatIpAllocateOption()));
            data.set("router", om.valueToTree(this.getRouter()));
            data.set("sourceSubnetworkIpRangesToNat", om.valueToTree(this.getSourceSubnetworkIpRangesToNat()));
            if (this.getDrainNatIps() != null) {
                data.set("drainNatIps", om.valueToTree(this.getDrainNatIps()));
            }
            if (this.getEnableDynamicPortAllocation() != null) {
                data.set("enableDynamicPortAllocation", om.valueToTree(this.getEnableDynamicPortAllocation()));
            }
            if (this.getEnableEndpointIndependentMapping() != null) {
                data.set("enableEndpointIndependentMapping", om.valueToTree(this.getEnableEndpointIndependentMapping()));
            }
            if (this.getIcmpIdleTimeoutSec() != null) {
                data.set("icmpIdleTimeoutSec", om.valueToTree(this.getIcmpIdleTimeoutSec()));
            }
            if (this.getId() != null) {
                data.set("id", om.valueToTree(this.getId()));
            }
            if (this.getLogConfig() != null) {
                data.set("logConfig", om.valueToTree(this.getLogConfig()));
            }
            if (this.getMaxPortsPerVm() != null) {
                data.set("maxPortsPerVm", om.valueToTree(this.getMaxPortsPerVm()));
            }
            if (this.getMinPortsPerVm() != null) {
                data.set("minPortsPerVm", om.valueToTree(this.getMinPortsPerVm()));
            }
            if (this.getNatIps() != null) {
                data.set("natIps", om.valueToTree(this.getNatIps()));
            }
            if (this.getProject() != null) {
                data.set("project", om.valueToTree(this.getProject()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getSubnetwork() != null) {
                data.set("subnetwork", om.valueToTree(this.getSubnetwork()));
            }
            if (this.getTcpEstablishedIdleTimeoutSec() != null) {
                data.set("tcpEstablishedIdleTimeoutSec", om.valueToTree(this.getTcpEstablishedIdleTimeoutSec()));
            }
            if (this.getTcpTransitoryIdleTimeoutSec() != null) {
                data.set("tcpTransitoryIdleTimeoutSec", om.valueToTree(this.getTcpTransitoryIdleTimeoutSec()));
            }
            if (this.getTimeouts() != null) {
                data.set("timeouts", om.valueToTree(this.getTimeouts()));
            }
            if (this.getUdpIdleTimeoutSec() != null) {
                data.set("udpIdleTimeoutSec", om.valueToTree(this.getUdpIdleTimeoutSec()));
            }
            if (this.getConnection() != null) {
                data.set("connection", om.valueToTree(this.getConnection()));
            }
            if (this.getCount() != null) {
                data.set("count", om.valueToTree(this.getCount()));
            }
            if (this.getDependsOn() != null) {
                data.set("dependsOn", om.valueToTree(this.getDependsOn()));
            }
            if (this.getForEach() != null) {
                data.set("forEach", om.valueToTree(this.getForEach()));
            }
            if (this.getLifecycle() != null) {
                data.set("lifecycle", om.valueToTree(this.getLifecycle()));
            }
            if (this.getProvider() != null) {
                data.set("provider", om.valueToTree(this.getProvider()));
            }
            if (this.getProvisioners() != null) {
                data.set("provisioners", om.valueToTree(this.getProvisioners()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.ComputeRouterNatConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ComputeRouterNatConfig.Jsii$Proxy that = (ComputeRouterNatConfig.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!natIpAllocateOption.equals(that.natIpAllocateOption)) return false;
            if (!router.equals(that.router)) return false;
            if (!sourceSubnetworkIpRangesToNat.equals(that.sourceSubnetworkIpRangesToNat)) return false;
            if (this.drainNatIps != null ? !this.drainNatIps.equals(that.drainNatIps) : that.drainNatIps != null) return false;
            if (this.enableDynamicPortAllocation != null ? !this.enableDynamicPortAllocation.equals(that.enableDynamicPortAllocation) : that.enableDynamicPortAllocation != null) return false;
            if (this.enableEndpointIndependentMapping != null ? !this.enableEndpointIndependentMapping.equals(that.enableEndpointIndependentMapping) : that.enableEndpointIndependentMapping != null) return false;
            if (this.icmpIdleTimeoutSec != null ? !this.icmpIdleTimeoutSec.equals(that.icmpIdleTimeoutSec) : that.icmpIdleTimeoutSec != null) return false;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
            if (this.logConfig != null ? !this.logConfig.equals(that.logConfig) : that.logConfig != null) return false;
            if (this.maxPortsPerVm != null ? !this.maxPortsPerVm.equals(that.maxPortsPerVm) : that.maxPortsPerVm != null) return false;
            if (this.minPortsPerVm != null ? !this.minPortsPerVm.equals(that.minPortsPerVm) : that.minPortsPerVm != null) return false;
            if (this.natIps != null ? !this.natIps.equals(that.natIps) : that.natIps != null) return false;
            if (this.project != null ? !this.project.equals(that.project) : that.project != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.subnetwork != null ? !this.subnetwork.equals(that.subnetwork) : that.subnetwork != null) return false;
            if (this.tcpEstablishedIdleTimeoutSec != null ? !this.tcpEstablishedIdleTimeoutSec.equals(that.tcpEstablishedIdleTimeoutSec) : that.tcpEstablishedIdleTimeoutSec != null) return false;
            if (this.tcpTransitoryIdleTimeoutSec != null ? !this.tcpTransitoryIdleTimeoutSec.equals(that.tcpTransitoryIdleTimeoutSec) : that.tcpTransitoryIdleTimeoutSec != null) return false;
            if (this.timeouts != null ? !this.timeouts.equals(that.timeouts) : that.timeouts != null) return false;
            if (this.udpIdleTimeoutSec != null ? !this.udpIdleTimeoutSec.equals(that.udpIdleTimeoutSec) : that.udpIdleTimeoutSec != null) return false;
            if (this.connection != null ? !this.connection.equals(that.connection) : that.connection != null) return false;
            if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
            if (this.dependsOn != null ? !this.dependsOn.equals(that.dependsOn) : that.dependsOn != null) return false;
            if (this.forEach != null ? !this.forEach.equals(that.forEach) : that.forEach != null) return false;
            if (this.lifecycle != null ? !this.lifecycle.equals(that.lifecycle) : that.lifecycle != null) return false;
            if (this.provider != null ? !this.provider.equals(that.provider) : that.provider != null) return false;
            return this.provisioners != null ? this.provisioners.equals(that.provisioners) : that.provisioners == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.natIpAllocateOption.hashCode());
            result = 31 * result + (this.router.hashCode());
            result = 31 * result + (this.sourceSubnetworkIpRangesToNat.hashCode());
            result = 31 * result + (this.drainNatIps != null ? this.drainNatIps.hashCode() : 0);
            result = 31 * result + (this.enableDynamicPortAllocation != null ? this.enableDynamicPortAllocation.hashCode() : 0);
            result = 31 * result + (this.enableEndpointIndependentMapping != null ? this.enableEndpointIndependentMapping.hashCode() : 0);
            result = 31 * result + (this.icmpIdleTimeoutSec != null ? this.icmpIdleTimeoutSec.hashCode() : 0);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.logConfig != null ? this.logConfig.hashCode() : 0);
            result = 31 * result + (this.maxPortsPerVm != null ? this.maxPortsPerVm.hashCode() : 0);
            result = 31 * result + (this.minPortsPerVm != null ? this.minPortsPerVm.hashCode() : 0);
            result = 31 * result + (this.natIps != null ? this.natIps.hashCode() : 0);
            result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.subnetwork != null ? this.subnetwork.hashCode() : 0);
            result = 31 * result + (this.tcpEstablishedIdleTimeoutSec != null ? this.tcpEstablishedIdleTimeoutSec.hashCode() : 0);
            result = 31 * result + (this.tcpTransitoryIdleTimeoutSec != null ? this.tcpTransitoryIdleTimeoutSec.hashCode() : 0);
            result = 31 * result + (this.timeouts != null ? this.timeouts.hashCode() : 0);
            result = 31 * result + (this.udpIdleTimeoutSec != null ? this.udpIdleTimeoutSec.hashCode() : 0);
            result = 31 * result + (this.connection != null ? this.connection.hashCode() : 0);
            result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
            result = 31 * result + (this.dependsOn != null ? this.dependsOn.hashCode() : 0);
            result = 31 * result + (this.forEach != null ? this.forEach.hashCode() : 0);
            result = 31 * result + (this.lifecycle != null ? this.lifecycle.hashCode() : 0);
            result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
            result = 31 * result + (this.provisioners != null ? this.provisioners.hashCode() : 0);
            return result;
        }
    }
}
