package com.hashicorp.cdktf.providers.google;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-10-03T00:49:21.767Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.ComputeRouterPeerConfig")
@software.amazon.jsii.Jsii.Proxy(ComputeRouterPeerConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ComputeRouterPeerConfig extends software.amazon.jsii.JsiiSerializable, com.hashicorp.cdktf.TerraformMetaArguments {

    /**
     * Name of the interface the BGP peer is associated with.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#interface ComputeRouterPeer#interface}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInterfaceValue();

    /**
     * Name of this BGP peer.
     * <p>
     * The name must be 1-63 characters long,
     * and comply with RFC1035. Specifically, the name must be 1-63 characters
     * long and match the regular expression '<a href="%5B-a-z0-9%5D*%5Ba-z0-9%5D">a-z</a>?' which
     * means the first character must be a lowercase letter, and all
     * following characters must be a dash, lowercase letter, or digit,
     * except the last character, which cannot be a dash.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#name ComputeRouterPeer#name}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Peer BGP Autonomous System Number (ASN). Each BGP interface may use a different value.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#peer_asn ComputeRouterPeer#peer_asn}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getPeerAsn();

    /**
     * IP address of the BGP interface outside Google Cloud Platform. Only IPv4 is supported.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#peer_ip_address ComputeRouterPeer#peer_ip_address}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPeerIpAddress();

    /**
     * The name of the Cloud Router in which this BgpPeer will be configured.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#router ComputeRouterPeer#router}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRouter();

    /**
     * User-specified list of prefix groups to advertise in custom mode, which can take one of the following options:.
     * <p>
     * 'ALL_SUBNETS': Advertises all available subnets, including peer VPC subnets.
     * 'ALL_VPC_SUBNETS': Advertises the router's own VPC subnets.
     * 'ALL_PEER_VPC_SUBNETS': Advertises peer subnets of the router's VPC network.
     * <p>
     * Note that this field can only be populated if advertiseMode is 'CUSTOM'
     * and overrides the list defined for the router (in the "bgp" message).
     * These groups are advertised in addition to any specified prefixes.
     * Leave this field blank to advertise no custom groups.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#advertised_groups ComputeRouterPeer#advertised_groups}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdvertisedGroups() {
        return null;
    }

    /**
     * advertised_ip_ranges block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#advertised_ip_ranges ComputeRouterPeer#advertised_ip_ranges}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAdvertisedIpRanges() {
        return null;
    }

    /**
     * The priority of routes advertised to this BGP peer.
     * <p>
     * Where there is more than one matching route of maximum
     * length, the routes with the lowest priority value win.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#advertised_route_priority ComputeRouterPeer#advertised_route_priority}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAdvertisedRoutePriority() {
        return null;
    }

    /**
     * User-specified flag to indicate which mode to use for advertisement.
     * <p>
     * Valid values of this enum field are: 'DEFAULT', 'CUSTOM' Default value: "DEFAULT" Possible values: ["DEFAULT", "CUSTOM"]
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#advertise_mode ComputeRouterPeer#advertise_mode}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAdvertiseMode() {
        return null;
    }

    /**
     * bfd block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#bfd ComputeRouterPeer#bfd}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.ComputeRouterPeerBfd getBfd() {
        return null;
    }

    /**
     * The status of the BGP peer connection.
     * <p>
     * If set to false, any active session
     * with the peer is terminated and all associated routing information is removed.
     * If set to true, the peer connection can be established with routing information.
     * The default is true.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#enable ComputeRouterPeer#enable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnable() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#id ComputeRouterPeer#id}.
     * <p>
     * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
     * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getId() {
        return null;
    }

    /**
     * IP address of the interface inside Google Cloud Platform. Only IPv4 is supported.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#ip_address ComputeRouterPeer#ip_address}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpAddress() {
        return null;
    }

    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#project ComputeRouterPeer#project}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProject() {
        return null;
    }

    /**
     * Region where the router and BgpPeer reside. If it is not provided, the provider region is used.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#region ComputeRouterPeer#region}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * timeouts block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#timeouts ComputeRouterPeer#timeouts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.ComputeRouterPeerTimeouts getTimeouts() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ComputeRouterPeerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ComputeRouterPeerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ComputeRouterPeerConfig> {
        java.lang.String interfaceValue;
        java.lang.String name;
        java.lang.Number peerAsn;
        java.lang.String peerIpAddress;
        java.lang.String router;
        java.util.List<java.lang.String> advertisedGroups;
        java.lang.Object advertisedIpRanges;
        java.lang.Number advertisedRoutePriority;
        java.lang.String advertiseMode;
        com.hashicorp.cdktf.providers.google.ComputeRouterPeerBfd bfd;
        java.lang.Object enable;
        java.lang.String id;
        java.lang.String ipAddress;
        java.lang.String project;
        java.lang.String region;
        com.hashicorp.cdktf.providers.google.ComputeRouterPeerTimeouts timeouts;
        java.lang.Object connection;
        java.lang.Number count;
        java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        com.hashicorp.cdktf.ITerraformIterator forEach;
        com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        com.hashicorp.cdktf.TerraformProvider provider;
        java.util.List<java.lang.Object> provisioners;

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getInterfaceValue}
         * @param interfaceValue Name of the interface the BGP peer is associated with. This parameter is required.
         *                       Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#interface ComputeRouterPeer#interface}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder interfaceValue(java.lang.String interfaceValue) {
            this.interfaceValue = interfaceValue;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getName}
         * @param name Name of this BGP peer. This parameter is required.
         *             The name must be 1-63 characters long,
         *             and comply with RFC1035. Specifically, the name must be 1-63 characters
         *             long and match the regular expression '<a href="%5B-a-z0-9%5D*%5Ba-z0-9%5D">a-z</a>?' which
         *             means the first character must be a lowercase letter, and all
         *             following characters must be a dash, lowercase letter, or digit,
         *             except the last character, which cannot be a dash.
         *             <p>
         *             Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#name ComputeRouterPeer#name}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getPeerAsn}
         * @param peerAsn Peer BGP Autonomous System Number (ASN). Each BGP interface may use a different value. This parameter is required.
         *                Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#peer_asn ComputeRouterPeer#peer_asn}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder peerAsn(java.lang.Number peerAsn) {
            this.peerAsn = peerAsn;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getPeerIpAddress}
         * @param peerIpAddress IP address of the BGP interface outside Google Cloud Platform. Only IPv4 is supported. This parameter is required.
         *                      Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#peer_ip_address ComputeRouterPeer#peer_ip_address}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder peerIpAddress(java.lang.String peerIpAddress) {
            this.peerIpAddress = peerIpAddress;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getRouter}
         * @param router The name of the Cloud Router in which this BgpPeer will be configured. This parameter is required.
         *               Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#router ComputeRouterPeer#router}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder router(java.lang.String router) {
            this.router = router;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getAdvertisedGroups}
         * @param advertisedGroups User-specified list of prefix groups to advertise in custom mode, which can take one of the following options:.
         *                         'ALL_SUBNETS': Advertises all available subnets, including peer VPC subnets.
         *                         'ALL_VPC_SUBNETS': Advertises the router's own VPC subnets.
         *                         'ALL_PEER_VPC_SUBNETS': Advertises peer subnets of the router's VPC network.
         *                         <p>
         *                         Note that this field can only be populated if advertiseMode is 'CUSTOM'
         *                         and overrides the list defined for the router (in the "bgp" message).
         *                         These groups are advertised in addition to any specified prefixes.
         *                         Leave this field blank to advertise no custom groups.
         *                         <p>
         *                         Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#advertised_groups ComputeRouterPeer#advertised_groups}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advertisedGroups(java.util.List<java.lang.String> advertisedGroups) {
            this.advertisedGroups = advertisedGroups;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getAdvertisedIpRanges}
         * @param advertisedIpRanges advertised_ip_ranges block.
         *                           Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#advertised_ip_ranges ComputeRouterPeer#advertised_ip_ranges}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advertisedIpRanges(com.hashicorp.cdktf.IResolvable advertisedIpRanges) {
            this.advertisedIpRanges = advertisedIpRanges;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getAdvertisedIpRanges}
         * @param advertisedIpRanges advertised_ip_ranges block.
         *                           Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#advertised_ip_ranges ComputeRouterPeer#advertised_ip_ranges}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advertisedIpRanges(java.util.List<? extends com.hashicorp.cdktf.providers.google.ComputeRouterPeerAdvertisedIpRanges> advertisedIpRanges) {
            this.advertisedIpRanges = advertisedIpRanges;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getAdvertisedRoutePriority}
         * @param advertisedRoutePriority The priority of routes advertised to this BGP peer.
         *                                Where there is more than one matching route of maximum
         *                                length, the routes with the lowest priority value win.
         *                                <p>
         *                                Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#advertised_route_priority ComputeRouterPeer#advertised_route_priority}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advertisedRoutePriority(java.lang.Number advertisedRoutePriority) {
            this.advertisedRoutePriority = advertisedRoutePriority;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getAdvertiseMode}
         * @param advertiseMode User-specified flag to indicate which mode to use for advertisement.
         *                      Valid values of this enum field are: 'DEFAULT', 'CUSTOM' Default value: "DEFAULT" Possible values: ["DEFAULT", "CUSTOM"]
         *                      <p>
         *                      Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#advertise_mode ComputeRouterPeer#advertise_mode}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advertiseMode(java.lang.String advertiseMode) {
            this.advertiseMode = advertiseMode;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getBfd}
         * @param bfd bfd block.
         *            Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#bfd ComputeRouterPeer#bfd}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bfd(com.hashicorp.cdktf.providers.google.ComputeRouterPeerBfd bfd) {
            this.bfd = bfd;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getEnable}
         * @param enable The status of the BGP peer connection.
         *               If set to false, any active session
         *               with the peer is terminated and all associated routing information is removed.
         *               If set to true, the peer connection can be established with routing information.
         *               The default is true.
         *               <p>
         *               Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#enable ComputeRouterPeer#enable}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enable(java.lang.Boolean enable) {
            this.enable = enable;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getEnable}
         * @param enable The status of the BGP peer connection.
         *               If set to false, any active session
         *               with the peer is terminated and all associated routing information is removed.
         *               If set to true, the peer connection can be established with routing information.
         *               The default is true.
         *               <p>
         *               Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#enable ComputeRouterPeer#enable}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enable(com.hashicorp.cdktf.IResolvable enable) {
            this.enable = enable;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getId}
         * @param id Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#id ComputeRouterPeer#id}.
         *           Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
         *           If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getIpAddress}
         * @param ipAddress IP address of the interface inside Google Cloud Platform. Only IPv4 is supported.
         *                  Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#ip_address ComputeRouterPeer#ip_address}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddress(java.lang.String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getProject}
         * @param project Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#project ComputeRouterPeer#project}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder project(java.lang.String project) {
            this.project = project;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getRegion}
         * @param region Region where the router and BgpPeer reside. If it is not provided, the provider region is used.
         *               Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#region ComputeRouterPeer#region}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getTimeouts}
         * @param timeouts timeouts block.
         *                 Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/compute_router_peer#timeouts ComputeRouterPeer#timeouts}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeouts(com.hashicorp.cdktf.providers.google.ComputeRouterPeerTimeouts timeouts) {
            this.timeouts = timeouts;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.SSHProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getConnection}
         * @param connection the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.WinrmProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getCount}
         * @param count the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder count(java.lang.Number count) {
            this.count = count;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getDependsOn}
         * @param dependsOn the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder dependsOn(java.util.List<? extends com.hashicorp.cdktf.ITerraformDependable> dependsOn) {
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)dependsOn;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getForEach}
         * @param forEach the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder forEach(com.hashicorp.cdktf.ITerraformIterator forEach) {
            this.forEach = forEach;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getLifecycle}
         * @param lifecycle the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lifecycle(com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getProvider}
         * @param provider the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder provider(com.hashicorp.cdktf.TerraformProvider provider) {
            this.provider = provider;
            return this;
        }

        /**
         * Sets the value of {@link ComputeRouterPeerConfig#getProvisioners}
         * @param provisioners the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder provisioners(java.util.List<? extends java.lang.Object> provisioners) {
            this.provisioners = (java.util.List<java.lang.Object>)provisioners;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ComputeRouterPeerConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ComputeRouterPeerConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ComputeRouterPeerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComputeRouterPeerConfig {
        private final java.lang.String interfaceValue;
        private final java.lang.String name;
        private final java.lang.Number peerAsn;
        private final java.lang.String peerIpAddress;
        private final java.lang.String router;
        private final java.util.List<java.lang.String> advertisedGroups;
        private final java.lang.Object advertisedIpRanges;
        private final java.lang.Number advertisedRoutePriority;
        private final java.lang.String advertiseMode;
        private final com.hashicorp.cdktf.providers.google.ComputeRouterPeerBfd bfd;
        private final java.lang.Object enable;
        private final java.lang.String id;
        private final java.lang.String ipAddress;
        private final java.lang.String project;
        private final java.lang.String region;
        private final com.hashicorp.cdktf.providers.google.ComputeRouterPeerTimeouts timeouts;
        private final java.lang.Object connection;
        private final java.lang.Number count;
        private final java.util.List<com.hashicorp.cdktf.ITerraformDependable> dependsOn;
        private final com.hashicorp.cdktf.ITerraformIterator forEach;
        private final com.hashicorp.cdktf.TerraformResourceLifecycle lifecycle;
        private final com.hashicorp.cdktf.TerraformProvider provider;
        private final java.util.List<java.lang.Object> provisioners;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.interfaceValue = software.amazon.jsii.Kernel.get(this, "interface", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.peerAsn = software.amazon.jsii.Kernel.get(this, "peerAsn", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.peerIpAddress = software.amazon.jsii.Kernel.get(this, "peerIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.router = software.amazon.jsii.Kernel.get(this, "router", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.advertisedGroups = software.amazon.jsii.Kernel.get(this, "advertisedGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.advertisedIpRanges = software.amazon.jsii.Kernel.get(this, "advertisedIpRanges", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.advertisedRoutePriority = software.amazon.jsii.Kernel.get(this, "advertisedRoutePriority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.advertiseMode = software.amazon.jsii.Kernel.get(this, "advertiseMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bfd = software.amazon.jsii.Kernel.get(this, "bfd", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.ComputeRouterPeerBfd.class));
            this.enable = software.amazon.jsii.Kernel.get(this, "enable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipAddress = software.amazon.jsii.Kernel.get(this, "ipAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.project = software.amazon.jsii.Kernel.get(this, "project", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeouts = software.amazon.jsii.Kernel.get(this, "timeouts", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.ComputeRouterPeerTimeouts.class));
            this.connection = software.amazon.jsii.Kernel.get(this, "connection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.dependsOn = software.amazon.jsii.Kernel.get(this, "dependsOn", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformDependable.class)));
            this.forEach = software.amazon.jsii.Kernel.get(this, "forEach", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.ITerraformIterator.class));
            this.lifecycle = software.amazon.jsii.Kernel.get(this, "lifecycle", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformResourceLifecycle.class));
            this.provider = software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.TerraformProvider.class));
            this.provisioners = software.amazon.jsii.Kernel.get(this, "provisioners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.interfaceValue = java.util.Objects.requireNonNull(builder.interfaceValue, "interfaceValue is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.peerAsn = java.util.Objects.requireNonNull(builder.peerAsn, "peerAsn is required");
            this.peerIpAddress = java.util.Objects.requireNonNull(builder.peerIpAddress, "peerIpAddress is required");
            this.router = java.util.Objects.requireNonNull(builder.router, "router is required");
            this.advertisedGroups = builder.advertisedGroups;
            this.advertisedIpRanges = builder.advertisedIpRanges;
            this.advertisedRoutePriority = builder.advertisedRoutePriority;
            this.advertiseMode = builder.advertiseMode;
            this.bfd = builder.bfd;
            this.enable = builder.enable;
            this.id = builder.id;
            this.ipAddress = builder.ipAddress;
            this.project = builder.project;
            this.region = builder.region;
            this.timeouts = builder.timeouts;
            this.connection = builder.connection;
            this.count = builder.count;
            this.dependsOn = (java.util.List<com.hashicorp.cdktf.ITerraformDependable>)builder.dependsOn;
            this.forEach = builder.forEach;
            this.lifecycle = builder.lifecycle;
            this.provider = builder.provider;
            this.provisioners = (java.util.List<java.lang.Object>)builder.provisioners;
        }

        @Override
        public final java.lang.String getInterfaceValue() {
            return this.interfaceValue;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Number getPeerAsn() {
            return this.peerAsn;
        }

        @Override
        public final java.lang.String getPeerIpAddress() {
            return this.peerIpAddress;
        }

        @Override
        public final java.lang.String getRouter() {
            return this.router;
        }

        @Override
        public final java.util.List<java.lang.String> getAdvertisedGroups() {
            return this.advertisedGroups;
        }

        @Override
        public final java.lang.Object getAdvertisedIpRanges() {
            return this.advertisedIpRanges;
        }

        @Override
        public final java.lang.Number getAdvertisedRoutePriority() {
            return this.advertisedRoutePriority;
        }

        @Override
        public final java.lang.String getAdvertiseMode() {
            return this.advertiseMode;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.ComputeRouterPeerBfd getBfd() {
            return this.bfd;
        }

        @Override
        public final java.lang.Object getEnable() {
            return this.enable;
        }

        @Override
        public final java.lang.String getId() {
            return this.id;
        }

        @Override
        public final java.lang.String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final java.lang.String getProject() {
            return this.project;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.ComputeRouterPeerTimeouts getTimeouts() {
            return this.timeouts;
        }

        @Override
        public final java.lang.Object getConnection() {
            return this.connection;
        }

        @Override
        public final java.lang.Number getCount() {
            return this.count;
        }

        @Override
        public final java.util.List<com.hashicorp.cdktf.ITerraformDependable> getDependsOn() {
            return this.dependsOn;
        }

        @Override
        public final com.hashicorp.cdktf.ITerraformIterator getForEach() {
            return this.forEach;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformResourceLifecycle getLifecycle() {
            return this.lifecycle;
        }

        @Override
        public final com.hashicorp.cdktf.TerraformProvider getProvider() {
            return this.provider;
        }

        @Override
        public final java.util.List<java.lang.Object> getProvisioners() {
            return this.provisioners;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("interface", om.valueToTree(this.getInterfaceValue()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("peerAsn", om.valueToTree(this.getPeerAsn()));
            data.set("peerIpAddress", om.valueToTree(this.getPeerIpAddress()));
            data.set("router", om.valueToTree(this.getRouter()));
            if (this.getAdvertisedGroups() != null) {
                data.set("advertisedGroups", om.valueToTree(this.getAdvertisedGroups()));
            }
            if (this.getAdvertisedIpRanges() != null) {
                data.set("advertisedIpRanges", om.valueToTree(this.getAdvertisedIpRanges()));
            }
            if (this.getAdvertisedRoutePriority() != null) {
                data.set("advertisedRoutePriority", om.valueToTree(this.getAdvertisedRoutePriority()));
            }
            if (this.getAdvertiseMode() != null) {
                data.set("advertiseMode", om.valueToTree(this.getAdvertiseMode()));
            }
            if (this.getBfd() != null) {
                data.set("bfd", om.valueToTree(this.getBfd()));
            }
            if (this.getEnable() != null) {
                data.set("enable", om.valueToTree(this.getEnable()));
            }
            if (this.getId() != null) {
                data.set("id", om.valueToTree(this.getId()));
            }
            if (this.getIpAddress() != null) {
                data.set("ipAddress", om.valueToTree(this.getIpAddress()));
            }
            if (this.getProject() != null) {
                data.set("project", om.valueToTree(this.getProject()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getTimeouts() != null) {
                data.set("timeouts", om.valueToTree(this.getTimeouts()));
            }
            if (this.getConnection() != null) {
                data.set("connection", om.valueToTree(this.getConnection()));
            }
            if (this.getCount() != null) {
                data.set("count", om.valueToTree(this.getCount()));
            }
            if (this.getDependsOn() != null) {
                data.set("dependsOn", om.valueToTree(this.getDependsOn()));
            }
            if (this.getForEach() != null) {
                data.set("forEach", om.valueToTree(this.getForEach()));
            }
            if (this.getLifecycle() != null) {
                data.set("lifecycle", om.valueToTree(this.getLifecycle()));
            }
            if (this.getProvider() != null) {
                data.set("provider", om.valueToTree(this.getProvider()));
            }
            if (this.getProvisioners() != null) {
                data.set("provisioners", om.valueToTree(this.getProvisioners()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.ComputeRouterPeerConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ComputeRouterPeerConfig.Jsii$Proxy that = (ComputeRouterPeerConfig.Jsii$Proxy) o;

            if (!interfaceValue.equals(that.interfaceValue)) return false;
            if (!name.equals(that.name)) return false;
            if (!peerAsn.equals(that.peerAsn)) return false;
            if (!peerIpAddress.equals(that.peerIpAddress)) return false;
            if (!router.equals(that.router)) return false;
            if (this.advertisedGroups != null ? !this.advertisedGroups.equals(that.advertisedGroups) : that.advertisedGroups != null) return false;
            if (this.advertisedIpRanges != null ? !this.advertisedIpRanges.equals(that.advertisedIpRanges) : that.advertisedIpRanges != null) return false;
            if (this.advertisedRoutePriority != null ? !this.advertisedRoutePriority.equals(that.advertisedRoutePriority) : that.advertisedRoutePriority != null) return false;
            if (this.advertiseMode != null ? !this.advertiseMode.equals(that.advertiseMode) : that.advertiseMode != null) return false;
            if (this.bfd != null ? !this.bfd.equals(that.bfd) : that.bfd != null) return false;
            if (this.enable != null ? !this.enable.equals(that.enable) : that.enable != null) return false;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
            if (this.ipAddress != null ? !this.ipAddress.equals(that.ipAddress) : that.ipAddress != null) return false;
            if (this.project != null ? !this.project.equals(that.project) : that.project != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.timeouts != null ? !this.timeouts.equals(that.timeouts) : that.timeouts != null) return false;
            if (this.connection != null ? !this.connection.equals(that.connection) : that.connection != null) return false;
            if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
            if (this.dependsOn != null ? !this.dependsOn.equals(that.dependsOn) : that.dependsOn != null) return false;
            if (this.forEach != null ? !this.forEach.equals(that.forEach) : that.forEach != null) return false;
            if (this.lifecycle != null ? !this.lifecycle.equals(that.lifecycle) : that.lifecycle != null) return false;
            if (this.provider != null ? !this.provider.equals(that.provider) : that.provider != null) return false;
            return this.provisioners != null ? this.provisioners.equals(that.provisioners) : that.provisioners == null;
        }

        @Override
        public final int hashCode() {
            int result = this.interfaceValue.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.peerAsn.hashCode());
            result = 31 * result + (this.peerIpAddress.hashCode());
            result = 31 * result + (this.router.hashCode());
            result = 31 * result + (this.advertisedGroups != null ? this.advertisedGroups.hashCode() : 0);
            result = 31 * result + (this.advertisedIpRanges != null ? this.advertisedIpRanges.hashCode() : 0);
            result = 31 * result + (this.advertisedRoutePriority != null ? this.advertisedRoutePriority.hashCode() : 0);
            result = 31 * result + (this.advertiseMode != null ? this.advertiseMode.hashCode() : 0);
            result = 31 * result + (this.bfd != null ? this.bfd.hashCode() : 0);
            result = 31 * result + (this.enable != null ? this.enable.hashCode() : 0);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.ipAddress != null ? this.ipAddress.hashCode() : 0);
            result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.timeouts != null ? this.timeouts.hashCode() : 0);
            result = 31 * result + (this.connection != null ? this.connection.hashCode() : 0);
            result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
            result = 31 * result + (this.dependsOn != null ? this.dependsOn.hashCode() : 0);
            result = 31 * result + (this.forEach != null ? this.forEach.hashCode() : 0);
            result = 31 * result + (this.lifecycle != null ? this.lifecycle.hashCode() : 0);
            result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
            result = 31 * result + (this.provisioners != null ? this.provisioners.hashCode() : 0);
            return result;
        }
    }
}
