package com.hashicorp.cdktf.providers.google;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-10-03T00:49:22.392Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.DataprocAutoscalingPolicyBasicAlgorithmYarnConfig")
@software.amazon.jsii.Jsii.Proxy(DataprocAutoscalingPolicyBasicAlgorithmYarnConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DataprocAutoscalingPolicyBasicAlgorithmYarnConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Timeout for YARN graceful decommissioning of Node Managers.
     * <p>
     * Specifies the
     * duration to wait for jobs to complete before forcefully removing workers
     * (and potentially interrupting jobs). Only applicable to downscaling operations.
     * <p>
     * Bounds: [0s, 1d].
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#graceful_decommission_timeout DataprocAutoscalingPolicy#graceful_decommission_timeout}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGracefulDecommissionTimeout();

    /**
     * Fraction of average pending memory in the last cooldown period for which to remove workers.
     * <p>
     * A scale-down factor of 1 will result in scaling down so that there
     * is no available memory remaining after the update (more aggressive scaling).
     * A scale-down factor of 0 disables removing workers, which can be beneficial for
     * autoscaling a single job.
     * <p>
     * Bounds: [0.0, 1.0].
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#scale_down_factor DataprocAutoscalingPolicy#scale_down_factor}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getScaleDownFactor();

    /**
     * Fraction of average pending memory in the last cooldown period for which to add workers.
     * <p>
     * A scale-up factor of 1.0 will result in scaling up so that there
     * is no pending memory remaining after the update (more aggressive scaling).
     * A scale-up factor closer to 0 will result in a smaller magnitude of scaling up
     * (less aggressive scaling).
     * <p>
     * Bounds: [0.0, 1.0].
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#scale_up_factor DataprocAutoscalingPolicy#scale_up_factor}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getScaleUpFactor();

    /**
     * Minimum scale-down threshold as a fraction of total cluster size before scaling occurs.
     * <p>
     * For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must
     * recommend at least a 2 worker scale-down for the cluster to scale. A threshold of 0
     * means the autoscaler will scale down on any recommended change.
     * <p>
     * Bounds: [0.0, 1.0]. Default: 0.0.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#scale_down_min_worker_fraction DataprocAutoscalingPolicy#scale_down_min_worker_fraction}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getScaleDownMinWorkerFraction() {
        return null;
    }

    /**
     * Minimum scale-up threshold as a fraction of total cluster size before scaling occurs.
     * <p>
     * For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler
     * must recommend at least a 2-worker scale-up for the cluster to scale. A threshold of
     * 0 means the autoscaler will scale up on any recommended change.
     * <p>
     * Bounds: [0.0, 1.0]. Default: 0.0.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#scale_up_min_worker_fraction DataprocAutoscalingPolicy#scale_up_min_worker_fraction}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getScaleUpMinWorkerFraction() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DataprocAutoscalingPolicyBasicAlgorithmYarnConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DataprocAutoscalingPolicyBasicAlgorithmYarnConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DataprocAutoscalingPolicyBasicAlgorithmYarnConfig> {
        java.lang.String gracefulDecommissionTimeout;
        java.lang.Number scaleDownFactor;
        java.lang.Number scaleUpFactor;
        java.lang.Number scaleDownMinWorkerFraction;
        java.lang.Number scaleUpMinWorkerFraction;

        /**
         * Sets the value of {@link DataprocAutoscalingPolicyBasicAlgorithmYarnConfig#getGracefulDecommissionTimeout}
         * @param gracefulDecommissionTimeout Timeout for YARN graceful decommissioning of Node Managers. This parameter is required.
         *                                    Specifies the
         *                                    duration to wait for jobs to complete before forcefully removing workers
         *                                    (and potentially interrupting jobs). Only applicable to downscaling operations.
         *                                    <p>
         *                                    Bounds: [0s, 1d].
         *                                    <p>
         *                                    Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#graceful_decommission_timeout DataprocAutoscalingPolicy#graceful_decommission_timeout}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gracefulDecommissionTimeout(java.lang.String gracefulDecommissionTimeout) {
            this.gracefulDecommissionTimeout = gracefulDecommissionTimeout;
            return this;
        }

        /**
         * Sets the value of {@link DataprocAutoscalingPolicyBasicAlgorithmYarnConfig#getScaleDownFactor}
         * @param scaleDownFactor Fraction of average pending memory in the last cooldown period for which to remove workers. This parameter is required.
         *                        A scale-down factor of 1 will result in scaling down so that there
         *                        is no available memory remaining after the update (more aggressive scaling).
         *                        A scale-down factor of 0 disables removing workers, which can be beneficial for
         *                        autoscaling a single job.
         *                        <p>
         *                        Bounds: [0.0, 1.0].
         *                        <p>
         *                        Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#scale_down_factor DataprocAutoscalingPolicy#scale_down_factor}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scaleDownFactor(java.lang.Number scaleDownFactor) {
            this.scaleDownFactor = scaleDownFactor;
            return this;
        }

        /**
         * Sets the value of {@link DataprocAutoscalingPolicyBasicAlgorithmYarnConfig#getScaleUpFactor}
         * @param scaleUpFactor Fraction of average pending memory in the last cooldown period for which to add workers. This parameter is required.
         *                      A scale-up factor of 1.0 will result in scaling up so that there
         *                      is no pending memory remaining after the update (more aggressive scaling).
         *                      A scale-up factor closer to 0 will result in a smaller magnitude of scaling up
         *                      (less aggressive scaling).
         *                      <p>
         *                      Bounds: [0.0, 1.0].
         *                      <p>
         *                      Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#scale_up_factor DataprocAutoscalingPolicy#scale_up_factor}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scaleUpFactor(java.lang.Number scaleUpFactor) {
            this.scaleUpFactor = scaleUpFactor;
            return this;
        }

        /**
         * Sets the value of {@link DataprocAutoscalingPolicyBasicAlgorithmYarnConfig#getScaleDownMinWorkerFraction}
         * @param scaleDownMinWorkerFraction Minimum scale-down threshold as a fraction of total cluster size before scaling occurs.
         *                                   For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must
         *                                   recommend at least a 2 worker scale-down for the cluster to scale. A threshold of 0
         *                                   means the autoscaler will scale down on any recommended change.
         *                                   <p>
         *                                   Bounds: [0.0, 1.0]. Default: 0.0.
         *                                   <p>
         *                                   Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#scale_down_min_worker_fraction DataprocAutoscalingPolicy#scale_down_min_worker_fraction}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scaleDownMinWorkerFraction(java.lang.Number scaleDownMinWorkerFraction) {
            this.scaleDownMinWorkerFraction = scaleDownMinWorkerFraction;
            return this;
        }

        /**
         * Sets the value of {@link DataprocAutoscalingPolicyBasicAlgorithmYarnConfig#getScaleUpMinWorkerFraction}
         * @param scaleUpMinWorkerFraction Minimum scale-up threshold as a fraction of total cluster size before scaling occurs.
         *                                 For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler
         *                                 must recommend at least a 2-worker scale-up for the cluster to scale. A threshold of
         *                                 0 means the autoscaler will scale up on any recommended change.
         *                                 <p>
         *                                 Bounds: [0.0, 1.0]. Default: 0.0.
         *                                 <p>
         *                                 Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy#scale_up_min_worker_fraction DataprocAutoscalingPolicy#scale_up_min_worker_fraction}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scaleUpMinWorkerFraction(java.lang.Number scaleUpMinWorkerFraction) {
            this.scaleUpMinWorkerFraction = scaleUpMinWorkerFraction;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DataprocAutoscalingPolicyBasicAlgorithmYarnConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DataprocAutoscalingPolicyBasicAlgorithmYarnConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DataprocAutoscalingPolicyBasicAlgorithmYarnConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataprocAutoscalingPolicyBasicAlgorithmYarnConfig {
        private final java.lang.String gracefulDecommissionTimeout;
        private final java.lang.Number scaleDownFactor;
        private final java.lang.Number scaleUpFactor;
        private final java.lang.Number scaleDownMinWorkerFraction;
        private final java.lang.Number scaleUpMinWorkerFraction;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.gracefulDecommissionTimeout = software.amazon.jsii.Kernel.get(this, "gracefulDecommissionTimeout", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scaleDownFactor = software.amazon.jsii.Kernel.get(this, "scaleDownFactor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.scaleUpFactor = software.amazon.jsii.Kernel.get(this, "scaleUpFactor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.scaleDownMinWorkerFraction = software.amazon.jsii.Kernel.get(this, "scaleDownMinWorkerFraction", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.scaleUpMinWorkerFraction = software.amazon.jsii.Kernel.get(this, "scaleUpMinWorkerFraction", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.gracefulDecommissionTimeout = java.util.Objects.requireNonNull(builder.gracefulDecommissionTimeout, "gracefulDecommissionTimeout is required");
            this.scaleDownFactor = java.util.Objects.requireNonNull(builder.scaleDownFactor, "scaleDownFactor is required");
            this.scaleUpFactor = java.util.Objects.requireNonNull(builder.scaleUpFactor, "scaleUpFactor is required");
            this.scaleDownMinWorkerFraction = builder.scaleDownMinWorkerFraction;
            this.scaleUpMinWorkerFraction = builder.scaleUpMinWorkerFraction;
        }

        @Override
        public final java.lang.String getGracefulDecommissionTimeout() {
            return this.gracefulDecommissionTimeout;
        }

        @Override
        public final java.lang.Number getScaleDownFactor() {
            return this.scaleDownFactor;
        }

        @Override
        public final java.lang.Number getScaleUpFactor() {
            return this.scaleUpFactor;
        }

        @Override
        public final java.lang.Number getScaleDownMinWorkerFraction() {
            return this.scaleDownMinWorkerFraction;
        }

        @Override
        public final java.lang.Number getScaleUpMinWorkerFraction() {
            return this.scaleUpMinWorkerFraction;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("gracefulDecommissionTimeout", om.valueToTree(this.getGracefulDecommissionTimeout()));
            data.set("scaleDownFactor", om.valueToTree(this.getScaleDownFactor()));
            data.set("scaleUpFactor", om.valueToTree(this.getScaleUpFactor()));
            if (this.getScaleDownMinWorkerFraction() != null) {
                data.set("scaleDownMinWorkerFraction", om.valueToTree(this.getScaleDownMinWorkerFraction()));
            }
            if (this.getScaleUpMinWorkerFraction() != null) {
                data.set("scaleUpMinWorkerFraction", om.valueToTree(this.getScaleUpMinWorkerFraction()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.DataprocAutoscalingPolicyBasicAlgorithmYarnConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DataprocAutoscalingPolicyBasicAlgorithmYarnConfig.Jsii$Proxy that = (DataprocAutoscalingPolicyBasicAlgorithmYarnConfig.Jsii$Proxy) o;

            if (!gracefulDecommissionTimeout.equals(that.gracefulDecommissionTimeout)) return false;
            if (!scaleDownFactor.equals(that.scaleDownFactor)) return false;
            if (!scaleUpFactor.equals(that.scaleUpFactor)) return false;
            if (this.scaleDownMinWorkerFraction != null ? !this.scaleDownMinWorkerFraction.equals(that.scaleDownMinWorkerFraction) : that.scaleDownMinWorkerFraction != null) return false;
            return this.scaleUpMinWorkerFraction != null ? this.scaleUpMinWorkerFraction.equals(that.scaleUpMinWorkerFraction) : that.scaleUpMinWorkerFraction == null;
        }

        @Override
        public final int hashCode() {
            int result = this.gracefulDecommissionTimeout.hashCode();
            result = 31 * result + (this.scaleDownFactor.hashCode());
            result = 31 * result + (this.scaleUpFactor.hashCode());
            result = 31 * result + (this.scaleDownMinWorkerFraction != null ? this.scaleDownMinWorkerFraction.hashCode() : 0);
            result = 31 * result + (this.scaleUpMinWorkerFraction != null ? this.scaleUpMinWorkerFraction.hashCode() : 0);
            return result;
        }
    }
}
