package com.hashicorp.cdktf.providers.google;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-10-03T00:49:23.044Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.NetworkServicesEdgeCacheOriginTimeout")
@software.amazon.jsii.Jsii.Proxy(NetworkServicesEdgeCacheOriginTimeout.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NetworkServicesEdgeCacheOriginTimeout extends software.amazon.jsii.JsiiSerializable {

    /**
     * The maximum duration to wait for a single origin connection to be established, including DNS lookup, TLS handshake and TCP/QUIC connection establishment.
     * <p>
     * Defaults to 5 seconds. The timeout must be a value between 1s and 15s.
     * <p>
     * The connectTimeout capped by the deadline set by the request's maxAttemptsTimeout.  The last connection attempt may have a smaller connectTimeout in order to adhere to the overall maxAttemptsTimeout.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#connect_timeout NetworkServicesEdgeCacheOrigin#connect_timeout}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConnectTimeout() {
        return null;
    }

    /**
     * The maximum time across all connection attempts to the origin, including failover origins, before returning an error to the client.
     * <p>
     * A HTTP 504 will be returned if the timeout is reached before a response is returned.
     * <p>
     * Defaults to 15 seconds. The timeout must be a value between 1s and 30s.
     * <p>
     * If a failoverOrigin is specified, the maxAttemptsTimeout of the first configured origin sets the deadline for all connection attempts across all failoverOrigins.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#max_attempts_timeout NetworkServicesEdgeCacheOrigin#max_attempts_timeout}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMaxAttemptsTimeout() {
        return null;
    }

    /**
     * The maximum duration to wait between reads of a single HTTP connection/stream.
     * <p>
     * Defaults to 15 seconds.  The timeout must be a value between 1s and 30s.
     * <p>
     * The readTimeout is capped by the responseTimeout.  All reads of the HTTP connection/stream must be completed by the deadline set by the responseTimeout.
     * <p>
     * If the response headers have already been written to the connection, the response will be truncated and logged.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#read_timeout NetworkServicesEdgeCacheOrigin#read_timeout}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReadTimeout() {
        return null;
    }

    /**
     * The maximum duration to wait for the last byte of a response to arrive when reading from the HTTP connection/stream.
     * <p>
     * Defaults to 30 seconds. The timeout must be a value between 1s and 120s.
     * <p>
     * The responseTimeout starts after the connection has been established.
     * <p>
     * This also applies to HTTP Chunked Transfer Encoding responses, and/or when an open-ended Range request is made to the origin. Origins that take longer to write additional bytes to the response than the configured responseTimeout will result in an error being returned to the client.
     * <p>
     * If the response headers have already been written to the connection, the response will be truncated and logged.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#response_timeout NetworkServicesEdgeCacheOrigin#response_timeout}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResponseTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NetworkServicesEdgeCacheOriginTimeout}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NetworkServicesEdgeCacheOriginTimeout}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NetworkServicesEdgeCacheOriginTimeout> {
        java.lang.String connectTimeout;
        java.lang.String maxAttemptsTimeout;
        java.lang.String readTimeout;
        java.lang.String responseTimeout;

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginTimeout#getConnectTimeout}
         * @param connectTimeout The maximum duration to wait for a single origin connection to be established, including DNS lookup, TLS handshake and TCP/QUIC connection establishment.
         *                       Defaults to 5 seconds. The timeout must be a value between 1s and 15s.
         *                       <p>
         *                       The connectTimeout capped by the deadline set by the request's maxAttemptsTimeout.  The last connection attempt may have a smaller connectTimeout in order to adhere to the overall maxAttemptsTimeout.
         *                       <p>
         *                       Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#connect_timeout NetworkServicesEdgeCacheOrigin#connect_timeout}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectTimeout(java.lang.String connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginTimeout#getMaxAttemptsTimeout}
         * @param maxAttemptsTimeout The maximum time across all connection attempts to the origin, including failover origins, before returning an error to the client.
         *                           A HTTP 504 will be returned if the timeout is reached before a response is returned.
         *                           <p>
         *                           Defaults to 15 seconds. The timeout must be a value between 1s and 30s.
         *                           <p>
         *                           If a failoverOrigin is specified, the maxAttemptsTimeout of the first configured origin sets the deadline for all connection attempts across all failoverOrigins.
         *                           <p>
         *                           Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#max_attempts_timeout NetworkServicesEdgeCacheOrigin#max_attempts_timeout}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAttemptsTimeout(java.lang.String maxAttemptsTimeout) {
            this.maxAttemptsTimeout = maxAttemptsTimeout;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginTimeout#getReadTimeout}
         * @param readTimeout The maximum duration to wait between reads of a single HTTP connection/stream.
         *                    Defaults to 15 seconds.  The timeout must be a value between 1s and 30s.
         *                    <p>
         *                    The readTimeout is capped by the responseTimeout.  All reads of the HTTP connection/stream must be completed by the deadline set by the responseTimeout.
         *                    <p>
         *                    If the response headers have already been written to the connection, the response will be truncated and logged.
         *                    <p>
         *                    Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#read_timeout NetworkServicesEdgeCacheOrigin#read_timeout}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readTimeout(java.lang.String readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        /**
         * Sets the value of {@link NetworkServicesEdgeCacheOriginTimeout#getResponseTimeout}
         * @param responseTimeout The maximum duration to wait for the last byte of a response to arrive when reading from the HTTP connection/stream.
         *                        Defaults to 30 seconds. The timeout must be a value between 1s and 120s.
         *                        <p>
         *                        The responseTimeout starts after the connection has been established.
         *                        <p>
         *                        This also applies to HTTP Chunked Transfer Encoding responses, and/or when an open-ended Range request is made to the origin. Origins that take longer to write additional bytes to the response than the configured responseTimeout will result in an error being returned to the client.
         *                        <p>
         *                        If the response headers have already been written to the connection, the response will be truncated and logged.
         *                        <p>
         *                        Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#response_timeout NetworkServicesEdgeCacheOrigin#response_timeout}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseTimeout(java.lang.String responseTimeout) {
            this.responseTimeout = responseTimeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkServicesEdgeCacheOriginTimeout}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NetworkServicesEdgeCacheOriginTimeout build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NetworkServicesEdgeCacheOriginTimeout}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkServicesEdgeCacheOriginTimeout {
        private final java.lang.String connectTimeout;
        private final java.lang.String maxAttemptsTimeout;
        private final java.lang.String readTimeout;
        private final java.lang.String responseTimeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.connectTimeout = software.amazon.jsii.Kernel.get(this, "connectTimeout", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxAttemptsTimeout = software.amazon.jsii.Kernel.get(this, "maxAttemptsTimeout", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.readTimeout = software.amazon.jsii.Kernel.get(this, "readTimeout", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.responseTimeout = software.amazon.jsii.Kernel.get(this, "responseTimeout", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.connectTimeout = builder.connectTimeout;
            this.maxAttemptsTimeout = builder.maxAttemptsTimeout;
            this.readTimeout = builder.readTimeout;
            this.responseTimeout = builder.responseTimeout;
        }

        @Override
        public final java.lang.String getConnectTimeout() {
            return this.connectTimeout;
        }

        @Override
        public final java.lang.String getMaxAttemptsTimeout() {
            return this.maxAttemptsTimeout;
        }

        @Override
        public final java.lang.String getReadTimeout() {
            return this.readTimeout;
        }

        @Override
        public final java.lang.String getResponseTimeout() {
            return this.responseTimeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getConnectTimeout() != null) {
                data.set("connectTimeout", om.valueToTree(this.getConnectTimeout()));
            }
            if (this.getMaxAttemptsTimeout() != null) {
                data.set("maxAttemptsTimeout", om.valueToTree(this.getMaxAttemptsTimeout()));
            }
            if (this.getReadTimeout() != null) {
                data.set("readTimeout", om.valueToTree(this.getReadTimeout()));
            }
            if (this.getResponseTimeout() != null) {
                data.set("responseTimeout", om.valueToTree(this.getResponseTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.NetworkServicesEdgeCacheOriginTimeout"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NetworkServicesEdgeCacheOriginTimeout.Jsii$Proxy that = (NetworkServicesEdgeCacheOriginTimeout.Jsii$Proxy) o;

            if (this.connectTimeout != null ? !this.connectTimeout.equals(that.connectTimeout) : that.connectTimeout != null) return false;
            if (this.maxAttemptsTimeout != null ? !this.maxAttemptsTimeout.equals(that.maxAttemptsTimeout) : that.maxAttemptsTimeout != null) return false;
            if (this.readTimeout != null ? !this.readTimeout.equals(that.readTimeout) : that.readTimeout != null) return false;
            return this.responseTimeout != null ? this.responseTimeout.equals(that.responseTimeout) : that.responseTimeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.connectTimeout != null ? this.connectTimeout.hashCode() : 0;
            result = 31 * result + (this.maxAttemptsTimeout != null ? this.maxAttemptsTimeout.hashCode() : 0);
            result = 31 * result + (this.readTimeout != null ? this.readTimeout.hashCode() : 0);
            result = 31 * result + (this.responseTimeout != null ? this.responseTimeout.hashCode() : 0);
            return result;
        }
    }
}
