package com.hashicorp.cdktf.providers.google;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-10-03T00:49:23.321Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.PubsubSubscriptionPushConfig")
@software.amazon.jsii.Jsii.Proxy(PubsubSubscriptionPushConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PubsubSubscriptionPushConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * A URL locating the endpoint to which messages should be pushed. For example, a Webhook endpoint might use "https://example.com/push".
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#push_endpoint PubsubSubscription#push_endpoint}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPushEndpoint();

    /**
     * Endpoint configuration attributes.
     * <p>
     * Every endpoint has a set of API supported attributes that can
     * be used to control different aspects of the message delivery.
     * <p>
     * The currently supported attribute is x-goog-version, which you
     * can use to change the format of the pushed message. This
     * attribute indicates the version of the data expected by
     * the endpoint. This controls the shape of the pushed message
     * (i.e., its fields and metadata). The endpoint version is
     * based on the version of the Pub/Sub API.
     * <p>
     * If not present during the subscriptions.create call,
     * it will default to the version of the API used to make
     * such call. If not present during a subscriptions.modifyPushConfig
     * call, its value will not be changed. subscriptions.get
     * calls will always return a valid version, even if the
     * subscription was created without this attribute.
     * <p>
     * The possible values for this attribute are:
     * <p>
     * <ul>
     * <li>v1beta1: uses the push format defined in the v1beta1 Pub/Sub API.</li>
     * <li>v1 or v1beta2: uses the push format defined in the v1 Pub/Sub API.</li>
     * </ul>
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#attributes PubsubSubscription#attributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getAttributes() {
        return null;
    }

    /**
     * oidc_token block.
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#oidc_token PubsubSubscription#oidc_token}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.providers.google.PubsubSubscriptionPushConfigOidcToken getOidcToken() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PubsubSubscriptionPushConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PubsubSubscriptionPushConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PubsubSubscriptionPushConfig> {
        java.lang.String pushEndpoint;
        java.util.Map<java.lang.String, java.lang.String> attributes;
        com.hashicorp.cdktf.providers.google.PubsubSubscriptionPushConfigOidcToken oidcToken;

        /**
         * Sets the value of {@link PubsubSubscriptionPushConfig#getPushEndpoint}
         * @param pushEndpoint A URL locating the endpoint to which messages should be pushed. For example, a Webhook endpoint might use "https://example.com/push". This parameter is required.
         *                     Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#push_endpoint PubsubSubscription#push_endpoint}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pushEndpoint(java.lang.String pushEndpoint) {
            this.pushEndpoint = pushEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionPushConfig#getAttributes}
         * @param attributes Endpoint configuration attributes.
         *                   Every endpoint has a set of API supported attributes that can
         *                   be used to control different aspects of the message delivery.
         *                   <p>
         *                   The currently supported attribute is x-goog-version, which you
         *                   can use to change the format of the pushed message. This
         *                   attribute indicates the version of the data expected by
         *                   the endpoint. This controls the shape of the pushed message
         *                   (i.e., its fields and metadata). The endpoint version is
         *                   based on the version of the Pub/Sub API.
         *                   <p>
         *                   If not present during the subscriptions.create call,
         *                   it will default to the version of the API used to make
         *                   such call. If not present during a subscriptions.modifyPushConfig
         *                   call, its value will not be changed. subscriptions.get
         *                   calls will always return a valid version, even if the
         *                   subscription was created without this attribute.
         *                   <p>
         *                   The possible values for this attribute are:
         *                   <p>
         *                   <ul>
         *                   <li>v1beta1: uses the push format defined in the v1beta1 Pub/Sub API.</li>
         *                   <li>v1 or v1beta2: uses the push format defined in the v1 Pub/Sub API.</li>
         *                   </ul>
         *                   <p>
         *                   Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#attributes PubsubSubscription#attributes}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributes(java.util.Map<java.lang.String, java.lang.String> attributes) {
            this.attributes = attributes;
            return this;
        }

        /**
         * Sets the value of {@link PubsubSubscriptionPushConfig#getOidcToken}
         * @param oidcToken oidc_token block.
         *                  Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#oidc_token PubsubSubscription#oidc_token}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder oidcToken(com.hashicorp.cdktf.providers.google.PubsubSubscriptionPushConfigOidcToken oidcToken) {
            this.oidcToken = oidcToken;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PubsubSubscriptionPushConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PubsubSubscriptionPushConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PubsubSubscriptionPushConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PubsubSubscriptionPushConfig {
        private final java.lang.String pushEndpoint;
        private final java.util.Map<java.lang.String, java.lang.String> attributes;
        private final com.hashicorp.cdktf.providers.google.PubsubSubscriptionPushConfigOidcToken oidcToken;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.pushEndpoint = software.amazon.jsii.Kernel.get(this, "pushEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.attributes = software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.oidcToken = software.amazon.jsii.Kernel.get(this, "oidcToken", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.providers.google.PubsubSubscriptionPushConfigOidcToken.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.pushEndpoint = java.util.Objects.requireNonNull(builder.pushEndpoint, "pushEndpoint is required");
            this.attributes = builder.attributes;
            this.oidcToken = builder.oidcToken;
        }

        @Override
        public final java.lang.String getPushEndpoint() {
            return this.pushEndpoint;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final com.hashicorp.cdktf.providers.google.PubsubSubscriptionPushConfigOidcToken getOidcToken() {
            return this.oidcToken;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("pushEndpoint", om.valueToTree(this.getPushEndpoint()));
            if (this.getAttributes() != null) {
                data.set("attributes", om.valueToTree(this.getAttributes()));
            }
            if (this.getOidcToken() != null) {
                data.set("oidcToken", om.valueToTree(this.getOidcToken()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.PubsubSubscriptionPushConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PubsubSubscriptionPushConfig.Jsii$Proxy that = (PubsubSubscriptionPushConfig.Jsii$Proxy) o;

            if (!pushEndpoint.equals(that.pushEndpoint)) return false;
            if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) return false;
            return this.oidcToken != null ? this.oidcToken.equals(that.oidcToken) : that.oidcToken == null;
        }

        @Override
        public final int hashCode() {
            int result = this.pushEndpoint.hashCode();
            result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
            result = 31 * result + (this.oidcToken != null ? this.oidcToken.hashCode() : 0);
            return result;
        }
    }
}
