package com.hashicorp.cdktf.providers.google;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-10-03T00:49:23.353Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.providers.google.$Module.class, fqn = "@cdktf/provider-google.RedisInstancePersistenceConfig")
@software.amazon.jsii.Jsii.Proxy(RedisInstancePersistenceConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RedisInstancePersistenceConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Optional. Available snapshot periods for scheduling.
     * <p>
     * <ul>
     * <li>ONE_HOUR:	Snapshot every 1 hour.</li>
     * <li>SIX_HOURS:	Snapshot every 6 hours.</li>
     * <li>TWELVE_HOURS:	Snapshot every 12 hours.</li>
     * <li>TWENTY_FOUR_HOURS:	Snapshot every 24 horus. Possible values: ["ONE_HOUR", "SIX_HOURS", "TWELVE_HOURS", "TWENTY_FOUR_HOURS"]</li>
     * </ul>
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#rdb_snapshot_period RedisInstance#rdb_snapshot_period}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRdbSnapshotPeriod();

    /**
     * Optional. Controls whether Persistence features are enabled. If not provided, the existing value will be used.
     * <p>
     * <ul>
     * <li>DISABLED: 	Persistence is disabled for the instance, and any existing snapshots are deleted.</li>
     * <li>RDB: RDB based Persistence is enabled. Possible values: ["DISABLED", "RDB"]</li>
     * </ul>
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#persistence_mode RedisInstance#persistence_mode}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPersistenceMode() {
        return null;
    }

    /**
     * Optional.
     * <p>
     * Date and time that the first snapshot was/will be attempted,
     * and to which future snapshots will be aligned. If not provided,
     * the current time will be used.
     * A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution
     * and up to nine fractional digits.
     * Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
     * <p>
     * Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#rdb_snapshot_start_time RedisInstance#rdb_snapshot_start_time}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRdbSnapshotStartTime() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RedisInstancePersistenceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RedisInstancePersistenceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RedisInstancePersistenceConfig> {
        java.lang.String rdbSnapshotPeriod;
        java.lang.String persistenceMode;
        java.lang.String rdbSnapshotStartTime;

        /**
         * Sets the value of {@link RedisInstancePersistenceConfig#getRdbSnapshotPeriod}
         * @param rdbSnapshotPeriod Optional. Available snapshot periods for scheduling. This parameter is required.
         *                          <ul>
         *                          <li>ONE_HOUR:	Snapshot every 1 hour.</li>
         *                          <li>SIX_HOURS:	Snapshot every 6 hours.</li>
         *                          <li>TWELVE_HOURS:	Snapshot every 12 hours.</li>
         *                          <li>TWENTY_FOUR_HOURS:	Snapshot every 24 horus. Possible values: ["ONE_HOUR", "SIX_HOURS", "TWELVE_HOURS", "TWENTY_FOUR_HOURS"]</li>
         *                          </ul>
         *                          <p>
         *                          Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#rdb_snapshot_period RedisInstance#rdb_snapshot_period}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rdbSnapshotPeriod(java.lang.String rdbSnapshotPeriod) {
            this.rdbSnapshotPeriod = rdbSnapshotPeriod;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstancePersistenceConfig#getPersistenceMode}
         * @param persistenceMode Optional. Controls whether Persistence features are enabled. If not provided, the existing value will be used.
         *                        <ul>
         *                        <li>DISABLED: 	Persistence is disabled for the instance, and any existing snapshots are deleted.</li>
         *                        <li>RDB: RDB based Persistence is enabled. Possible values: ["DISABLED", "RDB"]</li>
         *                        </ul>
         *                        <p>
         *                        Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#persistence_mode RedisInstance#persistence_mode}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder persistenceMode(java.lang.String persistenceMode) {
            this.persistenceMode = persistenceMode;
            return this;
        }

        /**
         * Sets the value of {@link RedisInstancePersistenceConfig#getRdbSnapshotStartTime}
         * @param rdbSnapshotStartTime Optional.
         *                             Date and time that the first snapshot was/will be attempted,
         *                             and to which future snapshots will be aligned. If not provided,
         *                             the current time will be used.
         *                             A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution
         *                             and up to nine fractional digits.
         *                             Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
         *                             <p>
         *                             Docs at Terraform Registry: {&#64;link https://www.terraform.io/docs/providers/google/r/redis_instance#rdb_snapshot_start_time RedisInstance#rdb_snapshot_start_time}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rdbSnapshotStartTime(java.lang.String rdbSnapshotStartTime) {
            this.rdbSnapshotStartTime = rdbSnapshotStartTime;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RedisInstancePersistenceConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RedisInstancePersistenceConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RedisInstancePersistenceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedisInstancePersistenceConfig {
        private final java.lang.String rdbSnapshotPeriod;
        private final java.lang.String persistenceMode;
        private final java.lang.String rdbSnapshotStartTime;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.rdbSnapshotPeriod = software.amazon.jsii.Kernel.get(this, "rdbSnapshotPeriod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.persistenceMode = software.amazon.jsii.Kernel.get(this, "persistenceMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.rdbSnapshotStartTime = software.amazon.jsii.Kernel.get(this, "rdbSnapshotStartTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.rdbSnapshotPeriod = java.util.Objects.requireNonNull(builder.rdbSnapshotPeriod, "rdbSnapshotPeriod is required");
            this.persistenceMode = builder.persistenceMode;
            this.rdbSnapshotStartTime = builder.rdbSnapshotStartTime;
        }

        @Override
        public final java.lang.String getRdbSnapshotPeriod() {
            return this.rdbSnapshotPeriod;
        }

        @Override
        public final java.lang.String getPersistenceMode() {
            return this.persistenceMode;
        }

        @Override
        public final java.lang.String getRdbSnapshotStartTime() {
            return this.rdbSnapshotStartTime;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("rdbSnapshotPeriod", om.valueToTree(this.getRdbSnapshotPeriod()));
            if (this.getPersistenceMode() != null) {
                data.set("persistenceMode", om.valueToTree(this.getPersistenceMode()));
            }
            if (this.getRdbSnapshotStartTime() != null) {
                data.set("rdbSnapshotStartTime", om.valueToTree(this.getRdbSnapshotStartTime()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@cdktf/provider-google.RedisInstancePersistenceConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RedisInstancePersistenceConfig.Jsii$Proxy that = (RedisInstancePersistenceConfig.Jsii$Proxy) o;

            if (!rdbSnapshotPeriod.equals(that.rdbSnapshotPeriod)) return false;
            if (this.persistenceMode != null ? !this.persistenceMode.equals(that.persistenceMode) : that.persistenceMode != null) return false;
            return this.rdbSnapshotStartTime != null ? this.rdbSnapshotStartTime.equals(that.rdbSnapshotStartTime) : that.rdbSnapshotStartTime == null;
        }

        @Override
        public final int hashCode() {
            int result = this.rdbSnapshotPeriod.hashCode();
            result = 31 * result + (this.persistenceMode != null ? this.persistenceMode.hashCode() : 0);
            result = 31 * result + (this.rdbSnapshotStartTime != null ? this.rdbSnapshotStartTime.hashCode() : 0);
            return result;
        }
    }
}
