package com.hashicorp.cdktf;

/**
 * (experimental) The Cloud Backend synthesizes a {@link https://developer.hashicorp.com/terraform/cli/cloud/settings#the-cloud-block cloud block}. The cloud block is a nested block within the top-level terraform settings block. It specifies which Terraform Cloud workspaces to use for the current working directory. The cloud block only affects Terraform CLI's behavior. When Terraform Cloud uses a configuration that contains a cloud block - for example, when a workspace is configured to use a VCS provider directly - it ignores the block and behaves according to its own workspace settings.
 * <p>
 * https://developer.hashicorp.com/terraform/cli/cloud/settings#arguments
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.93.0 (build 1706ca5)", date = "2024-01-15T15:38:00.845Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.$Module.class, fqn = "cdktf.CloudBackendConfig")
@software.amazon.jsii.Jsii.Proxy(CloudBackendConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CloudBackendConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The name of the organization containing the workspace(s) the current configuration should use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getOrganization();

    /**
     * (experimental) A nested block that specifies which remote Terraform Cloud workspaces to use for the current configuration.
     * <p>
     * The workspaces block must contain exactly one of the following arguments, each denoting a strategy for how workspaces should be mapped:
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Object getWorkspaces();

    /**
     * (experimental) The hostname of a Terraform Enterprise installation, if using Terraform Enterprise.
     * <p>
     * Default: app.terraform.io
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getHostname() {
        return null;
    }

    /**
     * (experimental) The token used to authenticate with Terraform Cloud.
     * <p>
     * We recommend omitting the token from the configuration, and instead using terraform login or manually configuring credentials in the CLI config file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getToken() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CloudBackendConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CloudBackendConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CloudBackendConfig> {
        java.lang.String organization;
        java.lang.Object workspaces;
        java.lang.String hostname;
        java.lang.String token;

        /**
         * Sets the value of {@link CloudBackendConfig#getOrganization}
         * @param organization The name of the organization containing the workspace(s) the current configuration should use. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder organization(java.lang.String organization) {
            this.organization = organization;
            return this;
        }

        /**
         * Sets the value of {@link CloudBackendConfig#getWorkspaces}
         * @param workspaces A nested block that specifies which remote Terraform Cloud workspaces to use for the current configuration. This parameter is required.
         *                   The workspaces block must contain exactly one of the following arguments, each denoting a strategy for how workspaces should be mapped:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workspaces(com.hashicorp.cdktf.NamedCloudWorkspace workspaces) {
            this.workspaces = workspaces;
            return this;
        }

        /**
         * Sets the value of {@link CloudBackendConfig#getWorkspaces}
         * @param workspaces A nested block that specifies which remote Terraform Cloud workspaces to use for the current configuration. This parameter is required.
         *                   The workspaces block must contain exactly one of the following arguments, each denoting a strategy for how workspaces should be mapped:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workspaces(com.hashicorp.cdktf.TaggedCloudWorkspaces workspaces) {
            this.workspaces = workspaces;
            return this;
        }

        /**
         * Sets the value of {@link CloudBackendConfig#getHostname}
         * @param hostname The hostname of a Terraform Enterprise installation, if using Terraform Enterprise.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder hostname(java.lang.String hostname) {
            this.hostname = hostname;
            return this;
        }

        /**
         * Sets the value of {@link CloudBackendConfig#getToken}
         * @param token The token used to authenticate with Terraform Cloud.
         *              We recommend omitting the token from the configuration, and instead using terraform login or manually configuring credentials in the CLI config file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder token(java.lang.String token) {
            this.token = token;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CloudBackendConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CloudBackendConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CloudBackendConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudBackendConfig {
        private final java.lang.String organization;
        private final java.lang.Object workspaces;
        private final java.lang.String hostname;
        private final java.lang.String token;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.organization = software.amazon.jsii.Kernel.get(this, "organization", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.workspaces = software.amazon.jsii.Kernel.get(this, "workspaces", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.hostname = software.amazon.jsii.Kernel.get(this, "hostname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.token = software.amazon.jsii.Kernel.get(this, "token", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.organization = java.util.Objects.requireNonNull(builder.organization, "organization is required");
            this.workspaces = java.util.Objects.requireNonNull(builder.workspaces, "workspaces is required");
            this.hostname = builder.hostname;
            this.token = builder.token;
        }

        @Override
        public final java.lang.String getOrganization() {
            return this.organization;
        }

        @Override
        public final java.lang.Object getWorkspaces() {
            return this.workspaces;
        }

        @Override
        public final java.lang.String getHostname() {
            return this.hostname;
        }

        @Override
        public final java.lang.String getToken() {
            return this.token;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("organization", om.valueToTree(this.getOrganization()));
            data.set("workspaces", om.valueToTree(this.getWorkspaces()));
            if (this.getHostname() != null) {
                data.set("hostname", om.valueToTree(this.getHostname()));
            }
            if (this.getToken() != null) {
                data.set("token", om.valueToTree(this.getToken()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdktf.CloudBackendConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CloudBackendConfig.Jsii$Proxy that = (CloudBackendConfig.Jsii$Proxy) o;

            if (!organization.equals(that.organization)) return false;
            if (!workspaces.equals(that.workspaces)) return false;
            if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) return false;
            return this.token != null ? this.token.equals(that.token) : that.token == null;
        }

        @Override
        public final int hashCode() {
            int result = this.organization.hashCode();
            result = 31 * result + (this.workspaces.hashCode());
            result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
            result = 31 * result + (this.token != null ? this.token.hashCode() : 0);
            return result;
        }
    }
}
