package com.hashicorp.cdktf;

/**
 * (experimental) Stores the state in the Consul KV store at a given path. This backend supports state locking.
 * <p>
 * Read more about this backend in the Terraform docs:
 * https://developer.hashicorp.com/terraform/language/settings/backends/consul
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.93.0 (build 1706ca5)", date = "2024-01-15T15:38:00.852Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.$Module.class, fqn = "cdktf.ConsulBackendConfig")
@software.amazon.jsii.Jsii.Proxy(ConsulBackendConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ConsulBackendConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) (Required) Access token.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getAccessToken();

    /**
     * (experimental) (Required) Path in the Consul KV store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getPath();

    /**
     * (experimental) (Optional) DNS name and port of your Consul endpoint specified in the format dnsname:port.
     * <p>
     * Defaults to the local agent HTTP listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getAddress() {
        return null;
    }

    /**
     * (experimental) (Optional) A path to a PEM-encoded certificate authority used to verify the remote agent's certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getCaFile() {
        return null;
    }

    /**
     * (experimental) (Optional) A path to a PEM-encoded certificate provided to the remote agent;
     * <p>
     * requires use of key_file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getCertFile() {
        return null;
    }

    /**
     * (experimental) (Optional) The datacenter to use.
     * <p>
     * Defaults to that of the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDatacenter() {
        return null;
    }

    /**
     * (experimental) (Optional) true to compress the state data using gzip, or false (the default) to leave it uncompressed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getGzip() {
        return null;
    }

    /**
     * (experimental) (Optional) HTTP Basic Authentication credentials to be used when communicating with Consul, in the format of either user or user:pass.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getHttpAuth() {
        return null;
    }

    /**
     * (experimental) (Optional) A path to a PEM-encoded private key, required if cert_file is specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyFile() {
        return null;
    }

    /**
     * (experimental) (Optional) false to disable locking.
     * <p>
     * This defaults to true, but will require session permissions with Consul and
     * at least kv write permissions on $path/.lock to perform locking.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getLock() {
        return null;
    }

    /**
     * (experimental) (Optional) Specifies what protocol to use when talking to the given address,either http or https.
     * <p>
     * SSL support can also be triggered by setting then environment variable CONSUL_HTTP_SSL to true.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getScheme() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ConsulBackendConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ConsulBackendConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ConsulBackendConfig> {
        java.lang.String accessToken;
        java.lang.String path;
        java.lang.String address;
        java.lang.String caFile;
        java.lang.String certFile;
        java.lang.String datacenter;
        java.lang.Boolean gzip;
        java.lang.String httpAuth;
        java.lang.String keyFile;
        java.lang.Boolean lock;
        java.lang.String scheme;

        /**
         * Sets the value of {@link ConsulBackendConfig#getAccessToken}
         * @param accessToken (Required) Access token. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder accessToken(java.lang.String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        /**
         * Sets the value of {@link ConsulBackendConfig#getPath}
         * @param path (Required) Path in the Consul KV store. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Sets the value of {@link ConsulBackendConfig#getAddress}
         * @param address (Optional) DNS name and port of your Consul endpoint specified in the format dnsname:port.
         *                Defaults to the local agent HTTP listener.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder address(java.lang.String address) {
            this.address = address;
            return this;
        }

        /**
         * Sets the value of {@link ConsulBackendConfig#getCaFile}
         * @param caFile (Optional) A path to a PEM-encoded certificate authority used to verify the remote agent's certificate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder caFile(java.lang.String caFile) {
            this.caFile = caFile;
            return this;
        }

        /**
         * Sets the value of {@link ConsulBackendConfig#getCertFile}
         * @param certFile (Optional) A path to a PEM-encoded certificate provided to the remote agent;.
         *                 requires use of key_file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder certFile(java.lang.String certFile) {
            this.certFile = certFile;
            return this;
        }

        /**
         * Sets the value of {@link ConsulBackendConfig#getDatacenter}
         * @param datacenter (Optional) The datacenter to use.
         *                   Defaults to that of the agent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder datacenter(java.lang.String datacenter) {
            this.datacenter = datacenter;
            return this;
        }

        /**
         * Sets the value of {@link ConsulBackendConfig#getGzip}
         * @param gzip (Optional) true to compress the state data using gzip, or false (the default) to leave it uncompressed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder gzip(java.lang.Boolean gzip) {
            this.gzip = gzip;
            return this;
        }

        /**
         * Sets the value of {@link ConsulBackendConfig#getHttpAuth}
         * @param httpAuth (Optional) HTTP Basic Authentication credentials to be used when communicating with Consul, in the format of either user or user:pass.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder httpAuth(java.lang.String httpAuth) {
            this.httpAuth = httpAuth;
            return this;
        }

        /**
         * Sets the value of {@link ConsulBackendConfig#getKeyFile}
         * @param keyFile (Optional) A path to a PEM-encoded private key, required if cert_file is specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder keyFile(java.lang.String keyFile) {
            this.keyFile = keyFile;
            return this;
        }

        /**
         * Sets the value of {@link ConsulBackendConfig#getLock}
         * @param lock (Optional) false to disable locking.
         *             This defaults to true, but will require session permissions with Consul and
         *             at least kv write permissions on $path/.lock to perform locking.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lock(java.lang.Boolean lock) {
            this.lock = lock;
            return this;
        }

        /**
         * Sets the value of {@link ConsulBackendConfig#getScheme}
         * @param scheme (Optional) Specifies what protocol to use when talking to the given address,either http or https.
         *               SSL support can also be triggered by setting then environment variable CONSUL_HTTP_SSL to true.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder scheme(java.lang.String scheme) {
            this.scheme = scheme;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ConsulBackendConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ConsulBackendConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ConsulBackendConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConsulBackendConfig {
        private final java.lang.String accessToken;
        private final java.lang.String path;
        private final java.lang.String address;
        private final java.lang.String caFile;
        private final java.lang.String certFile;
        private final java.lang.String datacenter;
        private final java.lang.Boolean gzip;
        private final java.lang.String httpAuth;
        private final java.lang.String keyFile;
        private final java.lang.Boolean lock;
        private final java.lang.String scheme;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessToken = software.amazon.jsii.Kernel.get(this, "accessToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.address = software.amazon.jsii.Kernel.get(this, "address", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.caFile = software.amazon.jsii.Kernel.get(this, "caFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.certFile = software.amazon.jsii.Kernel.get(this, "certFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.datacenter = software.amazon.jsii.Kernel.get(this, "datacenter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.gzip = software.amazon.jsii.Kernel.get(this, "gzip", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.httpAuth = software.amazon.jsii.Kernel.get(this, "httpAuth", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keyFile = software.amazon.jsii.Kernel.get(this, "keyFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lock = software.amazon.jsii.Kernel.get(this, "lock", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.scheme = software.amazon.jsii.Kernel.get(this, "scheme", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessToken = java.util.Objects.requireNonNull(builder.accessToken, "accessToken is required");
            this.path = java.util.Objects.requireNonNull(builder.path, "path is required");
            this.address = builder.address;
            this.caFile = builder.caFile;
            this.certFile = builder.certFile;
            this.datacenter = builder.datacenter;
            this.gzip = builder.gzip;
            this.httpAuth = builder.httpAuth;
            this.keyFile = builder.keyFile;
            this.lock = builder.lock;
            this.scheme = builder.scheme;
        }

        @Override
        public final java.lang.String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public final java.lang.String getPath() {
            return this.path;
        }

        @Override
        public final java.lang.String getAddress() {
            return this.address;
        }

        @Override
        public final java.lang.String getCaFile() {
            return this.caFile;
        }

        @Override
        public final java.lang.String getCertFile() {
            return this.certFile;
        }

        @Override
        public final java.lang.String getDatacenter() {
            return this.datacenter;
        }

        @Override
        public final java.lang.Boolean getGzip() {
            return this.gzip;
        }

        @Override
        public final java.lang.String getHttpAuth() {
            return this.httpAuth;
        }

        @Override
        public final java.lang.String getKeyFile() {
            return this.keyFile;
        }

        @Override
        public final java.lang.Boolean getLock() {
            return this.lock;
        }

        @Override
        public final java.lang.String getScheme() {
            return this.scheme;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accessToken", om.valueToTree(this.getAccessToken()));
            data.set("path", om.valueToTree(this.getPath()));
            if (this.getAddress() != null) {
                data.set("address", om.valueToTree(this.getAddress()));
            }
            if (this.getCaFile() != null) {
                data.set("caFile", om.valueToTree(this.getCaFile()));
            }
            if (this.getCertFile() != null) {
                data.set("certFile", om.valueToTree(this.getCertFile()));
            }
            if (this.getDatacenter() != null) {
                data.set("datacenter", om.valueToTree(this.getDatacenter()));
            }
            if (this.getGzip() != null) {
                data.set("gzip", om.valueToTree(this.getGzip()));
            }
            if (this.getHttpAuth() != null) {
                data.set("httpAuth", om.valueToTree(this.getHttpAuth()));
            }
            if (this.getKeyFile() != null) {
                data.set("keyFile", om.valueToTree(this.getKeyFile()));
            }
            if (this.getLock() != null) {
                data.set("lock", om.valueToTree(this.getLock()));
            }
            if (this.getScheme() != null) {
                data.set("scheme", om.valueToTree(this.getScheme()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdktf.ConsulBackendConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ConsulBackendConfig.Jsii$Proxy that = (ConsulBackendConfig.Jsii$Proxy) o;

            if (!accessToken.equals(that.accessToken)) return false;
            if (!path.equals(that.path)) return false;
            if (this.address != null ? !this.address.equals(that.address) : that.address != null) return false;
            if (this.caFile != null ? !this.caFile.equals(that.caFile) : that.caFile != null) return false;
            if (this.certFile != null ? !this.certFile.equals(that.certFile) : that.certFile != null) return false;
            if (this.datacenter != null ? !this.datacenter.equals(that.datacenter) : that.datacenter != null) return false;
            if (this.gzip != null ? !this.gzip.equals(that.gzip) : that.gzip != null) return false;
            if (this.httpAuth != null ? !this.httpAuth.equals(that.httpAuth) : that.httpAuth != null) return false;
            if (this.keyFile != null ? !this.keyFile.equals(that.keyFile) : that.keyFile != null) return false;
            if (this.lock != null ? !this.lock.equals(that.lock) : that.lock != null) return false;
            return this.scheme != null ? this.scheme.equals(that.scheme) : that.scheme == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accessToken.hashCode();
            result = 31 * result + (this.path.hashCode());
            result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
            result = 31 * result + (this.caFile != null ? this.caFile.hashCode() : 0);
            result = 31 * result + (this.certFile != null ? this.certFile.hashCode() : 0);
            result = 31 * result + (this.datacenter != null ? this.datacenter.hashCode() : 0);
            result = 31 * result + (this.gzip != null ? this.gzip.hashCode() : 0);
            result = 31 * result + (this.httpAuth != null ? this.httpAuth.hashCode() : 0);
            result = 31 * result + (this.keyFile != null ? this.keyFile.hashCode() : 0);
            result = 31 * result + (this.lock != null ? this.lock.hashCode() : 0);
            result = 31 * result + (this.scheme != null ? this.scheme.hashCode() : 0);
            return result;
        }
    }
}
