package com.hashicorp.cdktf;

/**
 * (experimental) Stores the state as an object in a configurable prefix in a given bucket on Tencent Cloud Object Storage (COS).
 * <p>
 * This backend supports state locking.
 * <p>
 * Warning! It is highly recommended that you enable Object Versioning on the COS bucket to allow for state recovery in the case of accidental deletions and human error.
 * <p>
 * Read more about this backend in the Terraform docs:
 * https://developer.hashicorp.com/terraform/language/settings/backends/cos
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.93.0 (build 1706ca5)", date = "2024-01-15T15:38:00.875Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.$Module.class, fqn = "cdktf.CosBackendConfig")
@software.amazon.jsii.Jsii.Proxy(CosBackendConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CosBackendConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) (Required) The name of the COS bucket.
     * <p>
     * You shall manually create it first.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getBucket();

    /**
     * (experimental) (Optional) Whether to enable global Acceleration.
     * <p>
     * Defaults to false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAccelerate() {
        return null;
    }

    /**
     * (experimental) (Optional) Object ACL to be applied to the state file, allows private and public-read.
     * <p>
     * Defaults to private.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getAcl() {
        return null;
    }

    /**
     * (experimental) (Optional) The assume_role block.
     * <p>
     * If provided, terraform will attempt to assume this role using the supplied credentials.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable com.hashicorp.cdktf.CosBackendAssumeRole getAssumeRole() {
        return null;
    }

    /**
     * (experimental) (Optional) The root domain of the API request.
     * <p>
     * Defaults to tencentcloudapi.com.
     * It supports the environment variable TENCENTCLOUD_DOMAIN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomain() {
        return null;
    }

    /**
     * (experimental) (Optional) Whether to enable server side encryption of the state file.
     * <p>
     * If it is true, COS will use 'AES256' encryption algorithm to encrypt state file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEncrypt() {
        return null;
    }

    /**
     * (experimental) (Optional) The Custom Endpoint for the COS backend.
     * <p>
     * It supports the environment variable TENCENTCLOUD_ENDPOINT.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndpoint() {
        return null;
    }

    /**
     * (experimental) (Optional) The path for saving the state file in bucket.
     * <p>
     * Defaults to terraform.tfstate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
        return null;
    }

    /**
     * (experimental) (Optional) The directory for saving the state file in bucket.
     * <p>
     * Default to "env:".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
        return null;
    }

    /**
     * (experimental) (Optional) The region of the COS bucket.
     * <p>
     * It supports environment variables TENCENTCLOUD_REGION.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * (experimental) (Optional) Secret id of Tencent Cloud.
     * <p>
     * It supports environment variables TENCENTCLOUD_SECRET_ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecretId() {
        return null;
    }

    /**
     * (experimental) (Optional) Secret key of Tencent Cloud.
     * <p>
     * It supports environment variables TENCENTCLOUD_SECRET_KEY.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecretKey() {
        return null;
    }

    /**
     * (experimental) (Optional) TencentCloud Security Token of temporary access credentials.
     * <p>
     * It supports environment variables TENCENTCLOUD_SECURITY_TOKEN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecurityToken() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CosBackendConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CosBackendConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CosBackendConfig> {
        java.lang.String bucket;
        java.lang.Boolean accelerate;
        java.lang.String acl;
        com.hashicorp.cdktf.CosBackendAssumeRole assumeRole;
        java.lang.String domain;
        java.lang.Boolean encrypt;
        java.lang.String endpoint;
        java.lang.String key;
        java.lang.String prefix;
        java.lang.String region;
        java.lang.String secretId;
        java.lang.String secretKey;
        java.lang.String securityToken;

        /**
         * Sets the value of {@link CosBackendConfig#getBucket}
         * @param bucket (Required) The name of the COS bucket. This parameter is required.
         *               You shall manually create it first.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bucket(java.lang.String bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link CosBackendConfig#getAccelerate}
         * @param accelerate (Optional) Whether to enable global Acceleration.
         *                   Defaults to false.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder accelerate(java.lang.Boolean accelerate) {
            this.accelerate = accelerate;
            return this;
        }

        /**
         * Sets the value of {@link CosBackendConfig#getAcl}
         * @param acl (Optional) Object ACL to be applied to the state file, allows private and public-read.
         *            Defaults to private.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder acl(java.lang.String acl) {
            this.acl = acl;
            return this;
        }

        /**
         * Sets the value of {@link CosBackendConfig#getAssumeRole}
         * @param assumeRole (Optional) The assume_role block.
         *                   If provided, terraform will attempt to assume this role using the supplied credentials.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assumeRole(com.hashicorp.cdktf.CosBackendAssumeRole assumeRole) {
            this.assumeRole = assumeRole;
            return this;
        }

        /**
         * Sets the value of {@link CosBackendConfig#getDomain}
         * @param domain (Optional) The root domain of the API request.
         *               Defaults to tencentcloudapi.com.
         *               It supports the environment variable TENCENTCLOUD_DOMAIN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domain(java.lang.String domain) {
            this.domain = domain;
            return this;
        }

        /**
         * Sets the value of {@link CosBackendConfig#getEncrypt}
         * @param encrypt (Optional) Whether to enable server side encryption of the state file.
         *                If it is true, COS will use 'AES256' encryption algorithm to encrypt state file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encrypt(java.lang.Boolean encrypt) {
            this.encrypt = encrypt;
            return this;
        }

        /**
         * Sets the value of {@link CosBackendConfig#getEndpoint}
         * @param endpoint (Optional) The Custom Endpoint for the COS backend.
         *                 It supports the environment variable TENCENTCLOUD_ENDPOINT.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder endpoint(java.lang.String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        /**
         * Sets the value of {@link CosBackendConfig#getKey}
         * @param key (Optional) The path for saving the state file in bucket.
         *            Defaults to terraform.tfstate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder key(java.lang.String key) {
            this.key = key;
            return this;
        }

        /**
         * Sets the value of {@link CosBackendConfig#getPrefix}
         * @param prefix (Optional) The directory for saving the state file in bucket.
         *               Default to "env:".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder prefix(java.lang.String prefix) {
            this.prefix = prefix;
            return this;
        }

        /**
         * Sets the value of {@link CosBackendConfig#getRegion}
         * @param region (Optional) The region of the COS bucket.
         *               It supports environment variables TENCENTCLOUD_REGION.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link CosBackendConfig#getSecretId}
         * @param secretId (Optional) Secret id of Tencent Cloud.
         *                 It supports environment variables TENCENTCLOUD_SECRET_ID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder secretId(java.lang.String secretId) {
            this.secretId = secretId;
            return this;
        }

        /**
         * Sets the value of {@link CosBackendConfig#getSecretKey}
         * @param secretKey (Optional) Secret key of Tencent Cloud.
         *                  It supports environment variables TENCENTCLOUD_SECRET_KEY.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder secretKey(java.lang.String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        /**
         * Sets the value of {@link CosBackendConfig#getSecurityToken}
         * @param securityToken (Optional) TencentCloud Security Token of temporary access credentials.
         *                      It supports environment variables TENCENTCLOUD_SECURITY_TOKEN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityToken(java.lang.String securityToken) {
            this.securityToken = securityToken;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CosBackendConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CosBackendConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CosBackendConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CosBackendConfig {
        private final java.lang.String bucket;
        private final java.lang.Boolean accelerate;
        private final java.lang.String acl;
        private final com.hashicorp.cdktf.CosBackendAssumeRole assumeRole;
        private final java.lang.String domain;
        private final java.lang.Boolean encrypt;
        private final java.lang.String endpoint;
        private final java.lang.String key;
        private final java.lang.String prefix;
        private final java.lang.String region;
        private final java.lang.String secretId;
        private final java.lang.String secretKey;
        private final java.lang.String securityToken;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accelerate = software.amazon.jsii.Kernel.get(this, "accelerate", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.acl = software.amazon.jsii.Kernel.get(this, "acl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assumeRole = software.amazon.jsii.Kernel.get(this, "assumeRole", software.amazon.jsii.NativeType.forClass(com.hashicorp.cdktf.CosBackendAssumeRole.class));
            this.domain = software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encrypt = software.amazon.jsii.Kernel.get(this, "encrypt", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.endpoint = software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.secretId = software.amazon.jsii.Kernel.get(this, "secretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.secretKey = software.amazon.jsii.Kernel.get(this, "secretKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityToken = software.amazon.jsii.Kernel.get(this, "securityToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
            this.accelerate = builder.accelerate;
            this.acl = builder.acl;
            this.assumeRole = builder.assumeRole;
            this.domain = builder.domain;
            this.encrypt = builder.encrypt;
            this.endpoint = builder.endpoint;
            this.key = builder.key;
            this.prefix = builder.prefix;
            this.region = builder.region;
            this.secretId = builder.secretId;
            this.secretKey = builder.secretKey;
            this.securityToken = builder.securityToken;
        }

        @Override
        public final java.lang.String getBucket() {
            return this.bucket;
        }

        @Override
        public final java.lang.Boolean getAccelerate() {
            return this.accelerate;
        }

        @Override
        public final java.lang.String getAcl() {
            return this.acl;
        }

        @Override
        public final com.hashicorp.cdktf.CosBackendAssumeRole getAssumeRole() {
            return this.assumeRole;
        }

        @Override
        public final java.lang.String getDomain() {
            return this.domain;
        }

        @Override
        public final java.lang.Boolean getEncrypt() {
            return this.encrypt;
        }

        @Override
        public final java.lang.String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final java.lang.String getKey() {
            return this.key;
        }

        @Override
        public final java.lang.String getPrefix() {
            return this.prefix;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.lang.String getSecretId() {
            return this.secretId;
        }

        @Override
        public final java.lang.String getSecretKey() {
            return this.secretKey;
        }

        @Override
        public final java.lang.String getSecurityToken() {
            return this.securityToken;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bucket", om.valueToTree(this.getBucket()));
            if (this.getAccelerate() != null) {
                data.set("accelerate", om.valueToTree(this.getAccelerate()));
            }
            if (this.getAcl() != null) {
                data.set("acl", om.valueToTree(this.getAcl()));
            }
            if (this.getAssumeRole() != null) {
                data.set("assumeRole", om.valueToTree(this.getAssumeRole()));
            }
            if (this.getDomain() != null) {
                data.set("domain", om.valueToTree(this.getDomain()));
            }
            if (this.getEncrypt() != null) {
                data.set("encrypt", om.valueToTree(this.getEncrypt()));
            }
            if (this.getEndpoint() != null) {
                data.set("endpoint", om.valueToTree(this.getEndpoint()));
            }
            if (this.getKey() != null) {
                data.set("key", om.valueToTree(this.getKey()));
            }
            if (this.getPrefix() != null) {
                data.set("prefix", om.valueToTree(this.getPrefix()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getSecretId() != null) {
                data.set("secretId", om.valueToTree(this.getSecretId()));
            }
            if (this.getSecretKey() != null) {
                data.set("secretKey", om.valueToTree(this.getSecretKey()));
            }
            if (this.getSecurityToken() != null) {
                data.set("securityToken", om.valueToTree(this.getSecurityToken()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdktf.CosBackendConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CosBackendConfig.Jsii$Proxy that = (CosBackendConfig.Jsii$Proxy) o;

            if (!bucket.equals(that.bucket)) return false;
            if (this.accelerate != null ? !this.accelerate.equals(that.accelerate) : that.accelerate != null) return false;
            if (this.acl != null ? !this.acl.equals(that.acl) : that.acl != null) return false;
            if (this.assumeRole != null ? !this.assumeRole.equals(that.assumeRole) : that.assumeRole != null) return false;
            if (this.domain != null ? !this.domain.equals(that.domain) : that.domain != null) return false;
            if (this.encrypt != null ? !this.encrypt.equals(that.encrypt) : that.encrypt != null) return false;
            if (this.endpoint != null ? !this.endpoint.equals(that.endpoint) : that.endpoint != null) return false;
            if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
            if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.secretId != null ? !this.secretId.equals(that.secretId) : that.secretId != null) return false;
            if (this.secretKey != null ? !this.secretKey.equals(that.secretKey) : that.secretKey != null) return false;
            return this.securityToken != null ? this.securityToken.equals(that.securityToken) : that.securityToken == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bucket.hashCode();
            result = 31 * result + (this.accelerate != null ? this.accelerate.hashCode() : 0);
            result = 31 * result + (this.acl != null ? this.acl.hashCode() : 0);
            result = 31 * result + (this.assumeRole != null ? this.assumeRole.hashCode() : 0);
            result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
            result = 31 * result + (this.encrypt != null ? this.encrypt.hashCode() : 0);
            result = 31 * result + (this.endpoint != null ? this.endpoint.hashCode() : 0);
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.secretId != null ? this.secretId.hashCode() : 0);
            result = 31 * result + (this.secretKey != null ? this.secretKey.hashCode() : 0);
            result = 31 * result + (this.securityToken != null ? this.securityToken.hashCode() : 0);
            return result;
        }
    }
}
