package com.hashicorp.cdktf;

/**
 * (experimental) The local-exec provisioner invokes a local executable after a resource is created.
 * <p>
 * This invokes a process on the machine running Terraform, not on the resource.
 * See {@link https://developer.hashicorp.com/terraform/language/resources/provisioners/local-exec local-exec}
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.93.0 (build 1706ca5)", date = "2024-01-15T15:38:01.050Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.$Module.class, fqn = "cdktf.LocalExecProvisioner")
@software.amazon.jsii.Jsii.Proxy(LocalExecProvisioner.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface LocalExecProvisioner extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) This is the command to execute.
     * <p>
     * It can be provided as a relative path to the current working directory or as an absolute path.
     * It is evaluated in a shell, and can use environment variables or Terraform variables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getCommand();

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * (experimental) A record of key value pairs representing the environment of the executed command.
     * <p>
     * It inherits the current process environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
        return null;
    }

    /**
     * (experimental) If provided, this is a list of interpreter arguments used to execute the command.
     * <p>
     * The first argument is the interpreter itself.
     * It can be provided as a relative path to the current working directory or as an absolute path
     * The remaining arguments are appended prior to the command.
     * This allows building command lines of the form "/bin/bash", "-c", "echo foo".
     * If interpreter is unspecified, sensible defaults will be chosen based on the system OS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInterpreter() {
        return null;
    }

    /**
     * (experimental) If provided, specifies when Terraform will execute the command.
     * <p>
     * For example, when = destroy specifies that the provisioner will run when the associated resource is destroyed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getWhen() {
        return null;
    }

    /**
     * (experimental) If provided, specifies the working directory where command will be executed.
     * <p>
     * It can be provided as a relative path to the current working directory or as an absolute path.
     * The directory must exist.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getWorkingDir() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LocalExecProvisioner}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LocalExecProvisioner}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<LocalExecProvisioner> {
        java.lang.String command;
        java.lang.String type;
        java.util.Map<java.lang.String, java.lang.String> environment;
        java.util.List<java.lang.String> interpreter;
        java.lang.String when;
        java.lang.String workingDir;

        /**
         * Sets the value of {@link LocalExecProvisioner#getCommand}
         * @param command This is the command to execute. This parameter is required.
         *                It can be provided as a relative path to the current working directory or as an absolute path.
         *                It is evaluated in a shell, and can use environment variables or Terraform variables.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder command(java.lang.String command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link LocalExecProvisioner#getType}
         * @param type the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link LocalExecProvisioner#getEnvironment}
         * @param environment A record of key value pairs representing the environment of the executed command.
         *                    It inherits the current process environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link LocalExecProvisioner#getInterpreter}
         * @param interpreter If provided, this is a list of interpreter arguments used to execute the command.
         *                    The first argument is the interpreter itself.
         *                    It can be provided as a relative path to the current working directory or as an absolute path
         *                    The remaining arguments are appended prior to the command.
         *                    This allows building command lines of the form "/bin/bash", "-c", "echo foo".
         *                    If interpreter is unspecified, sensible defaults will be chosen based on the system OS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder interpreter(java.util.List<java.lang.String> interpreter) {
            this.interpreter = interpreter;
            return this;
        }

        /**
         * Sets the value of {@link LocalExecProvisioner#getWhen}
         * @param when If provided, specifies when Terraform will execute the command.
         *             For example, when = destroy specifies that the provisioner will run when the associated resource is destroyed
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder when(java.lang.String when) {
            this.when = when;
            return this;
        }

        /**
         * Sets the value of {@link LocalExecProvisioner#getWorkingDir}
         * @param workingDir If provided, specifies the working directory where command will be executed.
         *                   It can be provided as a relative path to the current working directory or as an absolute path.
         *                   The directory must exist.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workingDir(java.lang.String workingDir) {
            this.workingDir = workingDir;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LocalExecProvisioner}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public LocalExecProvisioner build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LocalExecProvisioner}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LocalExecProvisioner {
        private final java.lang.String command;
        private final java.lang.String type;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final java.util.List<java.lang.String> interpreter;
        private final java.lang.String when;
        private final java.lang.String workingDir;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.interpreter = software.amazon.jsii.Kernel.get(this, "interpreter", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.when = software.amazon.jsii.Kernel.get(this, "when", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.workingDir = software.amazon.jsii.Kernel.get(this, "workingDir", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.command = java.util.Objects.requireNonNull(builder.command, "command is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.environment = builder.environment;
            this.interpreter = builder.interpreter;
            this.when = builder.when;
            this.workingDir = builder.workingDir;
        }

        @Override
        public final java.lang.String getCommand() {
            return this.command;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final java.util.List<java.lang.String> getInterpreter() {
            return this.interpreter;
        }

        @Override
        public final java.lang.String getWhen() {
            return this.when;
        }

        @Override
        public final java.lang.String getWorkingDir() {
            return this.workingDir;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("command", om.valueToTree(this.getCommand()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getInterpreter() != null) {
                data.set("interpreter", om.valueToTree(this.getInterpreter()));
            }
            if (this.getWhen() != null) {
                data.set("when", om.valueToTree(this.getWhen()));
            }
            if (this.getWorkingDir() != null) {
                data.set("workingDir", om.valueToTree(this.getWorkingDir()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdktf.LocalExecProvisioner"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LocalExecProvisioner.Jsii$Proxy that = (LocalExecProvisioner.Jsii$Proxy) o;

            if (!command.equals(that.command)) return false;
            if (!type.equals(that.type)) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.interpreter != null ? !this.interpreter.equals(that.interpreter) : that.interpreter != null) return false;
            if (this.when != null ? !this.when.equals(that.when) : that.when != null) return false;
            return this.workingDir != null ? this.workingDir.equals(that.workingDir) : that.workingDir == null;
        }

        @Override
        public final int hashCode() {
            int result = this.command.hashCode();
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.interpreter != null ? this.interpreter.hashCode() : 0);
            result = 31 * result + (this.when != null ? this.when.hashCode() : 0);
            result = 31 * result + (this.workingDir != null ? this.workingDir.hashCode() : 0);
            return result;
        }
    }
}
