package com.hashicorp.cdktf;

/**
 * (experimental) The remote-exec provisioner invokes a script on a remote resource after it is created.
 * <p>
 * This can be used to run a configuration management tool, bootstrap into a cluster, etc
 * The remote-exec provisioner requires a connection and supports both ssh and winrm.
 * See {@link https://developer.hashicorp.com/terraform/language/resources/provisioners/remote-exec remote-exec}
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.93.0 (build 1706ca5)", date = "2024-01-15T15:38:01.075Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.$Module.class, fqn = "cdktf.RemoteExecProvisioner")
@software.amazon.jsii.Jsii.Proxy(RemoteExecProvisioner.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface RemoteExecProvisioner extends software.amazon.jsii.JsiiSerializable {

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * (experimental) Most provisioners require access to the remote resource via SSH or WinRM and expect a nested connection block with details about how to connect.
     * <p>
     * A connection must be provided here or in the parent resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConnection() {
        return null;
    }

    /**
     * (experimental) This is a list of command strings.
     * <p>
     * They are executed in the order they are provided.
     * This cannot be provided with script or scripts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInline() {
        return null;
    }

    /**
     * (experimental) This is a path (relative or absolute) to a local script that will be copied to the remote resource and then executed.
     * <p>
     * This cannot be provided with inline or scripts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getScript() {
        return null;
    }

    /**
     * (experimental) This is a list of paths (relative or absolute) to local scripts that will be copied to the remote resource and then executed.
     * <p>
     * They are executed in the order they are provided.
     * This cannot be provided with inline or script.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getScripts() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RemoteExecProvisioner}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RemoteExecProvisioner}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<RemoteExecProvisioner> {
        java.lang.String type;
        java.lang.Object connection;
        java.util.List<java.lang.String> inline;
        java.lang.String script;
        java.util.List<java.lang.String> scripts;

        /**
         * Sets the value of {@link RemoteExecProvisioner#getType}
         * @param type the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link RemoteExecProvisioner#getConnection}
         * @param connection Most provisioners require access to the remote resource via SSH or WinRM and expect a nested connection block with details about how to connect.
         *                   A connection must be provided here or in the parent resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.SSHProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link RemoteExecProvisioner#getConnection}
         * @param connection Most provisioners require access to the remote resource via SSH or WinRM and expect a nested connection block with details about how to connect.
         *                   A connection must be provided here or in the parent resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(com.hashicorp.cdktf.WinrmProvisionerConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link RemoteExecProvisioner#getInline}
         * @param inline This is a list of command strings.
         *               They are executed in the order they are provided.
         *               This cannot be provided with script or scripts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder inline(java.util.List<java.lang.String> inline) {
            this.inline = inline;
            return this;
        }

        /**
         * Sets the value of {@link RemoteExecProvisioner#getScript}
         * @param script This is a path (relative or absolute) to a local script that will be copied to the remote resource and then executed.
         *               This cannot be provided with inline or scripts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder script(java.lang.String script) {
            this.script = script;
            return this;
        }

        /**
         * Sets the value of {@link RemoteExecProvisioner#getScripts}
         * @param scripts This is a list of paths (relative or absolute) to local scripts that will be copied to the remote resource and then executed.
         *                They are executed in the order they are provided.
         *                This cannot be provided with inline or script.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder scripts(java.util.List<java.lang.String> scripts) {
            this.scripts = scripts;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RemoteExecProvisioner}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public RemoteExecProvisioner build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RemoteExecProvisioner}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RemoteExecProvisioner {
        private final java.lang.String type;
        private final java.lang.Object connection;
        private final java.util.List<java.lang.String> inline;
        private final java.lang.String script;
        private final java.util.List<java.lang.String> scripts;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connection = software.amazon.jsii.Kernel.get(this, "connection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.inline = software.amazon.jsii.Kernel.get(this, "inline", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.script = software.amazon.jsii.Kernel.get(this, "script", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scripts = software.amazon.jsii.Kernel.get(this, "scripts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.connection = builder.connection;
            this.inline = builder.inline;
            this.script = builder.script;
            this.scripts = builder.scripts;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getConnection() {
            return this.connection;
        }

        @Override
        public final java.util.List<java.lang.String> getInline() {
            return this.inline;
        }

        @Override
        public final java.lang.String getScript() {
            return this.script;
        }

        @Override
        public final java.util.List<java.lang.String> getScripts() {
            return this.scripts;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            if (this.getConnection() != null) {
                data.set("connection", om.valueToTree(this.getConnection()));
            }
            if (this.getInline() != null) {
                data.set("inline", om.valueToTree(this.getInline()));
            }
            if (this.getScript() != null) {
                data.set("script", om.valueToTree(this.getScript()));
            }
            if (this.getScripts() != null) {
                data.set("scripts", om.valueToTree(this.getScripts()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdktf.RemoteExecProvisioner"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RemoteExecProvisioner.Jsii$Proxy that = (RemoteExecProvisioner.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            if (this.connection != null ? !this.connection.equals(that.connection) : that.connection != null) return false;
            if (this.inline != null ? !this.inline.equals(that.inline) : that.inline != null) return false;
            if (this.script != null ? !this.script.equals(that.script) : that.script != null) return false;
            return this.scripts != null ? this.scripts.equals(that.scripts) : that.scripts == null;
        }

        @Override
        public final int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.connection != null ? this.connection.hashCode() : 0);
            result = 31 * result + (this.inline != null ? this.inline.hashCode() : 0);
            result = 31 * result + (this.script != null ? this.script.hashCode() : 0);
            result = 31 * result + (this.scripts != null ? this.scripts.hashCode() : 0);
            return result;
        }
    }
}
