package com.hashicorp.cdktf;

/**
 * (experimental) Most provisioners require access to the remote resource via SSH or WinRM and expect a nested connection block with details about how to connect.
 * <p>
 * Refer to {@link https://developer.hashicorp.com/terraform/language/resources/provisioners/connection connection}
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.93.0 (build 1706ca5)", date = "2024-01-15T15:38:01.116Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.$Module.class, fqn = "cdktf.SSHProvisionerConnection")
@software.amazon.jsii.Jsii.Proxy(SSHProvisionerConnection.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface SSHProvisionerConnection extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The address of the resource to connect to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getHost();

    /**
     * (experimental) The connection type.
     * <p>
     * Valid values are "ssh" and "winrm".
     * Provisioners typically assume that the remote system runs Microsoft Windows when using WinRM.
     * Behaviors based on the SSH target_platform will force Windows-specific behavior for WinRM, unless otherwise specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * (experimental) Set to false to disable using ssh-agent to authenticate.
     * <p>
     * On Windows the only supported SSH authentication agent is Pageant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getAgent() {
        return null;
    }

    /**
     * (experimental) The preferred identity from the ssh agent for authentication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getAgentIdentity() {
        return null;
    }

    /**
     * (experimental) The contents of a signed CA Certificate.
     * <p>
     * The certificate argument must be used in conjunction with a bastion_private_key.
     * These can be loaded from a file on disk using the the file function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getBastionCertificate() {
        return null;
    }

    /**
     * (experimental) Setting this enables the bastion Host connection.
     * <p>
     * The provisioner will connect to bastion_host first, and then connect from there to host.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getBastionHost() {
        return null;
    }

    /**
     * (experimental) The public key from the remote host or the signing CA, used to verify the host connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getBastionHostKey() {
        return null;
    }

    /**
     * (experimental) The password to use for the bastion host.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getBastionPassword() {
        return null;
    }

    /**
     * (experimental) The port to use connect to the bastion host.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getBastionPort() {
        return null;
    }

    /**
     * (experimental) The contents of an SSH key file to use for the bastion host.
     * <p>
     * These can be loaded from a file on disk using the file function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getBastionPrivateKey() {
        return null;
    }

    /**
     * (experimental) The user for the connection to the bastion host.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getBastionUser() {
        return null;
    }

    /**
     * (experimental) The contents of a signed CA Certificate.
     * <p>
     * The certificate argument must be used in conjunction with a private_key.
     * These can be loaded from a file on disk using the the file function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getCertificate() {
        return null;
    }

    /**
     * (experimental) The public key from the remote host or the signing CA, used to verify the connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getHostKey() {
        return null;
    }

    /**
     * (experimental) The password to use for the connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
        return null;
    }

    /**
     * (experimental) The port to connect to.
     * <p>
     * Default: 22
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * (experimental) The contents of an SSH key to use for the connection.
     * <p>
     * These can be loaded from a file on disk using the file function.
     * This takes preference over password if provided.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrivateKey() {
        return null;
    }

    /**
     * (experimental) Setting this enables the SSH over HTTP connection.
     * <p>
     * This host will be connected to first, and then the host or bastion_host connection will be made from there.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getProxyHost() {
        return null;
    }

    /**
     * (experimental) The port to use connect to the proxy host.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getProxyPort() {
        return null;
    }

    /**
     * (experimental) The ssh connection also supports the following fields to facilitate connections by SSH over HTTP proxy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getProxyScheme() {
        return null;
    }

    /**
     * (experimental) The username to use connect to the private proxy host.
     * <p>
     * This argument should be specified only if authentication is required for the HTTP Proxy server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getProxyUserName() {
        return null;
    }

    /**
     * (experimental) The password to use connect to the private proxy host.
     * <p>
     * This argument should be specified only if authentication is required for the HTTP Proxy server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getProxyUserPassword() {
        return null;
    }

    /**
     * (experimental) The path used to copy scripts meant for remote execution.
     * <p>
     * Refer to {@link https://developer.hashicorp.com/terraform/language/resources/provisioners/connection#how-provisioners-execute-remote-scripts How Provisioners Execute Remote Scripts below for more details}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getScriptPath() {
        return null;
    }

    /**
     * (experimental) The target platform to connect to.
     * <p>
     * Valid values are "windows" and "unix".
     * If the platform is set to windows, the default script_path is c:\windows\temp\terraform_%RAND%.cmd, assuming the SSH default shell is cmd.exe.
     * If the SSH default shell is PowerShell, set script_path to "c:/windows/temp/terraform_%RAND%.ps1"
     * <p>
     * Default: unix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getTargetPlatform() {
        return null;
    }

    /**
     * (experimental) The timeout to wait for the connection to become available.
     * <p>
     * Should be provided as a string (e.g., "30s" or "5m".)
     * <p>
     * Default: 5m
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getTimeout() {
        return null;
    }

    /**
     * (experimental) The user to use for the connection.
     * <p>
     * Default: root
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getUser() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SSHProvisionerConnection}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SSHProvisionerConnection}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<SSHProvisionerConnection> {
        java.lang.String host;
        java.lang.String type;
        java.lang.String agent;
        java.lang.String agentIdentity;
        java.lang.String bastionCertificate;
        java.lang.String bastionHost;
        java.lang.String bastionHostKey;
        java.lang.String bastionPassword;
        java.lang.Number bastionPort;
        java.lang.String bastionPrivateKey;
        java.lang.String bastionUser;
        java.lang.String certificate;
        java.lang.String hostKey;
        java.lang.String password;
        java.lang.Number port;
        java.lang.String privateKey;
        java.lang.String proxyHost;
        java.lang.Number proxyPort;
        java.lang.String proxyScheme;
        java.lang.String proxyUserName;
        java.lang.String proxyUserPassword;
        java.lang.String scriptPath;
        java.lang.String targetPlatform;
        java.lang.String timeout;
        java.lang.String user;

        /**
         * Sets the value of {@link SSHProvisionerConnection#getHost}
         * @param host The address of the resource to connect to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder host(java.lang.String host) {
            this.host = host;
            return this;
        }

        /**
         * Sets the value of {@link SSHProvisionerConnection#getType}
         * @param type The connection type. This parameter is required.
         *             Valid values are "ssh" and "winrm".
         *             Provisioners typically assume that the remote system runs Microsoft Windows when using WinRM.
         *             Behaviors based on the SSH target_platform will force Windows-specific behavior for WinRM, unless otherwise specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link SSHProvisionerConnection#getAgent}
         * @param agent Set to false to disable using ssh-agent to authenticate.
         *              On Windows the only supported SSH authentication agent is Pageant.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder agent(java.lang.String agent) {
            this.agent = agent;
            return this;
        }

        /**
         * Sets the value of {@link SSHProvisionerConnection#getAgentIdentity}
         * @param agentIdentity The preferred identity from the ssh agent for authentication.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder agentIdentity(java.lang.String agentIdentity) {
            this.agentIdentity = agentIdentity;
            return this;
        }

        /**
         * Sets the value of {@link SSHProvisionerConnection#getBastionCertificate}
         * @param bastionCertificate The contents of a signed CA Certificate.
         *                           The certificate argument must be used in conjunction with a bastion_private_key.
         *                           These can be loaded from a file on disk using the the file function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bastionCertificate(java.lang.String bastionCertificate) {
            this.bastionCertificate = bastionCertificate;
            return this;
        }

        /**
         * Sets the value of {@link SSHProvisionerConnection#getBastionHost}
         * @param bastionHost Setting this enables the bastion Host connection.
         *                    The provisioner will connect to bastion_host first, and then connect from there to host.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bastionHost(java.lang.String bastionHost) {
            this.bastionHost = bastionHost;
            return this;
        }

        /**
         * Sets the value of {@link SSHProvisionerConnection#getBastionHostKey}
         * @param bastionHostKey The public key from the remote host or the signing CA, used to verify the host connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bastionHostKey(java.lang.String bastionHostKey) {
            this.bastionHostKey = bastionHostKey;
            return this;
        }

        /**
         * Sets the value of {@link SSHProvisionerConnection#getBastionPassword}
         * @param bastionPassword The password to use for the bastion host.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bastionPassword(java.lang.String bastionPassword) {
            this.bastionPassword = bastionPassword;
            return this;
        }

        /**
         * Sets the value of {@link SSHProvisionerConnection#getBastionPort}
         * @param bastionPort The port to use connect to the bastion host.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bastionPort(java.lang.Number bastionPort) {
            this.bastionPort = bastionPort;
            return this;
        }

        /**
         * Sets the value of {@link SSHProvisionerConnection#getBastionPrivateKey}
         * @param bastionPrivateKey The contents of an SSH key file to use for the bastion host.
         *                          These can be loaded from a file on disk using the file function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bastionPrivateKey(java.lang.String bastionPrivateKey) {
            this.bastionPrivateKey = bastionPrivateKey;
            return this;
        }

        /**
         * Sets the value of {@link SSHProvisionerConnection#getBastionUser}
         * @param bastionUser The user for the connection to the bastion host.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bastionUser(java.lang.String bastionUser) {
            this.bastionUser = bastionUser;
            return this;
        }

        /**
         * Sets the value of {@link SSHProvisionerConnection#getCertificate}
         * @param certificate The contents of a signed CA Certificate.
         *                    The certificate argument must be used in conjunction with a private_key.
         *                    These can be loaded from a file on disk using the the file function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder certificate(java.lang.String certificate) {
            this.certificate = certificate;
            return this;
        }

        /**
         * Sets the value of {@link SSHProvisionerConnection#getHostKey}
         * @param hostKey The public key from the remote host or the signing CA, used to verify the connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder hostKey(java.lang.String hostKey) {
            this.hostKey = hostKey;
            return this;
        }

        /**
         * Sets the value of {@link SSHProvisionerConnection#getPassword}
         * @param password The password to use for the connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder password(java.lang.String password) {
            this.password = password;
            return this;
        }

        /**
         * Sets the value of {@link SSHProvisionerConnection#getPort}
         * @param port The port to connect to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link SSHProvisionerConnection#getPrivateKey}
         * @param privateKey The contents of an SSH key to use for the connection.
         *                   These can be loaded from a file on disk using the file function.
         *                   This takes preference over password if provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder privateKey(java.lang.String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        /**
         * Sets the value of {@link SSHProvisionerConnection#getProxyHost}
         * @param proxyHost Setting this enables the SSH over HTTP connection.
         *                  This host will be connected to first, and then the host or bastion_host connection will be made from there.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder proxyHost(java.lang.String proxyHost) {
            this.proxyHost = proxyHost;
            return this;
        }

        /**
         * Sets the value of {@link SSHProvisionerConnection#getProxyPort}
         * @param proxyPort The port to use connect to the proxy host.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder proxyPort(java.lang.Number proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        /**
         * Sets the value of {@link SSHProvisionerConnection#getProxyScheme}
         * @param proxyScheme The ssh connection also supports the following fields to facilitate connections by SSH over HTTP proxy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder proxyScheme(java.lang.String proxyScheme) {
            this.proxyScheme = proxyScheme;
            return this;
        }

        /**
         * Sets the value of {@link SSHProvisionerConnection#getProxyUserName}
         * @param proxyUserName The username to use connect to the private proxy host.
         *                      This argument should be specified only if authentication is required for the HTTP Proxy server.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder proxyUserName(java.lang.String proxyUserName) {
            this.proxyUserName = proxyUserName;
            return this;
        }

        /**
         * Sets the value of {@link SSHProvisionerConnection#getProxyUserPassword}
         * @param proxyUserPassword The password to use connect to the private proxy host.
         *                          This argument should be specified only if authentication is required for the HTTP Proxy server.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder proxyUserPassword(java.lang.String proxyUserPassword) {
            this.proxyUserPassword = proxyUserPassword;
            return this;
        }

        /**
         * Sets the value of {@link SSHProvisionerConnection#getScriptPath}
         * @param scriptPath The path used to copy scripts meant for remote execution.
         *                   Refer to {@link https://developer.hashicorp.com/terraform/language/resources/provisioners/connection#how-provisioners-execute-remote-scripts How Provisioners Execute Remote Scripts below for more details}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder scriptPath(java.lang.String scriptPath) {
            this.scriptPath = scriptPath;
            return this;
        }

        /**
         * Sets the value of {@link SSHProvisionerConnection#getTargetPlatform}
         * @param targetPlatform The target platform to connect to.
         *                       Valid values are "windows" and "unix".
         *                       If the platform is set to windows, the default script_path is c:\windows\temp\terraform_%RAND%.cmd, assuming the SSH default shell is cmd.exe.
         *                       If the SSH default shell is PowerShell, set script_path to "c:/windows/temp/terraform_%RAND%.ps1"
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder targetPlatform(java.lang.String targetPlatform) {
            this.targetPlatform = targetPlatform;
            return this;
        }

        /**
         * Sets the value of {@link SSHProvisionerConnection#getTimeout}
         * @param timeout The timeout to wait for the connection to become available.
         *                Should be provided as a string (e.g., "30s" or "5m".)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder timeout(java.lang.String timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link SSHProvisionerConnection#getUser}
         * @param user The user to use for the connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder user(java.lang.String user) {
            this.user = user;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SSHProvisionerConnection}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public SSHProvisionerConnection build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SSHProvisionerConnection}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SSHProvisionerConnection {
        private final java.lang.String host;
        private final java.lang.String type;
        private final java.lang.String agent;
        private final java.lang.String agentIdentity;
        private final java.lang.String bastionCertificate;
        private final java.lang.String bastionHost;
        private final java.lang.String bastionHostKey;
        private final java.lang.String bastionPassword;
        private final java.lang.Number bastionPort;
        private final java.lang.String bastionPrivateKey;
        private final java.lang.String bastionUser;
        private final java.lang.String certificate;
        private final java.lang.String hostKey;
        private final java.lang.String password;
        private final java.lang.Number port;
        private final java.lang.String privateKey;
        private final java.lang.String proxyHost;
        private final java.lang.Number proxyPort;
        private final java.lang.String proxyScheme;
        private final java.lang.String proxyUserName;
        private final java.lang.String proxyUserPassword;
        private final java.lang.String scriptPath;
        private final java.lang.String targetPlatform;
        private final java.lang.String timeout;
        private final java.lang.String user;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.agent = software.amazon.jsii.Kernel.get(this, "agent", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.agentIdentity = software.amazon.jsii.Kernel.get(this, "agentIdentity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bastionCertificate = software.amazon.jsii.Kernel.get(this, "bastionCertificate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bastionHost = software.amazon.jsii.Kernel.get(this, "bastionHost", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bastionHostKey = software.amazon.jsii.Kernel.get(this, "bastionHostKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bastionPassword = software.amazon.jsii.Kernel.get(this, "bastionPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bastionPort = software.amazon.jsii.Kernel.get(this, "bastionPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.bastionPrivateKey = software.amazon.jsii.Kernel.get(this, "bastionPrivateKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bastionUser = software.amazon.jsii.Kernel.get(this, "bastionUser", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.certificate = software.amazon.jsii.Kernel.get(this, "certificate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hostKey = software.amazon.jsii.Kernel.get(this, "hostKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.privateKey = software.amazon.jsii.Kernel.get(this, "privateKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.proxyHost = software.amazon.jsii.Kernel.get(this, "proxyHost", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.proxyPort = software.amazon.jsii.Kernel.get(this, "proxyPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.proxyScheme = software.amazon.jsii.Kernel.get(this, "proxyScheme", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.proxyUserName = software.amazon.jsii.Kernel.get(this, "proxyUserName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.proxyUserPassword = software.amazon.jsii.Kernel.get(this, "proxyUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scriptPath = software.amazon.jsii.Kernel.get(this, "scriptPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetPlatform = software.amazon.jsii.Kernel.get(this, "targetPlatform", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.host = java.util.Objects.requireNonNull(builder.host, "host is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.agent = builder.agent;
            this.agentIdentity = builder.agentIdentity;
            this.bastionCertificate = builder.bastionCertificate;
            this.bastionHost = builder.bastionHost;
            this.bastionHostKey = builder.bastionHostKey;
            this.bastionPassword = builder.bastionPassword;
            this.bastionPort = builder.bastionPort;
            this.bastionPrivateKey = builder.bastionPrivateKey;
            this.bastionUser = builder.bastionUser;
            this.certificate = builder.certificate;
            this.hostKey = builder.hostKey;
            this.password = builder.password;
            this.port = builder.port;
            this.privateKey = builder.privateKey;
            this.proxyHost = builder.proxyHost;
            this.proxyPort = builder.proxyPort;
            this.proxyScheme = builder.proxyScheme;
            this.proxyUserName = builder.proxyUserName;
            this.proxyUserPassword = builder.proxyUserPassword;
            this.scriptPath = builder.scriptPath;
            this.targetPlatform = builder.targetPlatform;
            this.timeout = builder.timeout;
            this.user = builder.user;
        }

        @Override
        public final java.lang.String getHost() {
            return this.host;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getAgent() {
            return this.agent;
        }

        @Override
        public final java.lang.String getAgentIdentity() {
            return this.agentIdentity;
        }

        @Override
        public final java.lang.String getBastionCertificate() {
            return this.bastionCertificate;
        }

        @Override
        public final java.lang.String getBastionHost() {
            return this.bastionHost;
        }

        @Override
        public final java.lang.String getBastionHostKey() {
            return this.bastionHostKey;
        }

        @Override
        public final java.lang.String getBastionPassword() {
            return this.bastionPassword;
        }

        @Override
        public final java.lang.Number getBastionPort() {
            return this.bastionPort;
        }

        @Override
        public final java.lang.String getBastionPrivateKey() {
            return this.bastionPrivateKey;
        }

        @Override
        public final java.lang.String getBastionUser() {
            return this.bastionUser;
        }

        @Override
        public final java.lang.String getCertificate() {
            return this.certificate;
        }

        @Override
        public final java.lang.String getHostKey() {
            return this.hostKey;
        }

        @Override
        public final java.lang.String getPassword() {
            return this.password;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getPrivateKey() {
            return this.privateKey;
        }

        @Override
        public final java.lang.String getProxyHost() {
            return this.proxyHost;
        }

        @Override
        public final java.lang.Number getProxyPort() {
            return this.proxyPort;
        }

        @Override
        public final java.lang.String getProxyScheme() {
            return this.proxyScheme;
        }

        @Override
        public final java.lang.String getProxyUserName() {
            return this.proxyUserName;
        }

        @Override
        public final java.lang.String getProxyUserPassword() {
            return this.proxyUserPassword;
        }

        @Override
        public final java.lang.String getScriptPath() {
            return this.scriptPath;
        }

        @Override
        public final java.lang.String getTargetPlatform() {
            return this.targetPlatform;
        }

        @Override
        public final java.lang.String getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.lang.String getUser() {
            return this.user;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("host", om.valueToTree(this.getHost()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getAgent() != null) {
                data.set("agent", om.valueToTree(this.getAgent()));
            }
            if (this.getAgentIdentity() != null) {
                data.set("agentIdentity", om.valueToTree(this.getAgentIdentity()));
            }
            if (this.getBastionCertificate() != null) {
                data.set("bastionCertificate", om.valueToTree(this.getBastionCertificate()));
            }
            if (this.getBastionHost() != null) {
                data.set("bastionHost", om.valueToTree(this.getBastionHost()));
            }
            if (this.getBastionHostKey() != null) {
                data.set("bastionHostKey", om.valueToTree(this.getBastionHostKey()));
            }
            if (this.getBastionPassword() != null) {
                data.set("bastionPassword", om.valueToTree(this.getBastionPassword()));
            }
            if (this.getBastionPort() != null) {
                data.set("bastionPort", om.valueToTree(this.getBastionPort()));
            }
            if (this.getBastionPrivateKey() != null) {
                data.set("bastionPrivateKey", om.valueToTree(this.getBastionPrivateKey()));
            }
            if (this.getBastionUser() != null) {
                data.set("bastionUser", om.valueToTree(this.getBastionUser()));
            }
            if (this.getCertificate() != null) {
                data.set("certificate", om.valueToTree(this.getCertificate()));
            }
            if (this.getHostKey() != null) {
                data.set("hostKey", om.valueToTree(this.getHostKey()));
            }
            if (this.getPassword() != null) {
                data.set("password", om.valueToTree(this.getPassword()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getPrivateKey() != null) {
                data.set("privateKey", om.valueToTree(this.getPrivateKey()));
            }
            if (this.getProxyHost() != null) {
                data.set("proxyHost", om.valueToTree(this.getProxyHost()));
            }
            if (this.getProxyPort() != null) {
                data.set("proxyPort", om.valueToTree(this.getProxyPort()));
            }
            if (this.getProxyScheme() != null) {
                data.set("proxyScheme", om.valueToTree(this.getProxyScheme()));
            }
            if (this.getProxyUserName() != null) {
                data.set("proxyUserName", om.valueToTree(this.getProxyUserName()));
            }
            if (this.getProxyUserPassword() != null) {
                data.set("proxyUserPassword", om.valueToTree(this.getProxyUserPassword()));
            }
            if (this.getScriptPath() != null) {
                data.set("scriptPath", om.valueToTree(this.getScriptPath()));
            }
            if (this.getTargetPlatform() != null) {
                data.set("targetPlatform", om.valueToTree(this.getTargetPlatform()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getUser() != null) {
                data.set("user", om.valueToTree(this.getUser()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdktf.SSHProvisionerConnection"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SSHProvisionerConnection.Jsii$Proxy that = (SSHProvisionerConnection.Jsii$Proxy) o;

            if (!host.equals(that.host)) return false;
            if (!type.equals(that.type)) return false;
            if (this.agent != null ? !this.agent.equals(that.agent) : that.agent != null) return false;
            if (this.agentIdentity != null ? !this.agentIdentity.equals(that.agentIdentity) : that.agentIdentity != null) return false;
            if (this.bastionCertificate != null ? !this.bastionCertificate.equals(that.bastionCertificate) : that.bastionCertificate != null) return false;
            if (this.bastionHost != null ? !this.bastionHost.equals(that.bastionHost) : that.bastionHost != null) return false;
            if (this.bastionHostKey != null ? !this.bastionHostKey.equals(that.bastionHostKey) : that.bastionHostKey != null) return false;
            if (this.bastionPassword != null ? !this.bastionPassword.equals(that.bastionPassword) : that.bastionPassword != null) return false;
            if (this.bastionPort != null ? !this.bastionPort.equals(that.bastionPort) : that.bastionPort != null) return false;
            if (this.bastionPrivateKey != null ? !this.bastionPrivateKey.equals(that.bastionPrivateKey) : that.bastionPrivateKey != null) return false;
            if (this.bastionUser != null ? !this.bastionUser.equals(that.bastionUser) : that.bastionUser != null) return false;
            if (this.certificate != null ? !this.certificate.equals(that.certificate) : that.certificate != null) return false;
            if (this.hostKey != null ? !this.hostKey.equals(that.hostKey) : that.hostKey != null) return false;
            if (this.password != null ? !this.password.equals(that.password) : that.password != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.privateKey != null ? !this.privateKey.equals(that.privateKey) : that.privateKey != null) return false;
            if (this.proxyHost != null ? !this.proxyHost.equals(that.proxyHost) : that.proxyHost != null) return false;
            if (this.proxyPort != null ? !this.proxyPort.equals(that.proxyPort) : that.proxyPort != null) return false;
            if (this.proxyScheme != null ? !this.proxyScheme.equals(that.proxyScheme) : that.proxyScheme != null) return false;
            if (this.proxyUserName != null ? !this.proxyUserName.equals(that.proxyUserName) : that.proxyUserName != null) return false;
            if (this.proxyUserPassword != null ? !this.proxyUserPassword.equals(that.proxyUserPassword) : that.proxyUserPassword != null) return false;
            if (this.scriptPath != null ? !this.scriptPath.equals(that.scriptPath) : that.scriptPath != null) return false;
            if (this.targetPlatform != null ? !this.targetPlatform.equals(that.targetPlatform) : that.targetPlatform != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            return this.user != null ? this.user.equals(that.user) : that.user == null;
        }

        @Override
        public final int hashCode() {
            int result = this.host.hashCode();
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.agent != null ? this.agent.hashCode() : 0);
            result = 31 * result + (this.agentIdentity != null ? this.agentIdentity.hashCode() : 0);
            result = 31 * result + (this.bastionCertificate != null ? this.bastionCertificate.hashCode() : 0);
            result = 31 * result + (this.bastionHost != null ? this.bastionHost.hashCode() : 0);
            result = 31 * result + (this.bastionHostKey != null ? this.bastionHostKey.hashCode() : 0);
            result = 31 * result + (this.bastionPassword != null ? this.bastionPassword.hashCode() : 0);
            result = 31 * result + (this.bastionPort != null ? this.bastionPort.hashCode() : 0);
            result = 31 * result + (this.bastionPrivateKey != null ? this.bastionPrivateKey.hashCode() : 0);
            result = 31 * result + (this.bastionUser != null ? this.bastionUser.hashCode() : 0);
            result = 31 * result + (this.certificate != null ? this.certificate.hashCode() : 0);
            result = 31 * result + (this.hostKey != null ? this.hostKey.hashCode() : 0);
            result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.privateKey != null ? this.privateKey.hashCode() : 0);
            result = 31 * result + (this.proxyHost != null ? this.proxyHost.hashCode() : 0);
            result = 31 * result + (this.proxyPort != null ? this.proxyPort.hashCode() : 0);
            result = 31 * result + (this.proxyScheme != null ? this.proxyScheme.hashCode() : 0);
            result = 31 * result + (this.proxyUserName != null ? this.proxyUserName.hashCode() : 0);
            result = 31 * result + (this.proxyUserPassword != null ? this.proxyUserPassword.hashCode() : 0);
            result = 31 * result + (this.scriptPath != null ? this.scriptPath.hashCode() : 0);
            result = 31 * result + (this.targetPlatform != null ? this.targetPlatform.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
            return result;
        }
    }
}
