package com.hashicorp.cdktf;

/**
 * (experimental) Most provisioners require access to the remote resource via SSH or WinRM and expect a nested connection block with details about how to connect.
 * <p>
 * See {@link https://developer.hashicorp.com/terraform/language/resources/provisioners/connection connection}
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.93.0 (build 1706ca5)", date = "2024-01-15T15:38:01.196Z")
@software.amazon.jsii.Jsii(module = com.hashicorp.cdktf.$Module.class, fqn = "cdktf.WinrmProvisionerConnection")
@software.amazon.jsii.Jsii.Proxy(WinrmProvisionerConnection.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface WinrmProvisionerConnection extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The address of the resource to connect to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getHost();

    /**
     * (experimental) The connection type.
     * <p>
     * Valid values are "ssh" and "winrm".
     * Provisioners typically assume that the remote system runs Microsoft Windows when using WinRM.
     * Behaviors based on the SSH target_platform will force Windows-specific behavior for WinRM, unless otherwise specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * (experimental) The CA certificate to validate against.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getCacert() {
        return null;
    }

    /**
     * (experimental) Set to true to connect using HTTPS instead of HTTP.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getHttps() {
        return null;
    }

    /**
     * (experimental) Set to true to skip validating the HTTPS certificate chain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getInsecure() {
        return null;
    }

    /**
     * (experimental) The password to use for the connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
        return null;
    }

    /**
     * (experimental) The port to connect to.
     * <p>
     * Default: 22
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * (experimental) The path used to copy scripts meant for remote execution.
     * <p>
     * Refer to {@link https://developer.hashicorp.com/terraform/language/resources/provisioners/connection#how-provisioners-execute-remote-scripts How Provisioners Execute Remote Scripts below for more details}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getScriptPath() {
        return null;
    }

    /**
     * (experimental) The timeout to wait for the connection to become available.
     * <p>
     * Should be provided as a string (e.g., "30s" or "5m".)
     * <p>
     * Default: 5m
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getTimeout() {
        return null;
    }

    /**
     * (experimental) Set to true to use NTLM authentication rather than default (basic authentication), removing the requirement for basic authentication to be enabled within the target guest.
     * <p>
     * Refer to Authentication for Remote Connections in the Windows App Development documentation for more details.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUseNtlm() {
        return null;
    }

    /**
     * (experimental) The user to use for the connection.
     * <p>
     * Default: root
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getUser() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link WinrmProvisionerConnection}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WinrmProvisionerConnection}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<WinrmProvisionerConnection> {
        java.lang.String host;
        java.lang.String type;
        java.lang.String cacert;
        java.lang.Boolean https;
        java.lang.Boolean insecure;
        java.lang.String password;
        java.lang.Number port;
        java.lang.String scriptPath;
        java.lang.String timeout;
        java.lang.Boolean useNtlm;
        java.lang.String user;

        /**
         * Sets the value of {@link WinrmProvisionerConnection#getHost}
         * @param host The address of the resource to connect to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder host(java.lang.String host) {
            this.host = host;
            return this;
        }

        /**
         * Sets the value of {@link WinrmProvisionerConnection#getType}
         * @param type The connection type. This parameter is required.
         *             Valid values are "ssh" and "winrm".
         *             Provisioners typically assume that the remote system runs Microsoft Windows when using WinRM.
         *             Behaviors based on the SSH target_platform will force Windows-specific behavior for WinRM, unless otherwise specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link WinrmProvisionerConnection#getCacert}
         * @param cacert The CA certificate to validate against.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cacert(java.lang.String cacert) {
            this.cacert = cacert;
            return this;
        }

        /**
         * Sets the value of {@link WinrmProvisionerConnection#getHttps}
         * @param https Set to true to connect using HTTPS instead of HTTP.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder https(java.lang.Boolean https) {
            this.https = https;
            return this;
        }

        /**
         * Sets the value of {@link WinrmProvisionerConnection#getInsecure}
         * @param insecure Set to true to skip validating the HTTPS certificate chain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder insecure(java.lang.Boolean insecure) {
            this.insecure = insecure;
            return this;
        }

        /**
         * Sets the value of {@link WinrmProvisionerConnection#getPassword}
         * @param password The password to use for the connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder password(java.lang.String password) {
            this.password = password;
            return this;
        }

        /**
         * Sets the value of {@link WinrmProvisionerConnection#getPort}
         * @param port The port to connect to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link WinrmProvisionerConnection#getScriptPath}
         * @param scriptPath The path used to copy scripts meant for remote execution.
         *                   Refer to {@link https://developer.hashicorp.com/terraform/language/resources/provisioners/connection#how-provisioners-execute-remote-scripts How Provisioners Execute Remote Scripts below for more details}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder scriptPath(java.lang.String scriptPath) {
            this.scriptPath = scriptPath;
            return this;
        }

        /**
         * Sets the value of {@link WinrmProvisionerConnection#getTimeout}
         * @param timeout The timeout to wait for the connection to become available.
         *                Should be provided as a string (e.g., "30s" or "5m".)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder timeout(java.lang.String timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link WinrmProvisionerConnection#getUseNtlm}
         * @param useNtlm Set to true to use NTLM authentication rather than default (basic authentication), removing the requirement for basic authentication to be enabled within the target guest.
         *                Refer to Authentication for Remote Connections in the Windows App Development documentation for more details.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder useNtlm(java.lang.Boolean useNtlm) {
            this.useNtlm = useNtlm;
            return this;
        }

        /**
         * Sets the value of {@link WinrmProvisionerConnection#getUser}
         * @param user The user to use for the connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder user(java.lang.String user) {
            this.user = user;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WinrmProvisionerConnection}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public WinrmProvisionerConnection build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WinrmProvisionerConnection}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WinrmProvisionerConnection {
        private final java.lang.String host;
        private final java.lang.String type;
        private final java.lang.String cacert;
        private final java.lang.Boolean https;
        private final java.lang.Boolean insecure;
        private final java.lang.String password;
        private final java.lang.Number port;
        private final java.lang.String scriptPath;
        private final java.lang.String timeout;
        private final java.lang.Boolean useNtlm;
        private final java.lang.String user;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cacert = software.amazon.jsii.Kernel.get(this, "cacert", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.https = software.amazon.jsii.Kernel.get(this, "https", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.insecure = software.amazon.jsii.Kernel.get(this, "insecure", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.scriptPath = software.amazon.jsii.Kernel.get(this, "scriptPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.useNtlm = software.amazon.jsii.Kernel.get(this, "useNtlm", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.host = java.util.Objects.requireNonNull(builder.host, "host is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.cacert = builder.cacert;
            this.https = builder.https;
            this.insecure = builder.insecure;
            this.password = builder.password;
            this.port = builder.port;
            this.scriptPath = builder.scriptPath;
            this.timeout = builder.timeout;
            this.useNtlm = builder.useNtlm;
            this.user = builder.user;
        }

        @Override
        public final java.lang.String getHost() {
            return this.host;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getCacert() {
            return this.cacert;
        }

        @Override
        public final java.lang.Boolean getHttps() {
            return this.https;
        }

        @Override
        public final java.lang.Boolean getInsecure() {
            return this.insecure;
        }

        @Override
        public final java.lang.String getPassword() {
            return this.password;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getScriptPath() {
            return this.scriptPath;
        }

        @Override
        public final java.lang.String getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.lang.Boolean getUseNtlm() {
            return this.useNtlm;
        }

        @Override
        public final java.lang.String getUser() {
            return this.user;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("host", om.valueToTree(this.getHost()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getCacert() != null) {
                data.set("cacert", om.valueToTree(this.getCacert()));
            }
            if (this.getHttps() != null) {
                data.set("https", om.valueToTree(this.getHttps()));
            }
            if (this.getInsecure() != null) {
                data.set("insecure", om.valueToTree(this.getInsecure()));
            }
            if (this.getPassword() != null) {
                data.set("password", om.valueToTree(this.getPassword()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getScriptPath() != null) {
                data.set("scriptPath", om.valueToTree(this.getScriptPath()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getUseNtlm() != null) {
                data.set("useNtlm", om.valueToTree(this.getUseNtlm()));
            }
            if (this.getUser() != null) {
                data.set("user", om.valueToTree(this.getUser()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdktf.WinrmProvisionerConnection"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WinrmProvisionerConnection.Jsii$Proxy that = (WinrmProvisionerConnection.Jsii$Proxy) o;

            if (!host.equals(that.host)) return false;
            if (!type.equals(that.type)) return false;
            if (this.cacert != null ? !this.cacert.equals(that.cacert) : that.cacert != null) return false;
            if (this.https != null ? !this.https.equals(that.https) : that.https != null) return false;
            if (this.insecure != null ? !this.insecure.equals(that.insecure) : that.insecure != null) return false;
            if (this.password != null ? !this.password.equals(that.password) : that.password != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.scriptPath != null ? !this.scriptPath.equals(that.scriptPath) : that.scriptPath != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.useNtlm != null ? !this.useNtlm.equals(that.useNtlm) : that.useNtlm != null) return false;
            return this.user != null ? this.user.equals(that.user) : that.user == null;
        }

        @Override
        public final int hashCode() {
            int result = this.host.hashCode();
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.cacert != null ? this.cacert.hashCode() : 0);
            result = 31 * result + (this.https != null ? this.https.hashCode() : 0);
            result = 31 * result + (this.insecure != null ? this.insecure.hashCode() : 0);
            result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.scriptPath != null ? this.scriptPath.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.useNtlm != null ? this.useNtlm.hashCode() : 0);
            result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
            return result;
        }
    }
}
