/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClusterClientException;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.GroupProperties;
import com.hazelcast.util.ByteUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Packet {
    private byte[] headerInBytes;
    private byte[] key;
    private byte[] value;
    private String name;
    private ClusterOperation operation;
    private int blockId = 0;
    private int threadId;
    private int lockCount = 0;
    private long ttl = -1L;
    private long timeout = -1L;
    private long txnId = -1L;
    private long longValue;
    private long version = -1L;
    private byte responseType = (byte)2;
    private long callId = -1L;
    private byte indexCount = 0;
    private long[] indexes = new long[10];
    private byte[] indexTypes = new byte[10];
    private static final byte PACKET_VERSION = GroupProperties.PACKET_VERSION.getByte();
    private final ByteBuffer readHeaderBuffer = ByteBuffer.allocate(1024);
    private final ByteBuffer writeHeaderBuffer = ByteBuffer.allocate(1024);

    public void writeTo(DataOutputStream outputStream) throws IOException {
        ByteBuffer header = this.getHeader();
        int headerSize = header.position();
        outputStream.writeInt(headerSize);
        outputStream.writeInt(this.key == null ? 0 : this.key.length);
        outputStream.writeInt(this.value == null ? 0 : this.value.length);
        outputStream.writeByte(PACKET_VERSION);
        outputStream.write(header.array(), 0, headerSize);
        if (this.key != null) {
            outputStream.write(this.key);
        }
        if (this.value != null) {
            outputStream.write(this.value);
        }
    }

    public void readFrom(DataInputStream dis) throws IOException {
        int headerSize = dis.readInt();
        int keySize = dis.readInt();
        int valueSize = dis.readInt();
        byte packetVersion = dis.readByte();
        if (packetVersion != PACKET_VERSION) {
            throw new ClusterClientException("Invalid packet version. Expected:" + PACKET_VERSION + ", Found:" + packetVersion);
        }
        this.readHeaderBuffer.clear();
        this.readHeaderBuffer.limit(headerSize);
        dis.readFully(this.readHeaderBuffer.array(), 0, headerSize);
        this.operation = ClusterOperation.create(this.readHeaderBuffer.get());
        this.blockId = this.readHeaderBuffer.getInt();
        this.threadId = this.readHeaderBuffer.getInt();
        byte booleans = this.readHeaderBuffer.get();
        if (ByteUtil.isTrue(booleans, 0)) {
            this.lockCount = this.readHeaderBuffer.getInt();
        }
        if (ByteUtil.isTrue(booleans, 1)) {
            this.timeout = this.readHeaderBuffer.getLong();
        }
        if (ByteUtil.isTrue(booleans, 2)) {
            this.ttl = this.readHeaderBuffer.getLong();
        }
        if (ByteUtil.isTrue(booleans, 3)) {
            this.txnId = this.readHeaderBuffer.getLong();
        }
        if (ByteUtil.isTrue(booleans, 4)) {
            this.longValue = this.readHeaderBuffer.getLong();
        }
        if (ByteUtil.isTrue(booleans, 5)) {
            this.version = this.readHeaderBuffer.getLong();
        }
        if (!ByteUtil.isTrue(booleans, 7)) {
            throw new ClusterClientException("LockAddress cannot be sent to the client!" + (Object)((Object)this.operation));
        }
        this.callId = this.readHeaderBuffer.getLong();
        this.responseType = this.readHeaderBuffer.get();
        int nameLength = this.readHeaderBuffer.getInt();
        if (nameLength > 0) {
            byte[] b = new byte[nameLength];
            this.readHeaderBuffer.get(b);
            this.name = new String(b);
        }
        this.indexCount = this.readHeaderBuffer.get();
        for (int i = 0; i < this.indexCount; ++i) {
            this.indexes[i] = this.readHeaderBuffer.getLong();
            this.indexTypes[i] = this.readHeaderBuffer.get();
        }
        this.key = new byte[keySize];
        dis.readFully(this.key);
        this.value = new byte[valueSize];
        dis.readFully(this.value);
    }

    private ByteBuffer getHeader() throws IOException {
        this.writeHeaderBuffer.clear();
        this.writeHeaderBuffer.put(this.operation.getValue());
        this.writeHeaderBuffer.putInt(this.blockId);
        this.writeHeaderBuffer.putInt(this.threadId);
        byte booleans = 0;
        if (this.lockCount != 0) {
            booleans = ByteUtil.setTrue(booleans, 0);
        }
        if (this.timeout != -1L) {
            booleans = ByteUtil.setTrue(booleans, 1);
        }
        if (this.ttl != -1L) {
            booleans = ByteUtil.setTrue(booleans, 2);
        }
        if (this.txnId != -1L) {
            booleans = ByteUtil.setTrue(booleans, 3);
        }
        if (this.longValue != Long.MIN_VALUE) {
            booleans = ByteUtil.setTrue(booleans, 4);
        }
        if (this.version != -1L) {
            booleans = ByteUtil.setTrue(booleans, 5);
        }
        booleans = ByteUtil.setTrue(booleans, 6);
        booleans = ByteUtil.setTrue(booleans, 7);
        this.writeHeaderBuffer.put(booleans);
        if (this.lockCount != 0) {
            this.writeHeaderBuffer.putInt(this.lockCount);
        }
        if (this.timeout != -1L) {
            this.writeHeaderBuffer.putLong(this.timeout);
        }
        if (this.ttl != -1L) {
            this.writeHeaderBuffer.putLong(this.ttl);
        }
        if (this.txnId != -1L) {
            this.writeHeaderBuffer.putLong(this.txnId);
        }
        if (this.longValue != Long.MIN_VALUE) {
            this.writeHeaderBuffer.putLong(this.longValue);
        }
        if (this.version != -1L) {
            this.writeHeaderBuffer.putLong(this.version);
        }
        this.writeHeaderBuffer.putLong(this.callId);
        this.writeHeaderBuffer.put(this.responseType);
        int nameLen = 0;
        byte[] nameInBytes = null;
        if (this.name != null) {
            nameInBytes = this.name.getBytes();
            nameLen = nameInBytes.length;
        }
        this.writeHeaderBuffer.putInt(nameLen);
        if (nameLen > 0) {
            this.writeHeaderBuffer.put(nameInBytes);
        }
        this.writeHeaderBuffer.put(this.indexCount);
        for (int i = 0; i < this.indexCount; ++i) {
            this.writeHeaderBuffer.putLong(this.indexes[i]);
            this.writeHeaderBuffer.put(this.indexTypes[i]);
        }
        return this.writeHeaderBuffer;
    }

    public void set(String name, ClusterOperation operation, byte[] key, byte[] value) {
        this.name = name;
        this.operation = operation;
        this.setKey(key);
        this.setValue(value);
    }

    public byte[] getKey() {
        return this.key;
    }

    public void setKey(byte[] key) {
        this.key = key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public void setCallId(long callid) {
        this.callId = callid;
    }

    public long getCallId() {
        return this.callId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ClusterOperation getOperation() {
        return this.operation;
    }

    public void setOperation(ClusterOperation operation) {
        this.operation = operation;
    }

    public int getBlockId() {
        return this.blockId;
    }

    public void setBlockId(int blockId) {
        this.blockId = blockId;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public void setThreadId(int threadId) {
        this.threadId = threadId;
    }

    public int getLockCount() {
        return this.lockCount;
    }

    public void setLockCount(int lockCount) {
        this.lockCount = lockCount;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTxnId() {
        return this.txnId;
    }

    public void setTxnId(long txnId) {
        this.txnId = txnId;
    }

    public long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(long longValue) {
        this.longValue = longValue;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public byte getResponseType() {
        return this.responseType;
    }

    public void setResponseType(byte responseType) {
        this.responseType = responseType;
    }

    public byte getIndexCount() {
        return this.indexCount;
    }

    public void setIndexCount(byte indexCount) {
        this.indexCount = indexCount;
    }

    public long[] getIndexes() {
        return this.indexes;
    }

    public void setIndexes(long[] indexes) {
        this.indexes = indexes;
    }

    public byte[] getIndexTypes() {
        return this.indexTypes;
    }

    public void setIndexTypes(byte[] indexTypes) {
        this.indexTypes = indexTypes;
    }

    public String toString() {
        return "Packet [callId = " + this.callId + "  name = " + this.name + " operation = " + (Object)((Object)this.operation) + "]";
    }
}

