/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.util.ByteUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MapConfig
implements DataSerializable {
    public static final int MIN_BACKUP_COUNT = 0;
    public static final int DEFAULT_BACKUP_COUNT = 1;
    public static final int MAX_BACKUP_COUNT = 3;
    public static final int MIN_EVICTION_PERCENTAGE = 0;
    public static final int DEFAULT_EVICTION_PERCENTAGE = 25;
    public static final int MAX_EVICTION_PERCENTAGE = 100;
    public static final int DEFAULT_EVICTION_DELAY_SECONDS = 3;
    public static final int DEFAULT_TTL_SECONDS = 0;
    public static final int DEFAULT_MAX_IDLE_SECONDS = 0;
    public static final int DEFAULT_MAX_SIZE = Integer.MAX_VALUE;
    public static final String DEFAULT_EVICTION_POLICY = "NONE";
    public static final String DEFAULT_MERGE_POLICY = "hz.LATEST_UPDATE";
    private String name = null;
    private int backupCount = 1;
    private int evictionPercentage = 25;
    private int timeToLiveSeconds = 0;
    private int maxIdleSeconds = 0;
    private int evictionDelaySeconds = 3;
    private int maxSize = Integer.MAX_VALUE;
    private String evictionPolicy = "NONE";
    private boolean valueIndexed = false;
    private MapStoreConfig mapStoreConfig = null;
    private NearCacheConfig nearCacheConfig = null;
    private boolean useBackupData = false;
    private String mergePolicy = "hz.LATEST_UPDATE";

    public MapConfig(String name) {
        this.name = name;
    }

    public MapConfig() {
    }

    public String getName() {
        return this.name;
    }

    public MapConfig setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isValueIndexed() {
        return this.valueIndexed;
    }

    public void setValueIndexed(boolean valueIndexed) {
        this.valueIndexed = valueIndexed;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public MapConfig setBackupCount(int backupCount) {
        if (backupCount < 0 || backupCount > 3) {
            throw new IllegalArgumentException("map backup count must be 0, 1, 2 or 3");
        }
        this.backupCount = backupCount;
        return this;
    }

    public int getEvictionPercentage() {
        return this.evictionPercentage;
    }

    public MapConfig setEvictionPercentage(int evictionPercentage) {
        if (evictionPercentage < 0) {
            throw new IllegalArgumentException("eviction percentage must be greater or equal than 0");
        }
        if (evictionPercentage > 100) {
            throw new IllegalArgumentException("eviction percentage must be smaller or equal than 100");
        }
        this.evictionPercentage = evictionPercentage;
        return this;
    }

    public int getEvictionDelaySeconds() {
        return this.evictionDelaySeconds;
    }

    public MapConfig setEvictionDelaySeconds(int evictionDelaySeconds) {
        this.evictionDelaySeconds = evictionDelaySeconds;
        return this;
    }

    public int getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public MapConfig setTimeToLiveSeconds(int timeToLiveSeconds) {
        this.timeToLiveSeconds = timeToLiveSeconds;
        return this;
    }

    public int getMaxIdleSeconds() {
        return this.maxIdleSeconds;
    }

    public MapConfig setMaxIdleSeconds(int maxIdleSeconds) {
        this.maxIdleSeconds = maxIdleSeconds;
        return this;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public MapConfig setMaxSize(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("map max size must be greater than 0");
        }
        this.maxSize = maxSize;
        return this;
    }

    public String getEvictionPolicy() {
        return this.evictionPolicy;
    }

    public MapConfig setEvictionPolicy(String evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    public MapStoreConfig getMapStoreConfig() {
        return this.mapStoreConfig;
    }

    public MapConfig setMapStoreConfig(MapStoreConfig mapStoreConfig) {
        this.mapStoreConfig = mapStoreConfig;
        return this;
    }

    public NearCacheConfig getNearCacheConfig() {
        return this.nearCacheConfig;
    }

    public MapConfig setNearCacheConfig(NearCacheConfig nearCacheConfig) {
        this.nearCacheConfig = nearCacheConfig;
        return this;
    }

    public String getMergePolicy() {
        return this.mergePolicy;
    }

    public MapConfig setMergePolicy(String mergePolicyName) {
        this.mergePolicy = mergePolicyName;
        return this;
    }

    public boolean isUseBackupData() {
        return this.useBackupData;
    }

    public MapConfig setUseBackupData(boolean useBackupData) {
        this.useBackupData = useBackupData;
        return this;
    }

    public boolean isCompatible(MapConfig other) {
        if (this == other) {
            return true;
        }
        return other != null && (this.name != null ? this.name.equals(other.name) : other.name == null) && this.backupCount == other.backupCount && this.evictionDelaySeconds == other.evictionDelaySeconds && this.evictionPercentage == other.evictionPercentage && this.maxIdleSeconds == other.maxIdleSeconds && (this.maxSize == other.maxSize || Math.min(this.maxSize, other.maxSize) == 0 && Math.max(this.maxSize, other.maxSize) == Integer.MAX_VALUE) && this.timeToLiveSeconds == other.timeToLiveSeconds && this.useBackupData == other.useBackupData && this.valueIndexed == other.valueIndexed;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.backupCount;
        result = 31 * result + this.evictionDelaySeconds;
        result = 31 * result + this.evictionPercentage;
        result = 31 * result + (this.evictionPolicy == null ? 0 : this.evictionPolicy.hashCode());
        result = 31 * result + (this.mapStoreConfig == null ? 0 : this.mapStoreConfig.hashCode());
        result = 31 * result + this.maxIdleSeconds;
        result = 31 * result + this.maxSize;
        result = 31 * result + (this.mergePolicy == null ? 0 : this.mergePolicy.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nearCacheConfig == null ? 0 : this.nearCacheConfig.hashCode());
        result = 31 * result + this.timeToLiveSeconds;
        result = 31 * result + (this.useBackupData ? 1231 : 1237);
        result = 31 * result + (this.valueIndexed ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MapConfig)) {
            return false;
        }
        MapConfig other = (MapConfig)obj;
        return (this.name != null ? this.name.equals(other.name) : other.name == null) && this.backupCount == other.backupCount && this.evictionDelaySeconds == other.evictionDelaySeconds && this.evictionPercentage == other.evictionPercentage && this.maxIdleSeconds == other.maxIdleSeconds && this.maxSize == other.maxSize && this.timeToLiveSeconds == other.timeToLiveSeconds && this.useBackupData == other.useBackupData && this.valueIndexed == other.valueIndexed && (this.mergePolicy != null ? this.mergePolicy.equals(other.mergePolicy) : other.mergePolicy == null) && (this.evictionPolicy != null ? this.evictionPolicy.equals(other.evictionPolicy) : other.evictionPolicy == null) && (this.mapStoreConfig != null ? this.mapStoreConfig.equals(other.mapStoreConfig) : other.mapStoreConfig == null) && (this.nearCacheConfig != null ? this.nearCacheConfig.equals(other.nearCacheConfig) : other.nearCacheConfig == null);
    }

    public String toString() {
        return "MapConfig{name='" + this.name + '\'' + ", backupCount=" + this.backupCount + ", mergePolicy=" + this.mergePolicy + ", evictionPercentage=" + this.evictionPercentage + ", timeToLiveSeconds=" + this.timeToLiveSeconds + ", maxIdleSeconds=" + this.maxIdleSeconds + ", evictionDelaySeconds=" + this.evictionDelaySeconds + ", maxSize=" + this.maxSize + ", evictionPolicy='" + this.evictionPolicy + '\'' + ", mapStoreConfig=" + this.mapStoreConfig + ", nearCacheConfig=" + this.nearCacheConfig + ", useBackupData=" + this.useBackupData + '}';
    }

    public void readData(DataInput in) throws IOException {
        this.name = in.readUTF();
        this.backupCount = in.readInt();
        this.evictionPercentage = in.readInt();
        this.timeToLiveSeconds = in.readInt();
        this.maxIdleSeconds = in.readInt();
        this.evictionDelaySeconds = in.readInt();
        this.maxSize = in.readInt();
        boolean[] b = ByteUtil.fromByte(in.readByte());
        this.valueIndexed = b[0];
        this.useBackupData = b[1];
        this.evictionPolicy = in.readUTF();
        this.mergePolicy = in.readUTF();
    }

    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeInt(this.backupCount);
        out.writeInt(this.evictionPercentage);
        out.writeInt(this.timeToLiveSeconds);
        out.writeInt(this.maxIdleSeconds);
        out.writeInt(this.evictionDelaySeconds);
        out.writeInt(this.maxSize);
        out.writeByte(ByteUtil.toByte(this.valueIndexed, this.useBackupData));
        out.writeUTF(this.evictionPolicy);
        out.writeUTF(this.mergePolicy);
    }
}

