/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.nio.Address;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.util.AddressUtil;
import com.hazelcast.util.ByteUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpIpConfig
implements DataSerializable {
    private int connectionTimeoutSeconds = 5;
    private boolean enabled = false;
    private List<String> members = new ArrayList<String>();
    private String requiredMember = null;
    private final List<Address> addresses = new ArrayList<Address>();

    public TcpIpConfig addMember(String member) {
        this.members.addAll(AddressUtil.handleMember(member));
        return this;
    }

    public TcpIpConfig clear() {
        this.members.clear();
        this.addresses.clear();
        return this;
    }

    public TcpIpConfig addAddress(Address address) {
        this.addresses.add(address);
        return this;
    }

    public List<Address> getAddresses() {
        return this.addresses;
    }

    public int getConnectionTimeoutSeconds() {
        return this.connectionTimeoutSeconds;
    }

    public TcpIpConfig setConnectionTimeoutSeconds(int connectionTimeoutSeconds) {
        this.connectionTimeoutSeconds = connectionTimeoutSeconds;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public TcpIpConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public List<String> getMembers() {
        return this.members;
    }

    public TcpIpConfig setMembers(List<String> members) {
        this.members.clear();
        this.members.addAll(AddressUtil.handleMembers(members));
        return this;
    }

    public String getRequiredMember() {
        return this.requiredMember;
    }

    public TcpIpConfig setRequiredMember(String requiredMember) {
        this.requiredMember = requiredMember;
        return this;
    }

    public String toString() {
        return "TcpIpConfig [enabled=" + this.enabled + ", connectionTimeoutSeconds=" + this.connectionTimeoutSeconds + ", members=" + this.members + ", requiredMember=" + this.requiredMember + ", addresses=" + this.addresses + "]";
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        boolean hasMembers = this.members != null && !this.members.isEmpty();
        boolean hasAddresses = this.addresses != null && !this.addresses.isEmpty();
        boolean hasRequiredMember = this.requiredMember != null;
        out.writeByte(ByteUtil.toByte(this.enabled, hasRequiredMember, hasMembers, hasAddresses));
        out.writeInt(this.connectionTimeoutSeconds);
        if (hasRequiredMember) {
            out.writeUTF(this.requiredMember);
        }
        if (hasMembers) {
            out.writeInt(this.members.size());
            for (String member : this.members) {
                out.writeUTF(member);
            }
        }
        if (hasAddresses) {
            out.writeInt(this.addresses.size());
            for (Address address : this.addresses) {
                address.writeData(out);
            }
        }
    }

    @Override
    public void readData(DataInput in) throws IOException {
        int i;
        int size;
        boolean[] b = ByteUtil.fromByte(in.readByte());
        this.enabled = b[0];
        boolean hasRequiredMember = b[1];
        boolean hasMembers = b[2];
        boolean hasAddresses = b[3];
        this.connectionTimeoutSeconds = in.readInt();
        if (hasRequiredMember) {
            this.requiredMember = in.readUTF();
        }
        if (hasMembers) {
            size = in.readInt();
            this.members = new ArrayList<String>(size);
            for (i = 0; i < size; ++i) {
                this.members.add(in.readUTF());
            }
        }
        if (hasAddresses) {
            size = in.readInt();
            this.addresses.clear();
            for (i = 0; i < size; ++i) {
                Address address = new Address();
                address.readData(in);
                this.addresses.add(address);
            }
        }
    }
}

