/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.MapEntry;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.RecordEntry;
import com.hazelcast.impl.VersionedBackupOp;
import com.hazelcast.impl.base.DistributedLock;
import com.hazelcast.impl.base.ScheduledAction;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Data;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Record
implements MapEntry {
    private final CMap cmap;
    private final Long id;
    private final short blockId;
    private final Data key;
    private volatile Data value;
    private volatile boolean active = true;
    private volatile int hits = 0;
    private volatile long version = 0L;
    private volatile long maxIdleMillis = Long.MAX_VALUE;
    private volatile long writeTime = -1L;
    private volatile long removeTime = 0L;
    private volatile long lastAccessTime = 0L;
    private volatile long creationTime = 0L;
    private volatile long expirationTime = Long.MAX_VALUE;
    private volatile long lastUpdateTime = 0L;
    private volatile boolean dirty = false;
    private volatile int copyCount = 0;
    private DistributedLock lock = null;
    private OptionalInfo optionalInfo = null;

    public Record(CMap cmap, int blockId, Data key, Data value, long ttl, long maxIdleMillis, Long id) {
        this.id = id;
        this.cmap = cmap;
        this.blockId = (short)blockId;
        this.key = key;
        this.value = value;
        this.setCreationTime(System.currentTimeMillis());
        this.setExpirationTime(ttl);
        this.maxIdleMillis = maxIdleMillis == 0L ? Long.MAX_VALUE : maxIdleMillis;
        this.setVersion(0L);
    }

    public Record copy() {
        Record recordCopy = new Record(this.cmap, this.blockId, this.key, this.value, this.getRemainingTTL(), this.getRemainingIdle(), this.id);
        recordCopy.setIndexes(this.getOptionalInfo().indexes, this.getOptionalInfo().indexTypes);
        if (this.lock != null) {
            recordCopy.setLock(new DistributedLock(this.lock));
        }
        recordCopy.setMultiValues(this.getOptionalInfo().lsMultiValues);
        recordCopy.setCopyCount(this.copyCount);
        recordCopy.setVersion(this.getVersion());
        return recordCopy;
    }

    public RecordEntry getRecordEntry() {
        return this.cmap.getRecordEntry(this);
    }

    public CMap getCMap() {
        return this.cmap;
    }

    public void runBackupOps() {
        if (this.getBackupOps() != null && this.getBackupOps().size() > 0) {
            Iterator it = this.getBackupOps().iterator();
            while (it.hasNext()) {
                VersionedBackupOp bo = (VersionedBackupOp)it.next();
                if (bo.getVersion() < this.getVersion() + 1L) {
                    it.remove();
                    continue;
                }
                if (bo.getVersion() == this.getVersion() + 1L) {
                    bo.run();
                    this.setVersion(bo.getVersion());
                    it.remove();
                    continue;
                }
                return;
            }
        }
    }

    public void addBackupOp(VersionedBackupOp bo) {
        if (this.getBackupOps() == null) {
            this.setBackupOps(new TreeSet<VersionedBackupOp>());
        }
        this.getBackupOps().add(bo);
        if (this.getBackupOps().size() > 4) {
            this.forceBackupOps();
        }
    }

    public void forceBackupOps() {
        if (this.getBackupOps() == null) {
            return;
        }
        Iterator it = this.getBackupOps().iterator();
        while (it.hasNext()) {
            VersionedBackupOp v = (VersionedBackupOp)it.next();
            v.run();
            this.setVersion(v.getVersion());
            it.remove();
        }
    }

    @Override
    public Data getKey() {
        return this.key;
    }

    @Override
    public Data getValue() {
        return this.value;
    }

    @Override
    public Object setValue(Object value) {
        return this.getRecordEntry().setValue(value);
    }

    @Override
    public void setValue(Data value) {
        this.cmap.invalidateRecordEntryValue(this);
        this.value = value;
    }

    public Long[] getIndexes() {
        if (this.optionalInfo == null) {
            return null;
        }
        return this.getOptionalInfo().indexes;
    }

    public byte[] getIndexTypes() {
        if (this.optionalInfo == null) {
            return null;
        }
        return this.getOptionalInfo().indexTypes;
    }

    public void setIndexes(Long[] indexes, byte[] indexTypes) {
        if (indexes != null) {
            OptionalInfo.access$002(this.getOptionalInfo(), indexes);
            OptionalInfo.access$102(this.getOptionalInfo(), indexTypes);
        }
    }

    public int valueCount() {
        int count = 0;
        if (this.getValue() != null) {
            count = 1;
        } else if (this.getMultiValues() != null) {
            count = this.getMultiValues().size();
        } else if (this.copyCount > 0) {
            count += this.copyCount;
        }
        return count;
    }

    @Override
    public long getCost() {
        long cost = 0L;
        if (this.getValue() != null) {
            cost = this.getValue().size();
            if (this.copyCount > 0) {
                cost *= (long)this.copyCount;
            }
        } else if (this.getMultiValues() != null && this.getMultiValues().size() > 0) {
            for (Data data : this.getMultiValues()) {
                if (data == null) continue;
                cost += (long)data.size();
            }
        }
        return cost + (long)this.getKey().size() + 250L;
    }

    public boolean containsValue(Data value) {
        int count;
        if (this.getValue() != null) {
            return this.getValue().equals(value);
        }
        if (this.getMultiValues() != null && (count = this.getMultiValues().size()) > 0) {
            return this.getMultiValues().contains(value);
        }
        return false;
    }

    public void addValue(Data value) {
        if (this.getMultiValues() == null) {
            this.setMultiValues(new HashSet<Data>(2));
        }
        this.getMultiValues().add(value);
    }

    public boolean unlock(int threadId, Address address) {
        return this.lock == null || this.lock.unlock(address, threadId);
    }

    public boolean testLock(int threadId, Address address) {
        return this.lock == null || this.lock.testLock(threadId, address);
    }

    public boolean lock(int threadId, Address address) {
        if (this.lock == null) {
            this.lock = new DistributedLock(address, threadId);
            return true;
        }
        return this.lock.lock(address, threadId);
    }

    public void addScheduledAction(ScheduledAction scheduledAction) {
        if (this.getScheduledActions() == null) {
            this.setScheduledActions(new LinkedList<ScheduledAction>());
        }
        this.getScheduledActions().add(scheduledAction);
    }

    public boolean isRemovable() {
        return !this.isActive() && this.valueCount() <= 0 && !this.hasListener() && this.getScheduledActionCount() == 0 && this.getBackupOpCount() == 0;
    }

    public boolean isEvictable() {
        return this.getLockCount() == 0 && !this.hasListener() && this.getScheduledActionCount() == 0;
    }

    public boolean hasListener() {
        return this.getListeners() != null && this.getListeners().size() > 0;
    }

    public void addListener(Address address, boolean returnValue) {
        if (this.getListeners() == null) {
            this.setMapListeners(new HashMap<Address, Boolean>(1));
        }
        this.getListeners().put(address, returnValue);
    }

    public void removeListener(Address address) {
        if (this.getListeners() == null) {
            return;
        }
        this.getListeners().remove(address);
    }

    public void incrementCopyCount() {
        ++this.copyCount;
    }

    public void decrementCopyCount() {
        --this.copyCount;
    }

    public int getCopyCount() {
        return this.copyCount;
    }

    public void setLastUpdated() {
        this.setLastUpdateTime(System.currentTimeMillis());
        if (this.expirationTime != Long.MAX_VALUE && this.expirationTime > 0L) {
            long ttl = this.expirationTime - this.getCreationTime();
            this.updateExpirationTime(ttl);
        }
    }

    public void setLastAccessed() {
        this.setLastAccessTime(System.currentTimeMillis());
        this.incrementHits();
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    public long getRemainingTTL() {
        if (this.expirationTime == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        long ttl = this.expirationTime - System.currentTimeMillis();
        return ttl < 0L ? 1L : ttl;
    }

    public long getRemainingIdle() {
        if (this.maxIdleMillis == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        long lastTouch = Math.max(this.lastAccessTime, this.creationTime);
        long idle = System.currentTimeMillis() - lastTouch;
        return this.maxIdleMillis - idle;
    }

    public void setMaxIdle(long idle) {
        this.maxIdleMillis = idle <= 0L || idle == Long.MAX_VALUE ? Long.MAX_VALUE : idle;
    }

    public void updateExpirationTime(long ttl) {
        this.expirationTime = ttl <= 0L || ttl == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + ttl;
    }

    public void setExpirationTime(long ttl) {
        this.expirationTime = ttl <= 0L || ttl == Long.MAX_VALUE ? Long.MAX_VALUE : this.getCreationTime() + ttl;
    }

    public void setInvalid() {
        this.expirationTime = System.currentTimeMillis() - 10L;
    }

    public boolean isValid(long now) {
        if (this.expirationTime == Long.MAX_VALUE && this.maxIdleMillis == Long.MAX_VALUE) {
            return true;
        }
        long lastTouch = Math.max(this.lastAccessTime, this.creationTime);
        long idle = now - lastTouch;
        return this.expirationTime > now && this.maxIdleMillis > idle;
    }

    @Override
    public boolean isValid() {
        return this.isValid(System.currentTimeMillis());
    }

    public void markRemoved() {
        this.setActive(false);
        this.setRemoveTime(System.currentTimeMillis());
    }

    public void setActive() {
        this.setRemoveTime(0L);
        this.setActive(true);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Record)) {
            return false;
        }
        Record record = (Record)o;
        return record.getId().equals(this.getId());
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Record key=" + this.getKey() + ", active=" + this.isActive() + ", version=" + this.getVersion() + ", removable=" + this.isRemovable();
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public void incrementVersion() {
        ++this.version;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long newValue) {
        this.creationTime = newValue;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Override
    public int getHits() {
        return this.hits;
    }

    public void incrementHits() {
        ++this.hits;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (!active) {
            this.cmap.removeRecordEntry(this);
        }
    }

    public String getName() {
        return this.cmap.name;
    }

    public int getBlockId() {
        return this.blockId;
    }

    public DistributedLock getLock() {
        return this.lock;
    }

    public void setLock(DistributedLock lock) {
        this.lock = lock;
    }

    public Set<Data> getMultiValues() {
        if (this.optionalInfo == null) {
            return null;
        }
        return this.getOptionalInfo().lsMultiValues;
    }

    public void setMultiValues(Set<Data> lsValues) {
        if (lsValues != null || this.optionalInfo != null) {
            this.getOptionalInfo().lsMultiValues = lsValues;
        }
    }

    public int getBackupOpCount() {
        return this.getOptionalInfo().backupOps == null ? 0 : this.getOptionalInfo().backupOps.size();
    }

    public SortedSet<VersionedBackupOp> getBackupOps() {
        return this.getOptionalInfo().backupOps;
    }

    public void setBackupOps(SortedSet<VersionedBackupOp> backupOps) {
        this.getOptionalInfo().backupOps = backupOps;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public long getWriteTime() {
        return this.writeTime;
    }

    public void setWriteTime(long writeTime) {
        this.writeTime = writeTime;
    }

    public long getRemoveTime() {
        return this.removeTime;
    }

    public void setRemoveTime(long removeTime) {
        this.removeTime = removeTime;
    }

    public Long getId() {
        return this.id;
    }

    public boolean hasScheduledAction() {
        return this.optionalInfo != null && this.optionalInfo.lsScheduledActions != null && this.optionalInfo.lsScheduledActions.size() > 0;
    }

    public List<ScheduledAction> getScheduledActions() {
        if (this.optionalInfo == null) {
            return null;
        }
        return this.getOptionalInfo().lsScheduledActions;
    }

    public void setScheduledActions(List<ScheduledAction> lsScheduledActions) {
        this.getOptionalInfo().lsScheduledActions = lsScheduledActions;
    }

    public Map<Address, Boolean> getListeners() {
        if (this.optionalInfo == null) {
            return null;
        }
        return this.getOptionalInfo().mapListeners;
    }

    public void setMapListeners(Map<Address, Boolean> mapListeners) {
        this.getOptionalInfo().mapListeners = mapListeners;
    }

    public void setCopyCount(int copyCount) {
        this.copyCount = copyCount;
    }

    public boolean isLocked() {
        return this.lock != null && this.lock.isLocked();
    }

    public int getScheduledActionCount() {
        if (this.optionalInfo == null) {
            return 0;
        }
        return this.getOptionalInfo().lsScheduledActions == null ? 0 : this.getOptionalInfo().lsScheduledActions.size();
    }

    public int getLockCount() {
        return this.lock == null ? 0 : this.lock.getLockCount();
    }

    public void clearLock() {
        if (this.lock != null) {
            this.lock.clear();
        }
    }

    public Address getLockAddress() {
        return this.lock == null ? null : this.lock.getLockAddress();
    }

    public OptionalInfo getOptionalInfo() {
        if (this.optionalInfo == null) {
            this.optionalInfo = new OptionalInfo();
        }
        return this.optionalInfo;
    }

    class OptionalInfo {
        private Long[] indexes;
        private byte[] indexTypes;
        private List<ScheduledAction> lsScheduledActions = null;
        private Map<Address, Boolean> mapListeners = null;
        private Set<Data> lsMultiValues = null;
        private SortedSet<VersionedBackupOp> backupOps = null;

        OptionalInfo() {
        }

        static /* synthetic */ Long[] access$002(OptionalInfo x0, Long[] x1) {
            x0.indexes = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$102(OptionalInfo x0, byte[] x1) {
            x0.indexTypes = x1;
            return x1;
        }
    }
}

