/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Instance;
import com.hazelcast.core.MapEntry;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.query.Expression;
import com.hazelcast.query.Predicate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class ReplicatedMapFactory {
    private static final ConcurrentHashMap<String, IMap> maps = new ConcurrentHashMap(100);
    private static final Object factoryLock = new Object();

    private ReplicatedMapFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IMap getMap(String name) {
        ReplicatedMap map = maps.get(name);
        if (map == null) {
            Object object = factoryLock;
            synchronized (object) {
                map = maps.get(name);
                if (map == null) {
                    map = new ReplicatedMap(name);
                }
            }
        }
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReplicatedMap<K, V>
    extends ConcurrentHashMap<K, V>
    implements EntryListener<K, V>,
    IMap<K, V> {
        final IMap<K, V> distributedMap;

        public ReplicatedMap(String name) {
            this.distributedMap = Hazelcast.getMap(name);
            this.distributedMap.addEntryListener(this, true);
            Set keys = this.distributedMap.keySet();
            for (Object key : keys) {
                Object value = this.distributedMap.get(key);
                if (value == null) continue;
                super.putIfAbsent(key, value);
            }
            Set entries = this.distributedMap.entrySet();
            for (Map.Entry entry : entries) {
                this.putIfAbsent(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Future<V> getAsync(K key) {
            return this.distributedMap.getAsync(key);
        }

        @Override
        public Future<V> putAsync(K key, V value) {
            return this.distributedMap.putAsync(key, value);
        }

        @Override
        public Future<V> removeAsync(K key) {
            return this.distributedMap.removeAsync(key);
        }

        @Override
        public V put(K key, V value, long ttl, TimeUnit timeunit) {
            return this.distributedMap.put(key, value, ttl, timeunit);
        }

        @Override
        public V put(K key, V value) {
            return this.distributedMap.put(key, value);
        }

        @Override
        public boolean tryPut(K key, V value, long timeout, TimeUnit timeunit) {
            return this.distributedMap.tryPut(key, value, timeout, timeunit);
        }

        @Override
        public V remove(Object key) {
            return this.distributedMap.remove(key);
        }

        @Override
        public V putIfAbsent(K key, V value) {
            Object currentValue = super.get(key);
            if (currentValue != null) {
                return currentValue;
            }
            return this.distributedMap.putIfAbsent(key, value);
        }

        @Override
        public V putIfAbsent(K key, V value, long ttl, TimeUnit timeunit) {
            Object currentValue = super.get(key);
            if (currentValue != null) {
                return currentValue;
            }
            return this.distributedMap.putIfAbsent(key, value, ttl, timeunit);
        }

        @Override
        public void entryAdded(EntryEvent<K, V> event) {
            super.put(event.getKey(), event.getValue());
        }

        @Override
        public void entryRemoved(EntryEvent<K, V> event) {
            super.remove(event.getKey());
        }

        @Override
        public void entryUpdated(EntryEvent<K, V> event) {
            super.put(event.getKey(), event.getValue());
        }

        @Override
        public void entryEvicted(EntryEvent<K, V> event) {
            super.remove(event.getKey());
        }

        @Override
        public String getName() {
            return this.distributedMap.getName();
        }

        @Override
        public void lock(K key) {
            this.distributedMap.lock(key);
        }

        @Override
        public boolean tryLock(K key) {
            return this.distributedMap.tryLock(key);
        }

        @Override
        public boolean tryLock(K key, long time, TimeUnit timeunit) {
            return this.distributedMap.tryLock(key, time, timeunit);
        }

        @Override
        public void unlock(K key) {
            this.distributedMap.unlock(key);
        }

        @Override
        public boolean lockMap(long time, TimeUnit timeunit) {
            return this.distributedMap.lockMap(time, timeunit);
        }

        @Override
        public void unlockMap() {
            this.distributedMap.unlockMap();
        }

        @Override
        public LocalMapStats getLocalMapStats() {
            return this.distributedMap.getLocalMapStats();
        }

        @Override
        public void addEntryListener(EntryListener<K, V> listener, boolean includeValue) {
            this.distributedMap.addEntryListener(listener, includeValue);
        }

        @Override
        public void removeEntryListener(EntryListener<K, V> listener) {
            this.distributedMap.removeEntryListener(listener);
        }

        @Override
        public void addEntryListener(EntryListener<K, V> listener, K key, boolean includeValue) {
            this.distributedMap.addEntryListener(listener, key, includeValue);
        }

        @Override
        public void removeEntryListener(EntryListener<K, V> listener, K key) {
            this.distributedMap.removeEntryListener(listener, key);
        }

        @Override
        public MapEntry<K, V> getMapEntry(K key) {
            return this.distributedMap.getMapEntry(key);
        }

        @Override
        public boolean evict(Object key) {
            return this.distributedMap.evict(key);
        }

        @Override
        public Set<K> keySet(Predicate predicate) {
            HashSet result = new HashSet();
            Set entries = super.entrySet();
            for (Map.Entry entry : entries) {
                if (!predicate.apply((MapEntry)entry)) continue;
                result.add(entry.getKey());
            }
            return result;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet(Predicate predicate) {
            HashSet<Map.Entry<K, V>> result = new HashSet<Map.Entry<K, V>>();
            Set entries = super.entrySet();
            for (Map.Entry entry : entries) {
                if (!predicate.apply((MapEntry)entry)) continue;
                result.add(entry);
            }
            return result;
        }

        @Override
        public Collection<V> values(Predicate predicate) {
            HashSet result = new HashSet();
            Set entries = super.entrySet();
            for (Map.Entry entry : entries) {
                if (!predicate.apply((MapEntry)entry)) continue;
                result.add(entry.getValue());
            }
            return result;
        }

        @Override
        public Set<K> localKeySet() {
            return this.distributedMap.localKeySet();
        }

        @Override
        public Set<K> localKeySet(Predicate predicate) {
            return this.distributedMap.localKeySet(predicate);
        }

        @Override
        public void addIndex(String attribute, boolean ordered) {
            this.distributedMap.addIndex(attribute, ordered);
        }

        @Override
        public void addIndex(Expression<?> expression, boolean ordered) {
            this.distributedMap.addIndex(expression, ordered);
        }

        @Override
        public Instance.InstanceType getInstanceType() {
            return this.distributedMap.getInstanceType();
        }

        @Override
        public void destroy() {
            this.distributedMap.destroy();
            this.clear();
        }

        @Override
        public Object getId() {
            return this.distributedMap.getId();
        }
    }
}

