/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.executor;

import com.hazelcast.impl.executor.ParallelExecutor;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ParallelExecutorService {
    private final ExecutorService executorService;
    private final List<ParallelExecutor> lsParallelExecutors = new CopyOnWriteArrayList<ParallelExecutor>();

    public ParallelExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void shutdown() {
        for (ParallelExecutor parallelExecutor : this.lsParallelExecutors) {
            parallelExecutor.shutdown();
        }
        this.lsParallelExecutors.clear();
    }

    public ParallelExecutor newBlockingParallelExecutor(int concurrencyLevel, int capacity) {
        BlockingParallelExecutorImpl p = new BlockingParallelExecutorImpl(concurrencyLevel, capacity);
        this.lsParallelExecutors.add(p);
        return p;
    }

    public ParallelExecutor newParallelExecutor(int concurrencyLevel) {
        ParallelExecutor parallelExecutor = null;
        parallelExecutor = concurrencyLevel > 0 && concurrencyLevel < Integer.MAX_VALUE ? new ParallelExecutorImpl(concurrencyLevel) : new FullyParallelExecutorImpl();
        this.lsParallelExecutors.add(parallelExecutor);
        return parallelExecutor;
    }

    class ParallelExecutorImpl
    implements ParallelExecutor {
        final ExecutionSegment[] executionSegments;
        final AtomicInteger offerIndex = new AtomicInteger();
        final AtomicInteger activeCount = new AtomicInteger();
        final AtomicLong waitingExecutions = new AtomicLong();

        ParallelExecutorImpl(int concurrencyLevel) {
            this.executionSegments = new ExecutionSegment[concurrencyLevel];
            for (int i = 0; i < concurrencyLevel; ++i) {
                this.executionSegments[i] = new ExecutionSegment(i);
            }
        }

        public void execute(Runnable runnable) {
            int hash = this.offerIndex.incrementAndGet();
            int index = hash == Integer.MIN_VALUE ? 0 : Math.abs(hash) % this.executionSegments.length;
            ExecutionSegment segment = this.executionSegments[index];
            segment.offer(runnable);
            if (index >= 1000000) {
                this.offerIndex.set(0);
            }
        }

        public void execute(Runnable runnable, int hash) {
            int index = hash == Integer.MIN_VALUE ? 0 : Math.abs(hash) % this.executionSegments.length;
            ExecutionSegment segment = this.executionSegments[index];
            segment.offer(runnable);
        }

        public void shutdown() {
            for (ExecutionSegment executionSegment : this.executionSegments) {
                executionSegment.shutdown();
            }
        }

        public int getPoolSize() {
            int size = 0;
            for (ExecutionSegment executionSegment : this.executionSegments) {
                size += executionSegment.size();
            }
            return size;
        }

        public int getActiveCount() {
            return this.activeCount.get();
        }

        public long getQueueSize() {
            return this.waitingExecutions.get();
        }

        protected void onOffer() {
        }

        protected void beforeRun() {
        }

        protected void afterRun() {
        }

        class ExecutionSegment
        implements Runnable {
            final ConcurrentLinkedQueue<Runnable> q = new ConcurrentLinkedQueue();
            final AtomicInteger size = new AtomicInteger();
            final int segmentIndex;

            ExecutionSegment(int segmentIndex) {
                this.segmentIndex = segmentIndex;
            }

            public void offer(Runnable e) {
                ParallelExecutorImpl.this.waitingExecutions.incrementAndGet();
                this.q.offer(e);
                ParallelExecutorImpl.this.onOffer();
                if (this.size.incrementAndGet() == 1) {
                    ParallelExecutorService.this.executorService.execute(this);
                }
            }

            public void run() {
                ParallelExecutorImpl.this.activeCount.incrementAndGet();
                Runnable r = this.q.poll();
                while (r != null) {
                    try {
                        ParallelExecutorImpl.this.beforeRun();
                        r.run();
                        ParallelExecutorImpl.this.afterRun();
                        ParallelExecutorImpl.this.waitingExecutions.decrementAndGet();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    this.size.decrementAndGet();
                    r = this.q.poll();
                }
                ParallelExecutorImpl.this.activeCount.decrementAndGet();
            }

            public void shutdown() {
                Runnable r = this.q.poll();
                while (r != null) {
                    this.size.decrementAndGet();
                    r = this.q.poll();
                }
            }

            public int size() {
                return this.size.get();
            }
        }
    }

    class BlockingParallelExecutorImpl
    extends ParallelExecutorImpl {
        private final BlockingQueue<Object> q;

        BlockingParallelExecutorImpl(int concurrencyLevel, int capacity) {
            super(concurrencyLevel);
            this.q = new ArrayBlockingQueue<Object>(capacity);
        }

        protected void onOffer() {
            try {
                this.q.put(Boolean.TRUE);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        protected void afterRun() {
            this.q.poll();
        }
    }

    class FullyParallelExecutorImpl
    implements ParallelExecutor {
        FullyParallelExecutorImpl() {
        }

        public void execute(Runnable runnable) {
            ParallelExecutorService.this.executorService.execute(runnable);
        }

        public void execute(Runnable runnable, int hash) {
            ParallelExecutorService.this.executorService.execute(runnable);
        }

        public void shutdown() {
        }

        public int getPoolSize() {
            return 0;
        }

        public int getActiveCount() {
            return 0;
        }
    }
}

