/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.impl.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.SelectionHandler;
import com.hazelcast.util.ThreadWatcher;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public abstract class SelectorBase
implements Runnable {
    protected final ILogger logger;
    protected final Selector selector;
    protected final Queue<Runnable> selectorQueue = new ConcurrentLinkedQueue<Runnable>();
    protected final Node node;
    private final int waitTime;
    protected boolean live = true;
    protected final ThreadWatcher threadWatcher = new ThreadWatcher();

    public SelectorBase(Node node, int waitTime) {
        this.node = node;
        this.logger = node.getLogger(this.getClass().getName());
        this.waitTime = waitTime;
        Selector selectorTemp = null;
        try {
            selectorTemp = Selector.open();
        }
        catch (IOException e) {
            this.handleSelectorException(e);
        }
        this.selector = selectorTemp;
        this.live = true;
    }

    public void shutdown() {
        if (this.selectorQueue != null) {
            this.selectorQueue.clear();
        }
        try {
            final CountDownLatch l = new CountDownLatch(1);
            this.addTask(new Runnable(){

                public void run() {
                    SelectorBase.this.live = false;
                    l.countDown();
                }
            });
            l.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void addTask(Runnable runnable) {
        this.selectorQueue.offer(runnable);
    }

    public void processSelectionQueue() {
        while (this.live) {
            Runnable runnable = this.selectorQueue.poll();
            if (runnable == null) {
                return;
            }
            runnable.run();
        }
    }

    public abstract void publishUtilization();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final void run() {
        block26: {
            block21: while (true) {
                block27: {
                    block25: {
                        block24: {
                            if (!this.live) break;
                            if (this.threadWatcher.incrementRunCount() % 10000L == 0L) {
                                this.publishUtilization();
                            }
                            this.processSelectionQueue();
                            if (this.live) break block24;
                            try {
                                this.logger.log(Level.FINE, "closing selector " + Thread.currentThread().getName());
                                this.selector.close();
                            }
                            catch (Exception ignored) {
                                // empty catch block
                            }
                            return;
                        }
                        startWait = System.nanoTime();
                        selectedKeyCount = this.selector.select(this.waitTime);
                        now = System.nanoTime();
                        this.threadWatcher.addWait(now - startWait, now);
                        if (!Thread.interrupted()) break block25;
                        this.node.handleInterruptedException(Thread.currentThread(), new RuntimeException());
                        try {
                            this.logger.log(Level.FINE, "closing selector " + Thread.currentThread().getName());
                            this.selector.close();
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                        return;
                    }
                    break block27;
                    catch (Throwable exp) {
                    }
                }
                if (selectedKeyCount == 0) continue;
                setSelectedKeys = this.selector.selectedKeys();
                it = setSelectedKeys.iterator();
                while (true) {
                    if (it.hasNext()) ** break;
                    continue block21;
                    sk = it.next();
                    it.remove();
                    try {
                        sk.interestOps(sk.interestOps() & ~sk.readyOps());
                        selectionHandler = (SelectionHandler)sk.attachment();
                        selectionHandler.handle();
                    }
                    catch (CancelledKeyException e) {
                    }
                    catch (Throwable e) {
                        this.handleSelectorException(e);
                    }
                }
                break;
            }
            try {
                this.logger.log(Level.FINE, "closing selector " + Thread.currentThread().getName());
                this.selector.close();
            }
            catch (Exception ignored) {}
            break block26;
            catch (Throwable e) {
                try {
                    this.logger.log(Level.WARNING, "unhandled exception in " + Thread.currentThread().getName(), e);
                }
                catch (Throwable var7_16) {
                    throw var7_16;
                }
                finally {
                    try {
                        this.logger.log(Level.FINE, "closing selector " + Thread.currentThread().getName());
                        this.selector.close();
                    }
                    catch (Exception var1_5) {}
                }
            }
        }
    }

    protected void handleSelectorException(Throwable e) {
        String msg = "Selector exception at  " + Thread.currentThread().getName() + ", cause= " + e.toString();
        this.logger.log(Level.WARNING, msg, e);
    }

    protected Connection initChannel(SocketChannel socketChannel, boolean acceptor) throws Exception {
        Socket socket = socketChannel.socket();
        socket.setKeepAlive(true);
        socket.setSoLinger(true, 1);
        socket.setReceiveBufferSize(this.node.connectionManager.SOCKET_RECEIVE_BUFFER_SIZE);
        socket.setSendBufferSize(this.node.connectionManager.SOCKET_SEND_BUFFER_SIZE);
        socketChannel.configureBlocking(false);
        return this.node.connectionManager.createConnection(socketChannel, acceptor);
    }
}

