/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.AbstractSerializer;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.FastByteArrayInputStream;
import com.hazelcast.nio.FastByteArrayOutputStream;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Serializer
extends AbstractSerializer {
    private static final ILogger logger = Logger.getLogger(Serializer.class.getName());
    private static int OUTPUT_STREAM_BUFFER_SIZE = 102400;
    private static final AbstractSerializer.TypeSerializer[] serializers = Serializer.sort(new AbstractSerializer.TypeSerializer[]{new AbstractSerializer.DataSerializer(), new AbstractSerializer.ByteArraySerializer(), new AbstractSerializer.LongSerializer(), new AbstractSerializer.IntegerSerializer(), new AbstractSerializer.StringSerializer(), new AbstractSerializer.ClassSerializer(), new AbstractSerializer.DateSerializer(), new AbstractSerializer.BigIntegerSerializer(), new AbstractSerializer.Externalizer(), new AbstractSerializer.ObjectSerializer()});
    final FastByteArrayOutputStream bbos = new FastByteArrayOutputStream(OUTPUT_STREAM_BUFFER_SIZE);
    final FastByteArrayInputStream bbis = new FastByteArrayInputStream(new byte[10]);

    public Serializer() {
        super(serializers);
    }

    public static Object newInstance(Class klass) throws Exception {
        return AbstractSerializer.newInstance(klass);
    }

    public static Class<?> classForName(String className) throws ClassNotFoundException {
        return AbstractSerializer.classForName(className);
    }

    public static Class<?> classForName(ClassLoader classLoader, String className) throws ClassNotFoundException {
        return AbstractSerializer.classForName(classLoader, className);
    }

    public byte[] toByteArray(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            this.bbos.reset();
            this.toByte(this.bbos, obj);
            byte[] result = this.bbos.toByteArray();
            if (this.bbos.size() > OUTPUT_STREAM_BUFFER_SIZE) {
                this.bbos.set(new byte[OUTPUT_STREAM_BUFFER_SIZE]);
            }
            return result;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public Data writeObject(Object obj) {
        if (obj instanceof Data) {
            return (Data)obj;
        }
        byte[] bytes = this.toByteArray(obj);
        if (bytes == null) {
            return null;
        }
        return new Data(bytes);
    }

    public Object readObject(Data data) {
        if (data == null || data.buffer == null || data.buffer.length == 0) {
            return null;
        }
        this.bbis.set(data.buffer, data.buffer.length);
        Object obj = this.toObject(this.bbis);
        if (obj instanceof HazelcastInstanceAware) {
            ((HazelcastInstanceAware)obj).setHazelcastInstance(ThreadContext.get().getCurrentFactory());
        }
        return obj;
    }
}

