/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class ResponseQueueFactory {
    public static BlockingQueue newResponseQueue() {
        return new ResponseQueue();
    }

    private static final class ResponseQueue
    extends AbstractQueue
    implements BlockingQueue {
        volatile Object response;
        final Object lock = new Object();

        private ResponseQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object take() throws InterruptedException {
            while (this.response == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.response == null) {
                        this.lock.wait();
                    }
                }
            }
            return this.response;
        }

        public boolean offer(Object o, long timeout, TimeUnit unit) throws InterruptedException {
            return this.offer(o);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
            if (timeout == 0L) {
                return this.response;
            }
            if (timeout < 0L) {
                new IllegalArgumentException();
            }
            long remaining = unit.toMillis(timeout);
            while (this.response == null && remaining > 0L) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.response == null) {
                        long start = System.currentTimeMillis();
                        this.lock.wait(remaining);
                        remaining -= System.currentTimeMillis() - start;
                    }
                }
            }
            return this.response;
        }

        public void put(Object o) throws InterruptedException {
            this.offer(o);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean offer(Object obj) {
            if (this.response != null) {
                return false;
            }
            this.response = obj;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
            return true;
        }

        public Object poll() {
            return this.response;
        }

        public int remainingCapacity() {
            throw new UnsupportedOperationException();
        }

        public int drainTo(Collection c) {
            throw new UnsupportedOperationException();
        }

        public int drainTo(Collection c, int maxElements) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            this.response = null;
        }

        public Iterator iterator() {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.response == null ? 0 : 1;
        }

        public Object peek() {
            return this.response;
        }
    }
}

