/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import java.util.AbstractQueue;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleBoundedQueue<E>
extends AbstractQueue<E> {
    final int maxSize;
    final E[] objects;
    int add = 0;
    int remove = 0;
    int size = 0;

    public SimpleBoundedQueue(int maxSize) {
        this.maxSize = maxSize;
        this.objects = new Object[maxSize];
    }

    @Override
    public boolean add(E obj) {
        if (this.size == this.maxSize) {
            return false;
        }
        this.objects[this.add] = obj;
        ++this.add;
        ++this.size;
        if (this.add == this.maxSize) {
            this.add = 0;
        }
        return true;
    }

    public E pop() {
        if (this.size == 0) {
            return null;
        }
        int last = this.add - 1;
        E value = this.objects[last];
        this.objects[last] = null;
        --this.size;
        --this.add;
        return value;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean offer(E o) {
        return this.add(o);
    }

    @Override
    public E peek() {
        if (this.size == 0) {
            return null;
        }
        return this.objects[this.remove];
    }

    @Override
    public E poll() {
        if (this.size == 0) {
            return null;
        }
        E value = this.objects[this.remove];
        this.objects[this.remove] = null;
        ++this.remove;
        --this.size;
        if (this.remove == this.maxSize) {
            this.remove = 0;
        }
        return value;
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }
}

