/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.ascii.memcache;

import com.hazelcast.impl.ascii.AbstractTextCommandProcessor;
import com.hazelcast.impl.ascii.TextCommandConstants;
import com.hazelcast.impl.ascii.TextCommandService;
import com.hazelcast.impl.ascii.memcache.MemcacheEntry;
import com.hazelcast.impl.ascii.memcache.SetCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetCommandProcessor
extends AbstractTextCommandProcessor<SetCommand> {
    public SetCommandProcessor(TextCommandService textCommandService) {
        super(textCommandService);
    }

    @Override
    public void handle(SetCommand request) {
        String key = request.getKey();
        String mapName = "default";
        int index = key.indexOf(58);
        if (index != -1) {
            mapName = key.substring(0, index);
            key = key.substring(index + 1);
        }
        MemcacheEntry value = new MemcacheEntry(key, request.getValue(), request.getFlag());
        int ttl = this.textCommandService.getAdjustedTTLSeconds(request.getExpiration());
        this.textCommandService.incrementSetCount();
        if (TextCommandConstants.TextCommandType.SET == request.getType()) {
            request.setResponse(STORED);
            if (request.shouldReply()) {
                this.textCommandService.sendResponse(request);
            }
            this.textCommandService.put(mapName, key, value, ttl);
        } else if (TextCommandConstants.TextCommandType.ADD == request.getType()) {
            boolean added;
            boolean bl = added = this.textCommandService.putIfAbsent(mapName, key, value, ttl) == null;
            if (added) {
                request.setResponse(STORED);
            } else {
                request.setResponse(NOT_STORED);
            }
            if (request.shouldReply()) {
                this.textCommandService.sendResponse(request);
            }
        } else if (TextCommandConstants.TextCommandType.REPLACE == request.getType()) {
            boolean replaced;
            boolean bl = replaced = this.textCommandService.replace(mapName, key, value) != null;
            if (replaced) {
                request.setResponse(STORED);
            } else {
                request.setResponse(NOT_STORED);
            }
            if (request.shouldReply()) {
                this.textCommandService.sendResponse(request);
            }
        }
    }

    @Override
    public void handleRejection(SetCommand request) {
        request.setResponse(NOT_STORED);
        if (request.shouldReply()) {
            this.textCommandService.sendResponse(request);
        }
    }
}

