/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.CMap;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.SortedHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapNearCache {
    private final ILogger logger;
    private final SortedHashMap<Data, Object> sortedMap;
    private final ConcurrentMap<Object, CacheEntry> cache;
    private final CMap cmap;
    private final int maxSize;
    private final long ttl;
    private final long maxIdleTime;
    private final boolean invalidateOnChange;
    private final int LOCAL_INVALIDATION_COUNTER = 10000;
    private final AtomicInteger counter = new AtomicInteger();
    private long lastEvictionTime = 0L;

    public MapNearCache(CMap cmap, SortedHashMap.OrderingType orderingType, int maxSize, long ttl, long maxIdleTime, boolean invalidateOnChange) {
        this.cmap = cmap;
        this.logger = cmap.concurrentMapManager.node.getLogger(MapNearCache.class.getName());
        this.maxSize = maxSize;
        this.ttl = ttl;
        this.maxIdleTime = maxIdleTime;
        this.invalidateOnChange = invalidateOnChange;
        int size = maxSize == 0 || maxSize > 50000 ? 10000 : maxSize;
        this.sortedMap = new SortedHashMap(size, orderingType);
        this.cache = new ConcurrentHashMap<Object, CacheEntry>(size);
    }

    boolean shouldInvalidateOnChange() {
        return this.invalidateOnChange;
    }

    public boolean containsKey(Object key) {
        CacheEntry entry;
        long now = System.currentTimeMillis();
        if (this.counter.incrementAndGet() == 10000) {
            this.counter.addAndGet(-10000);
            this.evict(now, false);
        }
        return (entry = (CacheEntry)this.cache.get(key)) != null && !entry.isValid(now);
    }

    public void setContainsKey(Object key, Data dataKey) {
        CacheEntry entry = (CacheEntry)this.cache.get(key);
        if (entry == null) {
            this.put(key, dataKey, null);
        }
    }

    public Object get(Object key) {
        CacheEntry entry;
        long now = System.currentTimeMillis();
        if (this.counter.incrementAndGet() == 10000) {
            this.counter.addAndGet(-10000);
            this.evict(now, false);
        }
        if ((entry = (CacheEntry)this.cache.get(key)) == null) {
            return null;
        }
        if (entry.isValid(now)) {
            Object value = null;
            value = ThreadContext.get().isClient() ? entry.getValueData() : entry.getValue();
            this.cmap.concurrentMapManager.enqueueAndReturn(entry);
            entry.touch(now);
            return value;
        }
        return null;
    }

    private List<Data> getInvalidEntries(long now) {
        ArrayList<Data> lsKeysToInvalidate = null;
        if (now - this.lastEvictionTime > 10000L) {
            if (this.ttl != 0L || this.maxIdleTime != 0L) {
                lsKeysToInvalidate = new ArrayList<Data>();
                Collection entries = this.cache.values();
                for (CacheEntry entry : entries) {
                    if (entry.isValid(now)) continue;
                    lsKeysToInvalidate.add(entry.keyData);
                }
            }
            this.lastEvictionTime = now;
        }
        return lsKeysToInvalidate;
    }

    public void evict(long now, boolean serviceThread) {
        if (serviceThread) {
            this.checkThread();
        }
        if (this.maxSize == Integer.MAX_VALUE) {
            return;
        }
        final List<Data> lsKeysToInvalidate = this.getInvalidEntries(now);
        if (lsKeysToInvalidate != null && lsKeysToInvalidate.size() > 0) {
            if (serviceThread) {
                for (Data key : lsKeysToInvalidate) {
                    this.invalidate(key);
                }
            } else {
                this.cmap.concurrentMapManager.enqueueAndReturn(new Processable(){

                    public void process() {
                        for (Data key : lsKeysToInvalidate) {
                            MapNearCache.this.invalidate(key);
                        }
                    }
                });
            }
        }
    }

    public void put(Object key, Data keyData, Data value) {
        CacheEntry cacheEntry;
        this.checkThread();
        if (this.cache.size() != this.sortedMap.size()) {
            throw new IllegalStateException("cache and sorted map size should be the same: " + this.cache.size() + " vs. " + this.sortedMap.size());
        }
        if (this.cache.size() + 1 >= this.maxSize) {
            this.startEviction();
        }
        if (this.cache.size() + 1 >= this.maxSize) {
            return;
        }
        if (!this.sortedMap.containsKey(keyData)) {
            this.sortedMap.put(keyData, key);
        }
        if ((cacheEntry = (CacheEntry)this.cache.get(key)) == null) {
            cacheEntry = new CacheEntry(key, keyData, value);
        } else {
            cacheEntry.setValue(value);
        }
        this.cache.put(key, cacheEntry);
    }

    void startEviction() {
        this.checkThread();
        int evictionCount = (int)((double)this.cache.size() * 0.25);
        ArrayList<Data> lsRemoves = new ArrayList<Data>(evictionCount);
        int count = 0;
        for (Data key : this.sortedMap.keySet()) {
            lsRemoves.add(key);
            if (count++ < evictionCount) continue;
            break;
        }
        for (Data key : lsRemoves) {
            this.invalidate(key);
        }
        lsRemoves.clear();
    }

    public void invalidate(Data key) {
        CacheEntry removedCacheEntry;
        this.checkThread();
        Object theKey = this.sortedMap.remove(key);
        if (theKey != null && (removedCacheEntry = (CacheEntry)this.cache.remove(theKey)) == null) {
            throw new IllegalStateException("Removed CacheEntry cannot be null");
        }
    }

    void checkThread() {
        if (this.cmap.concurrentMapManager.node.serviceThread != Thread.currentThread()) {
            throw new RuntimeException("Only ServiceThread can update the cache! " + Thread.currentThread().getName());
        }
    }

    public void appendState(StringBuffer sbState) {
        sbState.append(", n.sorted:" + this.sortedMap.size());
        sbState.append(", n.cache:" + this.cache.size());
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public void reset() {
        this.sortedMap.clear();
        this.cache.clear();
    }

    private class CacheEntry
    implements Processable {
        final Object key;
        final Data keyData;
        private Data valueData = null;
        private Object value = null;
        private final long createTime;
        private volatile long lastAccessTime;

        private CacheEntry(Object key, Data keyData, Data valueData) {
            if (key == null) {
                throw new IllegalStateException("key cannot be null");
            }
            if (keyData == null) {
                throw new IllegalStateException("keyData cannot be null");
            }
            this.key = key;
            this.keyData = keyData;
            this.valueData = valueData;
            this.createTime = System.currentTimeMillis();
            this.touch(this.createTime);
        }

        public void touch(long now) {
            this.lastAccessTime = now;
        }

        public boolean isValid(long now) {
            if (MapNearCache.this.ttl != 0L && now - this.createTime > MapNearCache.this.ttl) {
                return false;
            }
            return MapNearCache.this.maxIdleTime == 0L || now - this.lastAccessTime <= MapNearCache.this.maxIdleTime;
        }

        public void setValue(Data valueData) {
            this.valueData = valueData;
            this.value = null;
        }

        public Object getValue() {
            if (this.value != null) {
                return this.value;
            }
            if (this.valueData == null) {
                return null;
            }
            this.value = IOUtil.toObject(this.valueData);
            this.valueData = null;
            return this.value;
        }

        public Data getValueData() {
            return this.valueData;
        }

        public void process() {
            MapNearCache.this.sortedMap.get(this.keyData);
        }
    }
}

