/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.cluster.ClusterService;
import com.hazelcast.impl.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.InSelector;
import com.hazelcast.nio.OutSelector;
import com.hazelcast.nio.SelectionHandler;
import java.io.EOFException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

abstract class AbstractSelectionHandler
implements SelectionHandler {
    protected final ILogger logger;
    protected final SocketChannel socketChannel;
    protected final Connection connection;
    protected final InSelector inSelector;
    protected final OutSelector outSelector;
    protected final ClusterService clusterService;
    protected final Node node;
    protected SelectionKey sk = null;

    public AbstractSelectionHandler(Connection connection) {
        this.connection = connection;
        this.socketChannel = connection.getSocketChannel();
        this.node = connection.connectionManager.node;
        this.logger = this.node.getLogger(this.getClass().getName());
        this.inSelector = this.node.inSelector;
        this.outSelector = this.node.outSelector;
        this.clusterService = this.node.clusterService;
    }

    protected void shutdown() {
    }

    final void handleSocketException(Throwable e) {
        if (e instanceof OutOfMemoryError) {
            this.node.onOutOfMemory((OutOfMemoryError)e);
        }
        if (this.sk != null) {
            this.sk.cancel();
        }
        this.connection.close();
        StringBuilder sb = new StringBuilder();
        sb.append(Thread.currentThread().getName());
        sb.append(" Closing socket to endpoint ");
        sb.append(this.connection.getEndPoint());
        sb.append(", Cause:").append(e);
        if (e instanceof EOFException) {
            this.logger.log(Level.WARNING, sb.toString());
        } else {
            this.logger.log(Level.WARNING, sb.toString(), e);
        }
    }

    final void registerOp(Selector selector, int operation) {
        try {
            if (!this.connection.live()) {
                return;
            }
            if (this.sk == null) {
                this.sk = this.socketChannel.register(selector, operation, this);
            } else {
                this.sk.interestOps(operation);
            }
        }
        catch (Throwable e) {
            this.handleSocketException(e);
        }
    }
}

