/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.provider;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEntry;
import com.hazelcast.hibernate.HazelcastTimestamper;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Map;
import java.util.logging.Level;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;

public final class HazelcastCache
implements Cache {
    private static final ILogger LOG = Logger.getLogger(HazelcastCache.class.getName());
    private final HazelcastInstance instance;
    private final IMap cache;
    private final String regionName;
    private final int timeout;

    public HazelcastCache(HazelcastInstance instance, String regionName) {
        LOG.log(Level.INFO, "Creating new HazelcastCache with region name: " + regionName);
        this.instance = instance;
        this.cache = instance.getMap(regionName);
        this.regionName = regionName;
        this.timeout = HazelcastTimestamper.getTimeout(instance, regionName);
    }

    public void clear() throws CacheException {
        this.cache.clear();
    }

    public void destroy() throws CacheException {
    }

    public long getElementCountInMemory() {
        return this.cache.size();
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public long getSizeInMemory() {
        long size = 0L;
        for (Object key : this.cache.keySet()) {
            MapEntry entry = this.cache.getMapEntry(key);
            if (entry == null) continue;
            size += entry.getCost();
        }
        return size;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public long nextTimestamp() {
        return HazelcastTimestamper.nextTimestamp(this.instance);
    }

    public void lock(Object key) throws CacheException {
        this.cache.lock(key);
    }

    public void unlock(Object key) throws CacheException {
        this.cache.unlock(key);
    }

    public Object get(Object key) throws CacheException {
        return this.cache.get(key);
    }

    public Object read(Object key) throws CacheException {
        return this.get(key);
    }

    public void put(Object key, Object value) throws CacheException {
        this.cache.put(key, value);
    }

    public void remove(Object key) throws CacheException {
        this.cache.remove(key);
    }

    public void update(Object key, Object value) throws CacheException {
        this.put(key, value);
    }

    public Map toMap() {
        return this.cache;
    }
}

