/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.ClusterImpl;
import com.hazelcast.core.AtomicNumber;
import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IList;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.Instance;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.MessageListener;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.MultiTask;
import com.hazelcast.core.Transaction;
import com.hazelcast.impl.BaseManager;
import com.hazelcast.impl.CallContext;
import com.hazelcast.impl.ClientDistributedTask;
import com.hazelcast.impl.ClientEndpoint;
import com.hazelcast.impl.ClientRequestHandler;
import com.hazelcast.impl.ClientServiceException;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.FallThroughRunnable;
import com.hazelcast.impl.Keys;
import com.hazelcast.impl.ListenerManager;
import com.hazelcast.impl.MProxy;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.MultiMapProxy;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.base.KeyValue;
import com.hazelcast.impl.base.Pairs;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import com.hazelcast.partition.Partition;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.query.Predicate;
import com.hazelcast.util.DistributedTimeoutException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

public class ClientService
implements ConnectionListener {
    private final Node node;
    private final Map<Connection, ClientEndpoint> mapClientEndpoints = new ConcurrentHashMap<Connection, ClientEndpoint>();
    private final ClientOperationHandler[] clientOperationHandlers = new ClientOperationHandler[300];
    private final ILogger logger;
    private final int THREAD_COUNT;
    final Worker[] workers;
    boolean firstCall = true;

    public ClientService(Node node) {
        this.node = node;
        this.logger = node.getLogger(this.getClass().getName());
        node.getClusterImpl().addMembershipListener(new ClientServiceMembershipListener());
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_PUT.getValue()] = new MapPutHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_PUT_AND_UNLOCK.getValue()] = new MapPutAndUnlockHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_PUT_ALL.getValue()] = new MapPutAllHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_PUT_MULTI.getValue()] = new MapPutMultiHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_PUT_IF_ABSENT.getValue()] = new MapPutIfAbsentHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_TRY_PUT.getValue()] = new MapTryPutHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_GET.getValue()] = new MapGetHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_GET_ALL.getValue()] = new MapGetAllHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_REMOVE.getValue()] = new MapRemoveHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_TRY_REMOVE.getValue()] = new MapTryRemoveHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_REMOVE_IF_SAME.getValue()] = new MapRemoveIfSameHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_REMOVE_MULTI.getValue()] = new MapRemoveMultiHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_EVICT.getValue()] = new MapEvictHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_FLUSH.getValue()] = new MapFlushHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_REPLACE_IF_NOT_NULL.getValue()] = new MapReplaceIfNotNullHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_REPLACE_IF_SAME.getValue()] = new MapReplaceIfSameHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_SIZE.getValue()] = new MapSizeHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_GET_MAP_ENTRY.getValue()] = new GetMapEntryHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_TRY_LOCK_AND_GET.getValue()] = new MapTryLockAndGetHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_LOCK.getValue()] = new MapLockHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_UNLOCK.getValue()] = new MapUnlockHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_LOCK_MAP.getValue()] = new MapLockMapHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_UNLOCK_MAP.getValue()] = new MapUnlockMapHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_CONTAINS.getValue()] = new MapContainsHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_CONTAINS_VALUE.getValue()] = new MapContainsValueHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_ADD_TO_LIST.getValue()] = new ListAddHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_ADD_TO_SET.getValue()] = new SetAddHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_REMOVE_ITEM.getValue()] = new MapItemRemoveHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS.getValue()] = new MapIterateKeysHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_ITERATE_ENTRIES.getValue()] = new MapIterateEntriesHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_VALUE_COUNT.getValue()] = new MapValueCountHandler();
        this.clientOperationHandlers[ClusterOperation.TOPIC_PUBLISH.getValue()] = new TopicPublishHandler();
        this.clientOperationHandlers[ClusterOperation.BLOCKING_QUEUE_OFFER.getValue()] = new QueueOfferHandler();
        this.clientOperationHandlers[ClusterOperation.BLOCKING_QUEUE_POLL.getValue()] = new QueuePollHandler();
        this.clientOperationHandlers[ClusterOperation.BLOCKING_QUEUE_REMOVE.getValue()] = new QueueRemoveHandler();
        this.clientOperationHandlers[ClusterOperation.BLOCKING_QUEUE_PEEK.getValue()] = new QueuePeekHandler();
        this.clientOperationHandlers[ClusterOperation.BLOCKING_QUEUE_SIZE.getValue()] = new QueueSizeHandler();
        this.clientOperationHandlers[ClusterOperation.BLOCKING_QUEUE_REMAINING_CAPACITY.getValue()] = new QueueRemainingCapacityHandler();
        this.clientOperationHandlers[ClusterOperation.BLOCKING_QUEUE_ENTRIES.getValue()] = new QueueEntriesHandler();
        this.clientOperationHandlers[ClusterOperation.TRANSACTION_BEGIN.getValue()] = new TransactionBeginHandler();
        this.clientOperationHandlers[ClusterOperation.TRANSACTION_COMMIT.getValue()] = new TransactionCommitHandler();
        this.clientOperationHandlers[ClusterOperation.TRANSACTION_ROLLBACK.getValue()] = new TransactionRollbackHandler();
        this.clientOperationHandlers[ClusterOperation.ADD_LISTENER.getValue()] = new AddListenerHandler();
        this.clientOperationHandlers[ClusterOperation.REMOVE_LISTENER.getValue()] = new RemoveListenerHandler();
        this.clientOperationHandlers[ClusterOperation.REMOTELY_PROCESS.getValue()] = new RemotelyProcessHandler();
        this.clientOperationHandlers[ClusterOperation.DESTROY.getValue()] = new DestroyHandler();
        this.clientOperationHandlers[ClusterOperation.GET_ID.getValue()] = new GetIdHandler();
        this.clientOperationHandlers[ClusterOperation.ADD_INDEX.getValue()] = new AddIndexHandler();
        this.clientOperationHandlers[ClusterOperation.NEW_ID.getValue()] = new NewIdHandler();
        this.clientOperationHandlers[ClusterOperation.EXECUTE.getValue()] = new ExecutorServiceHandler();
        this.clientOperationHandlers[ClusterOperation.CANCEL_EXECUTION.getValue()] = new CancelExecutionHandler();
        this.clientOperationHandlers[ClusterOperation.GET_INSTANCES.getValue()] = new GetInstancesHandler();
        this.clientOperationHandlers[ClusterOperation.GET_MEMBERS.getValue()] = new GetMembersHandler();
        this.clientOperationHandlers[ClusterOperation.GET_CLUSTER_TIME.getValue()] = new GetClusterTimeHandler();
        this.clientOperationHandlers[ClusterOperation.CLIENT_AUTHENTICATE.getValue()] = new ClientAuthenticateHandler();
        this.clientOperationHandlers[ClusterOperation.CLIENT_ADD_INSTANCE_LISTENER.getValue()] = new ClientAddInstanceListenerHandler();
        this.clientOperationHandlers[ClusterOperation.CLIENT_GET_PARTITIONS.getValue()] = new GetPartitionsHandler();
        this.clientOperationHandlers[ClusterOperation.ATOMIC_NUMBER_GET_AND_SET.getValue()] = new AtomicOperationHandler();
        this.clientOperationHandlers[ClusterOperation.ATOMIC_NUMBER_GET_AND_ADD.getValue()] = new AtomicOperationHandler();
        this.clientOperationHandlers[ClusterOperation.ATOMIC_NUMBER_COMPARE_AND_SET.getValue()] = new AtomicOperationHandler();
        this.clientOperationHandlers[ClusterOperation.ATOMIC_NUMBER_ADD_AND_GET.getValue()] = new AtomicOperationHandler();
        node.connectionManager.addConnectionListener(this);
        this.THREAD_COUNT = node.getGroupProperties().EXECUTOR_CLIENT_THREAD_COUNT.getInteger();
        this.workers = new Worker[this.THREAD_COUNT];
        for (int i = 0; i < this.THREAD_COUNT; ++i) {
            this.workers[i] = new Worker();
        }
    }

    public void handle(Packet packet) {
        if (this.firstCall) {
            String threadNamePrefix = this.node.getThreadPoolNamePrefix("client.service");
            for (int i = 0; i < this.THREAD_COUNT; ++i) {
                Worker worker = this.workers[i];
                new Thread(this.node.threadGroup, worker, threadNamePrefix + i).start();
            }
            this.firstCall = false;
        }
        ClientEndpoint clientEndpoint = this.getClientEndpoint(packet.conn);
        CallContext callContext = clientEndpoint.getCallContext(packet.threadId);
        ClientOperationHandler clientOperationHandler = this.clientOperationHandlers[packet.operation.getValue()];
        ClientRequestHandler clientRequestHandler = new ClientRequestHandler(this.node, packet, callContext, clientOperationHandler);
        if (packet.operation == ClusterOperation.CONCURRENT_MAP_UNLOCK) {
            this.node.executorManager.executeNow(clientRequestHandler);
        } else {
            int hash = this.hash(callContext.getThreadId(), this.THREAD_COUNT);
            this.workers[hash].addWork(clientRequestHandler);
        }
    }

    public void shutdown() {
        this.mapClientEndpoints.clear();
        for (Worker worker : this.workers) {
            worker.stop();
        }
    }

    public void restart() {
        for (ListenerManager.ListenerItem listener : this.node.listenerManager.listeners) {
            if (!(listener instanceof ClientListener)) continue;
            this.node.listenerManager.removeListener(listener.name, listener, listener.key);
        }
    }

    private int hash(int id, int maxCount) {
        return id == Integer.MIN_VALUE ? 0 : Math.abs(id) % maxCount;
    }

    public int numberOfConnectedClients() {
        return this.mapClientEndpoints.size();
    }

    public ClientEndpoint getClientEndpoint(Connection conn) {
        ClientEndpoint clientEndpoint = this.mapClientEndpoints.get(conn);
        if (clientEndpoint == null) {
            clientEndpoint = new ClientEndpoint(this.node, conn);
            this.mapClientEndpoints.put(conn, clientEndpoint);
        }
        return clientEndpoint;
    }

    public void connectionAdded(Connection connection) {
    }

    public void connectionRemoved(final Connection connection) {
        final ClientEndpoint clientEndpoint = this.mapClientEndpoints.remove(connection);
        if (clientEndpoint != null) {
            this.node.executorManager.executeNow(new FallThroughRunnable(){

                public void doRun() {
                    clientEndpoint.connectionRemoved(connection);
                }
            });
        }
    }

    private class ClientServiceMembershipListener
    implements MembershipListener {
        private ClientServiceMembershipListener() {
        }

        public void memberAdded(MembershipEvent membershipEvent) {
            this.notifyEndPoints(membershipEvent);
        }

        public void memberRemoved(MembershipEvent membershipEvent) {
            this.notifyEndPoints(membershipEvent);
        }

        void notifyEndPoints(MembershipEvent membershipEvent) {
            for (ClientEndpoint endpoint : ClientService.this.mapClientEndpoints.values()) {
                Packet membershipEventPacket = endpoint.createMembershipEventPacket(membershipEvent);
                endpoint.sendPacket(membershipEventPacket);
            }
        }
    }

    private abstract class ClientTransactionOperationHandler
    extends ClientOperationHandler {
        private ClientTransactionOperationHandler() {
        }

        public abstract void processTransactionOp(Transaction var1);

        public void processCall(Node node, Packet packet) {
            Transaction transaction = node.factory.getTransaction();
            this.processTransactionOp(transaction);
        }
    }

    private abstract class ClientCollectionOperationHandler
    extends ClientOperationHandler {
        private ClientCollectionOperationHandler() {
        }

        public abstract void doMapOp(Node var1, Packet var2);

        public abstract void doListOp(Node var1, Packet var2);

        public abstract void doSetOp(Node var1, Packet var2);

        public abstract void doMultiMapOp(Node var1, Packet var2);

        public abstract void doQueueOp(Node var1, Packet var2);

        public void processCall(Node node, Packet packet) {
            Instance.InstanceType instanceType = BaseManager.getInstanceType(packet.name);
            if (instanceType.equals((Object)Instance.InstanceType.LIST)) {
                this.doListOp(node, packet);
            } else if (instanceType.equals((Object)Instance.InstanceType.SET)) {
                this.doSetOp(node, packet);
            } else if (instanceType.equals((Object)Instance.InstanceType.MAP)) {
                this.doMapOp(node, packet);
            } else if (instanceType.equals((Object)Instance.InstanceType.MULTIMAP)) {
                this.doMultiMapOp(node, packet);
            } else if (instanceType.equals((Object)Instance.InstanceType.QUEUE)) {
                this.doQueueOp(node, packet);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ClientQueueOperationHandler
    extends ClientOperationHandler {
        private ClientQueueOperationHandler() {
        }

        public abstract Data processQueueOp(IQueue<Object> var1, Data var2, Data var3);

        @Override
        public void processCall(Node node, Packet packet) {
            IQueue queue = (IQueue)node.factory.getOrCreateProxyByName(packet.name);
            Data value = this.processQueueOp(queue, packet.getKeyData(), packet.getValueData());
            packet.clearForResponse();
            packet.setValue(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ClientMapOperationHandlerWithTTL
    extends ClientOperationHandler {
        private ClientMapOperationHandlerWithTTL() {
        }

        @Override
        public void processCall(Node node, Packet packet) {
            IMap map = (IMap)node.factory.getOrCreateProxyByName(packet.name);
            long ttl = packet.timeout;
            Data value = this.processMapOp(map, packet.getKeyData(), packet.getValueData(), ttl);
            packet.clearForResponse();
            packet.setValue(value);
        }

        protected abstract Data processMapOp(IMap<Object, Object> var1, Data var2, Data var3, long var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ClientMapOperationHandler
    extends ClientOperationHandler {
        private ClientMapOperationHandler() {
        }

        public abstract Data processMapOp(IMap<Object, Object> var1, Data var2, Data var3);

        @Override
        public void processCall(Node node, Packet packet) {
            IMap map = (IMap)node.factory.getOrCreateProxyByName(packet.name);
            Data value = this.processMapOp(map, packet.getKeyData(), packet.getValueData());
            packet.clearForResponse();
            packet.setValue(value);
        }
    }

    public abstract class ClientOperationHandler {
        public abstract void processCall(Node var1, Packet var2);

        public void handle(Node node, Packet packet) {
            try {
                this.processCall(node, packet);
            }
            catch (RuntimeException e) {
                ClientService.this.logger.log(Level.WARNING, "exception during handling " + (Object)((Object)packet.operation) + ": " + e.getMessage(), e);
                packet.clearForResponse();
                packet.setValue(IOUtil.toData(new ClientServiceException(e)));
            }
            this.sendResponse(packet);
        }

        protected void sendResponse(Packet request) {
            request.lockAddress = null;
            request.operation = ClusterOperation.RESPONSE;
            request.responseType = (byte)3;
            if (request.conn != null && request.conn.live()) {
                request.conn.getWriteHandler().enqueueSocketWritable(request);
            } else {
                ClientService.this.logger.log(Level.WARNING, "unable to send response " + request);
            }
        }
    }

    private class MapItemRemoveHandler
    extends ClientOperationHandler {
        private MapItemRemoveHandler() {
        }

        public void processCall(Node node, Packet packet) {
            Collection collection = (Collection)node.factory.getOrCreateProxyByName(packet.name);
            Data value = IOUtil.toData(collection.remove(packet.getKeyData()));
            packet.clearForResponse();
            packet.setValue(value);
        }
    }

    private class SetAddHandler
    extends ClientOperationHandler {
        private SetAddHandler() {
        }

        public void processCall(Node node, Packet packet) {
            ISet list = (ISet)node.factory.getOrCreateProxyByName(packet.name);
            Boolean value = list.add(packet.getKeyData());
            packet.clearForResponse();
            packet.setValue(IOUtil.toData(value));
        }
    }

    private class ListAddHandler
    extends ClientOperationHandler {
        private ListAddHandler() {
        }

        public void processCall(Node node, Packet packet) {
            IList list = (IList)node.factory.getOrCreateProxyByName(packet.name);
            Boolean value = list.add(packet.getKeyData());
            packet.clearForResponse();
            packet.setValue(IOUtil.toData(value));
        }
    }

    private class RemoveListenerHandler
    extends ClientOperationHandler {
        private RemoveListenerHandler() {
        }

        public void processCall(Node node, Packet packet) {
            ClientEndpoint clientEndpoint = node.clientService.getClientEndpoint(packet.conn);
            if (BaseManager.getInstanceType(packet.name).equals((Object)Instance.InstanceType.MAP)) {
                IMap map = (IMap)node.factory.getOrCreateProxyByName(packet.name);
                clientEndpoint.removeThisListener(map, packet.getKeyData());
            } else if (BaseManager.getInstanceType(packet.name).equals((Object)Instance.InstanceType.TOPIC)) {
                ITopic topic = (ITopic)node.factory.getOrCreateProxyByName(packet.name);
                topic.removeMessageListener(clientEndpoint.messageListeners.remove(topic));
            } else if (BaseManager.getInstanceType(packet.name).equals((Object)Instance.InstanceType.QUEUE)) {
                IQueue queue = (IQueue)node.factory.getOrCreateProxyByName(packet.name);
                queue.removeItemListener(clientEndpoint.queueItemListeners.remove(queue));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ClientMessageListener<T>
    implements MessageListener<T>,
    ClientListener {
        final ClientEndpoint clientEndpoint;
        final String name;

        ClientMessageListener(ClientEndpoint clientEndpoint, String name) {
            this.clientEndpoint = clientEndpoint;
            this.name = name;
        }

        @Override
        public void onMessage(T msg) {
            Packet p = new Packet();
            p.set(this.name, ClusterOperation.EVENT, msg, null);
            this.clientEndpoint.sendPacket(p);
        }
    }

    public class ClientItemListener
    implements ItemListener,
    ClientListener {
        final ClientEndpoint clientEndpoint;
        final String name;

        ClientItemListener(ClientEndpoint clientEndpoint, String name) {
            this.clientEndpoint = clientEndpoint;
            this.name = name;
        }

        public void itemAdded(Object item) {
            Packet p = new Packet();
            p.set(this.name, ClusterOperation.EVENT, item, true);
            this.clientEndpoint.sendPacket(p);
        }

        public void itemRemoved(Object item) {
            Packet p = new Packet();
            p.set(this.name, ClusterOperation.EVENT, item, false);
            this.clientEndpoint.sendPacket(p);
        }
    }

    public static interface ClientListener {
    }

    private class AddListenerHandler
    extends ClientOperationHandler {
        private AddListenerHandler() {
        }

        public void processCall(Node node, Packet packet) {
            boolean includeValue;
            ClientEndpoint clientEndpoint = node.clientService.getClientEndpoint(packet.conn);
            boolean bl = includeValue = (int)packet.longValue == 1;
            if (BaseManager.getInstanceType(packet.name).equals((Object)Instance.InstanceType.MAP)) {
                IMap map = (IMap)node.factory.getOrCreateProxyByName(packet.name);
                clientEndpoint.addThisAsListener(map, packet.getKeyData(), includeValue);
            } else if (BaseManager.getInstanceType(packet.name).equals((Object)Instance.InstanceType.LIST) || BaseManager.getInstanceType(packet.name).equals((Object)Instance.InstanceType.SET)) {
                FactoryImpl.CollectionProxyImpl collectionProxy = (FactoryImpl.CollectionProxyImpl)node.factory.getOrCreateProxyByName(packet.name);
                MProxy map = ((FactoryImpl.CollectionProxyImpl.CollectionProxyReal)collectionProxy.getBase()).mapProxy;
                clientEndpoint.addThisAsListener(map, null, includeValue);
            } else if (BaseManager.getInstanceType(packet.name).equals((Object)Instance.InstanceType.QUEUE)) {
                IQueue queue = (IQueue)node.factory.getOrCreateProxyByName(packet.name);
                String packetName = packet.name;
                ClientItemListener itemListener = new ClientItemListener(clientEndpoint, packetName);
                queue.addItemListener(itemListener, includeValue);
                clientEndpoint.queueItemListeners.put(queue, itemListener);
            } else if (BaseManager.getInstanceType(packet.name).equals((Object)Instance.InstanceType.TOPIC)) {
                ITopic topic = (ITopic)node.factory.getOrCreateProxyByName(packet.name);
                String packetName = packet.name;
                ClientMessageListener messageListener = new ClientMessageListener(clientEndpoint, packetName);
                topic.addMessageListener(messageListener);
                clientEndpoint.messageListeners.put(topic, messageListener);
            }
            packet.clearForResponse();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapIterateKeysHandler
    extends ClientCollectionOperationHandler {
        private MapIterateKeysHandler() {
        }

        public Data getMapKeys(IMap<Object, Object> map, Data key, Data value, Collection<Data> collection) {
            ConcurrentMapManager.Entries entries = null;
            if (value == null) {
                entries = (ConcurrentMapManager.Entries)map.keySet();
            } else {
                Predicate p = (Predicate)IOUtil.toObject(value);
                entries = (ConcurrentMapManager.Entries)map.keySet(p);
            }
            List<Map.Entry> list = entries.getKeyValues();
            Keys keys = new Keys(collection);
            for (Map.Entry obj : list) {
                KeyValue entry = (KeyValue)obj;
                keys.add(entry.getKeyData());
            }
            return IOUtil.toData(keys);
        }

        @Override
        public void doListOp(Node node, Packet packet) {
            FactoryImpl.CollectionProxyImpl collectionProxy = (FactoryImpl.CollectionProxyImpl)node.factory.getOrCreateProxyByName(packet.name);
            MProxy mapProxy = ((FactoryImpl.CollectionProxyImpl.CollectionProxyReal)collectionProxy.getBase()).mapProxy;
            packet.setValue(this.getMapKeys(mapProxy, packet.getKeyData(), packet.getValueData(), new ArrayList<Data>()));
        }

        @Override
        public void doMapOp(Node node, Packet packet) {
            packet.setValue(this.getMapKeys((IMap)node.factory.getOrCreateProxyByName(packet.name), packet.getKeyData(), packet.getValueData(), new HashSet<Data>()));
        }

        @Override
        public void doSetOp(Node node, Packet packet) {
            FactoryImpl.CollectionProxyImpl collectionProxy = (FactoryImpl.CollectionProxyImpl)node.factory.getOrCreateProxyByName(packet.name);
            MProxy mapProxy = ((FactoryImpl.CollectionProxyImpl.CollectionProxyReal)collectionProxy.getBase()).mapProxy;
            packet.setValue(this.getMapKeys(mapProxy, packet.getKeyData(), packet.getValueData(), new HashSet<Data>()));
        }

        @Override
        public void doMultiMapOp(Node node, Packet packet) {
            FactoryImpl.MultiMapProxyImpl multiMapImpl = (FactoryImpl.MultiMapProxyImpl)node.factory.getOrCreateProxyByName(packet.name);
            FactoryImpl.MultiMapProxyImpl.MultiMapReal real = multiMapImpl.getBase();
            MProxy mapProxy = real.mapProxy;
            Data value = this.getMapKeys(mapProxy, packet.getKeyData(), packet.getValueData(), new HashSet<Data>());
            packet.clearForResponse();
            packet.setValue(value);
        }

        @Override
        public void doQueueOp(Node node, Packet packet) {
            IQueue queue = (IQueue)node.factory.getOrCreateProxyByName(packet.name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapIterateEntriesHandler
    extends ClientCollectionOperationHandler {
        private MapIterateEntriesHandler() {
        }

        public Data getMapKeys(IMap<Object, Object> map, Data key, Data value) {
            ConcurrentMapManager.Entries entries = null;
            if (value == null) {
                entries = (ConcurrentMapManager.Entries)map.entrySet();
            } else {
                Predicate p = (Predicate)IOUtil.toObject(value);
                entries = (ConcurrentMapManager.Entries)map.entrySet(p);
            }
            List<Map.Entry> list = entries.getKeyValues();
            Keys keys = new Keys(new ArrayList<Data>(list.size() << 1));
            for (Map.Entry obj : list) {
                KeyValue entry = (KeyValue)obj;
                keys.add(IOUtil.toData(entry));
            }
            return IOUtil.toData(keys);
        }

        @Override
        public void doListOp(Node node, Packet packet) {
            FactoryImpl.CollectionProxyImpl collectionProxy = (FactoryImpl.CollectionProxyImpl)node.factory.getOrCreateProxyByName(packet.name);
            MProxy mapProxy = ((FactoryImpl.CollectionProxyImpl.CollectionProxyReal)collectionProxy.getBase()).mapProxy;
            packet.setValue(this.getMapKeys(mapProxy, packet.getKeyData(), packet.getValueData()));
        }

        @Override
        public void doMapOp(Node node, Packet packet) {
            packet.setValue(this.getMapKeys((IMap)node.factory.getOrCreateProxyByName(packet.name), packet.getKeyData(), packet.getValueData()));
        }

        @Override
        public void doSetOp(Node node, Packet packet) {
            FactoryImpl.CollectionProxyImpl collectionProxy = (FactoryImpl.CollectionProxyImpl)node.factory.getOrCreateProxyByName(packet.name);
            MProxy mapProxy = ((FactoryImpl.CollectionProxyImpl.CollectionProxyReal)collectionProxy.getBase()).mapProxy;
            packet.setValue(this.getMapKeys(mapProxy, packet.getKeyData(), packet.getValueData()));
        }

        @Override
        public void doMultiMapOp(Node node, Packet packet) {
            FactoryImpl.MultiMapProxyImpl multiMapImpl = (FactoryImpl.MultiMapProxyImpl)node.factory.getOrCreateProxyByName(packet.name);
            FactoryImpl.MultiMapProxyImpl.MultiMapReal real = multiMapImpl.getBase();
            MProxy mapProxy = real.mapProxy;
            Data value = this.getMapKeys(mapProxy, packet.getKeyData(), packet.getValueData());
            packet.clearForResponse();
            packet.setValue(value);
        }

        @Override
        public void doQueueOp(Node node, Packet packet) {
            IQueue queue = (IQueue)node.factory.getOrCreateProxyByName(packet.name);
        }
    }

    private class TransactionRollbackHandler
    extends ClientTransactionOperationHandler {
        private TransactionRollbackHandler() {
        }

        public void processTransactionOp(Transaction transaction) {
            transaction.rollback();
        }
    }

    private class TransactionCommitHandler
    extends ClientTransactionOperationHandler {
        private TransactionCommitHandler() {
        }

        public void processTransactionOp(Transaction transaction) {
            transaction.commit();
        }
    }

    private class TransactionBeginHandler
    extends ClientTransactionOperationHandler {
        private TransactionBeginHandler() {
        }

        public void processTransactionOp(Transaction transaction) {
            transaction.begin();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapUnlockMapHandler
    extends ClientMapOperationHandler {
        private MapUnlockMapHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            map.unlockMap();
            return null;
        }

        @Override
        public void processCall(Node node, Packet packet) {
            IMap map = (IMap)node.factory.getOrCreateProxyByName(packet.name);
            Data value = this.processMapOp(map, packet.getKeyData(), packet.getValueData());
            ClientEndpoint clientEndpoint = node.clientService.getClientEndpoint(packet.conn);
            clientEndpoint.unlocked(map, packet.getKeyData(), packet.threadId);
            packet.clearForResponse();
            packet.setValue(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapLockMapHandler
    extends ClientMapOperationHandler {
        private MapLockMapHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            throw new RuntimeException("Shouldn't invoke this method");
        }

        @Override
        public void processCall(Node node, Packet packet) {
            IMap map = (IMap)node.factory.getOrCreateProxyByName(packet.name);
            long timeout = packet.timeout;
            Data value = IOUtil.toData(map.lockMap(timeout, (TimeUnit)((Object)IOUtil.toObject(packet.getValueData()))));
            packet.setValue(value);
            ClientEndpoint clientEndpoint = node.clientService.getClientEndpoint(packet.conn);
            clientEndpoint.locked(map, packet.getKeyData(), packet.threadId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapUnlockHandler
    extends ClientMapOperationHandler {
        private MapUnlockHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            map.unlock(key);
            return null;
        }

        @Override
        public void processCall(Node node, Packet packet) {
            Instance.InstanceType type = BaseManager.getInstanceType(packet.name);
            IMap map = null;
            if (type == Instance.InstanceType.MAP) {
                map = (IMap)node.factory.getOrCreateProxyByName(packet.name);
            } else {
                MultiMapProxy multiMapProxy = (MultiMapProxy)node.factory.getOrCreateProxyByName(packet.name);
                map = multiMapProxy.getMProxy();
            }
            Data value = this.processMapOp(map, packet.getKeyData(), packet.getValueData());
            ClientEndpoint clientEndpoint = node.clientService.getClientEndpoint(packet.conn);
            clientEndpoint.unlocked(map, packet.getKeyData(), packet.threadId);
            packet.clearForResponse();
            packet.setValue(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapLockHandler
    extends ClientMapOperationHandler {
        private MapLockHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            throw new RuntimeException("Shouldn't invoke this method");
        }

        @Override
        public void processCall(Node node, Packet packet) {
            Instance.InstanceType type = BaseManager.getInstanceType(packet.name);
            long timeout = packet.timeout;
            Data value = null;
            IMap map = null;
            if (type == Instance.InstanceType.MAP) {
                map = (IMap)node.factory.getOrCreateProxyByName(packet.name);
            } else {
                MultiMapProxy multiMapProxy = (MultiMapProxy)node.factory.getOrCreateProxyByName(packet.name);
                map = multiMapProxy.getMProxy();
            }
            if (timeout == -1L) {
                map.lock(packet.getKeyData());
                value = null;
            } else {
                value = timeout == 0L ? IOUtil.toData(map.tryLock(packet.getKeyData())) : IOUtil.toData(map.tryLock(packet.getKeyData(), timeout, (TimeUnit)((Object)IOUtil.toObject(packet.getValueData()))));
            }
            packet.setValue(value);
            ClientEndpoint clientEndpoint = node.clientService.getClientEndpoint(packet.conn);
            clientEndpoint.locked(map, packet.getKeyData(), packet.threadId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetMapEntryHandler
    extends ClientMapOperationHandler {
        private GetMapEntryHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            return IOUtil.toData(map.getMapEntry(key));
        }
    }

    private class MapSizeHandler
    extends ClientCollectionOperationHandler {
        private MapSizeHandler() {
        }

        public void doListOp(Node node, Packet packet) {
            IList list = (IList)node.factory.getOrCreateProxyByName(packet.name);
            packet.setValue(IOUtil.toData(list.size()));
        }

        public void doMapOp(Node node, Packet packet) {
            IMap map = (IMap)node.factory.getOrCreateProxyByName(packet.name);
            packet.setValue(IOUtil.toData(map.size()));
        }

        public void doSetOp(Node node, Packet packet) {
            ISet set = (ISet)node.factory.getOrCreateProxyByName(packet.name);
            packet.setValue(IOUtil.toData(set.size()));
        }

        public void doMultiMapOp(Node node, Packet packet) {
            MultiMap multiMap = (MultiMap)node.factory.getOrCreateProxyByName(packet.name);
            packet.setValue(IOUtil.toData(multiMap.size()));
        }

        public void doQueueOp(Node node, Packet packet) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapContainsValueHandler
    extends ClientOperationHandler {
        private MapContainsValueHandler() {
        }

        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            return IOUtil.toData(map.containsValue(value));
        }

        @Override
        public void processCall(Node node, Packet packet) {
            Instance.InstanceType instanceType = BaseManager.getInstanceType(packet.name);
            if (instanceType.equals((Object)Instance.InstanceType.MAP)) {
                IMap map = (IMap)node.factory.getOrCreateProxyByName(packet.name);
                packet.setValue(IOUtil.toData(map.containsValue(packet.getValueData())));
            } else if (instanceType.equals((Object)Instance.InstanceType.MULTIMAP)) {
                MultiMap multiMap = (MultiMap)node.factory.getOrCreateProxyByName(packet.name);
                if (packet.getKeyData() != null && packet.getKeyData().size() > 0) {
                    packet.setValue(IOUtil.toData(multiMap.containsEntry(packet.getKeyData(), packet.getValueData())));
                } else {
                    packet.setValue(IOUtil.toData(multiMap.containsValue(packet.getValueData())));
                }
            }
        }
    }

    private class MapContainsHandler
    extends ClientOperationHandler {
        private MapContainsHandler() {
        }

        public void processCall(Node node, Packet packet) {
            Instance.InstanceType instanceType = BaseManager.getInstanceType(packet.name);
            if (instanceType.equals((Object)Instance.InstanceType.MAP)) {
                IMap map = (IMap)node.factory.getOrCreateProxyByName(packet.name);
                packet.setValue(IOUtil.toData(map.containsKey(packet.getKeyData())));
            } else if (instanceType.equals((Object)Instance.InstanceType.LIST) || instanceType.equals((Object)Instance.InstanceType.SET)) {
                Collection collection = (Collection)node.factory.getOrCreateProxyByName(packet.name);
                packet.setValue(IOUtil.toData(collection.contains(packet.getKeyData())));
            } else if (instanceType.equals((Object)Instance.InstanceType.MULTIMAP)) {
                MultiMap multiMap = (MultiMap)node.factory.getOrCreateProxyByName(packet.name);
                packet.setValue(IOUtil.toData(multiMap.containsKey(packet.getKeyData())));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapReplaceIfSameHandler
    extends ClientMapOperationHandler {
        private MapReplaceIfSameHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            Object[] arr = (Object[])IOUtil.toObject(value);
            return IOUtil.toData(map.replace(key, arr[0], arr[1]));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapReplaceIfNotNullHandler
    extends ClientMapOperationHandler {
        private MapReplaceIfNotNullHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            return (Data)map.replace(key, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapFlushHandler
    extends ClientMapOperationHandler {
        private MapFlushHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            map.flush();
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapEvictHandler
    extends ClientMapOperationHandler {
        private MapEvictHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            return IOUtil.toData(map.evict(key));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapRemoveIfSameHandler
    extends ClientMapOperationHandler {
        private MapRemoveIfSameHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            return IOUtil.toData(map.remove(key, value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapRemoveHandler
    extends ClientMapOperationHandler {
        private MapRemoveHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            return (Data)map.remove(key);
        }
    }

    private class MapGetHandler
    extends ClientOperationHandler {
        private MapGetHandler() {
        }

        public void processCall(Node node, Packet packet) {
            Instance.InstanceType instanceType = BaseManager.getInstanceType(packet.name);
            Data key = packet.getKeyData();
            if (instanceType == Instance.InstanceType.MAP) {
                IMap map = (IMap)node.factory.getOrCreateProxyByName(packet.name);
                packet.setKey(null);
                packet.setValue((Data)map.get(key));
            } else if (instanceType == Instance.InstanceType.MULTIMAP) {
                FactoryImpl.MultiMapProxyImpl multiMapImpl = (FactoryImpl.MultiMapProxyImpl)node.factory.getOrCreateProxyByName(packet.name);
                FactoryImpl.MultiMapProxyImpl.MultiMapReal real = multiMapImpl.getBase();
                MProxy mapProxy = real.mapProxy;
                packet.setKey(null);
                packet.setValue((Data)mapProxy.get(key));
            }
        }
    }

    private class MapGetAllHandler
    extends ClientOperationHandler {
        private MapGetAllHandler() {
        }

        public void processCall(Node node, Packet packet) {
            Keys keys = (Keys)IOUtil.toObject(packet.getKeyData());
            Pairs pairs = node.concurrentMapManager.getAllPairs(packet.name, keys);
            packet.clearForResponse();
            packet.setValue(IOUtil.toData(pairs));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapPutIfAbsentHandler
    extends ClientOperationHandler {
        private MapPutIfAbsentHandler() {
        }

        public Data processMapOp(IMap<Object, Object> map, Data key, Data value, long ttl) {
            MProxy mproxy = (MProxy)map;
            Object v = value;
            if (((ClientService)ClientService.this).node.concurrentMapManager.isMapIndexed(mproxy.getLongName())) {
                v = IOUtil.toObject(value);
            }
            if (ttl <= 0L) {
                return (Data)map.putIfAbsent(key, v);
            }
            return (Data)map.putIfAbsent(key, v, ttl, TimeUnit.MILLISECONDS);
        }

        @Override
        public void processCall(Node node, Packet packet) {
            IMap map = (IMap)node.factory.getOrCreateProxyByName(packet.name);
            long ttl = packet.timeout;
            Data value = this.processMapOp(map, packet.getKeyData(), packet.getValueData(), ttl);
            packet.clearForResponse();
            packet.setValue(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapTryLockAndGetHandler
    extends ClientMapOperationHandlerWithTTL {
        private MapTryLockAndGetHandler() {
        }

        @Override
        protected Data processMapOp(IMap<Object, Object> map, Data key, Data value, long ttl) {
            try {
                return IOUtil.toData(map.tryLockAndGet(key, ttl, TimeUnit.MILLISECONDS));
            }
            catch (TimeoutException e) {
                return IOUtil.toData(new DistributedTimeoutException());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapTryRemoveHandler
    extends ClientMapOperationHandlerWithTTL {
        private MapTryRemoveHandler() {
        }

        @Override
        protected Data processMapOp(IMap<Object, Object> map, Data key, Data value, long ttl) {
            try {
                return IOUtil.toData(map.tryRemove(key, ttl, TimeUnit.MILLISECONDS));
            }
            catch (TimeoutException e) {
                return IOUtil.toData(new DistributedTimeoutException());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapPutAndUnlockHandler
    extends ClientMapOperationHandlerWithTTL {
        private MapPutAndUnlockHandler() {
        }

        @Override
        protected Data processMapOp(IMap<Object, Object> map, Data key, Data value, long ttl) {
            MProxy mproxy = (MProxy)map;
            Object v = value;
            if (((ClientService)ClientService.this).node.concurrentMapManager.isMapIndexed(mproxy.getLongName())) {
                v = IOUtil.toObject(value);
            }
            map.putAndUnlock(key, v);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapTryPutHandler
    extends ClientMapOperationHandlerWithTTL {
        private MapTryPutHandler() {
        }

        @Override
        protected Data processMapOp(IMap<Object, Object> map, Data key, Data value, long ttl) {
            MProxy mproxy = (MProxy)map;
            Object v = value;
            if (((ClientService)ClientService.this).node.concurrentMapManager.isMapIndexed(mproxy.getLongName())) {
                v = IOUtil.toObject(value);
            }
            return IOUtil.toData(map.tryPut(key, v, ttl, TimeUnit.MILLISECONDS));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapPutHandler
    extends ClientMapOperationHandlerWithTTL {
        private MapPutHandler() {
        }

        @Override
        protected Data processMapOp(IMap<Object, Object> map, Data key, Data value, long ttl) {
            MProxy mproxy = (MProxy)map;
            Object v = value;
            if (((ClientService)ClientService.this).node.concurrentMapManager.isMapIndexed(mproxy.getLongName())) {
                v = IOUtil.toObject(value);
            }
            if (ttl <= 0L) {
                return (Data)map.put(key, v);
            }
            return (Data)map.put(key, v, ttl, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapPutAllHandler
    extends ClientMapOperationHandler {
        private MapPutAllHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> imap, Data key, Data value) {
            MProxy mproxy = (MProxy)imap;
            Pairs pairs = (Pairs)IOUtil.toObject(value);
            try {
                ((ClientService)ClientService.this).node.concurrentMapManager.doPutAll(mproxy.getLongName(), pairs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AddIndexHandler
    extends ClientMapOperationHandler {
        private AddIndexHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            map.addIndex((String)IOUtil.toObject(key), (boolean)((Boolean)IOUtil.toObject(value)));
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetIdHandler
    extends ClientMapOperationHandler {
        private GetIdHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            return IOUtil.toData(map.getId());
        }
    }

    private class ClientAddInstanceListenerHandler
    extends ClientOperationHandler {
        private ClientAddInstanceListenerHandler() {
        }

        public void processCall(Node node, Packet packet) {
            ClientEndpoint endPoint = ClientService.this.getClientEndpoint(packet.conn);
            node.factory.addInstanceListener(endPoint);
        }
    }

    private class ClientAuthenticateHandler
    extends ClientOperationHandler {
        private ClientAuthenticateHandler() {
        }

        public void processCall(Node node, Packet packet) {
            String nodeGroupName = node.factory.getConfig().getGroupConfig().getName();
            String nodeGroupPassword = node.factory.getConfig().getGroupConfig().getPassword();
            Object groupName = IOUtil.toObject(packet.getKeyData());
            Object groupPassword = IOUtil.toObject(packet.getValueData());
            boolean authenticated = nodeGroupName.equals(groupName) && nodeGroupPassword.equals(groupPassword);
            ClientService.this.logger.log(authenticated ? Level.INFO : Level.WARNING, "received auth from " + packet.conn + ", this group name:" + nodeGroupName + ", auth group name:" + groupName + ", " + (authenticated ? "successfully authenticated" : "authentication failed"));
            packet.clearForResponse();
            packet.setValue(IOUtil.toData(authenticated));
        }
    }

    private class GetClusterTimeHandler
    extends ClientOperationHandler {
        private GetClusterTimeHandler() {
        }

        public void processCall(Node node, Packet packet) {
            ClusterImpl cluster = node.factory.getCluster();
            long clusterTime = cluster.getClusterTime();
            packet.setValue(IOUtil.toData(clusterTime));
        }
    }

    public static class PartitionImpl
    implements Partition,
    HazelcastInstanceAware,
    DataSerializable,
    Comparable {
        int partitionId;
        MemberImpl owner;

        PartitionImpl(int partitionId, MemberImpl owner) {
            this.partitionId = partitionId;
            this.owner = owner;
        }

        public PartitionImpl() {
        }

        public int getPartitionId() {
            return this.partitionId;
        }

        public Member getOwner() {
            return this.owner;
        }

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            if (this.owner != null) {
                this.owner.setHazelcastInstance(hazelcastInstance);
            }
        }

        public void writeData(DataOutput out) throws IOException {
            out.writeInt(this.partitionId);
            boolean hasOwner = this.owner != null;
            out.writeBoolean(hasOwner);
            if (hasOwner) {
                this.owner.writeData(out);
            }
        }

        public void readData(DataInput in) throws IOException {
            this.partitionId = in.readInt();
            boolean hasOwner = in.readBoolean();
            if (hasOwner) {
                this.owner = new MemberImpl();
                this.owner.readData(in);
            }
        }

        public int compareTo(Object o) {
            PartitionImpl partition = (PartitionImpl)o;
            Integer id = this.partitionId;
            return id.compareTo(partition.getPartitionId());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionImpl partition = (PartitionImpl)o;
            return this.partitionId == partition.partitionId;
        }

        public int hashCode() {
            return this.partitionId;
        }

        public String toString() {
            return "Partition [" + this.partitionId + "], owner=" + this.owner;
        }
    }

    private class AtomicOperationHandler
    extends ClientOperationHandler {
        private AtomicOperationHandler() {
        }

        public void processCall(Node node, Packet packet) {
            Serializable result;
            String name = packet.name;
            AtomicNumber atomicNumber = node.factory.getAtomicNumber(name);
            switch (packet.operation) {
                case ATOMIC_NUMBER_GET_AND_SET: {
                    result = atomicNumber.getAndSet(packet.longValue);
                    break;
                }
                case ATOMIC_NUMBER_GET_AND_ADD: {
                    result = atomicNumber.getAndAdd(packet.longValue);
                    break;
                }
                case ATOMIC_NUMBER_COMPARE_AND_SET: {
                    Long expected = (Long)IOUtil.toObject(packet.getKey());
                    Long update = (Long)IOUtil.toObject(packet.getValue());
                    result = Boolean.valueOf(atomicNumber.compareAndSet(expected, update));
                    break;
                }
                case ATOMIC_NUMBER_ADD_AND_GET: {
                    result = atomicNumber.addAndGet(packet.longValue);
                    break;
                }
                default: {
                    ClientService.this.logger.log(Level.WARNING, "operation " + (Object)((Object)packet.operation) + " is unsupported.");
                    result = new UnsupportedOperationException("operation " + (Object)((Object)packet.operation) + " is unsupported.");
                }
            }
            packet.setValue(IOUtil.toData(result));
        }
    }

    private class GetPartitionsHandler
    extends ClientOperationHandler {
        private GetPartitionsHandler() {
        }

        public void processCall(Node node, Packet packet) {
            PartitionService partitionService = node.factory.getPartitionService();
            if (packet.getKeyData() != null && packet.getKeyData().size() > 0) {
                Object key = IOUtil.toObject(packet.getKeyData());
                Partition partition = partitionService.getPartition(key);
                Data value = IOUtil.toData(new PartitionImpl(partition.getPartitionId(), (MemberImpl)partition.getOwner()));
                packet.setValue(value);
            } else {
                Set<Partition> partitions = partitionService.getPartitions();
                LinkedHashSet<Data> setData = new LinkedHashSet<Data>();
                for (Partition partition : partitions) {
                    setData.add(IOUtil.toData(new PartitionImpl(partition.getPartitionId(), (MemberImpl)partition.getOwner())));
                }
                Keys keys = new Keys(setData);
                packet.setValue(IOUtil.toData(keys));
            }
        }
    }

    private class GetMembersHandler
    extends ClientOperationHandler {
        private GetMembersHandler() {
        }

        public void processCall(Node node, Packet packet) {
            ClusterImpl cluster = node.factory.getCluster();
            Set<Member> members = cluster.getMembers();
            LinkedHashSet<Data> setData = new LinkedHashSet<Data>();
            if (members != null) {
                for (Member member : members) {
                    setData.add(IOUtil.toData(member));
                }
                Keys keys = new Keys(setData);
                packet.setValue(IOUtil.toData(keys));
            }
        }
    }

    private class GetInstancesHandler
    extends ClientOperationHandler {
        private GetInstancesHandler() {
        }

        public void processCall(Node node, Packet packet) {
            Collection<Instance> instances = node.factory.getInstances();
            Object[] instanceIds = new Object[instances.size()];
            int counter = 0;
            for (Instance instance : instances) {
                Object key;
                Object id = instance.getId();
                if (id instanceof FactoryImpl.ProxyKey && (key = ((FactoryImpl.ProxyKey)id).getKey()) instanceof Instance) {
                    id = key.toString();
                }
                instanceIds[counter] = id;
                ++counter;
            }
            packet.setValue(IOUtil.toData(instanceIds));
        }
    }

    private class ExecutorServiceHandler
    extends ClientOperationHandler {
        private ExecutorServiceHandler() {
        }

        public void processCall(Node node, Packet packet) {
        }

        public final void handle(Node node, final Packet packet) {
            try {
                String name = packet.name;
                ExecutorService executorService = node.factory.getExecutorService(name);
                ClientDistributedTask cdt = (ClientDistributedTask)IOUtil.toObject(packet.getKeyData());
                DistributedTask task = cdt.getKey() != null ? new DistributedTask(cdt.getCallable(), cdt.getKey()) : (cdt.getMember() != null ? new DistributedTask(cdt.getCallable(), cdt.getMember()) : (cdt.getMembers() != null ? new MultiTask(cdt.getCallable(), cdt.getMembers()) : new DistributedTask(cdt.getCallable())));
                final ClientEndpoint clientEndpoint = ClientService.this.getClientEndpoint(packet.conn);
                clientEndpoint.storeTask(packet.callId, task);
                task.setExecutionCallback(new ExecutionCallback(){

                    public void done(Future future) {
                        try {
                            clientEndpoint.removeTask(packet.callId);
                            Object result = future.get();
                            packet.setValue(IOUtil.toData(result));
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        catch (CancellationException e) {
                            packet.setValue(IOUtil.toData(e));
                        }
                        catch (ExecutionException e) {
                            packet.setValue(IOUtil.toData(e));
                        }
                        ExecutorServiceHandler.this.sendResponse(packet);
                    }
                });
                executorService.execute(task);
            }
            catch (RuntimeException e) {
                ClientService.this.logger.log(Level.WARNING, "exception during handling " + (Object)((Object)packet.operation) + ": " + e.getMessage(), e);
                packet.clearForResponse();
                packet.setValue(IOUtil.toData(e));
            }
        }
    }

    private class CancelExecutionHandler
    extends ClientOperationHandler {
        private CancelExecutionHandler() {
        }

        public void processCall(Node node, Packet packet) {
            long taskId = (Long)IOUtil.toObject(packet.getKeyData());
            boolean mayInterruptIfRunning = (Boolean)IOUtil.toObject(packet.getValue());
            ClientEndpoint thisEndPoint = ClientService.this.getClientEndpoint(packet.conn);
            DistributedTask task = thisEndPoint.getTask(taskId);
            boolean cancelled = task.cancel(mayInterruptIfRunning);
            if (cancelled) {
                thisEndPoint.removeTask(taskId);
            }
            packet.setValue(IOUtil.toData(cancelled));
        }
    }

    private class MapRemoveMultiHandler
    extends ClientOperationHandler {
        private MapRemoveMultiHandler() {
        }

        public void processCall(Node node, Packet packet) {
            MultiMap multiMap = (MultiMap)node.factory.getOrCreateProxyByName(packet.name);
            if (packet.getValueData() == null || packet.getValueData().size() == 0) {
                FactoryImpl.MultiMapProxyImpl mmProxyImpl = (FactoryImpl.MultiMapProxyImpl)multiMap;
                FactoryImpl.MultiMapProxyImpl.MultiMapReal real = mmProxyImpl.getBase();
                MProxy mapProxy = real.mapProxy;
                packet.setValue((Data)mapProxy.remove(packet.getKeyData()));
            } else {
                packet.setValue(IOUtil.toData(multiMap.remove(packet.getKeyData(), packet.getValueData())));
            }
        }
    }

    private class MapValueCountHandler
    extends ClientOperationHandler {
        private MapValueCountHandler() {
        }

        public void processCall(Node node, Packet packet) {
            MultiMap multiMap = (MultiMap)node.factory.getOrCreateProxyByName(packet.name);
            packet.setValue(IOUtil.toData(multiMap.valueCount(packet.getKeyData())));
        }
    }

    private class MapPutMultiHandler
    extends ClientOperationHandler {
        private MapPutMultiHandler() {
        }

        public void processCall(Node node, Packet packet) {
            MultiMap multiMap = (MultiMap)node.factory.getOrCreateProxyByName(packet.name);
            packet.setValue(IOUtil.toData(multiMap.put(packet.getKeyData(), packet.getValueData())));
        }
    }

    private class NewIdHandler
    extends ClientOperationHandler {
        private NewIdHandler() {
        }

        public void processCall(Node node, Packet packet) {
            IdGenerator idGen = (IdGenerator)node.factory.getOrCreateProxyByName(packet.name);
            packet.setValue(IOUtil.toData(idGen.newId()));
        }
    }

    private class DestroyHandler
    extends ClientOperationHandler {
        private DestroyHandler() {
        }

        public void processCall(Node node, Packet packet) {
            Instance instance = (Instance)node.factory.getOrCreateProxyByName(packet.name);
            instance.destroy();
        }
    }

    private class RemotelyProcessHandler
    extends ClientOperationHandler {
        private RemotelyProcessHandler() {
        }

        public void processCall(Node node, Packet packet) {
            node.clusterService.enqueuePacket(packet);
        }

        protected void sendResponse(Packet request) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueEntriesHandler
    extends ClientQueueOperationHandler {
        private QueueEntriesHandler() {
        }

        @Override
        public Data processQueueOp(IQueue<Object> queue, Data key, Data value) {
            Object[] array = queue.toArray();
            return IOUtil.toData(array);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueRemainingCapacityHandler
    extends ClientQueueOperationHandler {
        private QueueRemainingCapacityHandler() {
        }

        @Override
        public Data processQueueOp(IQueue<Object> queue, Data key, Data value) {
            return IOUtil.toData(queue.remainingCapacity());
        }
    }

    private class TopicPublishHandler
    extends ClientOperationHandler {
        private TopicPublishHandler() {
        }

        public void processCall(Node node, Packet packet) {
            ITopic topic = (ITopic)node.factory.getOrCreateProxyByName(packet.name);
            topic.publish(packet.getKeyData());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueSizeHandler
    extends ClientQueueOperationHandler {
        private QueueSizeHandler() {
        }

        @Override
        public Data processQueueOp(IQueue<Object> queue, Data key, Data value) {
            return IOUtil.toData(queue.size());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueuePeekHandler
    extends ClientQueueOperationHandler {
        private QueuePeekHandler() {
        }

        @Override
        public Data processQueueOp(IQueue<Object> queue, Data key, Data value) {
            return (Data)queue.peek();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueRemoveHandler
    extends ClientQueueOperationHandler {
        private QueueRemoveHandler() {
        }

        @Override
        public Data processQueueOp(IQueue<Object> queue, Data key, Data value) {
            if (value != null) {
                return IOUtil.toData(queue.remove(value));
            }
            return (Data)queue.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueuePollHandler
    extends ClientQueueOperationHandler {
        private QueuePollHandler() {
        }

        @Override
        public Data processQueueOp(IQueue<Object> queue, Data key, Data value) {
            try {
                long millis = (Long)IOUtil.toObject(value);
                if (millis == -1L) {
                    return (Data)queue.take();
                }
                if (millis == 0L) {
                    return (Data)queue.poll();
                }
                return (Data)queue.poll(millis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueOfferHandler
    extends ClientQueueOperationHandler {
        private QueueOfferHandler() {
        }

        @Override
        public Data processQueueOp(IQueue<Object> queue, Data key, Data value) {
            long millis = (Long)IOUtil.toObject(value);
            try {
                if (millis == -1L) {
                    queue.put(key);
                    return IOUtil.toData(true);
                }
                if (millis == 0L) {
                    return IOUtil.toData(queue.offer(key));
                }
                return IOUtil.toData(queue.offer(key, (Long)IOUtil.toObject(value), TimeUnit.MILLISECONDS));
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
        }
    }

    class Worker
    implements Runnable {
        private final BlockingQueue<Runnable> q = new LinkedBlockingQueue<Runnable>();
        private volatile boolean active = true;

        Worker() {
        }

        public void run() {
            while (this.active) {
                try {
                    this.q.take().run();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        public void stop() {
            this.active = false;
            this.q.offer(new Runnable(){

                public void run() {
                }
            });
        }

        public void addWork(Runnable runnable) {
            this.q.offer(runnable);
        }
    }
}

