/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.JoinRequest;
import com.hazelcast.config.Config;
import com.hazelcast.impl.NodeType;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.DataSerializable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;

public class JoinInfo
extends JoinRequest
implements DataSerializable {
    private boolean request = true;
    private int memberCount = 0;

    public JoinInfo() {
    }

    public JoinInfo(boolean request, Address address, Config config, NodeType type, byte packetVersion, int buildNumber, int memberCount) {
        super(address, config, type, packetVersion, buildNumber);
        this.request = request;
        this.memberCount = memberCount;
    }

    public JoinInfo copy(boolean newRequest, Address newAddress) {
        return new JoinInfo(newRequest, newAddress, this.config, this.nodeType, this.packetVersion, this.buildNumber, this.memberCount);
    }

    public void readData(DataInput dis) throws IOException {
        super.readData(dis);
        this.request = dis.readBoolean();
        this.memberCount = dis.readInt();
    }

    public void writeData(DataOutput out) throws IOException {
        try {
            super.writeData(out);
            out.writeBoolean(this.isRequest());
            out.writeInt(this.memberCount);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToPacket(DatagramPacket packet) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            this.writeData(dos);
            dos.flush();
            packet.setData(bos.toByteArray());
            packet.setLength(bos.size());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readFromPacket(DatagramPacket packet) {
        ByteArrayInputStream bis = new ByteArrayInputStream(packet.getData(), 0, packet.getLength());
        DataInputStream dis = new DataInputStream(bis);
        try {
            this.readData(dis);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setRequest(boolean request) {
        this.request = request;
    }

    public boolean isRequest() {
        return this.request;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public String toString() {
        return "JoinInfo{request=" + this.isRequest() + ", memberCount=" + this.memberCount + "  " + super.toString() + '}';
    }
}

