/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.AsymmetricEncryptionConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.Interfaces;
import com.hazelcast.config.Join;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.SemaphoreConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.config.WanTargetClusterConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ConfigXmlGenerator {
    private final boolean formatted;
    final ILogger logger = Logger.getLogger(this.getClass().getName());

    public ConfigXmlGenerator() {
        this(true);
    }

    public ConfigXmlGenerator(boolean formatted) {
        this.formatted = formatted;
    }

    public String generate(Config config) {
        StringBuilder xml = new StringBuilder();
        xml.append("<hazelcast>");
        xml.append("<group>");
        xml.append("<name>").append(config.getGroupConfig().getName()).append("</name>");
        xml.append("<password>").append(config.getGroupConfig().getPassword()).append("</password>");
        xml.append("</group>");
        this.appendProperties(xml, config.getProperties());
        Collection<WanReplicationConfig> wanRepConfigs = config.getWanReplicationConfigs().values();
        for (WanReplicationConfig wan : wanRepConfigs) {
            xml.append("<wan-replication name=\"").append(wan.getName()).append("\">");
            List<WanTargetClusterConfig> targets = wan.getTargetClusterConfigs();
            for (WanTargetClusterConfig t : targets) {
                xml.append("<target-cluster group-name=\"").append(t.getGroupName()).append("\" group-password=\"").append(t.getGroupPassword()).append("\">");
                xml.append("<replication-impl>").append(t.getReplicationImpl()).append("</replication-impl>");
                xml.append("<end-points>");
                List<String> eps = t.getEndpoints();
                for (String ep : eps) {
                    xml.append("<address>").append(ep).append("</address>");
                }
                xml.append("</end-points>");
            }
            xml.append("</wan-replication>");
        }
        NetworkConfig netCfg = config.getNetworkConfig();
        xml.append("<network>");
        xml.append("<port auto-increment=\"").append(config.isPortAutoIncrement()).append("\">").append(config.getPort()).append("</port>");
        Join join = netCfg.getJoin();
        xml.append("<join>");
        MulticastConfig mcast = join.getMulticastConfig();
        xml.append("<multicast enabled=\"").append(mcast.isEnabled()).append("\">");
        xml.append("<multicast-group>").append(mcast.getMulticastGroup()).append("</multicast-group>");
        xml.append("<multicast-port>").append(mcast.getMulticastPort()).append("</multicast-port>");
        xml.append("<multicast-timeout-seconds>").append(mcast.getMulticastTimeoutSeconds()).append("</multicast-timeout-seconds>");
        xml.append("</multicast>");
        TcpIpConfig tcpCfg = join.getTcpIpConfig();
        xml.append("<tcp-ip enabled=\"").append(tcpCfg.isEnabled()).append("\">");
        List<String> members = tcpCfg.getMembers();
        for (String m : members) {
            xml.append("<interface>").append(m).append("</interface>");
        }
        List<Address> addresses = tcpCfg.getAddresses();
        for (Address a : addresses) {
            xml.append("<address>").append(a.getHost()).append(":").append(a.getPort()).append("</address>");
        }
        if (tcpCfg.getRequiredMember() != null) {
            xml.append("<required-member>").append(tcpCfg.getRequiredMember()).append("</required-member>");
        }
        xml.append("</tcp-ip>");
        xml.append("</join>");
        Interfaces interfaces = netCfg.getInterfaces();
        xml.append("<interfaces enabled=\"").append(interfaces.isEnabled()).append("\">");
        Collection<String> interfaceList = interfaces.getInterfaces();
        for (String i : interfaceList) {
            xml.append("<interface>").append(i).append("</interface>");
        }
        xml.append("</interfaces>");
        SymmetricEncryptionConfig sec = netCfg.getSymmetricEncryptionConfig();
        xml.append("<symmetric-encryption enabled=\"").append(sec != null && sec.isEnabled()).append("\">");
        if (sec != null) {
            xml.append("<algorithm>").append(sec.getAlgorithm()).append("</algorithm>");
            xml.append("<salt>").append(sec.getSalt()).append("</salt>");
            xml.append("<password>").append(sec.getPassword()).append("</password>");
            xml.append("<iteration-count>").append(sec.getIterationCount()).append("</iteration-count>");
        }
        xml.append("</symmetric-encryption>");
        AsymmetricEncryptionConfig asec = netCfg.getAsymmetricEncryptionConfig();
        xml.append("<asymmetric-encryption enabled=\"").append(asec != null && asec.isEnabled()).append("\">");
        if (asec != null) {
            xml.append("<algorithm>").append(asec.getAlgorithm()).append("</algorithm>");
            xml.append("<keyPassword>").append(asec.getKeyPassword()).append("</keyPassword>");
            xml.append("<keyAlias>").append(asec.getKeyAlias()).append("</keyAlias>");
            xml.append("<storeType>").append(asec.getStoreType()).append("</storeType>");
            xml.append("<storePassword>").append(asec.getStorePassword()).append("</storePassword>");
            xml.append("<storePath>").append(asec.getStorePath()).append("</storePath>");
        }
        xml.append("</asymmetric-encryption>");
        xml.append("</network>");
        Collection<ExecutorConfig> exCfgs = config.getExecutorConfigs();
        for (ExecutorConfig ex : exCfgs) {
            xml.append("<executor-service name=\"").append(ex.getName()).append("\">");
            xml.append("<core-pool-size>").append(ex.getCorePoolSize()).append("</core-pool-size>");
            xml.append("<max-pool-size>").append(ex.getMaxPoolSize()).append("</max-pool-size>");
            xml.append("<keep-alive-seconds>").append(ex.getKeepAliveSeconds()).append("</keep-alive-seconds>");
            xml.append("</executor-service>");
        }
        Collection<QueueConfig> qCfgs = config.getQConfigs().values();
        for (QueueConfig q : qCfgs) {
            xml.append("<queue name=\"").append(q.getName()).append("\">");
            xml.append("<max-size-per-jvm>").append(q.getMaxSizePerJVM()).append("</max-size-per-jvm>");
            xml.append("<backing-map-ref>").append(q.getBackingMapRef()).append("</backing-map-ref>");
            xml.append("</queue>");
        }
        Collection<TopicConfig> tCfgs = config.getTopicConfigs().values();
        for (TopicConfig t : tCfgs) {
            xml.append("<topic name=\"").append(t.getName()).append("\">");
            xml.append("<global-ordering-enabled>").append(t.isGlobalOrderingEnabled()).append("</global-ordering-enabled>");
            xml.append("</TopicConfig>");
        }
        Collection<MapConfig> mCfgs = config.getMapConfigs().values();
        for (MapConfig m : mCfgs) {
            xml.append("<map name=\"").append(m.getName()).append("\">");
            xml.append("<backup-count>").append(m.getBackupCount()).append("</backup-count>");
            xml.append("<eviction-policy>").append(m.getEvictionPolicy()).append("</eviction-policy>");
            xml.append("<eviction-percentage>").append(m.getEvictionPercentage()).append("</eviction-percentage>");
            xml.append("<max-size policy=\"").append(m.getMaxSizeConfig().getMaxSizePolicy()).append("\">").append(m.getMaxSizeConfig().getSize()).append("</max-size>");
            xml.append("<time-to-live-seconds>").append(m.getTimeToLiveSeconds()).append("</time-to-live-seconds>");
            xml.append("<max-idle-seconds>").append(m.getMaxIdleSeconds()).append("</max-idle-seconds>");
            xml.append("<cache-value>").append(m.isCacheValue()).append("</cache-value>");
            xml.append("<read-backup-data>").append(m.isReadBackupData()).append("</read-backup-data>");
            xml.append("<merge-policy>").append(m.getMergePolicy()).append("</merge-policy>");
            if (m.getMapStoreConfig() != null) {
                MapStoreConfig s = m.getMapStoreConfig();
                xml.append("<map-store enabled=\"").append(s.isEnabled()).append("\">");
                xml.append("<class-name>").append(s.getClassName()).append("</class-name>");
                xml.append("<write-delay-seconds>").append(s.getWriteDelaySeconds()).append("</write-delay-seconds>");
                this.appendProperties(xml, s.getProperties());
                xml.append("</map-store>");
            }
            if (m.getNearCacheConfig() != null) {
                NearCacheConfig n = m.getNearCacheConfig();
                xml.append("<near-cache>");
                xml.append("<time-to-live-seconds>").append(n.getTimeToLiveSeconds()).append("</time-to-live-seconds>");
                xml.append("<max-idle-seconds>").append(n.getMaxIdleSeconds()).append("</max-idle-seconds>");
                xml.append("<max-size>").append(n.getMaxSize()).append("</max-size>");
                xml.append("<eviction-policy>").append(n.getEvictionPolicy()).append("</eviction-policy>");
                xml.append("<invalidate-on-change>").append(n.isInvalidateOnChange()).append("</invalidate-on-change>");
                xml.append("</near-cache>");
            }
            if (m.getWanReplicationRef() != null) {
                WanReplicationRef wan = m.getWanReplicationRef();
                xml.append("<wan-replication-ref name=\"").append(wan.getName()).append("\"");
                xml.append("<merge-policy>").append(wan.getMergePolicy()).append("</merge-policy>");
                xml.append("</wan-replication-ref>");
            }
            xml.append("</map>");
        }
        Collection<SemaphoreConfig> semaphoreCfgs = config.getSemaphoreConfigs();
        for (SemaphoreConfig sc : semaphoreCfgs) {
            xml.append("<semaphore name=\"").append(sc.getName()).append("\">");
            xml.append("<initial-permits>").append(sc.getInitialPermits()).append("</initial-permits>");
            xml.append("<semaphore-factory enabled=\"").append(sc.isFactoryEnabled()).append("\">");
            xml.append("<class-name>").append(sc.getFactoryClassName()).append("</class-name>");
            xml.append("</semaphore-factory>");
            xml.append("</semaphore>");
        }
        Collection<MergePolicyConfig> merges = config.getMergePolicyConfigs().values();
        xml.append("<merge-policies>");
        for (MergePolicyConfig mp : merges) {
            xml.append("<map-merge-policy name=\"").append(mp.getName()).append("\">");
            String clazz = mp.getImplementation() != null ? mp.getImplementation().getClass().getName() : mp.getClassName();
            xml.append("<class-name>").append(clazz).append("</class-name>");
            xml.append("</map-merge-policy>");
        }
        xml.append("</merge-policies>");
        xml.append("</hazelcast>");
        return this.format(xml.toString(), 5);
    }

    private String format(String input, int indent) {
        if (!this.formatted) {
            return input;
        }
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(input));
            StreamResult xmlOutput = new StreamResult(new StringWriter());
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            try {
                transformerFactory.setAttribute("indent-number", indent);
            }
            catch (IllegalArgumentException e) {
                this.logger.log(Level.FINEST, "Failed to set indent-number attribute; cause: " + e.getMessage());
            }
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            try {
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(indent));
            }
            catch (IllegalArgumentException e) {
                this.logger.log(Level.FINEST, "Failed to set indent-amount property; cause: " + e.getMessage());
            }
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
            return input;
        }
    }

    private void appendProperties(StringBuilder xml, Properties props) {
        if (!props.isEmpty()) {
            xml.append("<properties>");
            Set<Object> keys = props.keySet();
            for (Object key : keys) {
                xml.append("<property name=\"").append(key).append("\">").append(props.getProperty(key.toString())).append("</property>");
            }
            xml.append("</properties>");
        }
    }
}

