/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.config.GroupConfig;
import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Instance;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.MultiTask;
import com.hazelcast.impl.AtomicNumberProxy;
import com.hazelcast.impl.CountDownLatchProxy;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.HazelcastInstanceAwareInstance;
import com.hazelcast.impl.MProxy;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.QProxy;
import com.hazelcast.impl.SemaphoreProxy;
import com.hazelcast.impl.TopicProxy;
import com.hazelcast.impl.management.ConsoleCommandHandler;
import com.hazelcast.impl.management.ConsoleCommandRequest;
import com.hazelcast.impl.management.ConsoleRequest;
import com.hazelcast.impl.management.EvictLocalMapRequest;
import com.hazelcast.impl.management.ExecuteScriptRequest;
import com.hazelcast.impl.management.GetClusterStateRequest;
import com.hazelcast.impl.management.LoginRequest;
import com.hazelcast.impl.management.MapConfigRequest;
import com.hazelcast.impl.management.ThreadDumpRequest;
import com.hazelcast.impl.monitor.LocalAtomicNumberStatsImpl;
import com.hazelcast.impl.monitor.LocalCountDownLatchStatsImpl;
import com.hazelcast.impl.monitor.LocalMapStatsImpl;
import com.hazelcast.impl.monitor.LocalQueueStatsImpl;
import com.hazelcast.impl.monitor.LocalSemaphoreStatsImpl;
import com.hazelcast.impl.monitor.LocalTopicStatsImpl;
import com.hazelcast.impl.monitor.MemberStateImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.monitor.MemberState;
import com.hazelcast.monitor.TimedClusterState;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.partition.Partition;
import com.hazelcast.partition.PartitionService;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementCenterService
implements MembershipListener {
    private static final int DATAGRAM_BUFFER_SIZE = 64000;
    private static final int STATE_DATA_BUFFER_SIZE = 640000;
    private final Queue<ClientHandler> qClientHandlers = new LinkedBlockingQueue<ClientHandler>(100);
    private final FactoryImpl factory;
    private volatile boolean running = true;
    private final DatagramSocket datagramSocket;
    private final SocketReadyServerSocket serverSocket;
    private final UDPListener udpListener;
    private final UDPSender udpSender;
    private final TCPListener tcpListener;
    private final List<ClientHandler> lsClientHandlers = new CopyOnWriteArrayList<ClientHandler>();
    private final ILogger logger;
    private final ConcurrentMap<Address, MemberState> memberStates = new ConcurrentHashMap<Address, MemberState>(1000);
    private final ConcurrentMap<Address, SocketAddress> socketAddresses = new ConcurrentHashMap<Address, SocketAddress>(1000);
    private final Set<Address> addresses = new CopyOnWriteArraySet<Address>();
    private volatile MemberStateImpl latestThisMemberState = null;
    private final Address thisAddress;
    private final ConsoleCommandHandler commandHandler;
    private final StatsInstanceFilter instanceFilterMap;
    private final StatsInstanceFilter instanceFilterQueue;
    private final StatsInstanceFilter instanceFilterTopic;
    private final StatsInstanceFilter instanceFilterAtomicNumber;
    private final StatsInstanceFilter instanceFilterCountDownLatch;
    private final StatsInstanceFilter instanceFilterSemaphore;
    private final int maxVisibleInstanceCount;

    public ManagementCenterService(FactoryImpl factoryImpl) throws Exception {
        this.factory = factoryImpl;
        this.instanceFilterMap = new StatsInstanceFilter(factoryImpl.node.getGroupProperties().MC_MAP_EXCLUDES.getString());
        this.instanceFilterQueue = new StatsInstanceFilter(factoryImpl.node.getGroupProperties().MC_QUEUE_EXCLUDES.getString());
        this.instanceFilterTopic = new StatsInstanceFilter(factoryImpl.node.getGroupProperties().MC_TOPIC_EXCLUDES.getString());
        this.instanceFilterAtomicNumber = new StatsInstanceFilter(factoryImpl.node.getGroupProperties().MC_ATOMIC_NUMBER_EXCLUDES.getString());
        this.instanceFilterCountDownLatch = new StatsInstanceFilter(factoryImpl.node.getGroupProperties().MC_COUNT_DOWN_LATCH_EXCLUDES.getString());
        this.instanceFilterSemaphore = new StatsInstanceFilter(factoryImpl.node.getGroupProperties().MC_SEMAPHORE_EXCLUDES.getString());
        this.thisAddress = ((MemberImpl)this.factory.getCluster().getLocalMember()).getAddress();
        this.updateMemberOrder();
        this.logger = this.factory.node.getLogger(ManagementCenterService.class.getName());
        for (int i = 0; i < 100; ++i) {
            this.qClientHandlers.offer(new ClientHandler());
        }
        this.maxVisibleInstanceCount = this.factory.node.groupProperties.MC_MAX_INSTANCE_COUNT.getInteger();
        this.factory.getCluster().addMembershipListener(this);
        MemberImpl memberLocal = (MemberImpl)this.factory.getCluster().getLocalMember();
        int port = memberLocal.getInetSocketAddress().getPort() + 100;
        this.datagramSocket = new DatagramSocket(port);
        this.serverSocket = new SocketReadyServerSocket(port);
        this.udpListener = new UDPListener(this.datagramSocket);
        this.udpListener.start();
        this.udpSender = new UDPSender(this.datagramSocket);
        this.udpSender.start();
        this.tcpListener = new TCPListener(this.serverSocket);
        this.tcpListener.start();
        this.commandHandler = new ConsoleCommandHandler(this.factory);
        this.logger.log(Level.INFO, "Hazelcast Management Center started at port " + port + ".");
    }

    public void shutdown() {
        this.running = false;
        try {
            this.datagramSocket.close();
            this.serverSocket.close();
            for (ClientHandler clientHandler : this.lsClientHandlers) {
                clientHandler.shutdown();
            }
            this.udpSender.interrupt();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void memberAdded(MembershipEvent membershipEvent) {
        this.updateMemberOrder();
    }

    @Override
    public void memberRemoved(MembershipEvent membershipEvent) {
        Address address = ((MemberImpl)membershipEvent.getMember()).getAddress();
        this.memberStates.remove(address);
        this.socketAddresses.remove(address);
        this.addresses.remove(address);
    }

    void updateMemberOrder() {
        block6: {
            try {
                Set<Member> memberSet = this.factory.getCluster().getMembers();
                for (Member member : memberSet) {
                    MemberImpl memberImpl = (MemberImpl)member;
                    Address address = memberImpl.getAddress();
                    try {
                        if (!this.socketAddresses.containsKey(address)) {
                            InetSocketAddress socketAddress = new InetSocketAddress(address.getInetAddress(), address.getPort() + 100);
                            this.socketAddresses.putIfAbsent(address, socketAddress);
                        }
                        this.addresses.add(address);
                    }
                    catch (UnknownHostException e) {
                        this.logger.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            }
            catch (Throwable e) {
                if (!this.running || !this.factory.node.isActive()) break block6;
                this.logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public boolean login(String groupName, String password) {
        this.logger.log(Level.INFO, "Management Center Client is trying to login.");
        GroupConfig groupConfig = this.factory.getConfig().getGroupConfig();
        return groupConfig.getName().equals(groupName) && groupConfig.getPassword().equals(password);
    }

    MemberState updateLocalState() {
        this.latestThisMemberState = this.createMemberState();
        this.memberStates.put(this.latestThisMemberState.getAddress(), this.latestThisMemberState);
        return this.latestThisMemberState;
    }

    public MemberStateImpl createMemberState() {
        MemberStateImpl memberState = new MemberStateImpl();
        this.createMemberState(memberState);
        return memberState;
    }

    public void createMemberState(MemberStateImpl memberState) {
        Node node = this.factory.node;
        memberState.setAddress(((MemberImpl)node.getClusterImpl().getLocalMember()).getAddress());
        memberState.getMemberHealthStats().setOutOfMemory(node.isOutOfMemory());
        memberState.getMemberHealthStats().setActive(node.isActive());
        memberState.getMemberHealthStats().setServiceThreadStats(node.getCpuUtilization().serviceThread);
        memberState.getMemberHealthStats().setOutThreadStats(node.getCpuUtilization().outThread);
        memberState.getMemberHealthStats().setInThreadStats(node.getCpuUtilization().inThread);
        PartitionService partitionService = this.factory.getPartitionService();
        Set<Partition> partitions = partitionService.getPartitions();
        memberState.clearPartitions();
        for (Partition partition : partitions) {
            if (partition.getOwner() == null || !partition.getOwner().localMember()) continue;
            memberState.addPartition(partition.getPartitionId());
        }
        ArrayList<HazelcastInstanceAwareInstance> proxyObjects = new ArrayList<HazelcastInstanceAwareInstance>(this.factory.getProxies());
        this.createMemState(memberState, proxyObjects.iterator(), Instance.InstanceType.MAP);
        this.createMemState(memberState, proxyObjects.iterator(), Instance.InstanceType.QUEUE);
        this.createMemState(memberState, proxyObjects.iterator(), Instance.InstanceType.TOPIC);
    }

    private void createMemState(MemberStateImpl memberState, Iterator<HazelcastInstanceAwareInstance> it, Instance.InstanceType type) {
        int count = 0;
        while (it.hasNext()) {
            HazelcastInstanceAwareInstance proxyObject = it.next();
            if (proxyObject.getInstanceType() != type) continue;
            if (count < this.maxVisibleInstanceCount) {
                SemaphoreProxy semaphoreProxy;
                if (type.isMap()) {
                    MProxy mapProxy = (MProxy)((Object)proxyObject);
                    if (this.instanceFilterMap.visible(mapProxy.getName())) {
                        memberState.putLocalMapStats(mapProxy.getName(), (LocalMapStatsImpl)mapProxy.getLocalMapStats());
                        ++count;
                    }
                } else if (type.isQueue()) {
                    QProxy qProxy = (QProxy)((Object)proxyObject);
                    if (this.instanceFilterQueue.visible(qProxy.getName())) {
                        memberState.putLocalQueueStats(qProxy.getName(), (LocalQueueStatsImpl)qProxy.getLocalQueueStats());
                        ++count;
                    }
                } else if (type.isTopic()) {
                    TopicProxy topicProxy = (TopicProxy)((Object)proxyObject);
                    if (this.instanceFilterTopic.visible(topicProxy.getName())) {
                        memberState.putLocalTopicStats(topicProxy.getName(), (LocalTopicStatsImpl)topicProxy.getLocalTopicStats());
                        ++count;
                    }
                } else if (type.isAtomicNumber()) {
                    AtomicNumberProxy atomicLongProxy = (AtomicNumberProxy)((Object)proxyObject);
                    if (this.instanceFilterAtomicNumber.visible(atomicLongProxy.getName())) {
                        memberState.putLocalAtomicNumberStats(atomicLongProxy.getName(), (LocalAtomicNumberStatsImpl)atomicLongProxy.getLocalAtomicNumberStats());
                        ++count;
                    }
                } else if (type.isCountDownLatch()) {
                    CountDownLatchProxy cdlProxy = (CountDownLatchProxy)((Object)proxyObject);
                    if (this.instanceFilterCountDownLatch.visible(cdlProxy.getName())) {
                        memberState.putLocalCountDownLatchStats(cdlProxy.getName(), (LocalCountDownLatchStatsImpl)cdlProxy.getLocalCountDownLatchStats());
                        ++count;
                    }
                } else if (type.isSemaphore() && this.instanceFilterSemaphore.visible((semaphoreProxy = (SemaphoreProxy)((Object)proxyObject)).getName())) {
                    memberState.putLocalSemaphoreStats(semaphoreProxy.getName(), (LocalSemaphoreStatsImpl)semaphoreProxy.getLocalSemaphoreStats());
                    ++count;
                }
            }
            it.remove();
        }
    }

    Set<String> getLongInstanceNames() {
        HashSet<String> setLongInstanceNames = new HashSet<String>(this.maxVisibleInstanceCount);
        ArrayList<HazelcastInstanceAwareInstance> proxyObjects = new ArrayList<HazelcastInstanceAwareInstance>(this.factory.getProxies());
        this.collectInstanceNames(setLongInstanceNames, proxyObjects.iterator(), Instance.InstanceType.MAP);
        this.collectInstanceNames(setLongInstanceNames, proxyObjects.iterator(), Instance.InstanceType.QUEUE);
        this.collectInstanceNames(setLongInstanceNames, proxyObjects.iterator(), Instance.InstanceType.TOPIC);
        return setLongInstanceNames;
    }

    private void collectInstanceNames(Set<String> setLongInstanceNames, Iterator<HazelcastInstanceAwareInstance> it, Instance.InstanceType type) {
        int count = 0;
        while (it.hasNext()) {
            HazelcastInstanceAwareInstance proxyObject = it.next();
            if (proxyObject.getInstanceType() != type) continue;
            if (count < this.maxVisibleInstanceCount) {
                SemaphoreProxy semaphoreProxy;
                if (type.isMap()) {
                    MProxy mapProxy = (MProxy)((Object)proxyObject);
                    if (this.instanceFilterMap.visible(mapProxy.getName())) {
                        setLongInstanceNames.add(mapProxy.getLongName());
                        ++count;
                    }
                } else if (type.isQueue()) {
                    QProxy qProxy = (QProxy)((Object)proxyObject);
                    if (this.instanceFilterQueue.visible(qProxy.getName())) {
                        setLongInstanceNames.add(qProxy.getLongName());
                        ++count;
                    }
                } else if (type.isTopic()) {
                    TopicProxy topicProxy = (TopicProxy)((Object)proxyObject);
                    if (this.instanceFilterTopic.visible(topicProxy.getName())) {
                        setLongInstanceNames.add(topicProxy.getLongName());
                        ++count;
                    }
                } else if (type.isAtomicNumber()) {
                    AtomicNumberProxy atomicLongProxy = (AtomicNumberProxy)((Object)proxyObject);
                    if (this.instanceFilterAtomicNumber.visible(atomicLongProxy.getName())) {
                        setLongInstanceNames.add(atomicLongProxy.getLongName());
                        ++count;
                    }
                } else if (type.isCountDownLatch()) {
                    CountDownLatchProxy cdlProxy = (CountDownLatchProxy)((Object)proxyObject);
                    if (this.instanceFilterCountDownLatch.visible(cdlProxy.getName())) {
                        setLongInstanceNames.add(cdlProxy.getLongName());
                        ++count;
                    }
                } else if (type.isSemaphore() && this.instanceFilterSemaphore.visible((semaphoreProxy = (SemaphoreProxy)((Object)proxyObject)).getName())) {
                    setLongInstanceNames.add(semaphoreProxy.getLongName());
                    ++count;
                }
            }
            it.remove();
        }
    }

    public Object call(Address address, Callable callable) {
        Set<Member> members = this.factory.getCluster().getMembers();
        for (Member member : members) {
            if (!address.equals(((MemberImpl)member).getAddress())) continue;
            DistributedTask task = new DistributedTask(callable, member);
            return this.executeTaskAndGet(task);
        }
        return null;
    }

    public Object call(Callable callable) {
        DistributedTask task = new DistributedTask(callable);
        return this.executeTaskAndGet(task);
    }

    public Collection callOnMembers(Set<Address> addresses, Callable callable) {
        Set<Member> allMembers = this.factory.getCluster().getMembers();
        HashSet<Member> selectedMembers = new HashSet<Member>(addresses.size());
        for (Member member : allMembers) {
            if (!addresses.contains(((MemberImpl)member).getAddress())) continue;
            selectedMembers.add(member);
        }
        return this.callOnMembers0(selectedMembers, callable);
    }

    public Collection callOnAllMembers(Callable callable) {
        Set<Member> members = this.factory.getCluster().getMembers();
        return this.callOnMembers0(members, callable);
    }

    private Collection callOnMembers0(Set<Member> members, Callable callable) {
        MultiTask task = new MultiTask(callable, members);
        return (Collection)this.executeTaskAndGet(task);
    }

    private Object executeTaskAndGet(DistributedTask task) {
        try {
            this.factory.getExecutorService().execute(task);
            try {
                return task.get(3L, TimeUnit.SECONDS);
            }
            catch (Throwable e) {
                this.logger.log(Level.FINEST, e.getMessage(), e);
                return null;
            }
        }
        catch (Throwable e) {
            if (this.running && this.factory.node.isActive()) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
            }
            return null;
        }
    }

    TimedClusterState getState() {
        if (this.latestThisMemberState == null) {
            this.updateLocalState();
        }
        TimedClusterState timedClusterState = new TimedClusterState();
        for (Address address : this.addresses) {
            MemberState memberState = (MemberState)this.memberStates.get(address);
            if (memberState == null) continue;
            timedClusterState.addMemberState(memberState);
        }
        timedClusterState.setInstanceNames(this.getLongInstanceNames());
        return timedClusterState;
    }

    HazelcastInstance getHazelcastInstance() {
        return this.factory;
    }

    ConsoleCommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    class StatsInstanceFilter {
        final Set<Pattern> setExcludes;
        final Set<String> setIncludeCache;
        final Set<String> setExcludeCache;

        StatsInstanceFilter(String excludes) {
            if (excludes != null) {
                this.setExcludes = new HashSet<Pattern>();
                this.setIncludeCache = new HashSet<String>();
                this.setExcludeCache = new HashSet<String>();
                StringTokenizer st = new StringTokenizer(excludes, ",");
                while (st.hasMoreTokens()) {
                    this.setExcludes.add(Pattern.compile(st.nextToken().trim()));
                }
            } else {
                this.setExcludes = null;
                this.setIncludeCache = null;
                this.setExcludeCache = null;
            }
        }

        boolean visible(String instanceName) {
            if (this.setExcludes == null) {
                return true;
            }
            if (this.setIncludeCache.contains(instanceName)) {
                return true;
            }
            if (this.setExcludeCache.contains(instanceName)) {
                return false;
            }
            for (Pattern pattern : this.setExcludes) {
                if (!pattern.matcher(instanceName).matches()) continue;
                this.setExcludeCache.add(instanceName);
                return false;
            }
            this.setIncludeCache.add(instanceName);
            return true;
        }
    }

    public static class SocketReadyServerSocket
    extends ServerSocket {
        public SocketReadyServerSocket(int port) throws IOException {
            super(port);
        }

        public void doAccept(Socket socket) throws IOException {
            super.implAccept(socket);
        }
    }

    class ClientHandler
    extends Thread {
        final ConsoleRequest[] consoleRequests = new ConsoleRequest[10];
        final Socket socket = new Socket();
        final LazyDataInputStream socketIn = new LazyDataInputStream();
        final LazyDataOutputStream socketOut = new LazyDataOutputStream();

        public ClientHandler() {
            this.register(new LoginRequest());
            this.register(new GetClusterStateRequest());
            this.register(new ThreadDumpRequest());
            this.register(new ExecuteScriptRequest());
            this.register(new EvictLocalMapRequest());
            this.register(new ConsoleCommandRequest());
            this.register(new MapConfigRequest());
        }

        public void register(ConsoleRequest consoleRequest) {
            this.consoleRequests[consoleRequest.getType()] = consoleRequest;
        }

        public Socket getSocket() {
            return this.socket;
        }

        public void run() {
            block5: {
                try {
                    this.socketIn.setInputStream(this.socket.getInputStream());
                    this.socketOut.setOutputStream(this.socket.getOutputStream());
                    while (ManagementCenterService.this.running) {
                        int requestType = this.socketIn.read();
                        if (requestType == -1) {
                            return;
                        }
                        ConsoleRequest consoleRequest = this.consoleRequests[requestType];
                        consoleRequest.readData(this.socketIn);
                        boolean isOutOfMemory = ((ManagementCenterService)ManagementCenterService.this).factory.node.isOutOfMemory();
                        if (isOutOfMemory) {
                            this.socketOut.writeByte(0);
                            continue;
                        }
                        this.socketOut.writeByte(1);
                        consoleRequest.writeResponse(ManagementCenterService.this, this.socketOut);
                    }
                }
                catch (Throwable e) {
                    if (!ManagementCenterService.this.running || !((ManagementCenterService)ManagementCenterService.this).factory.node.isActive()) break block5;
                    ManagementCenterService.this.logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }

        public void shutdown() {
            try {
                this.socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class LazyDataOutputStream
    extends DataOutputStream {
        LazyDataOutputStream() {
            super(null);
        }

        void setOutputStream(OutputStream out) {
            this.out = out;
        }
    }

    class LazyDataInputStream
    extends DataInputStream {
        LazyDataInputStream() {
            super(null);
        }

        void setInputStream(InputStream in) {
            this.in = in;
        }
    }

    class UDPSender
    extends Thread {
        final DatagramSocket socket;
        final DatagramPacket packet;
        final byte[] data;
        final Deflater deflater;
        final ByteBuffer bbState;
        final DataOutputStream dos;

        public UDPSender(DatagramSocket socket) throws SocketException {
            super("hz.UDP.Sender");
            this.packet = new DatagramPacket(new byte[0], 0);
            this.data = new byte[64000];
            this.deflater = new Deflater(1);
            this.bbState = ByteBuffer.allocate(640000);
            this.dos = new DataOutputStream(IOUtil.newOutputStream(this.bbState));
            this.socket = socket;
        }

        public void run() {
            try {
                while (ManagementCenterService.this.running) {
                    this.sendState();
                    Thread.sleep(5000L);
                }
            }
            catch (Throwable e) {
                if (ManagementCenterService.this.running && ((ManagementCenterService)ManagementCenterService.this).factory.node.isActive()) {
                    ManagementCenterService.this.logger.log(Level.WARNING, e.getMessage(), e);
                }
                this.deflater.end();
            }
        }

        void sendState() {
            boolean preparedStateData = false;
            int compressedCount = 0;
            for (Address address : ManagementCenterService.this.socketAddresses.keySet()) {
                SocketAddress socketAddress;
                if (ManagementCenterService.this.thisAddress.equals(address) || (socketAddress = (SocketAddress)ManagementCenterService.this.socketAddresses.get(address)) == null) continue;
                try {
                    if (!preparedStateData) {
                        compressedCount = this.prepareStateData();
                        preparedStateData = true;
                    }
                    this.packet.setData(this.data, 0, compressedCount);
                    this.packet.setSocketAddress(socketAddress);
                    this.socket.send(this.packet);
                }
                catch (IOException e) {
                    if (!ManagementCenterService.this.running || !((ManagementCenterService)ManagementCenterService.this).factory.node.isActive()) continue;
                    ManagementCenterService.this.logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }

        int prepareStateData() throws IOException {
            MemberState latestState = ManagementCenterService.this.updateLocalState();
            this.bbState.clear();
            latestState.writeData(this.dos);
            this.dos.flush();
            this.deflater.reset();
            this.deflater.setInput(this.bbState.array(), 0, this.bbState.position());
            this.deflater.finish();
            return this.deflater.deflate(this.data);
        }
    }

    class UDPListener
    extends Thread {
        final DatagramSocket socket;
        final ByteBuffer bbState;
        final byte[] data;
        final DatagramPacket packet;
        final DataInputStream dis;
        final Inflater inflater;

        public UDPListener(DatagramSocket socket) throws SocketException {
            super("hz.UDP.Listener");
            this.bbState = ByteBuffer.allocate(640000);
            this.data = new byte[64000];
            this.packet = new DatagramPacket(this.data, 64000);
            this.dis = new DataInputStream(IOUtil.newInputStream(this.bbState));
            this.inflater = new Inflater();
            this.socket = socket;
            this.socket.setSoTimeout(1000);
        }

        public void run() {
            try {
                while (ManagementCenterService.this.running) {
                    try {
                        this.bbState.clear();
                        this.socket.receive(this.packet);
                        this.inflater.reset();
                        this.inflater.setInput(this.data);
                        int actualCount = this.inflater.inflate(this.bbState.array());
                        this.bbState.limit(actualCount);
                        this.bbState.position(0);
                        MemberStateImpl memberState = new MemberStateImpl();
                        memberState.readData(this.dis);
                        ManagementCenterService.this.memberStates.put(memberState.getAddress(), memberState);
                    }
                    catch (SocketTimeoutException ignored) {}
                }
            }
            catch (Throwable e) {
                if (ManagementCenterService.this.running && ((ManagementCenterService)ManagementCenterService.this).factory.node.isActive()) {
                    ManagementCenterService.this.logger.log(Level.WARNING, e.getMessage(), e);
                }
                this.inflater.end();
            }
        }
    }

    class TCPListener
    extends Thread {
        final SocketReadyServerSocket serverSocket;

        TCPListener(SocketReadyServerSocket serverSocket) {
            super("hz.TCP.Listener");
            this.serverSocket = serverSocket;
        }

        public void run() {
            try {
                while (ManagementCenterService.this.running) {
                    ClientHandler clientHandler = (ClientHandler)ManagementCenterService.this.qClientHandlers.poll();
                    this.serverSocket.doAccept(clientHandler.getSocket());
                    clientHandler.start();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

