/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.access;

import com.hazelcast.hibernate.access.AbstractAccessDelegate;
import com.hazelcast.hibernate.region.HazelcastRegion;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.access.SoftLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadWriteAccessDelegate<T extends HazelcastRegion>
extends AbstractAccessDelegate<T> {
    public ReadWriteAccessDelegate(T hazelcastRegion) {
        super(hazelcastRegion);
    }

    @Override
    public boolean afterInsert(Object key, Object value, Object version) throws CacheException {
        this.getCache().put(key, value);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean afterUpdate(Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        try {
            this.getCache().put(key, value);
        }
        finally {
            this.unlockItem(key, lock);
        }
        return true;
    }

    @Override
    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        this.getCache().put(key, value);
        return true;
    }

    @Override
    public SoftLock lockItem(Object key, Object version) throws CacheException {
        this.getCache().lock(key);
        return new SoftLock(){};
    }

    @Override
    public void unlockItem(Object key, SoftLock lock) throws CacheException {
        this.getCache().unlock(key);
    }

    @Override
    public void unlockRegion(SoftLock lock) throws CacheException {
    }
}

