/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.wan;

import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanTargetClusterConfig;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.wan.WanNoDelayReplication;
import com.hazelcast.impl.wan.WanReplication;
import com.hazelcast.impl.wan.WanReplicationEndpoint;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WanReplicationService {
    final Node node;
    final Map<String, WanReplication> mapWanReplications = new ConcurrentHashMap<String, WanReplication>(2);

    public WanReplicationService(Node node) {
        this.node = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WanReplication getWanReplication(String name) {
        WanReplication wr = this.mapWanReplications.get(name);
        if (wr != null) {
            return wr;
        }
        WanReplicationService wanReplicationService = this;
        synchronized (wanReplicationService) {
            wr = this.mapWanReplications.get(name);
            if (wr != null) {
                return wr;
            }
            WanReplicationConfig wanReplicationConfig = this.node.getConfig().getWanReplicationConfig(name);
            if (wanReplicationConfig == null) {
                return null;
            }
            List<WanTargetClusterConfig> targets = wanReplicationConfig.getTargetClusterConfigs();
            WanReplicationEndpoint[] targetClusters = new WanReplicationEndpoint[targets.size()];
            int count = 0;
            for (WanTargetClusterConfig targetClusterConfig : targets) {
                WanNoDelayReplication target = new WanNoDelayReplication();
                String groupName = targetClusterConfig.getGroupName();
                String password = targetClusterConfig.getGroupPassword();
                String[] addresses = new String[targetClusterConfig.getEndpoints().size()];
                targetClusterConfig.getEndpoints().toArray(addresses);
                target.init(this.node, groupName, password, addresses);
                targetClusters[count++] = target;
            }
            wr = new WanReplication(name, targetClusters);
            this.mapWanReplications.put(name, wr);
            return wr;
        }
    }
}

