/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.core.AtomicNumber;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Instance;
import com.hazelcast.core.InstanceEvent;
import com.hazelcast.core.InstanceListener;
import com.hazelcast.core.MultiMap;
import com.hazelcast.jmx.AbstractMBean;
import com.hazelcast.jmx.AtomicNumberMBean;
import com.hazelcast.jmx.CountDownLatchMBean;
import com.hazelcast.jmx.JMXAttribute;
import com.hazelcast.jmx.JMXDescription;
import com.hazelcast.jmx.JMXOperation;
import com.hazelcast.jmx.ListMBean;
import com.hazelcast.jmx.LockMBean;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.jmx.MapMBean;
import com.hazelcast.jmx.MultiMapMBean;
import com.hazelcast.jmx.ObjectNameSpec;
import com.hazelcast.jmx.QueueMBean;
import com.hazelcast.jmx.SemaphoreMBean;
import com.hazelcast.jmx.SetMBean;
import com.hazelcast.jmx.StatisticsCollector;
import com.hazelcast.jmx.TopicMBean;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JMXDescription(value="Cluster statistics")
public class DataMBean
extends AbstractMBean<HazelcastInstance>
implements InstanceListener {
    private static final Logger logger = Logger.getLogger(DataMBean.class.getName());
    private StatisticsCollector creationStats = null;
    private StatisticsCollector destructionStats = null;

    private AbstractMBean buildMBean(Instance instance) throws Exception {
        if (instance.getInstanceType().isTopic()) {
            return new TopicMBean((ITopic)instance, this.managementService);
        }
        if (instance.getInstanceType().isQueue()) {
            return new QueueMBean((IQueue)instance, this.managementService);
        }
        if (instance.getInstanceType().isList()) {
            return new ListMBean((IList)instance, this.managementService);
        }
        if (instance.getInstanceType().isSet()) {
            return new SetMBean((ISet)instance, this.managementService);
        }
        if (instance.getInstanceType().isMultiMap()) {
            return new MultiMapMBean((MultiMap)instance, this.managementService);
        }
        if (instance.getInstanceType().isMap()) {
            return new MapMBean((IMap)instance, this.managementService);
        }
        if (instance.getInstanceType().isLock()) {
            return new LockMBean((ILock)instance, this.managementService);
        }
        if (instance.getInstanceType().isAtomicNumber()) {
            return new AtomicNumberMBean((AtomicNumber)instance, this.managementService);
        }
        if (instance.getInstanceType().isCountDownLatch()) {
            return new CountDownLatchMBean((ICountDownLatch)instance, this.managementService);
        }
        if (instance.getInstanceType().isSemaphore()) {
            return new SemaphoreMBean((ISemaphore)instance, this.managementService);
        }
        return null;
    }

    protected DataMBean(ManagementService managementService) {
        super(managementService.instance, managementService);
    }

    @Override
    public ObjectNameSpec getNameSpec() {
        return this.getParentName().getNested("Statistics");
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (registrationDone.booleanValue()) {
            this.creationStats = ManagementService.newStatisticsCollector();
            this.destructionStats = ManagementService.newStatisticsCollector();
            ((HazelcastInstance)this.getManagedObject()).addInstanceListener(this);
            for (Instance instance : ((HazelcastInstance)this.getManagedObject()).getInstances()) {
                this.registerInstance(instance);
            }
        }
    }

    @Override
    public void preDeregister() throws Exception {
        ((HazelcastInstance)this.getManagedObject()).removeInstanceListener(this);
        if (this.creationStats != null) {
            this.creationStats.destroy();
            this.creationStats = null;
        }
        if (this.destructionStats != null) {
            this.destructionStats.destroy();
            this.destructionStats = null;
        }
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void instanceCreated(InstanceEvent event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Received created notification {0} {1}", new String[]{event.getInstance().getInstanceType().toString(), event.getInstance().toString()});
        }
        if (this.creationStats != null) {
            this.creationStats.addEvent();
        }
        this.registerInstance(event.getInstance());
    }

    @Override
    public void instanceDestroyed(InstanceEvent event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Received destroyed notification " + event.getInstance().toString());
        }
        if (this.destructionStats != null) {
            this.destructionStats.addEvent();
        }
        this.unregisterInstance(event.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInstance(Object instance) {
        block7: {
            try {
                AbstractMBean mbean = this.buildMBean((Instance)instance);
                if (mbean == null) {
                    logger.log(Level.FINE, "Unsupported instance type " + instance.getClass().getName());
                    break block7;
                }
                mbean.setParentName(this.getParentName());
                ObjectName name = mbean.getObjectName();
                logger.log(Level.FINEST, "Register MBean {0}", name);
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                DataMBean dataMBean = this;
                synchronized (dataMBean) {
                    if (!mbs.isRegistered(name)) {
                        mbs.registerMBean(mbean, name);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Unable to register MBean", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterInstance(Object instance) {
        block7: {
            try {
                AbstractMBean mbean = this.buildMBean((Instance)instance);
                if (mbean == null) {
                    logger.log(Level.FINE, "Unsupported instance type " + instance.getClass().getName());
                    break block7;
                }
                mbean.setParentName(this.getParentName());
                ObjectName name = mbean.getObjectName();
                logger.log(Level.FINEST, "Unregister MBean {0}", name);
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                DataMBean dataMBean = this;
                synchronized (dataMBean) {
                    if (mbs.isRegistered(name)) {
                        mbs.unregisterMBean(name);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Unable to unregister MBean", e);
            }
        }
    }

    @JMXOperation(value="resetStats")
    public void resetStats() {
        if (this.creationStats != null) {
            this.creationStats.reset();
        }
        if (this.destructionStats != null) {
            this.destructionStats.reset();
        }
    }

    @JMXAttribute(value="InstanceCount")
    @JMXDescription(value="Total data structures registered")
    public int getInstanceCount() {
        Collection<Instance> instances = ((HazelcastInstance)this.getManagedObject()).getInstances();
        return instances.size();
    }

    @JMXAttribute(value="InstancesCreated")
    @JMXDescription(value="Total instances created since startup")
    public long getInstancesCreated() {
        return this.creationStats.getTotal();
    }

    @JMXAttribute(value="InstancesCreatedLast")
    @JMXDescription(value="Instances created in the last second")
    public double getInstancesCreatedAvg() {
        return this.creationStats.getAverage();
    }

    @JMXAttribute(value="InstancesCreatedPeak")
    @JMXDescription(value="Max instances created per second")
    public double getInstancesCreatedMax() {
        return this.creationStats.getMax();
    }

    @JMXAttribute(value="InstancesDestroyed")
    @JMXDescription(value="Total instances destroyed since startup")
    public long getInstancesDestroyed() {
        return this.destructionStats.getTotal();
    }

    @JMXAttribute(value="InstancesDestroyedLast")
    @JMXDescription(value="Instances destroyed in the last second")
    public double getInstancesDestroyedAvg() {
        return this.destructionStats.getAverage();
    }

    @JMXAttribute(value="InstancesDestroyedPeak")
    @JMXDescription(value="Max instances destroyed per second")
    public double getInstancesDestroyedMax() {
        return this.destructionStats.getMax();
    }
}

