/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query;

import com.hazelcast.core.MapEntry;
import com.hazelcast.impl.Record;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.SerializationHelper;
import com.hazelcast.query.Expression;
import com.hazelcast.query.Index;
import com.hazelcast.query.IndexAwarePredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.QueryContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Predicates {
    private static final SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
    private static final SimpleDateFormat sqlDateFormat = new SimpleDateFormat("yyyy-mm-dd");

    public static Predicate instanceOf(final Class klass) {
        return new Predicate(){

            public boolean apply(MapEntry mapEntry) {
                Object value = mapEntry.getValue();
                if (value == null) {
                    return false;
                }
                return klass.isAssignableFrom(value.getClass());
            }

            public String toString() {
                return " instanceOf (" + klass.getName() + ")";
            }
        };
    }

    public static Predicate and(Predicate x, Predicate y) {
        return new AndOrPredicate(true, x, y);
    }

    public static Predicate not(Predicate predicate) {
        return new NotPredicate(predicate);
    }

    public static Predicate or(Predicate x, Predicate y) {
        return new AndOrPredicate(false, x, y);
    }

    public static Predicate notEqual(Expression x, Object y) {
        return new NotEqualPredicate(x, y);
    }

    public static Predicate equal(Expression x, Object y) {
        return new EqualPredicate(x, y);
    }

    public static Predicate like(Expression<String> x, String pattern) {
        return new LikePredicate(x, pattern);
    }

    public static <T extends Comparable<T>> Predicate greaterThan(Expression<? extends T> x, T y) {
        return new GreaterLessPredicate(x, y, false, false);
    }

    public static <T extends Comparable<T>> Predicate greaterEqual(Expression<? extends T> x, T y) {
        return new GreaterLessPredicate(x, y, true, false);
    }

    public static <T extends Comparable<T>> Predicate lessThan(Expression<? extends T> x, T y) {
        return new GreaterLessPredicate(x, y, false, true);
    }

    public static <T extends Comparable<T>> Predicate lessEqual(Expression<? extends T> x, T y) {
        return new GreaterLessPredicate(x, y, true, true);
    }

    public static <T extends Comparable<T>> Predicate between(Expression<? extends T> expression, T from, T to) {
        return new BetweenPredicate(expression, from, to);
    }

    public static <T extends Comparable<T>> Predicate in(Expression<? extends T> expression, T ... values) {
        return new InPredicate(expression, values);
    }

    public static Predicate isNot(final Expression<Boolean> x) {
        return new Predicate(){

            public boolean apply(MapEntry entry) {
                Boolean value = (Boolean)x.getValue(entry);
                return Boolean.FALSE.equals(value);
            }
        };
    }

    public static GetExpression get(String methodName) {
        return new GetExpressionImpl(methodName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class GetExpressionImpl<T>
    extends AbstractExpression
    implements GetExpression,
    DataSerializable {
        transient Getter getter = null;
        String input;
        List<GetExpressionImpl<T>> ls = null;

        public GetExpressionImpl() {
        }

        public GetExpressionImpl(String input) {
            this.input = input;
        }

        @Override
        public GetExpression get(String methodName) {
            if (this.ls == null) {
                this.ls = new ArrayList<GetExpressionImpl<T>>();
            }
            this.ls.add(new GetExpressionImpl<T>(methodName));
            return this;
        }

        public Object getValue(Object obj) {
            if (this.ls != null) {
                Object result = this.doGetValue(obj);
                for (GetExpressionImpl<T> e : this.ls) {
                    result = super.doGetValue(result);
                }
                return result;
            }
            return this.doGetValue(obj);
        }

        private Object doGetValue(Object obj) {
            if (obj instanceof MapEntry) {
                obj = ((MapEntry)obj).getValue();
            }
            if (obj == null) {
                return null;
            }
            try {
                if (this.getter == null) {
                    ThisGetter parent = null;
                    Class<?> clazz = obj.getClass();
                    ArrayList<String> possibleMethodNames = new ArrayList<String>(3);
                    for (String name : this.input.split("\\.")) {
                        Getter localGetter = null;
                        possibleMethodNames.clear();
                        possibleMethodNames.add(name);
                        String camelName = Character.toUpperCase(name.charAt(0)) + name.substring(1);
                        possibleMethodNames.add("get" + camelName);
                        possibleMethodNames.add("is" + camelName);
                        if (name.equals("this")) {
                            localGetter = new ThisGetter(parent, obj);
                        } else {
                            for (String methodName : possibleMethodNames) {
                                try {
                                    Method method = clazz.getMethod(methodName, null);
                                    method.setAccessible(true);
                                    localGetter = new MethodGetter(parent, method);
                                    clazz = method.getReturnType();
                                    break;
                                }
                                catch (NoSuchMethodException ignored) {
                                }
                            }
                            if (localGetter == null) {
                                try {
                                    Field field = clazz.getField(name);
                                    localGetter = new FieldGetter(parent, field);
                                    clazz = field.getType();
                                }
                                catch (NoSuchFieldException ignored) {
                                    // empty catch block
                                }
                            }
                            if (localGetter == null) {
                                Class<?> c = clazz;
                                while (!Object.class.equals(c)) {
                                    try {
                                        Field field = c.getDeclaredField(name);
                                        field.setAccessible(true);
                                        localGetter = new FieldGetter(parent, field);
                                        clazz = field.getType();
                                        break;
                                    }
                                    catch (NoSuchFieldException ignored) {
                                        c = c.getSuperclass();
                                    }
                                }
                            }
                        }
                        if (localGetter == null) {
                            throw new RuntimeException("There is no suitable accessor for '" + name + "'");
                        }
                        parent = localGetter;
                    }
                    this.getter = parent;
                }
                return this.getter.getValue(obj);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            out.writeUTF(this.input);
        }

        @Override
        public void readData(DataInput in) throws IOException {
            this.input = in.readUTF();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GetExpressionImpl)) {
                return false;
            }
            GetExpressionImpl that = (GetExpressionImpl)o;
            return this.input.equals(that.input);
        }

        public int hashCode() {
            return this.input.hashCode();
        }

        public String toString() {
            return this.input;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ThisGetter
        extends Getter {
            final Object object;

            public ThisGetter(Getter parent, Object object) {
                super(parent);
                this.object = object;
            }

            @Override
            Object getValue(Object obj) throws Exception {
                return obj;
            }

            @Override
            Class getReturnType() {
                return this.object.getClass();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class FieldGetter
        extends Getter {
            final Field field;

            FieldGetter(Getter parent, Field field) {
                super(parent);
                this.field = field;
            }

            @Override
            Object getValue(Object obj) throws Exception {
                obj = this.parent != null ? this.parent.getValue(obj) : obj;
                return obj != null ? this.field.get(obj) : null;
            }

            @Override
            Class getReturnType() {
                return this.field.getType();
            }

            public String toString() {
                return "FieldGetter [parent=" + this.parent + ", field=" + this.field + "]";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MethodGetter
        extends Getter {
            final Method method;

            MethodGetter(Getter parent, Method method) {
                super(parent);
                this.method = method;
            }

            @Override
            Object getValue(Object obj) throws Exception {
                obj = this.parent != null ? this.parent.getValue(obj) : obj;
                return obj != null ? this.method.invoke(obj, new Object[0]) : null;
            }

            @Override
            Class getReturnType() {
                return this.method.getReturnType();
            }

            public String toString() {
                return "MethodGetter [parent=" + this.parent + ", method=" + this.method.getName() + "]";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        abstract class Getter {
            protected final Getter parent;

            public Getter(Getter parent) {
                this.parent = parent;
            }

            abstract Object getValue(Object var1) throws Exception;

            abstract Class getReturnType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface GetExpression<T>
    extends Expression {
        public GetExpression get(String var1);
    }

    public static abstract class AbstractExpression
    extends SerializationHelper
    implements Expression {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AndOrPredicate
    extends AbstractPredicate
    implements IndexAwarePredicate {
        Predicate[] predicates;
        boolean and = false;

        public AndOrPredicate() {
        }

        public AndOrPredicate(boolean and, Predicate first, Predicate second) {
            this.and = and;
            this.predicates = new Predicate[]{first, second};
        }

        public AndOrPredicate(boolean and, Predicate ... predicates) {
            this.and = and;
            this.predicates = predicates;
        }

        public boolean apply(MapEntry mapEntry) {
            for (Predicate predicate : this.predicates) {
                boolean result = predicate.apply(mapEntry);
                if (this.and && !result) {
                    return false;
                }
                if (this.and || !result) continue;
                return true;
            }
            return this.and;
        }

        @Override
        public boolean collectIndexAwarePredicates(List<IndexAwarePredicate> lsIndexPredicates, Map<Expression, Index> mapIndexes) {
            boolean strong = this.and;
            if (!mapIndexes.isEmpty()) {
                lsIndexPredicates.add(this);
                if (strong) {
                    ArrayList<IndexAwarePredicate> indexPredicates = new ArrayList<IndexAwarePredicate>(this.predicates.length);
                    for (Predicate predicate : this.predicates) {
                        if (predicate instanceof IndexAwarePredicate) {
                            IndexAwarePredicate p = (IndexAwarePredicate)predicate;
                            if (!p.collectIndexAwarePredicates(indexPredicates, mapIndexes)) {
                                strong = false;
                            }
                        } else {
                            strong = false;
                        }
                        if (!strong) break;
                    }
                }
                return strong;
            }
            if (this.and) {
                for (Predicate predicate : this.predicates) {
                    if (predicate instanceof IndexAwarePredicate) {
                        IndexAwarePredicate p = (IndexAwarePredicate)predicate;
                        if (p.collectIndexAwarePredicates(lsIndexPredicates, mapIndexes)) continue;
                        strong = false;
                        continue;
                    }
                    strong = false;
                }
            }
            return strong;
        }

        @Override
        public boolean isIndexed(QueryContext queryContext) {
            return true;
        }

        @Override
        public Set<MapEntry> filter(QueryContext queryContext) {
            Set<Object> results = null;
            for (Predicate predicate : this.predicates) {
                Set<Object> filter = null;
                if (predicate instanceof IndexAwarePredicate && ((IndexAwarePredicate)predicate).isIndexed(queryContext)) {
                    IndexAwarePredicate p = (IndexAwarePredicate)predicate;
                    filter = p.filter(queryContext);
                } else {
                    filter = new HashSet();
                    if (this.and && results != null) {
                        for (MapEntry mapEntry : results) {
                            if (!predicate.apply(mapEntry)) continue;
                            filter.add(mapEntry);
                        }
                        results = filter;
                        continue;
                    }
                    for (Record record : queryContext.getMapIndexService().getOwnedRecords()) {
                        if (!predicate.apply(record)) continue;
                        filter.add(record);
                    }
                }
                if (this.and && (filter == null || filter.isEmpty())) {
                    return null;
                }
                if (results == null) {
                    if (this.and) {
                        results = filter;
                        continue;
                    }
                    if (filter == null) {
                        results = new HashSet();
                        continue;
                    }
                    results = new HashSet<Object>(filter);
                    continue;
                }
                if (this.and) {
                    boolean direct = results.size() < filter.size();
                    Set<Object> set = direct ? results : filter;
                    Set<Object> s2 = direct ? filter : results;
                    results = new HashSet();
                    for (MapEntry mapEntry : set) {
                        if (!s2.contains(mapEntry)) continue;
                        results.add(mapEntry);
                    }
                    if (!results.isEmpty()) continue;
                    return null;
                }
                if (filter == null) continue;
                results.addAll(filter);
            }
            return results;
        }

        @Override
        public void collectAppliedIndexes(Set<Index> setAppliedIndexes, Map<Expression, Index> mapIndexes) {
            if (this.and) {
                for (Predicate predicate : this.predicates) {
                    if (!(predicate instanceof IndexAwarePredicate)) continue;
                    IndexAwarePredicate p = (IndexAwarePredicate)predicate;
                    p.collectAppliedIndexes(setAppliedIndexes, mapIndexes);
                }
            }
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            out.writeBoolean(this.and);
            out.writeInt(this.predicates.length);
            for (Predicate predicate : this.predicates) {
                AndOrPredicate.writeObject(out, predicate);
            }
        }

        @Override
        public void readData(DataInput in) throws IOException {
            this.and = in.readBoolean();
            int len = in.readInt();
            this.predicates = new Predicate[len];
            for (int i = 0; i < len; ++i) {
                this.predicates[i] = (Predicate)AndOrPredicate.readObject(in);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("(");
            String andOr = this.and ? " AND " : " OR ";
            int size = this.predicates.length;
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    sb.append(andOr);
                }
                sb.append(this.predicates[i]);
            }
            sb.append(")");
            return sb.toString();
        }
    }

    public static abstract class AbstractPredicate
    extends SerializationHelper
    implements Predicate,
    DataSerializable {
        public static Object getRealObject(Object type, String value) {
            Comparable<Integer> result = null;
            if (type instanceof Boolean) {
                result = "true".equalsIgnoreCase(value);
            } else if (type instanceof Integer) {
                result = Integer.valueOf(value);
            } else if (type instanceof Long) {
                result = Long.valueOf(value);
            } else if (type instanceof Double) {
                result = Double.valueOf(value);
            } else if (type instanceof Float) {
                result = Float.valueOf(value);
            } else if (type instanceof Byte) {
                result = Byte.valueOf(value);
            } else if (type instanceof Timestamp) {
                try {
                    result = new Timestamp(timestampFormat.parse(value).getTime());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            } else if (type instanceof Date) {
                try {
                    result = sqlDateFormat.parse(value);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            } else if (type instanceof java.util.Date) {
                try {
                    result = dateFormat.parse(value);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            } else {
                throw new RuntimeException("Unknown type " + type + " value=" + value);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EqualPredicate
    extends AbstractPredicate
    implements IndexAwarePredicate {
        Expression first;
        Object second;
        Object convertedSecondValue = null;
        protected boolean secondIsExpression = false;

        public EqualPredicate() {
        }

        public EqualPredicate(Expression first, Expression second) {
            this.first = first;
            this.second = second;
            this.secondIsExpression = true;
        }

        public EqualPredicate(Expression first, Object second) {
            this.first = first;
            this.second = second;
        }

        public boolean apply(MapEntry entry) {
            if (this.secondIsExpression) {
                return this.doApply(this.first.getValue(entry), ((Expression)this.second).getValue(entry));
            }
            Object firstVal = this.first.getValue(entry);
            if (firstVal == null) {
                return this.second == null;
            }
            if (this.second == null) {
                return false;
            }
            if (this.convertedSecondValue == null) {
                this.convertedSecondValue = EqualPredicate.getConvertedRealValue(firstVal, this.second);
            }
            return this.doApply(firstVal, this.convertedSecondValue);
        }

        protected static Object getConvertedRealValue(Object firstValue, Object value) {
            if (firstValue == null) {
                return value;
            }
            if (firstValue.getClass() == value.getClass()) {
                return value;
            }
            return EqualPredicate.getRealObject(firstValue, String.valueOf(value));
        }

        protected boolean doApply(Object first, Object second) {
            return first.equals(second);
        }

        @Override
        public boolean collectIndexAwarePredicates(List<IndexAwarePredicate> lsIndexPredicates, Map<Expression, Index> mapIndexes) {
            if (!this.secondIsExpression && this.first instanceof GetExpression) {
                Index index = mapIndexes.get(this.first);
                if (index != null) {
                    lsIndexPredicates.add(this);
                } else {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void collectAppliedIndexes(Set<Index> setAppliedIndexes, Map<Expression, Index> mapIndexes) {
            Index index = mapIndexes.get(this.first);
            if (index != null) {
                setAppliedIndexes.add(index);
            }
        }

        @Override
        public boolean isIndexed(QueryContext queryContext) {
            return queryContext.getMapIndexes().get(this.first) != null;
        }

        @Override
        public Set<MapEntry> filter(QueryContext queryContext) {
            Index index = queryContext.getMapIndexes().get(this.first);
            if (index != null) {
                return index.getRecords(index.getLongValue(this.second));
            }
            return null;
        }

        public Object getValue() {
            return this.second;
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            EqualPredicate.writeObject(out, this.first);
            out.writeBoolean(this.secondIsExpression);
            EqualPredicate.writeObject(out, this.second);
        }

        @Override
        public void readData(DataInput in) throws IOException {
            try {
                this.first = (Expression)EqualPredicate.readObject(in);
                this.secondIsExpression = in.readBoolean();
                this.second = EqualPredicate.readObject(in);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }

        public String toString() {
            return this.first + "=" + this.second;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LikePredicate
    extends AbstractPredicate {
        Expression<String> first;
        String second;
        Pattern pattern = null;

        public LikePredicate() {
        }

        public LikePredicate(Expression<String> first, String second) {
            this.first = first;
            this.second = second;
        }

        public boolean apply(MapEntry entry) {
            String firstVal = this.first.getValue(entry);
            if (firstVal == null) {
                return this.second == null;
            }
            if (this.second == null) {
                return false;
            }
            if (this.pattern == null) {
                this.pattern = Pattern.compile(this.second.replaceAll("%", ".*").replaceAll("_", "."));
            }
            Matcher m = this.pattern.matcher(firstVal);
            return m.matches();
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            LikePredicate.writeObject(out, this.first);
            out.writeUTF(this.second);
        }

        @Override
        public void readData(DataInput in) throws IOException {
            try {
                this.first = (Expression)LikePredicate.readObject(in);
                this.second = in.readUTF();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }

        public String toString() {
            return this.first + " LIKE '" + this.second + "'";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RegexPredicate
    extends AbstractPredicate {
        Expression<String> first;
        String regex;
        Pattern pattern = null;

        public RegexPredicate() {
        }

        public RegexPredicate(Expression<String> first, String regex) {
            this.first = first;
            this.regex = regex;
        }

        public boolean apply(MapEntry entry) {
            String firstVal = this.first.getValue(entry);
            if (firstVal == null) {
                return this.regex == null;
            }
            if (this.regex == null) {
                return false;
            }
            if (this.pattern == null) {
                this.pattern = Pattern.compile(this.regex);
            }
            Matcher m = this.pattern.matcher(firstVal);
            return m.matches();
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            RegexPredicate.writeObject(out, this.first);
            out.writeUTF(this.regex);
        }

        @Override
        public void readData(DataInput in) throws IOException {
            try {
                this.first = (Expression)RegexPredicate.readObject(in);
                this.regex = in.readUTF();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }

        public String toString() {
            return this.first + " REGEX '" + this.regex + "'";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InPredicate
    extends AbstractPredicate
    implements IndexAwarePredicate {
        Expression first;
        Object[] inValueArray = null;
        Set inValues = null;
        Set convertedInValues = null;
        Object firstValueObject = null;

        public InPredicate() {
        }

        public InPredicate(Expression first, Object ... second) {
            this.first = first;
            this.inValueArray = second;
        }

        private void checkInValues() {
            if (this.inValues == null) {
                this.inValues = new HashSet(this.inValueArray.length);
                for (Object o : this.inValueArray) {
                    this.inValues.add(o);
                }
            }
        }

        public boolean apply(MapEntry entry) {
            Object entryValue;
            this.checkInValues();
            if (this.firstValueObject == null) {
                this.firstValueObject = this.inValues.iterator().next();
            }
            if ((entryValue = this.first.getValue(entry)) == null) {
                return false;
            }
            if (this.convertedInValues != null) {
                return InPredicate.in(entryValue, this.convertedInValues);
            }
            if (entryValue.getClass() == this.firstValueObject.getClass()) {
                return InPredicate.in(entryValue, this.inValues);
            }
            if (this.firstValueObject instanceof String) {
                this.convertedInValues = new HashSet(this.inValues.size());
                for (Object objValue : this.inValues) {
                    this.convertedInValues.add(InPredicate.getRealObject(entryValue, (String)objValue));
                }
                return InPredicate.in(entryValue, this.convertedInValues);
            }
            return InPredicate.in(entryValue, this.inValues);
        }

        private static boolean in(Object firstVal, Set values) {
            return values.contains(firstVal);
        }

        @Override
        public boolean collectIndexAwarePredicates(List<IndexAwarePredicate> lsIndexPredicates, Map<Expression, Index> mapIndexes) {
            if (this.first instanceof GetExpression) {
                Index index = mapIndexes.get(this.first);
                if (index != null) {
                    lsIndexPredicates.add(this);
                } else {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void collectAppliedIndexes(Set<Index> setAppliedIndexes, Map<Expression, Index> mapIndexes) {
            Index index = mapIndexes.get(this.first);
            if (index != null) {
                setAppliedIndexes.add(index);
            }
        }

        @Override
        public boolean isIndexed(QueryContext queryContext) {
            return queryContext.getMapIndexes().get(this.first) != null;
        }

        @Override
        public Set<MapEntry> filter(QueryContext queryContext) {
            this.checkInValues();
            Index index = queryContext.getMapIndexes().get(this.first);
            if (index != null) {
                HashSet<Long> setLongValues = new HashSet<Long>(this.inValues.size());
                for (Object valueObj : this.inValues) {
                    Long value = index.getLongValue(valueObj);
                    setLongValues.add(value);
                }
                return index.getRecords(setLongValues);
            }
            return null;
        }

        public Object getValue() {
            return this.inValues;
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            InPredicate.writeObject(out, this.first);
            out.writeInt(this.inValueArray.length);
            for (Object value : this.inValueArray) {
                InPredicate.writeObject(out, value);
            }
        }

        @Override
        public void readData(DataInput in) throws IOException {
            try {
                this.first = (Expression)InPredicate.readObject(in);
                int len = in.readInt();
                this.inValueArray = new Object[len];
                for (int i = 0; i < len; ++i) {
                    this.inValueArray[i] = InPredicate.readObject(in);
                }
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.first);
            sb.append(" IN (");
            for (int i = 0; i < this.inValueArray.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(this.inValueArray[i]);
            }
            sb.append(")");
            return sb.toString();
        }
    }

    public static class NotPredicate
    extends AbstractPredicate {
        Predicate predicate;

        public NotPredicate(Predicate predicate) {
            this.predicate = predicate;
        }

        public NotPredicate() {
        }

        public boolean apply(MapEntry mapEntry) {
            return !this.predicate.apply(mapEntry);
        }

        public void writeData(DataOutput out) throws IOException {
            NotPredicate.writeObject(out, this.predicate);
        }

        public void readData(DataInput in) throws IOException {
            this.predicate = (Predicate)NotPredicate.readObject(in);
        }

        public String toString() {
            return "NOT(" + this.predicate + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NotEqualPredicate
    extends EqualPredicate
    implements IndexAwarePredicate {
        public NotEqualPredicate() {
        }

        public NotEqualPredicate(Expression first, Expression second) {
            super(first, second);
        }

        public NotEqualPredicate(Expression first, Object second) {
            super(first, second);
        }

        @Override
        public boolean apply(MapEntry entry) {
            return !super.apply(entry);
        }

        @Override
        public Set<MapEntry> filter(QueryContext queryContext) {
            Index index = queryContext.getMapIndexes().get(this.first);
            if (index != null) {
                return index.getSubRecords(false, false, index.getLongValue(this.second));
            }
            return null;
        }

        @Override
        public String toString() {
            return this.first + " != " + this.second;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BetweenPredicate
    extends EqualPredicate {
        Object to;
        Comparable fromConvertedValue = null;
        Comparable toConvertedValue = null;

        public BetweenPredicate() {
        }

        public BetweenPredicate(Expression first, Expression from, Object to) {
            super(first, from);
            this.to = to;
        }

        public BetweenPredicate(Expression first, Object from, Object to) {
            super(first, from);
            this.to = to;
        }

        @Override
        public boolean apply(MapEntry entry) {
            Expression cFirst = this.first;
            Comparable firstValue = (Comparable)cFirst.getValue(entry);
            if (firstValue == null) {
                return false;
            }
            if (this.fromConvertedValue == null) {
                this.fromConvertedValue = (Comparable)BetweenPredicate.getConvertedRealValue(firstValue, this.second);
                this.toConvertedValue = (Comparable)BetweenPredicate.getConvertedRealValue(firstValue, this.to);
            }
            if (firstValue == null || this.fromConvertedValue == null || this.toConvertedValue == null) {
                return false;
            }
            return firstValue.compareTo(this.fromConvertedValue) >= 0 && firstValue.compareTo(this.toConvertedValue) <= 0;
        }

        @Override
        public Set<MapEntry> filter(QueryContext queryContext) {
            Index index = queryContext.getMapIndexes().get(this.first);
            return index.getSubRecordsBetween(index.getLongValue(this.second), index.getLongValue(this.to));
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            super.writeData(out);
            BetweenPredicate.writeObject(out, this.to);
        }

        @Override
        public void readData(DataInput in) throws IOException {
            super.readData(in);
            this.to = BetweenPredicate.readObject(in);
        }

        @Override
        public String toString() {
            return this.first + " BETWEEN " + this.second + " AND " + this.to;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GreaterLessPredicate
    extends EqualPredicate {
        boolean equal = false;
        boolean less = false;

        public GreaterLessPredicate() {
        }

        public GreaterLessPredicate(Expression first, Expression second, boolean equal, boolean less) {
            super(first, second);
            this.equal = equal;
            this.less = less;
        }

        public GreaterLessPredicate(Expression first, Object second, boolean equal, boolean less) {
            super(first, second);
            this.equal = equal;
            this.less = less;
        }

        @Override
        protected boolean doApply(Object first, Object second) {
            int expectedResult = this.less ? -1 : 1;
            int result = ((Comparable)first).compareTo(second);
            return this.equal && result == 0 || expectedResult == result;
        }

        @Override
        public Set<MapEntry> filter(QueryContext queryContext) {
            Index index = queryContext.getMapIndexes().get(this.first);
            return index.getSubRecords(this.equal, this.less, index.getLongValue(this.second));
        }

        @Override
        public void readData(DataInput in) throws IOException {
            super.readData(in);
            this.equal = in.readBoolean();
            this.less = in.readBoolean();
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            super.writeData(out);
            out.writeBoolean(this.equal);
            out.writeBoolean(this.less);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.first);
            sb.append(this.less ? "<" : ">");
            if (this.equal) {
                sb.append("=");
            }
            sb.append(this.second);
            return sb.toString();
        }
    }
}

