/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.ClusterImpl;
import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.AtomicNumber;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.HazelcastInstanceAwareObject;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.Instance;
import com.hazelcast.core.InstanceDestroyedException;
import com.hazelcast.core.InstanceEvent;
import com.hazelcast.core.InstanceListener;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.MapEntry;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.core.MessageListener;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.MultiTask;
import com.hazelcast.core.Transaction;
import com.hazelcast.impl.AsyncCall;
import com.hazelcast.impl.AtomicNumberProxy;
import com.hazelcast.impl.BaseCollection;
import com.hazelcast.impl.BaseManager;
import com.hazelcast.impl.BlockingQueueManager;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.CollectionProxy;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.Constants;
import com.hazelcast.impl.CountDownLatchProxy;
import com.hazelcast.impl.ExecutorServiceProxy;
import com.hazelcast.impl.HazelcastInstanceAwareInstance;
import com.hazelcast.impl.IGetAwareProxy;
import com.hazelcast.impl.LifecycleServiceImpl;
import com.hazelcast.impl.ListProxyImpl;
import com.hazelcast.impl.ListenerManager;
import com.hazelcast.impl.LockProxy;
import com.hazelcast.impl.MProxy;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.MultiMapProxy;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.QProxy;
import com.hazelcast.impl.SemaphoreProxy;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.TopicManager;
import com.hazelcast.impl.TopicProxy;
import com.hazelcast.impl.TransactionFactory;
import com.hazelcast.impl.TransactionImpl;
import com.hazelcast.impl.Util;
import com.hazelcast.impl.base.FactoryAwareNamedProxy;
import com.hazelcast.impl.base.RuntimeInterruptedException;
import com.hazelcast.impl.concurrentmap.AddMapIndex;
import com.hazelcast.impl.management.ManagementCenterService;
import com.hazelcast.impl.monitor.AtomicNumberOperationsCounter;
import com.hazelcast.impl.monitor.CountDownLatchOperationsCounter;
import com.hazelcast.impl.monitor.LocalAtomicNumberStatsImpl;
import com.hazelcast.impl.monitor.LocalCountDownLatchStatsImpl;
import com.hazelcast.impl.monitor.LocalLockStatsImpl;
import com.hazelcast.impl.monitor.LocalMapStatsImpl;
import com.hazelcast.impl.monitor.LocalQueueStatsImpl;
import com.hazelcast.impl.monitor.LocalSemaphoreStatsImpl;
import com.hazelcast.impl.monitor.LocalTopicStatsImpl;
import com.hazelcast.impl.monitor.LockOperationsCounter;
import com.hazelcast.impl.monitor.MapOperationsCounter;
import com.hazelcast.impl.monitor.QueueOperationsCounter;
import com.hazelcast.impl.monitor.SemaphoreOperationsCounter;
import com.hazelcast.impl.monitor.TopicOperationsCounter;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.monitor.LocalAtomicNumberStats;
import com.hazelcast.monitor.LocalCountDownLatchStats;
import com.hazelcast.monitor.LocalLockStats;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.LocalQueueStats;
import com.hazelcast.monitor.LocalSemaphoreStats;
import com.hazelcast.monitor.LocalTopicStats;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.SerializationHelper;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.query.Expression;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.Predicates;
import com.hazelcast.util.ResponseQueueFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryImpl
implements HazelcastInstance {
    static final ConcurrentMap<String, FactoryImpl> factories = new ConcurrentHashMap<String, FactoryImpl>(5);
    private static AtomicInteger factoryIdGen = new AtomicInteger();
    final ConcurrentMap<String, HazelcastInstanceAwareInstance> proxiesByName = new ConcurrentHashMap<String, HazelcastInstanceAwareInstance>(1000);
    final ConcurrentMap<ProxyKey, HazelcastInstanceAwareInstance> proxies = new ConcurrentHashMap<ProxyKey, HazelcastInstanceAwareInstance>(1000);
    final MProxy locksMapProxy;
    final MProxy idGeneratorMapProxy;
    final MProxy globalProxies;
    final ConcurrentMap<String, ExecutorServiceProxy> executorServiceProxies = new ConcurrentHashMap<String, ExecutorServiceProxy>(2);
    final CopyOnWriteArrayList<InstanceListener> lsInstanceListeners = new CopyOnWriteArrayList();
    final String name;
    final TransactionFactory transactionFactory;
    final HazelcastInstanceProxy hazelcastInstanceProxy;
    final ManagementService managementService;
    final ILogger logger;
    final LifecycleServiceImpl lifecycleService;
    final ManagementCenterService managementCenterService;
    public final Node node;
    volatile boolean restarted = false;

    public static HazelcastInstanceProxy newHazelcastInstanceProxy(Config config) {
        FactoryImpl factory = null;
        try {
            if (config == null) {
                config = new XmlConfigBuilder().build();
            }
            String name = "_hzInstance_" + factoryIdGen.incrementAndGet() + "_" + config.getGroupConfig().getName();
            factory = new FactoryImpl(name, config);
            factories.put(name, factory);
            boolean firstMember = factory.node.getClusterImpl().getMembers().iterator().next().localMember();
            int initialWaitSeconds = factory.node.groupProperties.INITIAL_WAIT_SECONDS.getInteger();
            if (initialWaitSeconds > 0) {
                try {
                    Thread.sleep(initialWaitSeconds * 1000);
                    if (firstMember) {
                        final ConcurrentMapManager concurrentMapManager = factory.node.concurrentMapManager;
                        concurrentMapManager.enqueueAndReturn(new Processable(){

                            public void process() {
                                concurrentMapManager.partitionManager.quickBlockRearrangement();
                            }
                        });
                    } else {
                        Thread.sleep(4000L);
                    }
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }
            int initialMinClusterSize = factory.node.groupProperties.INITIAL_MIN_CLUSTER_SIZE.getInteger();
            while (factory.node.getClusterImpl().getMembers().size() < initialMinClusterSize) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignored) {}
            }
            if (initialMinClusterSize > 0) {
                if (firstMember) {
                    final ConcurrentMapManager concurrentMapManager = factory.node.concurrentMapManager;
                    concurrentMapManager.enqueueAndReturn(new Processable(){

                        public void process() {
                            concurrentMapManager.partitionManager.quickBlockRearrangement();
                        }
                    });
                } else {
                    Thread.sleep(4000L);
                }
                factory.logger.log(Level.INFO, "HazelcastInstance starting after waiting for cluster size of " + initialMinClusterSize);
            }
            factory.lifecycleService.fireLifecycleEvent(LifecycleEvent.LifecycleState.STARTED);
            return factory.hazelcastInstanceProxy;
        }
        catch (Throwable t) {
            if (factory != null) {
                factory.logger.log(Level.SEVERE, t.getMessage(), t);
            }
            throw new RuntimeException(t);
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return o == this || this.name.equals(((FactoryImpl)o).name);
    }

    public HazelcastInstanceProxy getHazelcastInstanceProxy() {
        return this.hazelcastInstanceProxy;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static void shutdownAll() {
        Collection colFactories = factories.values();
        for (FactoryImpl factory : colFactories) {
            factory.shutdown();
        }
        factories.clear();
        FactoryImpl.shutdownManagementService();
        ThreadContext.shutdownAll();
    }

    public static void shutdown(HazelcastInstanceProxy hazelcastInstanceProxy) {
        FactoryImpl factory = hazelcastInstanceProxy.getFactory();
        factory.managementService.unregister();
        factory.proxies.clear();
        if (factory.managementCenterService != null) {
            factory.managementCenterService.shutdown();
        }
        for (ExecutorServiceProxy esp : factory.executorServiceProxies.values()) {
            esp.shutdown();
        }
        factory.node.shutdown();
        factories.remove(factory.getName());
        if (factories.size() == 0) {
            FactoryImpl.shutdownManagementService();
        }
    }

    private static void shutdownManagementService() {
        ManagementService.shutdown();
    }

    public FactoryImpl(String name, Config config) {
        this.name = name;
        this.node = new Node(this, config);
        this.globalProxies = new MProxyImpl("c:__hz_Proxies", this);
        this.logger = this.node.getLogger(FactoryImpl.class.getName());
        this.lifecycleService = new LifecycleServiceImpl(this);
        this.transactionFactory = new TransactionFactory(this);
        this.hazelcastInstanceProxy = new HazelcastInstanceProxy(this);
        this.locksMapProxy = new MProxyImpl("c:__hz_Locks", this);
        this.idGeneratorMapProxy = new MProxyImpl("c:__hz_IdGenerator", this);
        this.lifecycleService.fireLifecycleEvent(LifecycleEvent.LifecycleState.STARTING);
        this.node.start();
        this.globalProxies.addEntryListener(new EntryListener(){

            public void entryAdded(EntryEvent event) {
                if (FactoryImpl.this.node.localMember.equals(event.getMember())) {
                    return;
                }
                final ProxyKey proxyKey = (ProxyKey)event.getKey();
                if (!FactoryImpl.this.proxies.containsKey(proxyKey)) {
                    FactoryImpl.this.logger.log(Level.FINEST, "Instance created " + proxyKey);
                    FactoryImpl.this.node.clusterService.enqueueAndReturn(new Processable(){

                        public void process() {
                            FactoryImpl.this.createProxy(proxyKey);
                        }
                    });
                }
            }

            public void entryRemoved(EntryEvent event) {
                if (FactoryImpl.this.node.localMember.equals(event.getMember())) {
                    return;
                }
                final ProxyKey proxyKey = (ProxyKey)event.getKey();
                FactoryImpl.this.logger.log(Level.FINEST, "Instance removed " + proxyKey);
                FactoryImpl.this.node.clusterService.enqueueAndReturn(new Processable(){

                    public void process() {
                        FactoryImpl.this.destroyProxy(proxyKey);
                    }
                });
            }

            public void entryUpdated(EntryEvent event) {
                FactoryImpl.this.logger.log(Level.FINEST, "Instance updated " + event.getKey());
            }

            public void entryEvicted(EntryEvent event) {
                FactoryImpl.this.logger.log(Level.FINEST, "Instance evicted " + event.getKey());
            }
        }, false);
        if (this.node.getClusterImpl().getMembers().size() > 1) {
            Set proxyKeys = this.globalProxies.allKeys();
            for (final ProxyKey proxyKey : proxyKeys) {
                if (this.proxies.containsKey(proxyKey)) continue;
                this.node.clusterService.enqueueAndReturn(new Processable(){

                    public void process() {
                        FactoryImpl.this.createProxy(proxyKey);
                    }
                });
            }
        }
        this.managementService = new ManagementService(this);
        this.managementService.register();
        ManagementCenterService managementCenterServiceTmp = null;
        if (this.node.groupProperties.MANCENTER_ENABLED.getBoolean()) {
            try {
                managementCenterServiceTmp = new ManagementCenterService(this);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.managementCenterService = managementCenterServiceTmp;
    }

    public Set<String> getLongInstanceNames() {
        return this.proxiesByName.keySet();
    }

    public String toString() {
        return "HazelcastInstance {name='" + this.name + "'}";
    }

    @Override
    public Config getConfig() {
        return this.node.getConfig();
    }

    @Override
    public Collection<Instance> getInstances() {
        return new ArrayList<Instance>(this.proxies.values());
    }

    public Collection<HazelcastInstanceAwareInstance> getProxies() {
        this.initialChecks();
        return this.proxies.values();
    }

    @Override
    public ExecutorService getExecutorService() {
        this.initialChecks();
        return this.getExecutorService("default");
    }

    @Override
    public ExecutorService getExecutorService(String name) {
        ExecutorServiceProxy old;
        if (name == null) {
            throw new IllegalArgumentException("ExecutorService name cannot be null");
        }
        this.initialChecks();
        name = "x:" + name;
        ExecutorServiceProxy executorServiceProxy = (ExecutorServiceProxy)this.executorServiceProxies.get(name);
        if (executorServiceProxy == null && (old = this.executorServiceProxies.putIfAbsent(name, executorServiceProxy = new ExecutorServiceProxy(this.node, name))) != null) {
            executorServiceProxy = old;
        }
        return executorServiceProxy;
    }

    @Override
    public ClusterImpl getCluster() {
        this.initialChecks();
        return this.node.getClusterImpl();
    }

    @Override
    public IdGenerator getIdGenerator(String name) {
        return (IdGenerator)this.getOrCreateProxyByName("i:" + name);
    }

    @Override
    public AtomicNumber getAtomicNumber(String name) {
        return (AtomicNumber)this.getOrCreateProxyByName("a:" + name);
    }

    @Override
    public ICountDownLatch getCountDownLatch(String name) {
        return (ICountDownLatch)this.getOrCreateProxyByName("d:" + name);
    }

    @Override
    public ISemaphore getSemaphore(String name) {
        return (ISemaphore)this.getOrCreateProxyByName("4:" + name);
    }

    @Override
    public Transaction getTransaction() {
        this.initialChecks();
        ThreadContext threadContext = ThreadContext.get();
        threadContext.setCurrentFactory(this);
        TransactionImpl txn = threadContext.getCallContext().getTransaction();
        if (txn == null) {
            txn = this.transactionFactory.newTransaction();
            threadContext.getCallContext().setTransaction(txn);
        }
        return txn;
    }

    @Override
    public PartitionService getPartitionService() {
        return this.node.concurrentMapManager.partitionManager.partitionServiceImpl;
    }

    @Override
    public LoggingService getLoggingService() {
        return this.node.loggingService;
    }

    @Override
    public LifecycleService getLifecycleService() {
        return this.lifecycleService;
    }

    @Override
    public void restart() {
        this.lifecycleService.restart();
    }

    @Override
    public void shutdown() {
        this.lifecycleService.shutdown();
    }

    @Override
    public <K, V> IMap<K, V> getMap(String name) {
        return (IMap)this.getOrCreateProxyByName("c:" + name);
    }

    @Override
    public <E> IQueue<E> getQueue(String name) {
        return (IQueue)this.getOrCreateProxyByName("q:" + name);
    }

    @Override
    public <E> ITopic<E> getTopic(String name) {
        return (ITopic)this.getOrCreateProxyByName("t:" + name);
    }

    @Override
    public <E> ISet<E> getSet(String name) {
        return (ISet)this.getOrCreateProxyByName("m:s:" + name);
    }

    @Override
    public <E> IList<E> getList(String name) {
        return (IList)this.getOrCreateProxyByName("l:" + name);
    }

    @Override
    public <K, V> MultiMap<K, V> getMultiMap(String name) {
        return (MultiMap)this.getOrCreateProxyByName("m:u:" + name);
    }

    @Override
    public ILock getLock(Object key) {
        return (ILock)this.getOrCreateProxy(new ProxyKey("lock", key));
    }

    public Object getOrCreateProxyByName(String name) {
        Object proxy = this.proxiesByName.get(name);
        if (proxy == null) {
            proxy = this.getOrCreateProxy(new ProxyKey(name, null));
        }
        this.checkInitialization(proxy);
        return proxy;
    }

    public Object getOrCreateProxy(ProxyKey proxyKey) {
        this.initialChecks();
        Object proxy = this.proxies.get(proxyKey);
        if (proxy == null) {
            proxy = this.createInstanceClusterWide(proxyKey);
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInitialization(Object proxy) {
        if (proxy instanceof MProxy) {
            MProxy mProxy = (MProxy)proxy;
            CMap cmap = this.node.concurrentMapManager.getMap(mProxy.getLongName());
            if (cmap == null) {
                this.logger.log(Level.WARNING, "Cmap[" + mProxy.getLongName() + "] has not been created yet! Initialization attempt failed!");
                return;
            }
            if (!cmap.isMapForQueue() && !cmap.initialized) {
                Object object = cmap.getInitLock();
                synchronized (object) {
                    block12: {
                        if (!cmap.initialized && cmap.loader != null) {
                            try {
                                Set keys;
                                if (this.getAtomicNumber(this.name).compareAndSet(0L, 1L)) {
                                    ExecutorService es = this.getExecutorService();
                                    MultiTask<Boolean> task = new MultiTask<Boolean>(new InitializeMap(mProxy.getName()), this.getCluster().getMembers());
                                    es.execute(task);
                                }
                                if ((keys = cmap.loader.loadAllKeys()) != null) {
                                    int count = 0;
                                    PartitionService partitionService = this.getPartitionService();
                                    ConcurrentLinkedQueue<Set> chunks = new ConcurrentLinkedQueue<Set>();
                                    HashSet ownedKeys = new HashSet();
                                    for (Object key : keys) {
                                        if (!partitionService.getPartition(key).getOwner().localMember()) continue;
                                        ownedKeys.add(key);
                                        ++count;
                                        if (ownedKeys.size() < this.node.groupProperties.MAP_LOAD_CHUNK_SIZE.getInteger()) continue;
                                        chunks.add(ownedKeys);
                                        ownedKeys = new HashSet();
                                    }
                                    chunks.add(ownedKeys);
                                    this.loadChunks(mProxy, cmap, chunks);
                                    this.logger.log(Level.INFO, this.node.address + "[" + mProxy.getName() + "] loaded " + count);
                                }
                            }
                            catch (Throwable e) {
                                if (!this.node.isActive()) break block12;
                                this.logger.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                    }
                    cmap.initialized = true;
                }
            }
        }
    }

    private void loadChunks(final MProxy mProxy, final CMap cmap, final Queue<Set> chunks) throws InterruptedException {
        if (chunks.size() > 0) {
            int threadCount = this.node.groupProperties.MAP_LOAD_THREAD_COUNT.getInteger();
            ExecutorService es = Executors.newFixedThreadPool(threadCount);
            final CountDownLatch latch = new CountDownLatch(chunks.size());
            for (int i = 0; i < threadCount; ++i) {
                es.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Set chunk = (Set)chunks.poll();
                        if (chunk == null) {
                            return;
                        }
                        try {
                            FactoryImpl.this.loadKeys(mProxy, cmap, chunk);
                        }
                        catch (Exception e) {
                            FactoryImpl.this.logger.log(Level.SEVERE, "Initial loading failed.", e);
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                });
            }
            latch.await();
        }
    }

    private void loadKeys(MProxy mProxy, CMap cmap, Set keys) {
        Map map;
        if (keys.size() > 0 && (map = cmap.loader.loadAll(keys)) != null && map.size() > 0) {
            Set entries = map.entrySet();
            for (Map.Entry entry : entries) {
                mProxy.putTransient(entry.getKey(), entry.getValue(), 0L, null);
            }
        }
    }

    public void initialChecks() {
        while (this.node.isActive() && this.lifecycleService.paused.get()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
        if (!this.node.isActive()) {
            throw new IllegalStateException("Hazelcast Instance is not active!");
        }
    }

    public void destroyProxy(ProxyKey proxyKey) {
        this.proxiesByName.remove(proxyKey.name);
        Instance proxy = (Instance)this.proxies.remove(proxyKey);
        if (proxy != null) {
            String name = proxyKey.name;
            if (name.startsWith("q:")) {
                this.node.blockingQueueManager.destroy(name);
            } else if (name.startsWith("c:")) {
                this.node.concurrentMapManager.destroy(name);
            } else if (name.startsWith("m:")) {
                this.node.concurrentMapManager.destroy(name);
            } else if (name.startsWith("t:")) {
                this.node.topicManager.destroy(name);
            }
            this.fireInstanceDestroyEvent(proxy);
        }
    }

    public Object createProxy(ProxyKey proxyKey) {
        this.node.clusterManager.checkServiceThread();
        boolean created = false;
        HazelcastInstanceAwareInstance proxy = (HazelcastInstanceAwareInstance)this.proxies.get(proxyKey);
        if (proxy == null) {
            created = true;
            String name = proxyKey.name;
            if (name.startsWith("q:")) {
                proxy = new QProxyImpl(name, this);
            } else if (name.startsWith("t:")) {
                proxy = new TopicProxyImpl(name, this);
            } else if (name.startsWith("c:")) {
                proxy = new MProxyImpl(name, this);
                this.node.concurrentMapManager.getOrCreateMap(name);
            } else if (name.startsWith("l:")) {
                proxy = new ListProxyImpl(name, this);
            } else if (name.startsWith("m:u:")) {
                proxy = new MultiMapProxyImpl(name, this);
            } else if (name.startsWith("m:s:")) {
                proxy = new CollectionProxyImpl(name, this);
            } else if (name.startsWith("a:")) {
                proxy = new AtomicNumberProxyImpl(name, this);
            } else if (name.startsWith("i:")) {
                proxy = new IdGeneratorProxy(name, this);
            } else if (name.startsWith("4:")) {
                proxy = new SemaphoreProxyImpl(name, this);
            } else if (name.startsWith("d:")) {
                proxy = new CountDownLatchProxyImpl(name, this);
            } else if (name.equals("lock")) {
                proxy = new LockProxyImpl(this, proxyKey.key);
            }
            HazelcastInstanceAwareInstance anotherProxy = this.proxies.putIfAbsent(proxyKey, proxy);
            if (anotherProxy != null) {
                created = false;
                proxy = anotherProxy;
            }
            if (proxyKey.key == null) {
                this.proxiesByName.put(proxyKey.name, proxy);
            }
        }
        if (created) {
            this.fireInstanceCreateEvent(proxy);
        }
        return proxy;
    }

    @Override
    public void addInstanceListener(InstanceListener instanceListener) {
        this.lsInstanceListeners.add(instanceListener);
    }

    @Override
    public void removeInstanceListener(InstanceListener instanceListener) {
        this.lsInstanceListeners.remove(instanceListener);
    }

    void fireInstanceCreateEvent(Instance instance) {
        if (this.lsInstanceListeners.size() > 0) {
            final InstanceEvent instanceEvent = new InstanceEvent(InstanceEvent.InstanceEventType.CREATED, instance);
            for (final InstanceListener instanceListener : this.lsInstanceListeners) {
                this.node.executorManager.executeLocally(new Runnable(){

                    public void run() {
                        instanceListener.instanceCreated(instanceEvent);
                    }
                });
            }
        }
    }

    void fireInstanceDestroyEvent(Instance instance) {
        if (this.lsInstanceListeners.size() > 0) {
            final InstanceEvent instanceEvent = new InstanceEvent(InstanceEvent.InstanceEventType.DESTROYED, instance);
            for (final InstanceListener instanceListener : this.lsInstanceListeners) {
                this.node.executorManager.executeLocally(new Runnable(){

                    public void run() {
                        instanceListener.instanceDestroyed(instanceEvent);
                    }
                });
            }
        }
    }

    Object createInstanceClusterWide(final ProxyKey proxyKey) {
        final BlockingQueue result = ResponseQueueFactory.newResponseQueue();
        this.node.clusterService.enqueueAndWait(new Processable(){

            public void process() {
                try {
                    result.put(FactoryImpl.this.createProxy(proxyKey));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }, 10);
        Object proxy = null;
        try {
            proxy = result.take();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.globalProxies.put(proxyKey, Constants.IO.EMPTY_DATA);
        return proxy;
    }

    void destroyInstanceClusterWide(String name, Object key) {
        final ProxyKey proxyKey = new ProxyKey(name, key);
        if (this.proxies.containsKey(proxyKey)) {
            if (name.equals("lock")) {
                this.locksMapProxy.remove(key);
            } else if (name.startsWith("i:")) {
                this.idGeneratorMapProxy.remove(name);
            }
            this.globalProxies.remove(proxyKey);
            this.node.clusterService.enqueueAndWait(new Processable(){

                public void process() {
                    try {
                        FactoryImpl.this.destroyProxy(proxyKey);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, 5);
        } else {
            this.logger.log(Level.WARNING, "Destroying unknown instance name: " + name);
        }
    }

    private static void check(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Object cannot be null.");
        }
        if (!(obj instanceof Serializable)) {
            throw new IllegalArgumentException(obj.getClass().getName() + " is not Serializable.");
        }
    }

    public static class IdGeneratorProxy
    extends FactoryAwareNamedProxy
    implements IdGenerator,
    DataSerializable {
        private transient IdGenerator base = null;

        public IdGeneratorProxy() {
        }

        public IdGeneratorProxy(String name, FactoryImpl factory) {
            this.setName(name);
            this.setHazelcastInstance(factory);
            this.base = new IdGeneratorBase();
        }

        private void ensure() {
            this.factory.initialChecks();
            if (this.base == null) {
                this.base = (IdGenerator)this.factory.getOrCreateProxyByName(this.name);
            }
        }

        public Object getId() {
            this.ensure();
            return this.base.getId();
        }

        public String toString() {
            return "IdGenerator [" + this.getName() + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IdGeneratorProxy that = (IdGeneratorProxy)o;
            return !(this.name == null ? that.name != null : !this.name.equals(that.name));
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        public Instance.InstanceType getInstanceType() {
            this.ensure();
            return this.base.getInstanceType();
        }

        public void destroy() {
            this.ensure();
            this.base.destroy();
        }

        public String getName() {
            this.ensure();
            return this.base.getName();
        }

        public long newId() {
            this.ensure();
            return this.base.newId();
        }

        private class IdGeneratorBase
        implements IdGenerator {
            private static final long MILLION = 1000000L;
            final AtomicLong million = new AtomicLong(-1L);
            final AtomicLong currentId = new AtomicLong(2000000L);

            private IdGeneratorBase() {
            }

            public String getName() {
                return IdGeneratorProxy.this.name.substring("i:".length());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long newId() {
                long idAddition = this.currentId.incrementAndGet();
                if (idAddition >= 1000000L) {
                    IdGeneratorBase idGeneratorBase = this;
                    synchronized (idGeneratorBase) {
                        idAddition = this.currentId.get();
                        if (idAddition >= 1000000L) {
                            Long idMillion = this.getNewMillion();
                            long newMillion = idMillion * 1000000L;
                            this.million.set(newMillion);
                            this.currentId.set(0L);
                        }
                        return this.newId();
                    }
                }
                long millionNow = this.million.get();
                return millionNow + idAddition;
            }

            private Long getNewMillion() {
                return IdGeneratorProxy.this.factory.getAtomicNumber("__idGen" + IdGeneratorProxy.this.name).incrementAndGet() - 1L;
            }

            public Instance.InstanceType getInstanceType() {
                return Instance.InstanceType.ID_GENERATOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void destroy() {
                this.currentId.set(2000000L);
                IdGeneratorBase idGeneratorBase = this;
                synchronized (idGeneratorBase) {
                    IdGeneratorProxy.this.factory.destroyInstanceClusterWide(IdGeneratorProxy.this.name, null);
                    IdGeneratorProxy.this.factory.getAtomicNumber("__idGen" + IdGeneratorProxy.this.name).destroy();
                    this.currentId.set(2000000L);
                    this.million.set(-1L);
                }
            }

            public Object getId() {
                return IdGeneratorProxy.this.name;
            }
        }
    }

    public static class MProxyImpl
    extends FactoryAwareNamedProxy
    implements MProxy,
    DataSerializable {
        private transient MProxy mproxyReal = null;
        private transient ConcurrentMapManager concurrentMapManager = null;
        private transient ListenerManager listenerManager = null;
        private volatile transient MProxy dynamicProxy;

        public MProxyImpl() {
        }

        MProxyImpl(String name, FactoryImpl factory) {
            this.setName(name);
            this.setHazelcastInstance(factory);
            this.mproxyReal = new MProxyReal();
        }

        public MapOperationsCounter getMapOperationCounter() {
            return this.mproxyReal.getMapOperationCounter();
        }

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            super.setHazelcastInstance(hazelcastInstance);
            this.concurrentMapManager = this.factory.node.concurrentMapManager;
            this.listenerManager = this.factory.node.listenerManager;
            ClassLoader cl = MProxy.class.getClassLoader();
            this.dynamicProxy = (MProxy)Proxy.newProxyInstance(cl, new Class[]{MProxy.class}, (InvocationHandler)new DynamicInvoker());
        }

        private void beforeCall() {
            ThreadContext.get().setCurrentFactory(this.factory);
            this.factory.initialChecks();
            if (this.mproxyReal == null) {
                this.mproxyReal = (MProxy)this.factory.getOrCreateProxyByName(this.name);
            }
        }

        private void afterCall() {
        }

        public Object get(Object key) {
            this.beforeCall();
            try {
                Object v = this.mproxyReal.get(key);
                return v;
            }
            catch (Throwable e) {
                if (this.factory.restarted) {
                    Object object = this.get(key);
                    return object;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            finally {
                this.afterCall();
            }
        }

        public Object put(Object key, Object value) {
            return this.put(key, value, 0L, TimeUnit.SECONDS);
        }

        public Future getAsync(Object key) {
            final MProxyImpl mProxy = this;
            final Data dataKey = IOUtil.toData(key);
            AsyncCall call = new AsyncCall(){

                protected void call() {
                    this.setResult(mProxy.get(dataKey));
                }
            };
            this.factory.node.executorManager.executeAsync(call);
            return call;
        }

        public Future putAsync(Object key, Object value) {
            final MProxyImpl mProxy = this;
            final Data dataKey = IOUtil.toData(key);
            final Data dataValue = IOUtil.toData(value);
            AsyncCall call = new AsyncCall(){

                protected void call() {
                    this.setResult(mProxy.put(dataKey, dataValue));
                }
            };
            this.factory.node.executorManager.executeAsync(call);
            return call;
        }

        public Future removeAsync(Object key) {
            final MProxyImpl mProxy = this;
            final Data dataKey = IOUtil.toData(key);
            AsyncCall call = new AsyncCall(){

                protected void call() {
                    this.setResult(mProxy.remove(dataKey));
                }
            };
            this.factory.node.executorManager.executeAsync(call);
            return call;
        }

        public Object put(Object key, Object value, long ttl, TimeUnit timeunit) {
            this.beforeCall();
            try {
                Object object = this.mproxyReal.put(key, value, ttl, timeunit);
                return object;
            }
            catch (Throwable e) {
                if (this.factory.restarted) {
                    Object object = this.put(key, value);
                    return object;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            finally {
                this.afterCall();
            }
        }

        public Object remove(Object key) {
            this.beforeCall();
            try {
                Object v = this.mproxyReal.remove(key);
                return v;
            }
            catch (Throwable e) {
                if (this.factory.restarted) {
                    Object object = this.remove(key);
                    return object;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            finally {
                this.afterCall();
            }
        }

        public Object tryRemove(Object key, long time, TimeUnit timeunit) throws TimeoutException {
            this.beforeCall();
            try {
                Object object = this.mproxyReal.tryRemove(key, time, timeunit);
                return object;
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof TimeoutException) {
                    throw (TimeoutException)e;
                }
                throw new RuntimeException(e);
            }
            finally {
                this.afterCall();
            }
        }

        public void putAndUnlock(Object key, Object value) {
            this.dynamicProxy.putAndUnlock(key, value);
        }

        public Object tryLockAndGet(Object key, long time, TimeUnit timeunit) throws TimeoutException {
            return this.dynamicProxy.tryLockAndGet(key, time, timeunit);
        }

        public Map getAll(Set keys) {
            return this.dynamicProxy.getAll(keys);
        }

        public void flush() {
            this.dynamicProxy.flush();
        }

        public void putForSync(Object key, Object value) {
            this.dynamicProxy.putForSync(key, value);
        }

        public void removeForSync(Object key) {
            this.dynamicProxy.removeForSync(key);
        }

        public void putTransient(Object key, Object value, long time, TimeUnit timeunit) {
            this.dynamicProxy.putTransient(key, value, time, timeunit);
        }

        public boolean tryPut(Object key, Object value, long time, TimeUnit timeunit) {
            return this.dynamicProxy.tryPut(key, value, time, timeunit);
        }

        public Object putIfAbsent(Object key, Object value, long ttl, TimeUnit timeunit) {
            return this.dynamicProxy.putIfAbsent(key, value, ttl, timeunit);
        }

        public Object putIfAbsent(Object key, Object value) {
            return this.dynamicProxy.putIfAbsent(key, value);
        }

        public LocalMapStats getLocalMapStats() {
            return this.dynamicProxy.getLocalMapStats();
        }

        public void addIndex(String attribute, boolean ordered) {
            this.dynamicProxy.addIndex(attribute, ordered);
        }

        public void addIndex(Expression expression, boolean ordered) {
            this.dynamicProxy.addIndex(expression, ordered);
        }

        public Object getId() {
            return this.dynamicProxy.getId();
        }

        public String toString() {
            return "Map [" + this.getName() + "] " + this.factory;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MProxyImpl mProxy = (MProxyImpl)o;
            return this.name.equals(mProxy.name);
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        public void destroy() {
            this.dynamicProxy.destroy();
        }

        public Instance.InstanceType getInstanceType() {
            return this.dynamicProxy.getInstanceType();
        }

        public boolean removeKey(Object key) {
            return this.dynamicProxy.removeKey(key);
        }

        public int size() {
            return this.dynamicProxy.size();
        }

        public boolean isEmpty() {
            return this.dynamicProxy.isEmpty();
        }

        public boolean containsKey(Object key) {
            return this.dynamicProxy.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.dynamicProxy.containsValue(value);
        }

        public MapEntry getMapEntry(Object key) {
            return this.dynamicProxy.getMapEntry(key);
        }

        public void putAll(Map t) {
            this.dynamicProxy.putAll(t);
        }

        public void clear() {
            this.dynamicProxy.clear();
        }

        public int valueCount(Object key) {
            return this.dynamicProxy.valueCount(key);
        }

        public Set allKeys() {
            return this.dynamicProxy.allKeys();
        }

        public Set localKeySet() {
            return this.dynamicProxy.localKeySet();
        }

        public Set localKeySet(Predicate predicate) {
            return this.dynamicProxy.localKeySet(predicate);
        }

        public Set keySet() {
            return this.dynamicProxy.keySet();
        }

        public Collection values() {
            return this.dynamicProxy.values();
        }

        public Set entrySet() {
            return this.dynamicProxy.entrySet();
        }

        public Set keySet(Predicate predicate) {
            return this.dynamicProxy.keySet(predicate);
        }

        public Collection values(Predicate predicate) {
            return this.dynamicProxy.values(predicate);
        }

        public Set entrySet(Predicate predicate) {
            return this.dynamicProxy.entrySet(predicate);
        }

        public boolean remove(Object key, Object value) {
            return this.dynamicProxy.remove(key, value);
        }

        public boolean replace(Object key, Object oldValue, Object newValue) {
            return this.dynamicProxy.replace(key, oldValue, newValue);
        }

        public Object replace(Object key, Object value) {
            return this.dynamicProxy.replace(key, value);
        }

        public String getName() {
            return this.name.substring("c:".length());
        }

        public boolean lockMap(long time, TimeUnit timeunit) {
            return this.dynamicProxy.lockMap(time, timeunit);
        }

        public void unlockMap() {
            this.dynamicProxy.unlockMap();
        }

        public void lock(Object key) {
            this.dynamicProxy.lock(key);
        }

        public boolean tryLock(Object key) {
            return this.dynamicProxy.tryLock(key);
        }

        public boolean tryLock(Object key, long time, TimeUnit timeunit) {
            return this.dynamicProxy.tryLock(key, time, timeunit);
        }

        public void unlock(Object key) {
            this.dynamicProxy.unlock(key);
        }

        public String getLongName() {
            return this.dynamicProxy.getLongName();
        }

        public void addGenericListener(Object listener, Object key, boolean includeValue, Instance.InstanceType instanceType) {
            this.dynamicProxy.addGenericListener(listener, key, includeValue, instanceType);
        }

        public void removeGenericListener(Object listener, Object key) {
            this.dynamicProxy.removeGenericListener(listener, key);
        }

        public void addLocalEntryListener(EntryListener entryListener) {
            this.dynamicProxy.addLocalEntryListener(entryListener);
        }

        public void addEntryListener(EntryListener listener, boolean includeValue) {
            this.dynamicProxy.addEntryListener(listener, includeValue);
        }

        public void addEntryListener(EntryListener listener, Object key, boolean includeValue) {
            this.dynamicProxy.addEntryListener(listener, key, includeValue);
        }

        public void removeEntryListener(EntryListener listener) {
            this.dynamicProxy.removeEntryListener(listener);
        }

        public void removeEntryListener(EntryListener listener, Object key) {
            this.dynamicProxy.removeEntryListener(listener, key);
        }

        public boolean containsEntry(Object key, Object value) {
            return this.dynamicProxy.containsEntry(key, value);
        }

        public boolean putMulti(Object key, Object value) {
            return this.dynamicProxy.putMulti(key, value);
        }

        public boolean removeMulti(Object key, Object value) {
            return this.dynamicProxy.removeMulti(key, value);
        }

        public boolean add(Object value) {
            return this.dynamicProxy.add(value);
        }

        public boolean evict(Object key) {
            return this.dynamicProxy.evict(key);
        }

        private class MProxyReal
        implements MProxy {
            private final transient MapOperationsCounter mapOperationCounter = new MapOperationsCounter();

            public String toString() {
                return "Map [" + this.getName() + "]";
            }

            public Instance.InstanceType getInstanceType() {
                return Instance.InstanceType.MAP;
            }

            public Object getId() {
                return MProxyImpl.this.name;
            }

            public boolean equals(Object o) {
                return MProxyImpl.this.equals(o);
            }

            public int hashCode() {
                return MProxyImpl.this.hashCode();
            }

            public String getLongName() {
                return MProxyImpl.this.name;
            }

            public String getName() {
                return MProxyImpl.this.name.substring("c:".length());
            }

            public void addIndex(String attribute, boolean ordered) {
                this.addIndex((Expression)Predicates.get(attribute), ordered);
            }

            public void addIndex(final Expression expression, final boolean ordered) {
                final CountDownLatch latch = new CountDownLatch(1);
                MProxyImpl.this.concurrentMapManager.enqueueAndReturn(new Processable(){

                    public void process() {
                        AddMapIndex addMapIndexProcess = new AddMapIndex(MProxyImpl.this.name, expression, ordered);
                        MProxyImpl.this.concurrentMapManager.sendProcessableToAll(addMapIndexProcess, true);
                        latch.countDown();
                    }
                });
                try {
                    latch.await();
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }

            public void flush() {
                MProxyImpl.this.concurrentMapManager.flush(MProxyImpl.this.name);
            }

            public MapEntry getMapEntry(Object key) {
                long begin = System.currentTimeMillis();
                FactoryImpl.check(key);
                ConcurrentMapManager.MGetMapEntry mgetMapEntry = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MGetMapEntry();
                MapEntry mapEntry = mgetMapEntry.get(MProxyImpl.this.name, key);
                this.mapOperationCounter.incrementGets(System.currentTimeMillis() - begin);
                return mapEntry;
            }

            public boolean putMulti(Object key, Object value) {
                FactoryImpl.check(key);
                FactoryImpl.check(value);
                ConcurrentMapManager.MPutMulti mput = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MPutMulti();
                return mput.put(MProxyImpl.this.name, key, value);
            }

            public Object put(Object key, Object value) {
                long begin = System.currentTimeMillis();
                FactoryImpl.check(key);
                FactoryImpl.check(value);
                ConcurrentMapManager.MPut mput = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMPut();
                Object result = mput.put(MProxyImpl.this.name, key, value, -1L, -1L);
                this.mapOperationCounter.incrementPuts(System.currentTimeMillis() - begin);
                return result;
            }

            public void putForSync(Object key, Object value) {
                long begin = System.currentTimeMillis();
                FactoryImpl.check(key);
                FactoryImpl.check(value);
                ConcurrentMapManager.MPut mput = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMPut();
                mput.putForSync(MProxyImpl.this.name, key, value);
                this.mapOperationCounter.incrementPuts(System.currentTimeMillis() - begin);
            }

            public void removeForSync(Object key) {
                long begin = System.currentTimeMillis();
                FactoryImpl.check(key);
                ConcurrentMapManager.MRemove mremove = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMRemove();
                mremove.removeForSync(MProxyImpl.this.name, key);
                this.mapOperationCounter.incrementRemoves(System.currentTimeMillis() - begin);
            }

            public Map getAll(Set keys) {
                if (keys == null) {
                    throw new NullPointerException();
                }
                return MProxyImpl.this.concurrentMapManager.getAll(MProxyImpl.this.name, keys);
            }

            public Future getAsync(Object key) {
                throw new UnsupportedOperationException();
            }

            public Future putAsync(Object key, Object value) {
                throw new UnsupportedOperationException();
            }

            public Future removeAsync(Object key) {
                throw new UnsupportedOperationException();
            }

            public Object put(Object key, Object value, long ttl, TimeUnit timeunit) {
                if (ttl < 0L) {
                    throw new IllegalArgumentException("ttl value cannot be negative. " + ttl);
                }
                ttl = ttl == 0L ? -1L : Util.toMillis(ttl, timeunit);
                return this.put(key, value, -1L, ttl);
            }

            public void putTransient(Object key, Object value, long ttl, TimeUnit timeunit) {
                if (ttl < 0L) {
                    throw new IllegalArgumentException("ttl value cannot be negative. " + ttl);
                }
                ttl = ttl == 0L ? -1L : Util.toMillis(ttl, timeunit);
                this.mapOperationCounter.incrementOtherOperations();
                MProxyImpl.this.concurrentMapManager.putTransient(MProxyImpl.this.name, key, value, -1L, ttl);
            }

            public Object put(Object key, Object value, long timeout, long ttl) {
                long begin = System.currentTimeMillis();
                FactoryImpl.check(key);
                FactoryImpl.check(value);
                ConcurrentMapManager.MPut mput = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMPut();
                Object result = mput.put(MProxyImpl.this.name, key, value, timeout, ttl);
                this.mapOperationCounter.incrementPuts(System.currentTimeMillis() - begin);
                return result;
            }

            public boolean tryPut(Object key, Object value, long timeout, TimeUnit timeunit) {
                long begin = System.currentTimeMillis();
                if (timeout < 0L) {
                    throw new IllegalArgumentException("timeout value cannot be negative. " + timeout);
                }
                timeout = timeout == 0L ? -1L : Util.toMillis(timeout, timeunit);
                FactoryImpl.check(key);
                FactoryImpl.check(value);
                ConcurrentMapManager.MPut mput = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMPut();
                Boolean result = mput.tryPut(MProxyImpl.this.name, key, value, timeout, -1L);
                this.mapOperationCounter.incrementPuts(System.currentTimeMillis() - begin);
                return result;
            }

            public Object tryLockAndGet(Object key, long timeout, TimeUnit timeunit) throws TimeoutException {
                long begin = System.currentTimeMillis();
                if (timeout < 0L) {
                    throw new IllegalArgumentException("timeout value cannot be negative. " + timeout);
                }
                timeout = Util.toMillis(timeout, timeunit);
                FactoryImpl.check(key);
                Object result = MProxyImpl.this.concurrentMapManager.tryLockAndGet(MProxyImpl.this.name, key, timeout);
                this.mapOperationCounter.incrementGets(System.currentTimeMillis() - begin);
                return result;
            }

            public void putAndUnlock(Object key, Object value) {
                long begin = System.currentTimeMillis();
                FactoryImpl.check(key);
                FactoryImpl.check(value);
                MProxyImpl.this.concurrentMapManager.putAndUnlock(MProxyImpl.this.name, key, value);
                this.mapOperationCounter.incrementPuts(System.currentTimeMillis() - begin);
            }

            public Object putIfAbsent(Object key, Object value) {
                return this.putIfAbsent(key, value, -1L, -1L);
            }

            public Object putIfAbsent(Object key, Object value, long ttl, TimeUnit timeunit) {
                if (ttl < 0L) {
                    throw new IllegalArgumentException("ttl value cannot be negative. " + ttl);
                }
                ttl = ttl == 0L ? -1L : Util.toMillis(ttl, timeunit);
                return this.putIfAbsent(key, value, -1L, timeunit.toMillis(ttl));
            }

            public Object putIfAbsent(Object key, Object value, long timeout, long ttl) {
                long begin = System.currentTimeMillis();
                FactoryImpl.check(key);
                FactoryImpl.check(value);
                ConcurrentMapManager.MPut mput = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MPut();
                Object result = mput.putIfAbsent(MProxyImpl.this.name, key, value, timeout, ttl);
                this.mapOperationCounter.incrementPuts(System.currentTimeMillis() - begin);
                return result;
            }

            public Object get(Object key) {
                FactoryImpl.check(key);
                long begin = System.currentTimeMillis();
                ConcurrentMapManager.MGet mget = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMGet();
                Object result = mget.get(MProxyImpl.this.name, key, -1L);
                if (result == null && MProxyImpl.this.name.contains("testConcurrentLockPrimitive")) {
                    boolean isClient = ThreadContext.get().isClient();
                    TransactionImpl txn = ThreadContext.get().getTransaction();
                    throw new RuntimeException(result + " testConcurrentLockPrimitive returns null " + isClient + "  " + txn);
                }
                this.mapOperationCounter.incrementGets(System.currentTimeMillis() - begin);
                return result;
            }

            public Object remove(Object key) {
                long begin = System.currentTimeMillis();
                FactoryImpl.check(key);
                ConcurrentMapManager.MRemove mremove = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMRemove();
                Object result = mremove.remove(MProxyImpl.this.name, key, -1L);
                this.mapOperationCounter.incrementRemoves(System.currentTimeMillis() - begin);
                return result;
            }

            public Object tryRemove(Object key, long timeout, TimeUnit timeunit) throws TimeoutException {
                long begin = System.currentTimeMillis();
                FactoryImpl.check(key);
                ConcurrentMapManager.MRemove mremove = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMRemove();
                Object result = mremove.tryRemove(MProxyImpl.this.name, key, Util.toMillis(timeout, timeunit));
                this.mapOperationCounter.incrementRemoves(System.currentTimeMillis() - begin);
                return result;
            }

            public int size() {
                this.mapOperationCounter.incrementOtherOperations();
                ConcurrentMapManager concurrentMapManager = MProxyImpl.this.concurrentMapManager;
                concurrentMapManager.getClass();
                ConcurrentMapManager.MSize msize = concurrentMapManager.new ConcurrentMapManager.MSize(MProxyImpl.this.name);
                return msize.getSize();
            }

            public int valueCount(Object key) {
                this.mapOperationCounter.incrementOtherOperations();
                ConcurrentMapManager.MValueCount mcount = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MValueCount();
                int count = ((Number)mcount.count(MProxyImpl.this.name, key, -1L)).intValue();
                return count;
            }

            public boolean removeMulti(Object key, Object value) {
                FactoryImpl.check(key);
                FactoryImpl.check(value);
                ConcurrentMapManager.MRemoveMulti mremove = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MRemoveMulti();
                return mremove.remove(MProxyImpl.this.name, key, value);
            }

            public boolean remove(Object key, Object value) {
                long begin = System.currentTimeMillis();
                FactoryImpl.check(key);
                FactoryImpl.check(value);
                ConcurrentMapManager.MRemove mremove = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MRemove();
                boolean result = mremove.removeIfSame(MProxyImpl.this.name, key, value, -1L) != null;
                this.mapOperationCounter.incrementRemoves(System.currentTimeMillis() - begin);
                return result;
            }

            public Object replace(Object key, Object value) {
                long begin = System.currentTimeMillis();
                FactoryImpl.check(key);
                FactoryImpl.check(value);
                ConcurrentMapManager.MPut mput = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MPut();
                Object result = mput.replace(MProxyImpl.this.name, key, value, -1L, -1L);
                this.mapOperationCounter.incrementPuts(System.currentTimeMillis() - begin);
                return result;
            }

            public boolean replace(Object key, Object oldValue, Object newValue) {
                long begin = System.currentTimeMillis();
                FactoryImpl.check(key);
                FactoryImpl.check(oldValue);
                FactoryImpl.check(newValue);
                ConcurrentMapManager.MPut mput = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MPut();
                Boolean result = mput.replace(MProxyImpl.this.name, key, oldValue, newValue, -1L);
                this.mapOperationCounter.incrementPuts(System.currentTimeMillis() - begin);
                return result;
            }

            public boolean lockMap(long time, TimeUnit timeunit) {
                if (((MProxyImpl)MProxyImpl.this).factory.locksMapProxy.tryLock("map_lock_" + MProxyImpl.this.name, time, timeunit)) {
                    ConcurrentMapManager concurrentMapManager = MProxyImpl.this.concurrentMapManager;
                    concurrentMapManager.getClass();
                    ConcurrentMapManager.MLockMap mLockMap = concurrentMapManager.new ConcurrentMapManager.MLockMap(MProxyImpl.this.name, true);
                    mLockMap.call();
                    return true;
                }
                return false;
            }

            public void unlockMap() {
                ConcurrentMapManager concurrentMapManager = MProxyImpl.this.concurrentMapManager;
                concurrentMapManager.getClass();
                ConcurrentMapManager.MLockMap mLockMap = concurrentMapManager.new ConcurrentMapManager.MLockMap(MProxyImpl.this.name, false);
                mLockMap.call();
                ((MProxyImpl)MProxyImpl.this).factory.locksMapProxy.unlock("map_lock_" + MProxyImpl.this.name);
            }

            public void lock(Object key) {
                FactoryImpl.check(key);
                this.mapOperationCounter.incrementOtherOperations();
                ConcurrentMapManager.MLock mlock = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MLock();
                mlock.lock(MProxyImpl.this.name, key, -1L);
            }

            public boolean tryLock(Object key) {
                FactoryImpl.check(key);
                this.mapOperationCounter.incrementOtherOperations();
                ConcurrentMapManager.MLock mlock = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MLock();
                return mlock.lock(MProxyImpl.this.name, key, 0L);
            }

            public boolean tryLock(Object key, long time, TimeUnit timeunit) {
                FactoryImpl.check(key);
                if (time < 0L) {
                    throw new IllegalArgumentException("Time cannot be negative. time = " + time);
                }
                this.mapOperationCounter.incrementOtherOperations();
                long timeoutMillis = timeunit.toMillis(time);
                ConcurrentMapManager.MLock mlock = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MLock();
                return mlock.lock(MProxyImpl.this.name, key, timeoutMillis < 0L || timeoutMillis == Long.MAX_VALUE ? -1L : timeoutMillis);
            }

            public void unlock(Object key) {
                FactoryImpl.check(key);
                this.mapOperationCounter.incrementOtherOperations();
                ConcurrentMapManager.MLock mlock = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MLock();
                mlock.unlock(MProxyImpl.this.name, key, 0L);
            }

            public LocalMapStats getLocalMapStats() {
                this.mapOperationCounter.incrementOtherOperations();
                LocalMapStatsImpl localMapStats = MProxyImpl.this.concurrentMapManager.getLocalMapStats(MProxyImpl.this.name);
                localMapStats.setOperationStats(this.mapOperationCounter.getPublishedStats());
                return localMapStats;
            }

            public void addGenericListener(Object listener, Object key, boolean includeValue, Instance.InstanceType instanceType) {
                if (listener == null) {
                    throw new IllegalArgumentException("Listener cannot be null");
                }
                MProxyImpl.this.listenerManager.addListener(MProxyImpl.this.name, listener, key, includeValue, instanceType);
            }

            public void removeGenericListener(Object listener, Object key) {
                if (listener == null) {
                    throw new IllegalArgumentException("Listener cannot be null");
                }
                MProxyImpl.this.listenerManager.removeListener(MProxyImpl.this.name, listener, key);
            }

            public void addLocalEntryListener(EntryListener listener) {
                if (listener == null) {
                    throw new IllegalArgumentException("Listener cannot be null");
                }
                MProxyImpl.this.listenerManager.addLocalListener(MProxyImpl.this.name, listener, this.getInstanceType());
            }

            public void addEntryListener(EntryListener listener, boolean includeValue) {
                if (listener == null) {
                    throw new IllegalArgumentException("Listener cannot be null");
                }
                this.addGenericListener(listener, null, includeValue, this.getInstanceType());
            }

            public void addEntryListener(EntryListener listener, Object key, boolean includeValue) {
                if (listener == null) {
                    throw new IllegalArgumentException("Listener cannot be null");
                }
                FactoryImpl.check(key);
                this.addGenericListener(listener, key, includeValue, this.getInstanceType());
            }

            public void removeEntryListener(EntryListener listener) {
                if (listener == null) {
                    throw new IllegalArgumentException("Listener cannot be null");
                }
                this.removeGenericListener(listener, null);
            }

            public void removeEntryListener(EntryListener listener, Object key) {
                if (listener == null) {
                    throw new IllegalArgumentException("Listener cannot be null");
                }
                FactoryImpl.check(key);
                this.removeGenericListener(listener, key);
            }

            public boolean containsEntry(Object key, Object value) {
                FactoryImpl.check(key);
                FactoryImpl.check(value);
                this.mapOperationCounter.incrementOtherOperations();
                TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
                if (txn != null && txn.has(MProxyImpl.this.name, key)) {
                    Object v = txn.get(MProxyImpl.this.name, key);
                    return v != null;
                }
                ConcurrentMapManager.MContainsKey mContainsKey = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MContainsKey();
                return mContainsKey.containsEntry(MProxyImpl.this.name, key, value);
            }

            public boolean containsKey(Object key) {
                FactoryImpl.check(key);
                this.mapOperationCounter.incrementOtherOperations();
                TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
                if (txn != null && txn.has(MProxyImpl.this.name, key)) {
                    Object value = txn.get(MProxyImpl.this.name, key);
                    return value != null;
                }
                ConcurrentMapManager.MContainsKey mContainsKey = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MContainsKey();
                return mContainsKey.containsKey(MProxyImpl.this.name, key);
            }

            public boolean containsValue(Object value) {
                FactoryImpl.check(value);
                this.mapOperationCounter.incrementOtherOperations();
                TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
                if (txn != null && txn.containsValue(MProxyImpl.this.name, value)) {
                    return true;
                }
                ConcurrentMapManager concurrentMapManager = MProxyImpl.this.concurrentMapManager;
                concurrentMapManager.getClass();
                ConcurrentMapManager.MContainsValue mContainsValue = concurrentMapManager.new ConcurrentMapManager.MContainsValue(MProxyImpl.this.name, value);
                return (Boolean)mContainsValue.call();
            }

            public boolean isEmpty() {
                this.mapOperationCounter.incrementOtherOperations();
                ConcurrentMapManager.MEmpty mempty = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MEmpty();
                return mempty.isEmpty(MProxyImpl.this.name);
            }

            public void putAll(Map map) {
                Set entries = map.entrySet();
                TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
                if (txn != null && txn.getStatus() == 1) {
                    for (Map.Entry entry : entries) {
                        this.put(entry.getKey(), entry.getValue());
                    }
                } else {
                    MProxyImpl.this.concurrentMapManager.doPutAll(MProxyImpl.this.name, map);
                }
            }

            public boolean add(Object value) {
                FactoryImpl.check(value);
                ConcurrentMapManager.MAdd madd = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MAdd();
                MProxyImpl.this.concurrentMapManager;
                Instance.InstanceType type = ConcurrentMapManager.getInstanceType(MProxyImpl.this.name);
                if (type == Instance.InstanceType.LIST) {
                    return madd.addToList(MProxyImpl.this.name, value);
                }
                return madd.addToSet(MProxyImpl.this.name, value);
            }

            public boolean removeKey(Object key) {
                long begin = System.currentTimeMillis();
                FactoryImpl.check(key);
                ConcurrentMapManager.MRemoveItem mRemoveItem = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MRemoveItem();
                boolean result = mRemoveItem.removeItem(MProxyImpl.this.name, key);
                this.mapOperationCounter.incrementRemoves(System.currentTimeMillis() - begin);
                return result;
            }

            public void clear() {
                Set keys = this.keySet();
                for (Object key : keys) {
                    this.removeKey(key);
                }
            }

            public Set localKeySet() {
                return this.localKeySet(null);
            }

            public Set localKeySet(Predicate predicate) {
                this.mapOperationCounter.incrementOtherOperations();
                ConcurrentMapManager concurrentMapManager = MProxyImpl.this.concurrentMapManager;
                concurrentMapManager.getClass();
                ConcurrentMapManager.MIterateLocal miterate = concurrentMapManager.new ConcurrentMapManager.MIterateLocal(MProxyImpl.this.name, predicate);
                return miterate.iterate();
            }

            public Set entrySet(Predicate predicate) {
                return (Set)this.iterate(ClusterOperation.CONCURRENT_MAP_ITERATE_ENTRIES, predicate);
            }

            public Set keySet(Predicate predicate) {
                return (Set)this.iterate(ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS, predicate);
            }

            public Collection values(Predicate predicate) {
                return this.iterate(ClusterOperation.CONCURRENT_MAP_ITERATE_VALUES, predicate);
            }

            public Set entrySet() {
                return (Set)this.iterate(ClusterOperation.CONCURRENT_MAP_ITERATE_ENTRIES, null);
            }

            public Set keySet() {
                return (Set)this.iterate(ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS, null);
            }

            public Set allKeys() {
                return (Set)this.iterate(ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS_ALL, null);
            }

            public MapOperationsCounter getMapOperationCounter() {
                return this.mapOperationCounter;
            }

            public Collection values() {
                return this.iterate(ClusterOperation.CONCURRENT_MAP_ITERATE_VALUES, null);
            }

            private Collection iterate(ClusterOperation iteratorType, Predicate predicate) {
                this.mapOperationCounter.incrementOtherOperations();
                ConcurrentMapManager concurrentMapManager = MProxyImpl.this.concurrentMapManager;
                concurrentMapManager.getClass();
                ConcurrentMapManager.MIterate miterate = concurrentMapManager.new ConcurrentMapManager.MIterate(iteratorType, MProxyImpl.this.name, predicate);
                return (Collection)miterate.call();
            }

            public void destroy() {
                MProxyImpl.this.factory.destroyInstanceClusterWide(MProxyImpl.this.name, null);
            }

            public boolean evict(Object key) {
                this.mapOperationCounter.incrementOtherOperations();
                ConcurrentMapManager.MEvict mevict = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMEvict();
                return mevict.evict(MProxyImpl.this.name, key);
            }
        }

        class DynamicInvoker
        implements InvocationHandler {
            DynamicInvoker() {
            }

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                MProxyImpl.this.beforeCall();
                try {
                    Object object = method.invoke((Object)MProxyImpl.this.mproxyReal, args);
                    return object;
                }
                catch (Throwable e) {
                    if (e instanceof InvocationTargetException) {
                        InvocationTargetException ite = (InvocationTargetException)e;
                        throw ite.getCause();
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
                finally {
                    MProxyImpl.this.afterCall();
                }
            }
        }
    }

    public static class MultiMapProxyImpl
    extends FactoryAwareNamedProxy
    implements MultiMapProxy,
    DataSerializable,
    IGetAwareProxy {
        private transient MultiMapProxy base = null;

        public MultiMapProxyImpl() {
        }

        public MultiMapProxyImpl(String name, FactoryImpl factory) {
            this.setName(name);
            this.setHazelcastInstance(factory);
            this.base = new MultiMapReal();
        }

        private void ensure() {
            this.factory.initialChecks();
            if (this.base == null) {
                this.base = (MultiMapProxy)this.factory.getOrCreateProxyByName(this.name);
            }
        }

        public MultiMapReal getBase() {
            return (MultiMapReal)this.base;
        }

        public MProxy getMProxy() {
            this.ensure();
            return this.base.getMProxy();
        }

        public Object getId() {
            this.ensure();
            return this.base.getId();
        }

        public String toString() {
            return "MultiMap [" + this.getName() + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MultiMapProxyImpl that = (MultiMapProxyImpl)o;
            return !(this.name == null ? that.name != null : !this.name.equals(that.name));
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        public Instance.InstanceType getInstanceType() {
            this.ensure();
            return this.base.getInstanceType();
        }

        public void destroy() {
            this.factory.destroyInstanceClusterWide(this.name, null);
        }

        public String getName() {
            this.ensure();
            return this.base.getName();
        }

        public boolean put(Object key, Object value) {
            this.ensure();
            return this.base.put(key, value);
        }

        public Collection get(Object key) {
            this.ensure();
            return this.base.get(key);
        }

        public boolean remove(Object key, Object value) {
            this.ensure();
            return this.base.remove(key, value);
        }

        public Collection remove(Object key) {
            this.ensure();
            return this.base.remove(key);
        }

        public Set localKeySet() {
            this.ensure();
            return this.base.localKeySet();
        }

        public Set keySet() {
            this.ensure();
            return this.base.keySet();
        }

        public Collection values() {
            this.ensure();
            return this.base.values();
        }

        public Set entrySet() {
            this.ensure();
            return this.base.entrySet();
        }

        public boolean containsKey(Object key) {
            this.ensure();
            return this.base.containsKey(key);
        }

        public boolean containsValue(Object value) {
            this.ensure();
            return this.base.containsValue(value);
        }

        public boolean containsEntry(Object key, Object value) {
            this.ensure();
            return this.base.containsEntry(key, value);
        }

        public int size() {
            this.ensure();
            return this.base.size();
        }

        public void clear() {
            this.ensure();
            this.base.clear();
        }

        public int valueCount(Object key) {
            this.ensure();
            return this.base.valueCount(key);
        }

        public void addLocalEntryListener(EntryListener entryListener) {
            this.ensure();
            this.base.addLocalEntryListener(entryListener);
        }

        public void addEntryListener(EntryListener entryListener, boolean includeValue) {
            this.ensure();
            this.base.addEntryListener(entryListener, includeValue);
        }

        public void removeEntryListener(EntryListener entryListener) {
            this.ensure();
            this.base.removeEntryListener(entryListener);
        }

        public void addEntryListener(EntryListener entryListener, Object key, boolean includeValue) {
            this.ensure();
            this.base.addEntryListener(entryListener, key, includeValue);
        }

        public void removeEntryListener(EntryListener entryListener, Object key) {
            this.ensure();
            this.base.removeEntryListener(entryListener, key);
        }

        public void lock(Object key) {
            this.ensure();
            this.base.lock(key);
        }

        public boolean tryLock(Object key) {
            this.ensure();
            return this.base.tryLock(key);
        }

        public boolean tryLock(Object key, long time, TimeUnit timeunit) {
            this.ensure();
            return this.base.tryLock(key, time, timeunit);
        }

        public void unlock(Object key) {
            this.ensure();
            this.base.unlock(key);
        }

        public boolean lockMap(long time, TimeUnit timeunit) {
            this.ensure();
            return this.base.lockMap(time, timeunit);
        }

        public void unlockMap() {
            this.ensure();
            this.base.unlockMap();
        }

        class MultiMapReal
        implements MultiMapProxy,
        IGetAwareProxy {
            final MProxy mapProxy;

            private MultiMapReal() {
                this.mapProxy = new MProxyImpl(MultiMapProxyImpl.this.name, MultiMapProxyImpl.this.factory);
            }

            public MProxy getMProxy() {
                return this.mapProxy;
            }

            public String getName() {
                return MultiMapProxyImpl.this.name.substring("m:u:".length());
            }

            public void clear() {
                this.mapProxy.clear();
            }

            public boolean containsEntry(Object key, Object value) {
                return this.mapProxy.containsEntry(key, value);
            }

            public boolean containsKey(Object key) {
                return this.mapProxy.containsKey(key);
            }

            public boolean containsValue(Object value) {
                return this.mapProxy.containsValue(value);
            }

            public Collection get(Object key) {
                ConcurrentMapManager.MMultiGet multiGet = ((MultiMapProxyImpl)MultiMapProxyImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MMultiGet();
                return multiGet.get(MultiMapProxyImpl.this.name, key);
            }

            public boolean put(Object key, Object value) {
                return this.mapProxy.putMulti(key, value);
            }

            public boolean remove(Object key, Object value) {
                return this.mapProxy.removeMulti(key, value);
            }

            public Collection remove(Object key) {
                ConcurrentMapManager.MRemoveMulti m = ((MultiMapProxyImpl)MultiMapProxyImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MRemoveMulti();
                return m.remove(MultiMapProxyImpl.this.name, key);
            }

            public int size() {
                return this.mapProxy.size();
            }

            public Set localKeySet() {
                return this.mapProxy.localKeySet();
            }

            public Set keySet() {
                return this.mapProxy.keySet();
            }

            public Collection values() {
                return this.mapProxy.values();
            }

            public Set entrySet() {
                return this.mapProxy.entrySet();
            }

            public int valueCount(Object key) {
                return this.mapProxy.valueCount(key);
            }

            public Instance.InstanceType getInstanceType() {
                return Instance.InstanceType.MULTIMAP;
            }

            public void destroy() {
                this.mapProxy.destroy();
            }

            public Object getId() {
                return MultiMapProxyImpl.this.name;
            }

            public void addLocalEntryListener(EntryListener entryListener) {
                this.mapProxy.addLocalEntryListener(entryListener);
            }

            public void addEntryListener(EntryListener entryListener, boolean includeValue) {
                this.mapProxy.addEntryListener(entryListener, includeValue);
            }

            public void removeEntryListener(EntryListener entryListener) {
                this.mapProxy.removeEntryListener(entryListener);
            }

            public void addEntryListener(EntryListener entryListener, Object key, boolean includeValue) {
                this.mapProxy.addEntryListener(entryListener, key, includeValue);
            }

            public void removeEntryListener(EntryListener entryListener, Object key) {
                this.mapProxy.removeEntryListener(entryListener, key);
            }

            public void lock(Object key) {
                this.mapProxy.lock(key);
            }

            public boolean tryLock(Object key) {
                return this.mapProxy.tryLock(key);
            }

            public boolean tryLock(Object key, long time, TimeUnit timeunit) {
                return this.mapProxy.tryLock(key, time, timeunit);
            }

            public void unlock(Object key) {
                this.mapProxy.unlock(key);
            }

            public boolean lockMap(long time, TimeUnit timeunit) {
                return this.mapProxy.lockMap(time, timeunit);
            }

            public void unlockMap() {
                this.mapProxy.unlockMap();
            }
        }
    }

    public static class QProxyImpl
    extends AbstractQueue
    implements QProxy,
    HazelcastInstanceAwareInstance,
    DataSerializable {
        private transient QProxy qproxyReal = null;
        private transient FactoryImpl factory = null;
        private String name = null;
        private BlockingQueueManager blockingQueueManager = null;
        private ListenerManager listenerManager = null;

        public QProxyImpl() {
        }

        private QProxyImpl(String name, FactoryImpl factory) {
            this.name = name;
            this.qproxyReal = new QProxyReal();
            this.setHazelcastInstance(factory);
        }

        public FactoryImpl getFactory() {
            return this.factory;
        }

        public String getLongName() {
            this.ensure();
            return this.qproxyReal.getLongName();
        }

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            this.factory = (FactoryImpl)hazelcastInstance;
            this.blockingQueueManager = this.factory.node.blockingQueueManager;
            this.listenerManager = this.factory.node.listenerManager;
        }

        private void ensure() {
            ThreadContext.get().setCurrentFactory(this.factory);
            this.factory.initialChecks();
            if (this.qproxyReal == null) {
                this.qproxyReal = (QProxy)this.factory.getOrCreateProxyByName(this.name);
            }
        }

        public Object getId() {
            this.ensure();
            return this.qproxyReal.getId();
        }

        public String toString() {
            return "Queue [" + this.getName() + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QProxyImpl qProxy = (QProxyImpl)o;
            return !(this.name == null ? qProxy.name != null : !this.name.equals(qProxy.name));
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        public void writeData(DataOutput out) throws IOException {
            out.writeUTF(this.name);
        }

        public void readData(DataInput in) throws IOException {
            this.name = in.readUTF();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            this.writeData(out);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.readData(in);
        }

        public LocalQueueStats getLocalQueueStats() {
            this.ensure();
            return this.qproxyReal.getLocalQueueStats();
        }

        public Iterator iterator() {
            this.ensure();
            return this.qproxyReal.iterator();
        }

        public int size() {
            this.ensure();
            return this.qproxyReal.size();
        }

        public void addItemListener(ItemListener listener, boolean includeValue) {
            this.ensure();
            this.qproxyReal.addItemListener(listener, includeValue);
        }

        public void removeItemListener(ItemListener listener) {
            this.ensure();
            this.qproxyReal.removeItemListener(listener);
        }

        public String getName() {
            this.ensure();
            return this.qproxyReal.getName();
        }

        public int drainTo(Collection c) {
            this.ensure();
            return this.qproxyReal.drainTo(c);
        }

        public int drainTo(Collection c, int maxElements) {
            this.ensure();
            return this.qproxyReal.drainTo(c, maxElements);
        }

        public void destroy() {
            this.ensure();
            this.qproxyReal.destroy();
        }

        public Instance.InstanceType getInstanceType() {
            this.ensure();
            return this.qproxyReal.getInstanceType();
        }

        public boolean offer(Object o) {
            this.ensure();
            return this.qproxyReal.offer(o);
        }

        public boolean offer(Object obj, long timeout, TimeUnit unit) throws InterruptedException {
            this.ensure();
            return this.qproxyReal.offer(obj, timeout, unit);
        }

        public void put(Object obj) throws InterruptedException {
            this.ensure();
            this.qproxyReal.put(obj);
        }

        public Object poll() {
            this.ensure();
            return this.qproxyReal.poll();
        }

        public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
            this.ensure();
            return this.qproxyReal.poll(timeout, unit);
        }

        public Object take() throws InterruptedException {
            this.ensure();
            return this.qproxyReal.take();
        }

        public int remainingCapacity() {
            this.ensure();
            return this.qproxyReal.remainingCapacity();
        }

        public Object peek() {
            this.ensure();
            return this.qproxyReal.peek();
        }

        public QueueOperationsCounter getQueueOperationCounter() {
            return this.qproxyReal.getQueueOperationCounter();
        }

        private class QProxyReal
        extends AbstractQueue
        implements QProxy {
            private final QueueOperationsCounter operationsCounter = new QueueOperationsCounter();

            public LocalQueueStats getLocalQueueStats() {
                this.operationsCounter.incrementOtherOperations();
                LocalQueueStatsImpl localQueueStats = QProxyImpl.this.blockingQueueManager.getOrCreateBQ(QProxyImpl.this.name).getQueueStats();
                localQueueStats.setOperationStats(this.operationsCounter.getPublishedStats());
                return localQueueStats;
            }

            public String getLongName() {
                return QProxyImpl.this.name;
            }

            public boolean offer(Object obj) {
                FactoryImpl.check(obj);
                try {
                    return this.offer(obj, 0L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ignored) {
                    return false;
                }
            }

            public boolean offer(Object obj, long timeout, TimeUnit unit) throws InterruptedException {
                boolean result;
                FactoryImpl.check(obj);
                if (timeout < 0L) {
                    timeout = 0L;
                }
                if (!(result = QProxyImpl.this.blockingQueueManager.offer(QProxyImpl.this.name, obj, unit.toMillis(timeout)))) {
                    this.operationsCounter.incrementRejectedOffers();
                }
                this.operationsCounter.incrementOffers();
                return result;
            }

            public void put(Object obj) throws InterruptedException {
                FactoryImpl.check(obj);
                QProxyImpl.this.blockingQueueManager.offer(QProxyImpl.this.name, obj, -1L);
                this.operationsCounter.incrementOffers();
            }

            public Object peek() {
                this.operationsCounter.incrementOtherOperations();
                return QProxyImpl.this.blockingQueueManager.peek(QProxyImpl.this.name);
            }

            public Object poll() {
                try {
                    Object result = QProxyImpl.this.blockingQueueManager.poll(QProxyImpl.this.name, 0L);
                    if (result == null) {
                        this.operationsCounter.incrementEmptyPolls();
                    }
                    this.operationsCounter.incrementPolls();
                    return result;
                }
                catch (InterruptedException e) {
                    return null;
                }
            }

            public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
                Object result;
                if (timeout < 0L) {
                    timeout = 0L;
                }
                if ((result = QProxyImpl.this.blockingQueueManager.poll(QProxyImpl.this.name, unit.toMillis(timeout))) == null) {
                    this.operationsCounter.incrementEmptyPolls();
                }
                this.operationsCounter.incrementPolls();
                return result;
            }

            public Object take() throws InterruptedException {
                Object result = QProxyImpl.this.blockingQueueManager.poll(QProxyImpl.this.name, -1L);
                if (result == null) {
                    this.operationsCounter.incrementEmptyPolls();
                }
                this.operationsCounter.incrementPolls();
                return result;
            }

            public int remainingCapacity() {
                this.operationsCounter.incrementOtherOperations();
                BlockingQueueManager.BQ q = QProxyImpl.this.blockingQueueManager.getOrCreateBQ(QProxyImpl.this.name);
                int maxSizePerJVM = q.getMaxSizePerJVM();
                if (maxSizePerJVM <= 0) {
                    return Integer.MAX_VALUE;
                }
                int size = this.size();
                int numberOfMembers = ((QProxyImpl)QProxyImpl.this).factory.node.getClusterImpl().getMembers().size();
                int totalCapacity = numberOfMembers * maxSizePerJVM;
                return totalCapacity - size;
            }

            public Iterator iterator() {
                this.operationsCounter.incrementOtherOperations();
                return QProxyImpl.this.blockingQueueManager.iterate(QProxyImpl.this.name);
            }

            public int size() {
                this.operationsCounter.incrementOtherOperations();
                return QProxyImpl.this.blockingQueueManager.size(QProxyImpl.this.name);
            }

            public void addItemListener(ItemListener listener, boolean includeValue) {
                QProxyImpl.this.blockingQueueManager.addItemListener(QProxyImpl.this.name, listener, includeValue);
            }

            public void removeItemListener(ItemListener listener) {
                QProxyImpl.this.blockingQueueManager.removeItemListener(QProxyImpl.this.name, listener);
            }

            public String getName() {
                return QProxyImpl.this.name.substring("q:".length());
            }

            public boolean remove(Object obj) {
                throw new UnsupportedOperationException();
            }

            public int drainTo(Collection c) {
                return this.drainTo(c, Integer.MAX_VALUE);
            }

            public int drainTo(Collection c, int maxElements) {
                QProxy q;
                if (c == null) {
                    throw new NullPointerException("drainTo null!");
                }
                if (maxElements < 0) {
                    throw new IllegalArgumentException("Negative maxElements:" + maxElements);
                }
                if (maxElements == 0) {
                    return 0;
                }
                if (c instanceof QProxy && (q = (QProxy)c).getName().equals(this.getName())) {
                    throw new IllegalArgumentException("Cannot drainTo self!");
                }
                this.operationsCounter.incrementOtherOperations();
                int added = 0;
                Object value = null;
                do {
                    if ((value = this.poll()) == null) continue;
                    if (!c.add(value)) {
                        throw new RuntimeException("drainTo is not able to add!");
                    }
                    ++added;
                } while (added < maxElements && value != null);
                return added;
            }

            public void destroy() {
                this.operationsCounter.incrementOtherOperations();
                QProxyImpl.this.factory.destroyInstanceClusterWide(QProxyImpl.this.name, null);
                QProxyImpl.this.factory.destroyInstanceClusterWide("c:" + QProxyImpl.this.name, null);
            }

            public Instance.InstanceType getInstanceType() {
                return Instance.InstanceType.QUEUE;
            }

            public Object getId() {
                return QProxyImpl.this.name;
            }

            public QueueOperationsCounter getQueueOperationCounter() {
                return this.operationsCounter;
            }
        }
    }

    public static class CollectionProxyImpl
    extends BaseCollection
    implements CollectionProxy,
    HazelcastInstanceAwareInstance,
    DataSerializable {
        String name = null;
        private transient CollectionProxy base = null;
        private transient FactoryImpl factory = null;

        public CollectionProxyImpl() {
        }

        public CollectionProxyImpl(String name, FactoryImpl factory) {
            this.name = name;
            this.factory = factory;
            this.base = new CollectionProxyReal();
        }

        public FactoryImpl getFactory() {
            return this.factory;
        }

        public CollectionProxy getBase() {
            return this.base;
        }

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            this.factory = (FactoryImpl)hazelcastInstance;
        }

        private void ensure() {
            this.factory.initialChecks();
            if (this.base == null) {
                this.base = (CollectionProxy)this.factory.getOrCreateProxyByName(this.name);
            }
        }

        public Object getId() {
            this.ensure();
            return this.base.getId();
        }

        public String toString() {
            this.ensure();
            if (this.getInstanceType().isSet()) {
                return "Set [" + this.getName() + "]";
            }
            return "List [" + this.getName() + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CollectionProxyImpl that = (CollectionProxyImpl)o;
            return !(this.name == null ? that.name != null : !this.name.equals(that.name));
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        public int size() {
            this.ensure();
            return this.base.size();
        }

        public boolean contains(Object o) {
            this.ensure();
            return this.base.contains(o);
        }

        public Iterator iterator() {
            this.ensure();
            return this.base.iterator();
        }

        public boolean add(Object o) {
            this.ensure();
            return this.base.add(o);
        }

        public boolean remove(Object o) {
            this.ensure();
            return this.base.remove(o);
        }

        public void clear() {
            this.ensure();
            this.base.clear();
        }

        public Instance.InstanceType getInstanceType() {
            this.ensure();
            return this.base.getInstanceType();
        }

        public void destroy() {
            this.factory.destroyInstanceClusterWide(this.name, null);
        }

        public void writeData(DataOutput out) throws IOException {
            out.writeUTF(this.name);
        }

        public void readData(DataInput in) throws IOException {
            this.name = in.readUTF();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            this.writeData(out);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.readData(in);
        }

        public String getName() {
            this.ensure();
            return this.base.getName();
        }

        public void addItemListener(ItemListener itemListener, boolean includeValue) {
            this.ensure();
            this.base.addItemListener(itemListener, includeValue);
        }

        public void removeItemListener(ItemListener itemListener) {
            this.ensure();
            this.base.removeItemListener(itemListener);
        }

        public boolean removeKey(Object key) {
            this.ensure();
            return this.base.removeKey(key);
        }

        class CollectionProxyReal
        extends BaseCollection
        implements CollectionProxy {
            final MProxy mapProxy;

            public CollectionProxyReal() {
                this.mapProxy = new MProxyImpl(CollectionProxyImpl.this.name, CollectionProxyImpl.this.factory);
            }

            public Object getId() {
                return CollectionProxyImpl.this.name;
            }

            public boolean equals(Object o) {
                return CollectionProxyImpl.this.equals(o);
            }

            public int hashCode() {
                return CollectionProxyImpl.this.hashCode();
            }

            public Instance.InstanceType getInstanceType() {
                return BaseManager.getInstanceType(CollectionProxyImpl.this.name);
            }

            public void addItemListener(ItemListener listener, boolean includeValue) {
                this.mapProxy.addGenericListener(listener, null, includeValue, this.getInstanceType());
            }

            public void removeItemListener(ItemListener listener) {
                this.mapProxy.removeGenericListener(listener, null);
            }

            public String getName() {
                return CollectionProxyImpl.this.name.substring("m:s:".length());
            }

            public boolean add(Object obj) {
                return this.mapProxy.add(obj);
            }

            public boolean remove(Object obj) {
                return this.mapProxy.removeKey(obj);
            }

            public boolean removeKey(Object obj) {
                return this.mapProxy.removeKey(obj);
            }

            public boolean contains(Object obj) {
                return this.mapProxy.containsKey(obj);
            }

            public Iterator iterator() {
                return this.mapProxy.keySet().iterator();
            }

            public int size() {
                return this.mapProxy.size();
            }

            public void destroy() {
                CollectionProxyImpl.this.factory.destroyInstanceClusterWide(CollectionProxyImpl.this.name, null);
            }
        }
    }

    public class SemaphoreProxyImpl
    extends FactoryAwareNamedProxy
    implements SemaphoreProxy {
        private transient SemaphoreProxy base = null;
        Data nameAsData = null;

        public SemaphoreProxyImpl(String name, FactoryImpl factory) {
            this.setName(name);
            this.setHazelcastInstance(factory);
            this.base = new SemaphoreProxyReal();
        }

        private void ensure() {
            this.factory.initialChecks();
            if (this.base == null) {
                this.base = (SemaphoreProxy)this.factory.getOrCreateProxyByName(this.name);
            }
        }

        public String getLongName() {
            return this.name;
        }

        public String getName() {
            return this.name.substring("4:".length());
        }

        Data getNameAsData() {
            if (this.nameAsData == null) {
                this.nameAsData = IOUtil.toData(this.getName());
            }
            return this.nameAsData;
        }

        public Object getId() {
            this.ensure();
            return this.base.getId();
        }

        public String toString() {
            return "Semaphore [" + this.getName() + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SemaphoreProxyImpl that = (SemaphoreProxyImpl)o;
            return !(this.name == null ? that.name != null : !this.name.equals(that.name));
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        public Instance.InstanceType getInstanceType() {
            this.ensure();
            return this.base.getInstanceType();
        }

        public LocalSemaphoreStats getLocalSemaphoreStats() {
            this.ensure();
            return this.base.getLocalSemaphoreStats();
        }

        public SemaphoreOperationsCounter getOperationsCounter() {
            this.ensure();
            return this.base.getOperationsCounter();
        }

        public void acquire() throws InstanceDestroyedException, InterruptedException {
            this.ensure();
            this.base.acquire();
        }

        public void acquire(int permits) throws InstanceDestroyedException, InterruptedException {
            this.check(permits);
            this.ensure();
            this.base.acquire(permits);
        }

        public Future acquireAsync() {
            return this.doAsyncAcquire(1, false);
        }

        public Future acquireAsync(int permits) {
            this.check(permits);
            return this.doAsyncAcquire(permits, false);
        }

        public void acquireAttach() throws InstanceDestroyedException, InterruptedException {
            this.ensure();
            this.base.acquireAttach();
        }

        public void acquireAttach(int permits) throws InstanceDestroyedException, InterruptedException {
            this.check(permits);
            this.ensure();
            this.base.acquireAttach(permits);
        }

        public Future acquireAttachAsync() {
            return this.doAsyncAcquire(1, true);
        }

        public Future acquireAttachAsync(int permits) {
            this.check(permits);
            return this.doAsyncAcquire(permits, true);
        }

        public void attach() {
            this.ensure();
            this.base.attach();
        }

        public void attach(int permits) {
            this.check(permits);
            this.ensure();
            this.base.attach(permits);
        }

        public int attachedPermits() {
            this.ensure();
            return this.base.attachedPermits();
        }

        public int availablePermits() {
            this.ensure();
            return this.base.availablePermits();
        }

        public void detach() {
            this.ensure();
            this.base.detach();
        }

        public void detach(int permits) {
            this.check(permits);
            this.ensure();
            this.base.detach(permits);
        }

        public void destroy() {
            this.ensure();
            this.base.destroy();
        }

        public int drainPermits() {
            this.ensure();
            return this.base.drainPermits();
        }

        public void reducePermits(int permits) {
            this.check(permits);
            this.ensure();
            this.base.reducePermits(permits);
        }

        public void release() {
            this.ensure();
            this.base.release();
        }

        public void release(int permits) {
            this.check(permits);
            this.ensure();
            this.base.release(permits);
        }

        public void releaseDetach() {
            this.ensure();
            this.base.releaseDetach();
        }

        public void releaseDetach(int permits) {
            this.check(permits);
            this.ensure();
            this.base.releaseDetach(permits);
        }

        public boolean tryAcquire() {
            this.ensure();
            return this.base.tryAcquire();
        }

        public boolean tryAcquire(int permits) {
            this.check(permits);
            this.ensure();
            return this.base.tryAcquire(permits);
        }

        public boolean tryAcquire(long timeout, TimeUnit unit) throws InstanceDestroyedException, InterruptedException {
            this.ensure();
            return this.base.tryAcquire(timeout, unit);
        }

        public boolean tryAcquire(int permits, long timeout, TimeUnit timeunit) throws InstanceDestroyedException, InterruptedException {
            this.check(permits, timeout, timeunit);
            this.ensure();
            return this.base.tryAcquire(permits, timeout, timeunit);
        }

        public boolean tryAcquireAttach() {
            this.ensure();
            return this.base.tryAcquireAttach();
        }

        public boolean tryAcquireAttach(int permits) {
            this.check(permits);
            this.ensure();
            return this.base.tryAcquireAttach(permits);
        }

        public boolean tryAcquireAttach(long timeout, TimeUnit timeunit) throws InstanceDestroyedException, InterruptedException {
            this.ensure();
            return this.base.tryAcquireAttach(timeout, timeunit);
        }

        public boolean tryAcquireAttach(int permits, long timeout, TimeUnit timeunit) throws InstanceDestroyedException, InterruptedException {
            this.check(permits, timeout, timeunit);
            this.ensure();
            return this.base.tryAcquireAttach(permits, timeout, timeunit);
        }

        private void check(int permits) {
            if (permits < 0) {
                throw new IllegalArgumentException("Number of permits can not be negative: " + permits);
            }
        }

        private void check(int permits, long timeout, TimeUnit timeunit) {
            this.check(permits);
            if (timeout < -1L) {
                throw new IllegalArgumentException("Invalid timeout value: " + timeout);
            }
            if (timeunit == null) {
                throw new NullPointerException("TimeUnit can not be null.");
            }
        }

        private Future doAsyncAcquire(final Integer permits, final Boolean attach) {
            final SemaphoreProxyImpl semaphoreProxy = this;
            AsyncCall call = new AsyncCall(){

                protected void call() {
                    try {
                        if (attach.booleanValue()) {
                            semaphoreProxy.acquireAttach(permits);
                        } else {
                            semaphoreProxy.acquire(permits);
                        }
                        this.setResult(null);
                    }
                    catch (InterruptedException e) {
                        this.setResult(e);
                    }
                    catch (InstanceDestroyedException e) {
                        e.printStackTrace();
                    }
                }

                public boolean cancel(boolean mayInterruptIfRunning) {
                    ConcurrentMapManager.MSemaphore msemaphore = ((SemaphoreProxyImpl)SemaphoreProxyImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MSemaphore();
                    return msemaphore.cancelAcquire(SemaphoreProxyImpl.this.getNameAsData());
                }
            };
            this.factory.node.executorManager.executeAsync(call);
            return call;
        }

        private class SemaphoreProxyReal
        implements SemaphoreProxy {
            SemaphoreOperationsCounter operationsCounter = new SemaphoreOperationsCounter();

            private SemaphoreProxyReal() {
            }

            public Object getId() {
                return SemaphoreProxyImpl.this.name;
            }

            public Instance.InstanceType getInstanceType() {
                return Instance.InstanceType.SEMAPHORE;
            }

            public String getLongName() {
                return SemaphoreProxyImpl.this.name;
            }

            public String getName() {
                return SemaphoreProxyImpl.this.name.substring("4:".length());
            }

            public void destroy() {
                this.newMSemaphore().destroy(SemaphoreProxyImpl.this.getNameAsData());
                SemaphoreProxyImpl.this.factory.destroyInstanceClusterWide(SemaphoreProxyImpl.this.name, null);
            }

            public void acquire() throws InstanceDestroyedException, InterruptedException {
                this.acquire(1);
            }

            public void acquire(int permits) throws InstanceDestroyedException, InterruptedException {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                try {
                    this.doTryAcquire(permits, false, -1L);
                }
                catch (RuntimeInterruptedException e) {
                    throw new InterruptedException();
                }
            }

            public Future acquireAsync() {
                throw new UnsupportedOperationException();
            }

            public Future acquireAsync(int permits) {
                throw new UnsupportedOperationException();
            }

            public void acquireAttach() throws InstanceDestroyedException, InterruptedException {
                this.acquireAttach(1);
            }

            public void acquireAttach(int permits) throws InstanceDestroyedException, InterruptedException {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                try {
                    this.doTryAcquire(permits, true, -1L);
                }
                catch (RuntimeInterruptedException e) {
                    throw new InterruptedException();
                }
            }

            public Future acquireAttachAsync() {
                throw new UnsupportedOperationException();
            }

            public Future acquireAttachAsync(int permits) {
                throw new UnsupportedOperationException();
            }

            public void attach() {
                this.attach(1);
            }

            public void attach(int permits) {
                this.newMSemaphore().attachDetach(SemaphoreProxyImpl.this.getNameAsData(), permits);
            }

            public int attachedPermits() {
                return this.newMSemaphore().getAttached(SemaphoreProxyImpl.this.getNameAsData());
            }

            public int availablePermits() {
                return this.newMSemaphore().getAvailable(SemaphoreProxyImpl.this.getNameAsData());
            }

            public void detach() {
                this.detach(1);
            }

            public void detach(int permits) {
                this.newMSemaphore().attachDetach(SemaphoreProxyImpl.this.getNameAsData(), -permits);
            }

            public int drainPermits() {
                return this.newMSemaphore().drainPermits(SemaphoreProxyImpl.this.getNameAsData());
            }

            public void release() {
                this.release(1);
            }

            public void release(int permits) {
                this.newMSemaphore().release(SemaphoreProxyImpl.this.getNameAsData(), permits, false);
            }

            public void releaseDetach() {
                this.releaseDetach(1);
            }

            public void releaseDetach(int permits) {
                this.newMSemaphore().release(SemaphoreProxyImpl.this.getNameAsData(), permits, true);
            }

            public boolean tryAcquire() {
                return this.tryAcquire(1);
            }

            public boolean tryAcquire(int permits) {
                try {
                    return this.doTryAcquire(permits, false, -1L);
                }
                catch (Throwable e) {
                    return false;
                }
            }

            public boolean tryAcquire(long timeout, TimeUnit unit) throws InstanceDestroyedException, InterruptedException {
                return this.tryAcquire(1, timeout, unit);
            }

            public boolean tryAcquire(int permits, long timeout, TimeUnit unit) throws InstanceDestroyedException, InterruptedException {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                try {
                    return this.doTryAcquire(permits, false, unit.toMillis(timeout));
                }
                catch (RuntimeInterruptedException e) {
                    throw new InterruptedException();
                }
            }

            public boolean tryAcquireAttach() {
                return this.tryAcquireAttach(1);
            }

            public boolean tryAcquireAttach(int permits) {
                try {
                    return this.doTryAcquire(permits, true, -1L);
                }
                catch (Throwable e) {
                    return false;
                }
            }

            public boolean tryAcquireAttach(long timeout, TimeUnit unit) throws InstanceDestroyedException, InterruptedException {
                return this.tryAcquireAttach(1, timeout, unit);
            }

            public boolean tryAcquireAttach(int permits, long timeout, TimeUnit unit) throws InstanceDestroyedException, InterruptedException {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                try {
                    return this.doTryAcquire(permits, true, unit.toMillis(timeout));
                }
                catch (RuntimeInterruptedException e) {
                    throw new InterruptedException();
                }
            }

            public void reducePermits(int permits) {
                this.newMSemaphore().reduce(SemaphoreProxyImpl.this.getNameAsData(), permits);
            }

            public LocalSemaphoreStats getLocalSemaphoreStats() {
                LocalSemaphoreStatsImpl localSemaphoreStats = new LocalSemaphoreStatsImpl();
                localSemaphoreStats.setOperationStats(this.operationsCounter.getPublishedStats());
                return localSemaphoreStats;
            }

            public SemaphoreOperationsCounter getOperationsCounter() {
                return this.operationsCounter;
            }

            private ConcurrentMapManager.MSemaphore newMSemaphore() {
                ConcurrentMapManager.MSemaphore msemaphore = ((SemaphoreProxyImpl)SemaphoreProxyImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MSemaphore();
                msemaphore.setOperationsCounter(this.operationsCounter);
                return msemaphore;
            }

            private boolean doTryAcquire(int permits, boolean attach, long timeout) throws InstanceDestroyedException {
                return this.newMSemaphore().tryAcquire(SemaphoreProxyImpl.this.getNameAsData(), permits, attach, timeout);
            }
        }
    }

    public class CountDownLatchProxyImpl
    extends FactoryAwareNamedProxy
    implements CountDownLatchProxy {
        private transient CountDownLatchProxy base = null;
        Data nameAsData = null;

        public CountDownLatchProxyImpl(String name, FactoryImpl factory) {
            this.set(name, factory);
            this.base = new CountDownLatchProxyReal();
        }

        public void set(String name, FactoryImpl factory) {
            this.setName(name);
            this.setHazelcastInstance(factory);
        }

        public Instance.InstanceType getInstanceType() {
            this.ensure();
            return this.base.getInstanceType();
        }

        public void destroy() {
            this.ensure();
            this.base.destroy();
        }

        public Object getId() {
            this.ensure();
            return this.base.getId();
        }

        public String getName() {
            this.ensure();
            return this.base.getName();
        }

        public String getLongName() {
            return this.name;
        }

        public String toString() {
            return "CountDownLatch [" + this.getName() + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CountDownLatchProxyImpl that = (CountDownLatchProxyImpl)o;
            return !(this.name == null ? that.name != null : !this.name.equals(that.name));
        }

        public int hashCode() {
            int result = this.base != null ? this.base.hashCode() : 0;
            result = 31 * result + (this.nameAsData != null ? this.nameAsData.hashCode() : 0);
            return result;
        }

        public void await() throws InstanceDestroyedException, MemberLeftException, InterruptedException {
            this.ensure();
            this.base.await();
        }

        public boolean await(long timeout, TimeUnit unit) throws InstanceDestroyedException, MemberLeftException, InterruptedException {
            this.ensure();
            return this.base.await(timeout, unit);
        }

        public void countDown() {
            this.ensure();
            this.base.countDown();
        }

        public int getCount() {
            this.ensure();
            return this.base.getCount();
        }

        public Member getOwner() {
            this.ensure();
            return this.base.getOwner();
        }

        public boolean hasCount() {
            this.ensure();
            return this.base.hasCount();
        }

        public boolean setCount(int count) {
            this.ensure();
            return this.base.setCount(count);
        }

        public boolean setCount(int count, Address ownerAddress) {
            this.ensure();
            return this.base.setCount(count, ownerAddress);
        }

        public LocalCountDownLatchStats getLocalCountDownLatchStats() {
            this.ensure();
            return this.base.getLocalCountDownLatchStats();
        }

        public CountDownLatchOperationsCounter getCountDownLatchOperationsCounter() {
            this.ensure();
            return this.base.getCountDownLatchOperationsCounter();
        }

        private Data getNameAsData() {
            if (this.nameAsData == null) {
                this.nameAsData = IOUtil.toData(this.name);
            }
            return this.nameAsData;
        }

        private void ensure() {
            this.factory.initialChecks();
            if (this.base == null) {
                this.base = (CountDownLatchProxy)this.factory.getOrCreateProxyByName(this.name);
            }
        }

        private class CountDownLatchProxyReal
        implements CountDownLatchProxy {
            CountDownLatchOperationsCounter operationsCounter = new CountDownLatchOperationsCounter();

            public String getName() {
                return CountDownLatchProxyImpl.this.name.substring("d:".length());
            }

            public String getLongName() {
                return CountDownLatchProxyImpl.this.name;
            }

            public Object getId() {
                return CountDownLatchProxyImpl.this.name;
            }

            public void await() throws InstanceDestroyedException, MemberLeftException, InterruptedException {
                this.await(-1L, TimeUnit.MILLISECONDS);
            }

            public boolean await(long timeout, TimeUnit unit) throws InstanceDestroyedException, MemberLeftException, InterruptedException {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                return this.newMCountDownLatch().await(CountDownLatchProxyImpl.this.getNameAsData(), timeout, unit);
            }

            public void countDown() {
                this.newMCountDownLatch().countDown(CountDownLatchProxyImpl.this.getNameAsData());
            }

            public void destroy() {
                this.newMCountDownLatch().destroy(CountDownLatchProxyImpl.this.getNameAsData());
                CountDownLatchProxyImpl.this.factory.destroyInstanceClusterWide(CountDownLatchProxyImpl.this.name, null);
            }

            public int getCount() {
                return this.newMCountDownLatch().getCount(CountDownLatchProxyImpl.this.getNameAsData());
            }

            public Member getOwner() {
                Address owner = this.newMCountDownLatch().getOwnerAddress(CountDownLatchProxyImpl.this.getNameAsData());
                Address local = FactoryImpl.this.node.baseVariables.thisAddress;
                return owner != null ? new MemberImpl(owner, local.equals(owner)) : null;
            }

            public boolean hasCount() {
                return this.newMCountDownLatch().getCount(CountDownLatchProxyImpl.this.getNameAsData()) > 0;
            }

            public boolean setCount(int count) {
                return this.setCount(count, FactoryImpl.this.node.getThisAddress());
            }

            public boolean setCount(int count, Address ownerAddress) {
                return this.newMCountDownLatch().setCount(CountDownLatchProxyImpl.this.getNameAsData(), count, ownerAddress);
            }

            public Instance.InstanceType getInstanceType() {
                return Instance.InstanceType.COUNT_DOWN_LATCH;
            }

            public CountDownLatchOperationsCounter getCountDownLatchOperationsCounter() {
                return this.operationsCounter;
            }

            public LocalCountDownLatchStats getLocalCountDownLatchStats() {
                LocalCountDownLatchStatsImpl localCountDownLatchStats = new LocalCountDownLatchStatsImpl();
                localCountDownLatchStats.setOperationStats(this.operationsCounter.getPublishedStats());
                return localCountDownLatchStats;
            }

            ConcurrentMapManager.MCountDownLatch newMCountDownLatch() {
                ConcurrentMapManager.MCountDownLatch mcdl = ((CountDownLatchProxyImpl)CountDownLatchProxyImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MCountDownLatch();
                mcdl.setOperationsCounter(this.operationsCounter);
                return mcdl;
            }
        }
    }

    public static class AtomicNumberProxyImpl
    extends FactoryAwareNamedProxy
    implements AtomicNumberProxy {
        private transient AtomicNumberProxy base = null;
        Data nameAsData = null;

        public AtomicNumberProxyImpl() {
        }

        public AtomicNumberProxyImpl(String name, FactoryImpl factory) {
            this.setName(name);
            this.setHazelcastInstance(factory);
            this.base = new AtomicNumberProxyReal();
        }

        Data getNameAsData() {
            if (this.nameAsData == null) {
                this.nameAsData = IOUtil.toData(this.name);
            }
            return this.nameAsData;
        }

        private void ensure() {
            this.factory.initialChecks();
            if (this.base == null) {
                this.base = (AtomicNumberProxy)this.factory.getOrCreateProxyByName(this.name);
            }
        }

        public String toString() {
            return "AtomicLong [" + this.getName() + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AtomicNumberProxyImpl that = (AtomicNumberProxyImpl)o;
            return !(this.name == null ? that.name != null : !this.name.equals(that.name));
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        public void destroy() {
            this.ensure();
            this.base.destroy();
        }

        public Instance.InstanceType getInstanceType() {
            this.ensure();
            return this.base.getInstanceType();
        }

        public Object getId() {
            this.ensure();
            return this.base.getId();
        }

        public String getName() {
            this.ensure();
            return this.base.getName();
        }

        public String getLongName() {
            return this.name;
        }

        public long addAndGet(long delta) {
            this.ensure();
            return this.base.addAndGet(delta);
        }

        public boolean compareAndSet(long expect, long update) {
            this.ensure();
            return this.base.compareAndSet(expect, update);
        }

        public long decrementAndGet() {
            this.ensure();
            return this.base.decrementAndGet();
        }

        public long get() {
            this.ensure();
            return this.base.get();
        }

        public long getAndAdd(long delta) {
            this.ensure();
            return this.base.getAndAdd(delta);
        }

        public long getAndSet(long newValue) {
            this.ensure();
            return this.base.getAndSet(newValue);
        }

        public long incrementAndGet() {
            this.ensure();
            return this.base.incrementAndGet();
        }

        public void set(long newValue) {
            this.ensure();
            this.base.set(newValue);
        }

        public AtomicNumberOperationsCounter getOperationsCounter() {
            this.ensure();
            return this.base.getOperationsCounter();
        }

        public LocalAtomicNumberStats getLocalAtomicNumberStats() {
            this.ensure();
            return this.base.getLocalAtomicNumberStats();
        }

        @Deprecated
        public void lazySet(long newValue) {
            this.set(newValue);
        }

        @Deprecated
        public boolean weakCompareAndSet(long expect, long update) {
            return this.compareAndSet(expect, update);
        }

        private class AtomicNumberProxyReal
        implements AtomicNumberProxy {
            AtomicNumberOperationsCounter operationsCounter = new AtomicNumberOperationsCounter();

            public String getName() {
                return AtomicNumberProxyImpl.this.name.substring("a:".length());
            }

            public String getLongName() {
                return AtomicNumberProxyImpl.this.name;
            }

            public Object getId() {
                return AtomicNumberProxyImpl.this.name;
            }

            public long addAndGet(long delta) {
                return this.newMAtomicNumber().addAndGet(AtomicNumberProxyImpl.this.getNameAsData(), delta);
            }

            public boolean compareAndSet(long expect, long update) {
                return this.newMAtomicNumber().compareAndSet(AtomicNumberProxyImpl.this.getNameAsData(), expect, update);
            }

            public long decrementAndGet() {
                return this.addAndGet(-1L);
            }

            public long get() {
                return this.addAndGet(0L);
            }

            public long getAndAdd(long delta) {
                return this.newMAtomicNumber().getAndAdd(AtomicNumberProxyImpl.this.getNameAsData(), delta);
            }

            public long getAndSet(long newValue) {
                return this.newMAtomicNumber().getAndSet(AtomicNumberProxyImpl.this.getNameAsData(), newValue);
            }

            public long incrementAndGet() {
                return this.addAndGet(1L);
            }

            public void set(long newValue) {
                this.getAndSet(newValue);
            }

            public Instance.InstanceType getInstanceType() {
                return Instance.InstanceType.ATOMIC_NUMBER;
            }

            public void destroy() {
                this.newMAtomicNumber().destroy(AtomicNumberProxyImpl.this.getNameAsData());
                AtomicNumberProxyImpl.this.factory.destroyInstanceClusterWide(AtomicNumberProxyImpl.this.name, null);
            }

            public AtomicNumberOperationsCounter getOperationsCounter() {
                return this.operationsCounter;
            }

            public LocalAtomicNumberStats getLocalAtomicNumberStats() {
                LocalAtomicNumberStatsImpl localAtomicStats = new LocalAtomicNumberStatsImpl();
                localAtomicStats.setOperationStats(this.operationsCounter.getPublishedStats());
                return localAtomicStats;
            }

            @Deprecated
            public void lazySet(long newValue) {
                this.set(newValue);
            }

            @Deprecated
            public boolean weakCompareAndSet(long expect, long update) {
                return this.compareAndSet(expect, update);
            }

            ConcurrentMapManager.MAtomicNumber newMAtomicNumber() {
                ConcurrentMapManager.MAtomicNumber mAtomicNumber = ((AtomicNumberProxyImpl)AtomicNumberProxyImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MAtomicNumber();
                mAtomicNumber.setOperationsCounter(this.operationsCounter);
                return mAtomicNumber;
            }
        }
    }

    public static class TopicProxyImpl
    extends FactoryAwareNamedProxy
    implements TopicProxy,
    DataSerializable {
        private transient TopicProxy base = null;
        private TopicManager topicManager = null;
        private ListenerManager listenerManager = null;

        public TopicProxyImpl() {
        }

        public TopicProxyImpl(String name, FactoryImpl factory) {
            this.set(name, factory);
            this.base = new TopicProxyReal();
        }

        private void ensure() {
            this.factory.initialChecks();
            if (this.base == null) {
                this.base = (TopicProxy)this.factory.getOrCreateProxyByName(this.name);
            }
        }

        public void set(String name, FactoryImpl factory) {
            this.setName(name);
            this.setHazelcastInstance(factory);
        }

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            super.setHazelcastInstance(hazelcastInstance);
            this.topicManager = this.factory.node.topicManager;
            this.listenerManager = this.factory.node.listenerManager;
        }

        public String getLongName() {
            return this.base.getLongName();
        }

        public Object getId() {
            this.ensure();
            return this.base.getId();
        }

        public String toString() {
            return "Topic [" + this.getName() + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TopicProxyImpl that = (TopicProxyImpl)o;
            return !(this.name == null ? that.name != null : !this.name.equals(that.name));
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        public void publish(Object msg) {
            this.ensure();
            this.base.publish(msg);
        }

        public void addMessageListener(MessageListener listener) {
            this.ensure();
            this.base.addMessageListener(listener);
        }

        public void removeMessageListener(MessageListener listener) {
            this.ensure();
            this.base.removeMessageListener(listener);
        }

        public void destroy() {
            this.ensure();
            this.base.destroy();
        }

        public Instance.InstanceType getInstanceType() {
            this.ensure();
            return this.base.getInstanceType();
        }

        public String getName() {
            this.ensure();
            return this.base.getName();
        }

        public LocalTopicStats getLocalTopicStats() {
            this.ensure();
            return this.base.getLocalTopicStats();
        }

        public TopicOperationsCounter getTopicOperationCounter() {
            return this.base.getTopicOperationCounter();
        }

        class TopicProxyReal
        implements TopicProxy {
            TopicOperationsCounter topicOperationsCounter = new TopicOperationsCounter();

            TopicProxyReal() {
            }

            public void publish(Object msg) {
                FactoryImpl.check(msg);
                this.topicOperationsCounter.incrementPublishes();
                TopicProxyImpl.this.topicManager.doPublish(TopicProxyImpl.this.name, msg);
            }

            public void addMessageListener(MessageListener listener) {
                TopicProxyImpl.this.listenerManager.addListener(TopicProxyImpl.this.name, listener, null, true, this.getInstanceType());
            }

            public void removeMessageListener(MessageListener listener) {
                TopicProxyImpl.this.listenerManager.removeListener(TopicProxyImpl.this.name, listener, null);
            }

            public void destroy() {
                TopicProxyImpl.this.factory.destroyInstanceClusterWide(TopicProxyImpl.this.name, null);
            }

            public Instance.InstanceType getInstanceType() {
                return Instance.InstanceType.TOPIC;
            }

            public String getName() {
                return TopicProxyImpl.this.name.substring("t:".length());
            }

            public String getLongName() {
                return TopicProxyImpl.this.name;
            }

            public Object getId() {
                return TopicProxyImpl.this.name;
            }

            public LocalTopicStats getLocalTopicStats() {
                LocalTopicStatsImpl localTopicStats = TopicProxyImpl.this.topicManager.getTopicInstance(TopicProxyImpl.this.name).getTopicStats();
                localTopicStats.setOperationStats(this.topicOperationsCounter.getPublishedStats());
                return localTopicStats;
            }

            public TopicOperationsCounter getTopicOperationCounter() {
                return this.topicOperationsCounter;
            }
        }
    }

    public static class ProxyKey
    extends SerializationHelper
    implements DataSerializable {
        String name;
        Object key;

        public ProxyKey() {
        }

        public ProxyKey(String name, Object key) {
            this.name = name;
            this.key = key;
        }

        public void writeData(DataOutput out) throws IOException {
            out.writeUTF(this.name);
            boolean keyNull = this.key == null;
            out.writeBoolean(keyNull);
            if (!keyNull) {
                ProxyKey.writeObject(out, this.key);
            }
        }

        public void readData(DataInput in) throws IOException {
            this.name = in.readUTF();
            boolean keyNull = in.readBoolean();
            if (!keyNull) {
                this.key = ProxyKey.readObject(in);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProxyKey pk = (ProxyKey)o;
            return (this.name != null ? this.name.equals(pk.name) : pk.name == null) && (this.key != null ? this.key.equals(pk.key) : pk.key == null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ProxyKey {name='" + this.name + "', key=" + this.key + '}';
        }

        public String getName() {
            return this.name;
        }

        public Object getKey() {
            return this.key;
        }
    }

    public static class LockProxyImpl
    extends SerializationHelper
    implements HazelcastInstanceAwareInstance,
    LockProxy,
    DataSerializable {
        private Object key = null;
        private transient LockProxy base = null;
        private transient FactoryImpl factory = null;

        public LockProxyImpl() {
        }

        public LockProxyImpl(HazelcastInstance hazelcastInstance, Object key) {
            this.key = key;
            this.setHazelcastInstance(hazelcastInstance);
            this.base = new LockProxyBase();
        }

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            this.factory = (FactoryImpl)hazelcastInstance;
        }

        private void ensure() {
            this.factory.initialChecks();
            if (this.base == null) {
                this.base = (LockProxy)this.factory.getLock(this.key);
            }
        }

        public String toString() {
            return "ILock [" + this.key + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LockProxyImpl lockProxy = (LockProxyImpl)o;
            return !(this.key == null ? lockProxy.key != null : !this.key.equals(lockProxy.key));
        }

        public int hashCode() {
            return this.key != null ? this.key.hashCode() : 0;
        }

        public void writeData(DataOutput out) throws IOException {
            LockProxyImpl.writeObject(out, this.key);
        }

        public void readData(DataInput in) throws IOException {
            this.key = LockProxyImpl.readObject(in);
            this.setHazelcastInstance(ThreadContext.get().getCurrentFactory());
        }

        public void lock() {
            this.ensure();
            this.base.lock();
        }

        public void lockInterruptibly() throws InterruptedException {
            this.ensure();
            this.base.lockInterruptibly();
        }

        public boolean tryLock() {
            this.ensure();
            return this.base.tryLock();
        }

        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            this.ensure();
            return this.base.tryLock(time, unit);
        }

        public void unlock() {
            this.ensure();
            this.base.unlock();
        }

        public Condition newCondition() {
            this.ensure();
            return this.base.newCondition();
        }

        public Instance.InstanceType getInstanceType() {
            this.ensure();
            return Instance.InstanceType.LOCK;
        }

        public void destroy() {
            this.ensure();
            this.base.destroy();
        }

        public Object getLockObject() {
            return this.key;
        }

        public Object getId() {
            this.ensure();
            return this.base.getId();
        }

        public LocalLockStats getLocalLockStats() {
            this.ensure();
            return this.base.getLocalLockStats();
        }

        public LockOperationsCounter getLockOperationCounter() {
            this.ensure();
            return this.base.getLockOperationCounter();
        }

        private class LockProxyBase
        implements LockProxy {
            private LockOperationsCounter lockOperationsCounter = new LockOperationsCounter();

            private LockProxyBase() {
            }

            public void lock() {
                ((LockProxyImpl)LockProxyImpl.this).factory.locksMapProxy.lock(LockProxyImpl.this.key);
                this.lockOperationsCounter.incrementLocks();
            }

            public void lockInterruptibly() throws InterruptedException {
                throw new UnsupportedOperationException("lockInterruptibly is not implemented!");
            }

            public Condition newCondition() {
                return null;
            }

            public boolean tryLock() {
                if (((LockProxyImpl)LockProxyImpl.this).factory.locksMapProxy.tryLock(LockProxyImpl.this.key)) {
                    this.lockOperationsCounter.incrementLocks();
                    return true;
                }
                this.lockOperationsCounter.incrementFailedLocks();
                return false;
            }

            public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
                try {
                    if (((LockProxyImpl)LockProxyImpl.this).factory.locksMapProxy.tryLock(LockProxyImpl.this.key, time, unit)) {
                        this.lockOperationsCounter.incrementLocks();
                        return true;
                    }
                }
                catch (RuntimeInterruptedException e) {
                    this.lockOperationsCounter.incrementFailedLocks();
                    throw new InterruptedException();
                }
                this.lockOperationsCounter.incrementFailedLocks();
                return false;
            }

            public void unlock() {
                ((LockProxyImpl)LockProxyImpl.this).factory.locksMapProxy.unlock(LockProxyImpl.this.key);
                this.lockOperationsCounter.incrementUnlocks();
            }

            public void destroy() {
                LockProxyImpl.this.factory.destroyInstanceClusterWide("lock", LockProxyImpl.this.key);
            }

            public Instance.InstanceType getInstanceType() {
                return Instance.InstanceType.LOCK;
            }

            public Object getLockObject() {
                return LockProxyImpl.this.key;
            }

            public Object getId() {
                return new ProxyKey("lock", LockProxyImpl.this.key);
            }

            public LocalLockStats getLocalLockStats() {
                LocalLockStatsImpl localLockStats = new LocalLockStatsImpl();
                localLockStats.setOperationStats(this.lockOperationsCounter.getPublishedStats());
                return localLockStats;
            }

            public LockOperationsCounter getLockOperationCounter() {
                return this.lockOperationsCounter;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InitializeMap
    implements Callable<Boolean>,
    DataSerializable,
    HazelcastInstanceAware {
        String name;
        private transient HazelcastInstance hazelcast = null;

        public InitializeMap(String name) {
            this.name = name;
        }

        public InitializeMap() {
        }

        @Override
        public Boolean call() throws Exception {
            this.hazelcast.getMap(this.name).getName();
            return Boolean.TRUE;
        }

        @Override
        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            this.hazelcast = hazelcastInstance;
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            out.writeUTF(this.name);
        }

        @Override
        public void readData(DataInput in) throws IOException {
            this.name = in.readUTF();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HazelcastInstanceProxy
    extends HazelcastInstanceAwareObject
    implements HazelcastInstance {
        public HazelcastInstanceProxy() {
        }

        public HazelcastInstanceProxy(FactoryImpl factory) {
            this.hazelcastInstance = factory;
        }

        public FactoryImpl getFactory() {
            return (FactoryImpl)this.hazelcastInstance;
        }

        @Override
        public String getName() {
            return this.hazelcastInstance.getName();
        }

        @Override
        public void shutdown() {
            this.hazelcastInstance.shutdown();
        }

        @Override
        public void restart() {
            this.hazelcastInstance.restart();
        }

        @Override
        public Collection<Instance> getInstances() {
            return this.hazelcastInstance.getInstances();
        }

        @Override
        public ExecutorService getExecutorService() {
            return this.hazelcastInstance.getExecutorService();
        }

        @Override
        public ExecutorService getExecutorService(String name) {
            return this.hazelcastInstance.getExecutorService(name);
        }

        @Override
        public Cluster getCluster() {
            return this.hazelcastInstance.getCluster();
        }

        @Override
        public IdGenerator getIdGenerator(String name) {
            return this.hazelcastInstance.getIdGenerator(name);
        }

        @Override
        public AtomicNumber getAtomicNumber(String name) {
            return this.hazelcastInstance.getAtomicNumber(name);
        }

        @Override
        public Transaction getTransaction() {
            return this.hazelcastInstance.getTransaction();
        }

        @Override
        public <K, V> IMap<K, V> getMap(String name) {
            return this.hazelcastInstance.getMap(name);
        }

        @Override
        public <E> IQueue<E> getQueue(String name) {
            return this.hazelcastInstance.getQueue(name);
        }

        @Override
        public <E> ITopic<E> getTopic(String name) {
            return this.hazelcastInstance.getTopic(name);
        }

        @Override
        public <E> ISet<E> getSet(String name) {
            return this.hazelcastInstance.getSet(name);
        }

        @Override
        public <E> IList<E> getList(String name) {
            return this.hazelcastInstance.getList(name);
        }

        @Override
        public <K, V> MultiMap<K, V> getMultiMap(String name) {
            return this.hazelcastInstance.getMultiMap(name);
        }

        @Override
        public ILock getLock(Object key) {
            return this.hazelcastInstance.getLock(key);
        }

        @Override
        public ICountDownLatch getCountDownLatch(String name) {
            return this.hazelcastInstance.getCountDownLatch(name);
        }

        @Override
        public ISemaphore getSemaphore(String name) {
            return this.hazelcastInstance.getSemaphore(name);
        }

        @Override
        public void addInstanceListener(InstanceListener instanceListener) {
            this.hazelcastInstance.addInstanceListener(instanceListener);
        }

        @Override
        public void removeInstanceListener(InstanceListener instanceListener) {
            this.hazelcastInstance.removeInstanceListener(instanceListener);
        }

        @Override
        public Config getConfig() {
            return this.hazelcastInstance.getConfig();
        }

        @Override
        public PartitionService getPartitionService() {
            return this.hazelcastInstance.getPartitionService();
        }

        @Override
        public LoggingService getLoggingService() {
            return this.hazelcastInstance.getLoggingService();
        }

        @Override
        public LifecycleService getLifecycleService() {
            return this.hazelcastInstance.getLifecycleService();
        }
    }
}

