/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.cluster.Bind;
import com.hazelcast.cluster.ClusterManager;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.Processable;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.nio.Packet;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class ConnectionManager {
    protected final ILogger logger;
    final int SOCKET_RECEIVE_BUFFER_SIZE;
    final int SOCKET_SEND_BUFFER_SIZE;
    final int SOCKET_LINGER_SECONDS;
    final boolean SOCKET_KEEP_ALIVE;
    final boolean SOCKET_NO_DELAY;
    private final Map<Address, Connection> mapConnections = new ConcurrentHashMap<Address, Connection>(100);
    private final Set<Address> setConnectionInProgress = new CopyOnWriteArraySet<Address>();
    private final Set<ConnectionListener> setConnectionListeners = new CopyOnWriteArraySet<ConnectionListener>();
    private final Set<Connection> setActiveConnections = new CopyOnWriteArraySet<Connection>();
    private final AtomicInteger allTextConnections = new AtomicInteger();
    private final AtomicInteger connectionIdGen = new AtomicInteger();
    private boolean acceptTypeConnection = false;
    private volatile boolean live = true;
    final Node node;

    public ConnectionManager(Node node) {
        this.node = node;
        this.logger = node.getLogger(ConnectionManager.class.getName());
        this.SOCKET_RECEIVE_BUFFER_SIZE = this.node.getGroupProperties().SOCKET_RECEIVE_BUFFER_SIZE.getInteger() * 1024;
        this.SOCKET_SEND_BUFFER_SIZE = this.node.getGroupProperties().SOCKET_SEND_BUFFER_SIZE.getInteger() * 1024;
        this.SOCKET_LINGER_SECONDS = this.node.getGroupProperties().SOCKET_LINGER_SECONDS.getInteger();
        this.SOCKET_KEEP_ALIVE = this.node.getGroupProperties().SOCKET_KEEP_ALIVE.getBoolean();
        this.SOCKET_NO_DELAY = this.node.getGroupProperties().SOCKET_NO_DELAY.getBoolean();
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.setConnectionListeners.add(listener);
    }

    public boolean bind(Address endPoint, Connection connection, boolean accept) {
        connection.setEndPoint(endPoint);
        Connection connExisting = this.mapConnections.get(endPoint);
        if (connExisting != null && connExisting != connection) {
            String msg = "Two connections from the same endpoint " + endPoint + ", acceptTypeConnection=" + this.acceptTypeConnection + ",  now accept=" + accept;
            if (this.node.joined() && this.node.isMaster()) {
                this.logger.log(Level.WARNING, msg);
                connExisting.closeSilently();
                final Address deadEndpoint = connExisting.getEndPoint();
                if (deadEndpoint != null) {
                    this.node.clusterManager.enqueueAndReturn(new Processable(){

                        public void process() {
                            ConnectionManager.this.node.clusterManager.disconnectExistingCalls(deadEndpoint);
                        }
                    });
                }
            } else {
                this.logger.log(Level.FINEST, msg);
                return true;
            }
        }
        if (!endPoint.equals(this.node.getThisAddress())) {
            this.acceptTypeConnection = accept;
            if (!accept) {
                ClusterManager clusterManager = this.node.clusterManager;
                Packet bindPacket = clusterManager.createRemotelyProcessablePacket(new Bind(clusterManager.getThisAddress()));
                connection.writeHandler.enqueueSocketWritable(bindPacket);
            }
            this.mapConnections.put(endPoint, connection);
            this.setConnectionInProgress.remove(endPoint);
            for (ConnectionListener listener : this.setConnectionListeners) {
                listener.connectionAdded(connection);
            }
        } else {
            return false;
        }
        return true;
    }

    public Connection createConnection(SocketChannel socketChannel, boolean acceptor) {
        Connection connection = new Connection(this, this.connectionIdGen.incrementAndGet(), socketChannel);
        this.setActiveConnections.add(connection);
        try {
            if (!acceptor) {
                this.node.inSelector.addTask(connection.getReadHandler());
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
        }
        return connection;
    }

    public void failedConnection(Address address) {
        this.setConnectionInProgress.remove(address);
        if (!this.node.joined()) {
            this.node.failedConnection(address);
        }
    }

    public Connection getConnection(Address address) {
        return this.mapConnections.get(address);
    }

    public Connection getOrConnect(Address address) {
        if (address.equals(this.node.getThisAddress())) {
            throw new RuntimeException("Connecting to self! " + address);
        }
        Connection connection = this.mapConnections.get(address);
        if (connection == null && this.setConnectionInProgress.add(address)) {
            if (!this.node.clusterManager.shouldConnectTo(address)) {
                throw new RuntimeException("Should not connect to " + address);
            }
            this.node.outSelector.connect(address);
        }
        return connection;
    }

    public Connection detachAndGetConnection(Address address) {
        return this.mapConnections.remove(address);
    }

    public void attachConnection(Address address, Connection conn) {
        this.mapConnections.put(address, conn);
    }

    public void destroyConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        this.setActiveConnections.remove(connection);
        if (connection.getEndPoint() != null) {
            this.mapConnections.remove(connection.getEndPoint());
            this.setConnectionInProgress.remove(connection.getEndPoint());
            for (ConnectionListener listener : this.setConnectionListeners) {
                listener.connectionRemoved(connection);
            }
        }
        connection.close();
    }

    public void start() {
        this.live = true;
    }

    public void onRestart() {
        this.shutdown();
        this.start();
    }

    public int getTotalWriteQueueSize() {
        int count = 0;
        for (Connection conn : this.mapConnections.values()) {
            if (!conn.live()) continue;
            count += conn.getWriteHandler().size();
        }
        return count;
    }

    public void shutdown() {
        this.live = false;
        for (Connection conn : this.mapConnections.values()) {
            try {
                this.destroyConnection(conn);
            }
            catch (Throwable ignore) {
                this.logger.log(Level.FINEST, ignore.getMessage(), ignore);
            }
        }
        for (Connection conn : this.setActiveConnections) {
            try {
                this.destroyConnection(conn);
            }
            catch (Throwable ignore) {
                this.logger.log(Level.FINEST, ignore.getMessage(), ignore);
            }
        }
        this.setConnectionInProgress.clear();
        this.mapConnections.clear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Connections {");
        for (Connection conn : this.mapConnections.values()) {
            sb.append("\n");
            sb.append(conn);
        }
        sb.append("\nlive=");
        sb.append(this.live);
        sb.append("\n}");
        return sb.toString();
    }

    public int getCurrentClientConnections() {
        int count = 0;
        for (Connection conn : this.setActiveConnections) {
            if (!conn.live() || !conn.isClient()) continue;
            ++count;
        }
        return count;
    }

    public int getAllTextConnections() {
        return this.allTextConnections.get();
    }

    public void incrementTextConnections() {
        this.allTextConnections.incrementAndGet();
    }

    public void appendState(StringBuffer sbState) {
        long now = System.currentTimeMillis();
        sbState.append("\nConnectionManager {");
        for (Connection conn : this.mapConnections.values()) {
            long wr = (now - conn.getWriteHandler().lastRegistration) / 1000L;
            long wh = (now - conn.getWriteHandler().lastHandle) / 1000L;
            long rr = (now - conn.getReadHandler().lastRegistration) / 1000L;
            long rh = (now - conn.getReadHandler().lastHandle) / 1000L;
            sbState.append("\n\tEndPoint: " + conn.getEndPoint());
            sbState.append("  " + conn.live());
            sbState.append("  " + conn.getWriteHandler().size());
            sbState.append("  w:").append(wr).append("/").append(wh);
            sbState.append("  r:").append(rr).append("/").append(rh);
        }
        sbState.append("\n}");
    }
}

