/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate;

import com.hazelcast.config.Config;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.UrlXmlConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.HazelcastInstanceFactory;
import com.hazelcast.hibernate.IHazelcastInstanceLoader;
import com.hazelcast.hibernate.VersionAwareMergePolicy;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import org.hibernate.cache.CacheException;
import org.hibernate.util.ConfigHelper;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.StringHelper;

class HazelcastInstanceLoader
implements IHazelcastInstanceLoader {
    private static final ILogger logger = Logger.getLogger(HazelcastInstanceFactory.class.getName());

    HazelcastInstanceLoader() {
    }

    public HazelcastInstance loadInstance(Properties props) throws CacheException {
        boolean useSuperClient = false;
        String configResourcePath = null;
        if (props != null) {
            useSuperClient = PropertiesHelper.getBoolean((String)"hibernate.cache.hazelcast.use_super_client", (Properties)props, (boolean)false);
            configResourcePath = PropertiesHelper.getString((String)"hibernate.cache.provider_configuration_file_resource_path", (Properties)props, null);
            if (StringHelper.isEmpty((String)configResourcePath)) {
                configResourcePath = PropertiesHelper.getString((String)"hibernate.cache.hazelcast.configuration_file_path", (Properties)props, null);
            }
        }
        if (useSuperClient) {
            logger.log(Level.WARNING, "Creating Hazelcast node as Super-Client. Be sure this node has access to an already running cluster...");
        }
        Config config = null;
        if (StringHelper.isEmpty(configResourcePath)) {
            if (!useSuperClient) {
                return Hazelcast.getDefaultInstance();
            }
            config = new XmlConfigBuilder().build();
            config.setSuperClient(true);
        } else {
            URL url = ConfigHelper.locateConfig(configResourcePath);
            try {
                config = new UrlXmlConfig(url);
                config.setSuperClient(useSuperClient);
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
        }
        config.addMergePolicyConfig(new MergePolicyConfig("hz.HIBERNATE_VERSION_AWARE", new VersionAwareMergePolicy()));
        return Hazelcast.newHazelcastInstance(config);
    }
}

