/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.collection;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.collection.NonStrictReadWriteAccessStrategy;
import com.hazelcast.hibernate.collection.ReadOnlyAccessStrategy;
import com.hazelcast.hibernate.collection.ReadWriteAccessStrategy;
import com.hazelcast.hibernate.region.AbstractTransactionalDataRegion;
import java.util.Properties;
import org.hibernate.cache.CacheDataDescription;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CollectionRegion;
import org.hibernate.cache.access.AccessType;
import org.hibernate.cache.access.CollectionRegionAccessStrategy;

public class HazelcastCollectionRegion
extends AbstractTransactionalDataRegion
implements CollectionRegion {
    public HazelcastCollectionRegion(HazelcastInstance instance, String regionName, CacheDataDescription metadata, Properties properties) {
        super(instance, regionName, metadata, properties);
    }

    public CollectionRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        if (null == accessType) {
            throw new CacheException("Got null AccessType while attempting to build CollectionRegionAccessStrategy. This can't happen!");
        }
        if (AccessType.READ_ONLY.equals(accessType)) {
            return new ReadOnlyAccessStrategy(this);
        }
        if (AccessType.NONSTRICT_READ_WRITE.equals(accessType)) {
            return new NonStrictReadWriteAccessStrategy(this);
        }
        if (AccessType.READ_WRITE.equals(accessType)) {
            return new ReadWriteAccessStrategy(this);
        }
        if (AccessType.TRANSACTIONAL.equals(accessType)) {
            throw new CacheException("Transactional access is not currently supported by Hazelcast.");
        }
        throw new CacheException("Got unknown AccessType " + accessType + " while attempting to build CollectionRegionAccessStrategy.");
    }
}

