/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.ClusterImpl;
import com.hazelcast.cluster.ClusterManager;
import com.hazelcast.cluster.ClusterService;
import com.hazelcast.cluster.JoinInfo;
import com.hazelcast.cluster.JoinRequest;
import com.hazelcast.config.Config;
import com.hazelcast.config.Join;
import com.hazelcast.impl.AddressPicker;
import com.hazelcast.impl.BlockingQueueManager;
import com.hazelcast.impl.ClientService;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.ExecutorManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.GroupProperties;
import com.hazelcast.impl.Joiner;
import com.hazelcast.impl.ListenerManager;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.MulticastJoiner;
import com.hazelcast.impl.MulticastService;
import com.hazelcast.impl.NodeBaseVariables;
import com.hazelcast.impl.NodeMulticastListener;
import com.hazelcast.impl.NodeType;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.TcpIpJoiner;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.TopicManager;
import com.hazelcast.impl.ascii.TextCommandService;
import com.hazelcast.impl.ascii.TextCommandServiceImpl;
import com.hazelcast.impl.base.CpuUtilization;
import com.hazelcast.impl.base.VersionCheck;
import com.hazelcast.impl.wan.WanReplicationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingServiceImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.InSelector;
import com.hazelcast.nio.OutSelector;
import com.hazelcast.nio.Packet;
import com.hazelcast.util.NoneStrictObjectPool;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.nio.channels.ServerSocketChannel;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node {
    private final ILogger logger;
    private AtomicBoolean joined = new AtomicBoolean(false);
    private volatile boolean active = false;
    private volatile boolean outOfMemory = false;
    private volatile boolean completelyShutdown = false;
    private final ClusterImpl clusterImpl;
    private final Set<Address> failedConnections = new CopyOnWriteArraySet<Address>();
    private final NodeShutdownHookThread shutdownHookThread = new NodeShutdownHookThread("hz.ShutdownThread");
    private final boolean superClient;
    private final NodeType localNodeType;
    final NodeBaseVariables baseVariables;
    public final ConcurrentMapManager concurrentMapManager;
    public final BlockingQueueManager blockingQueueManager;
    public final ClusterManager clusterManager;
    public final TopicManager topicManager;
    public final ListenerManager listenerManager;
    public final ClusterService clusterService;
    public final ExecutorManager executorManager;
    public final InSelector inSelector;
    public final OutSelector outSelector;
    public final MulticastService multicastService;
    public final ConnectionManager connectionManager;
    public final ClientService clientService;
    public final TextCommandServiceImpl textCommandService;
    public final Config config;
    public final GroupProperties groupProperties;
    public final ThreadGroup threadGroup;
    final Address address;
    final MemberImpl localMember;
    volatile Address masterAddress = null;
    volatile Thread serviceThread = null;
    public final FactoryImpl factory;
    private final int buildNumber;
    public final LoggingServiceImpl loggingService;
    private final NoneStrictObjectPool<Packet> packetPool;
    private static final AtomicInteger counter = new AtomicInteger();
    private final CpuUtilization cpuUtilization = new CpuUtilization();
    private final ServerSocketChannel serverSocketChannel;
    final int id = counter.incrementAndGet();
    final WanReplicationService wanReplicationService;
    final Joiner joiner;

    public Node(FactoryImpl factory, Config config) {
        this.threadGroup = new ThreadGroup(factory.getName());
        this.factory = factory;
        this.config = config;
        this.groupProperties = new GroupProperties(config);
        this.superClient = config.isSuperClient();
        this.localNodeType = this.superClient ? NodeType.SUPER_CLIENT : NodeType.MEMBER;
        String version = System.getProperty("hazelcast.version", "unknown");
        String build = System.getProperty("hazelcast.build", "unknown");
        if ("unknown".equals(version) || "unknown".equals(build)) {
            try {
                InputStream inRuntimeProperties = Node.class.getClassLoader().getResourceAsStream("hazelcast-runtime.properties");
                if (inRuntimeProperties != null) {
                    Properties runtimeProperties = new Properties();
                    runtimeProperties.load(inRuntimeProperties);
                    version = runtimeProperties.getProperty("hazelcast.version");
                    build = runtimeProperties.getProperty("hazelcast.build");
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        int tmpBuildNumber = 0;
        try {
            tmpBuildNumber = Integer.getInteger("hazelcast.build", -1);
            if (tmpBuildNumber == -1) {
                tmpBuildNumber = Integer.parseInt(build);
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        this.buildNumber = tmpBuildNumber;
        ServerSocketChannel serverSocketChannelTemp = null;
        Address localAddress = null;
        try {
            String preferIPv4Stack = System.getProperty("java.net.preferIPv4Stack");
            String preferIPv6Address = System.getProperty("java.net.preferIPv6Addresses");
            if (preferIPv6Address == null && preferIPv4Stack == null) {
                System.setProperty("java.net.preferIPv4Stack", "true");
            }
            serverSocketChannelTemp = ServerSocketChannel.open();
            AddressPicker addressPicker = new AddressPicker(this, serverSocketChannelTemp);
            localAddress = addressPicker.pickAddress();
            localAddress.setThisAddress(true);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        this.serverSocketChannel = serverSocketChannelTemp;
        this.address = localAddress;
        this.localMember = new MemberImpl(this.address, true, this.localNodeType);
        this.packetPool = new NoneStrictObjectPool<Packet>(2000){

            @Override
            public Packet obtain() {
                return this.createNew();
            }

            @Override
            public boolean release(Packet packet) {
                return true;
            }

            @Override
            public void onObtain(Packet packet) {
            }

            @Override
            public void onRelease(Packet packet) {
            }

            @Override
            public Packet createNew() {
                return new Packet();
            }
        };
        String loggingType = this.groupProperties.LOGGING_TYPE.getString();
        this.loggingService = new LoggingServiceImpl(config.getGroupConfig().getName(), loggingType, this.localMember);
        this.logger = this.loggingService.getLogger(Node.class.getName());
        this.clusterImpl = new ClusterImpl(this, this.localMember);
        this.baseVariables = new NodeBaseVariables(this.address, this.localMember);
        this.clusterService = new ClusterService(this);
        this.clusterService.start();
        this.inSelector = new InSelector(this, this.serverSocketChannel);
        this.outSelector = new OutSelector(this);
        this.connectionManager = new ConnectionManager(this);
        this.clusterManager = new ClusterManager(this);
        this.executorManager = new ExecutorManager(this);
        this.clientService = new ClientService(this);
        this.concurrentMapManager = new ConcurrentMapManager(this);
        this.blockingQueueManager = new BlockingQueueManager(this);
        this.listenerManager = new ListenerManager(this);
        this.topicManager = new TopicManager(this);
        this.textCommandService = new TextCommandServiceImpl(this);
        this.clusterManager.addMember(false, this.localMember);
        ILogger systemLogger = this.getLogger("com.hazelcast.system");
        systemLogger.log(Level.INFO, "Hazelcast " + version + " (" + build + ") starting at " + this.address);
        systemLogger.log(Level.INFO, "Copyright (C) 2008-2011 Hazelcast.com");
        VersionCheck.check(this, build, version);
        Join join = config.getNetworkConfig().getJoin();
        MulticastService mcService = null;
        try {
            if (join.getMulticastConfig().isEnabled()) {
                MulticastSocket multicastSocket = new MulticastSocket(null);
                multicastSocket.setReuseAddress(true);
                multicastSocket.bind(new InetSocketAddress(join.getMulticastConfig().getMulticastPort()));
                multicastSocket.setTimeToLive(32);
                multicastSocket.setInterface(this.address.getInetAddress());
                multicastSocket.setReceiveBufferSize(65536);
                multicastSocket.setSendBufferSize(65536);
                multicastSocket.joinGroup(InetAddress.getByName(join.getMulticastConfig().getMulticastGroup()));
                multicastSocket.setSoTimeout(1000);
                mcService = new MulticastService(this, multicastSocket);
                mcService.addMulticastListener(new NodeMulticastListener(this));
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.multicastService = mcService;
        this.wanReplicationService = new WanReplicationService(this);
        this.joiner = this.createJoiner();
    }

    public void failedConnection(Address address) {
        this.logger.log(Level.FINEST, this.getThisAddress() + " failed connecting to " + address);
        this.failedConnections.add(address);
    }

    public ClusterImpl getClusterImpl() {
        return this.clusterImpl;
    }

    public final NodeType getLocalNodeType() {
        return this.localNodeType;
    }

    public Address getMasterAddress() {
        return this.masterAddress;
    }

    public Address getThisAddress() {
        return this.address;
    }

    public String getName() {
        return this.factory.getName();
    }

    public String getThreadPoolNamePrefix(String poolName) {
        return "hz." + this.id + ".threads." + this.getName() + "." + poolName + ".thread-";
    }

    public void handleInterruptedException(Thread thread, Exception e) {
        this.logger.log(Level.FINEST, thread.getName() + " is interrupted ", e);
    }

    public void checkNodeState() {
        if (this.factory.restarted) {
            throw new IllegalStateException("Hazelcast Instance is restarted!");
        }
        if (!this.isActive()) {
            throw new IllegalStateException("Hazelcast Instance is not active!");
        }
    }

    public final boolean isSuperClient() {
        return this.superClient;
    }

    public boolean joined() {
        return this.joined.get();
    }

    public boolean isMaster() {
        return this.address != null && this.address.equals(this.masterAddress);
    }

    public void setMasterAddress(Address master) {
        if (master != null) {
            this.logger.log(Level.FINE, "** setting master address to " + master.toString());
        }
        this.masterAddress = master;
    }

    public void cleanupServiceThread() {
        this.clusterManager.checkServiceThread();
        this.baseVariables.qServiceThreadPacketCache.clear();
        this.concurrentMapManager.reset();
        this.clusterManager.stop();
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public void shutdown(boolean force) {
        this.logger.log(Level.FINE, "** we are being asked to shutdown when active = " + String.valueOf(this.active));
        while (!force && this.isActive() && this.concurrentMapManager.partitionManager.hasActiveBackupTask()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        if (this.isActive()) {
            long start = System.currentTimeMillis();
            this.joined.set(false);
            this.setActive(false);
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            this.logger.log(Level.FINEST, "Shutting down the clientService");
            this.clientService.shutdown();
            this.logger.log(Level.FINEST, "Shutting down the NIO socket selector for input");
            this.inSelector.shutdown();
            this.logger.log(Level.FINEST, "Shutting down the NIO socket selector for output");
            this.outSelector.shutdown();
            this.logger.log(Level.FINEST, "Shutting down the cluster service");
            this.concurrentMapManager.shutdown();
            this.clusterService.stop();
            this.logger.log(Level.FINEST, "Shutting down the query service");
            if (this.multicastService != null) {
                this.multicastService.stop();
            }
            this.logger.log(Level.FINEST, "Shutting down the connection manager");
            this.connectionManager.shutdown();
            this.logger.log(Level.FINEST, "Shutting down the concurrentMapManager");
            this.logger.log(Level.FINEST, "Shutting down the executorManager");
            this.executorManager.stop();
            this.textCommandService.stop();
            this.masterAddress = null;
            this.packetPool.clear();
            this.logger.log(Level.FINEST, "Shutting down the cluster manager");
            int numThreads = this.threadGroup.activeCount();
            Thread[] threads = new Thread[numThreads * 2];
            numThreads = this.threadGroup.enumerate(threads, false);
            for (int i = 0; i < numThreads; ++i) {
                Thread thread = threads[i];
                this.logger.log(Level.FINEST, "Shutting down thread " + thread.getName());
                thread.interrupt();
            }
            ThreadContext.get().shutdown(this.factory);
            this.logger.log(Level.INFO, "Hazelcast Shutdown is completed in " + (System.currentTimeMillis() - start) + " ms.");
        }
    }

    public void start() {
        this.logger.log(Level.FINEST, "We are asked to start and completelyShutdown is " + String.valueOf(this.completelyShutdown));
        if (this.completelyShutdown) {
            return;
        }
        String prefix = "hz." + this.id + ".";
        Thread inThread = new Thread(this.threadGroup, this.inSelector, prefix + "InThread");
        inThread.setPriority(this.groupProperties.IN_THREAD_PRIORITY.getInteger());
        this.logger.log(Level.FINEST, "Starting thread " + inThread.getName());
        inThread.start();
        Thread outThread = new Thread(this.threadGroup, this.outSelector, prefix + "OutThread");
        outThread.setPriority(this.groupProperties.OUT_THREAD_PRIORITY.getInteger());
        this.logger.log(Level.FINEST, "Starting thread " + outThread.getName());
        outThread.start();
        this.serviceThread = new Thread(this.threadGroup, this.clusterService, prefix + "ServiceThread");
        this.serviceThread.setPriority(this.groupProperties.SERVICE_THREAD_PRIORITY.getInteger());
        this.logger.log(Level.FINEST, "Starting thread " + this.serviceThread.getName());
        this.serviceThread.start();
        if (this.config.getNetworkConfig().getJoin().getMulticastConfig().isEnabled()) {
            Thread multicastServiceThread = new Thread(this.threadGroup, this.multicastService, prefix + "MulticastThread");
            multicastServiceThread.start();
        }
        this.setActive(true);
        if (!this.completelyShutdown) {
            this.logger.log(Level.FINEST, "Adding ShutdownHook");
            Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
        }
        this.logger.log(Level.FINEST, "finished starting threads, calling join");
        this.join();
        int clusterSize = this.clusterImpl.getMembers().size();
        if (this.address.getPort() >= this.config.getPort() + clusterSize) {
            StringBuilder sb = new StringBuilder("Config seed port is ");
            sb.append(this.config.getPort());
            sb.append(" and cluster size is ");
            sb.append(clusterSize);
            sb.append(". Some of the ports seem occupied!");
            this.logger.log(Level.WARNING, sb.toString());
        }
    }

    public ILogger getLogger(String name) {
        return this.loggingService.getLogger(name);
    }

    public NoneStrictObjectPool<Packet> getPacketPool() {
        return this.packetPool;
    }

    public GroupProperties getGroupProperties() {
        return this.groupProperties;
    }

    public TextCommandService getTextCommandService() {
        return this.textCommandService;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOutOfMemory(OutOfMemoryError e) {
        try {
            if (this.serverSocketChannel != null) {
                try {
                    this.serverSocketChannel.close();
                    this.connectionManager.shutdown();
                    this.shutdown(true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        finally {
            this.active = false;
            this.outOfMemory = true;
            e.printStackTrace();
        }
    }

    public Set<Address> getFailedConnections() {
        return this.failedConnections;
    }

    public void setJoined() {
        this.joined.set(true);
    }

    public JoinInfo createJoinInfo() {
        return new JoinInfo(this.getLogger(JoinInfo.class.getName()), true, this.address, this.config, this.getLocalNodeType(), Packet.PACKET_VERSION, this.buildNumber, this.clusterImpl.getMembers().size(), 0);
    }

    public boolean validateJoinRequest(JoinRequest joinRequest) throws Exception {
        boolean valid;
        boolean bl = valid = Packet.PACKET_VERSION == joinRequest.packetVersion && this.buildNumber == joinRequest.buildNumber;
        if (valid) {
            try {
                valid = this.config.isCompatible(joinRequest.config);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Invalid join request, reason:" + e.getMessage());
                throw e;
            }
        }
        return valid;
    }

    void rejoin() {
        this.masterAddress = null;
        this.joined.set(false);
        this.clusterImpl.reset();
        this.failedConnections.clear();
        this.join();
    }

    void join() {
        try {
            if (this.joiner == null) {
                this.logger.log(Level.WARNING, "No join method is enabled! Starting standalone.");
                this.setAsMaster();
            } else {
                this.joiner.join(this.joined);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, e.getMessage());
            this.factory.lifecycleService.restart();
        }
    }

    Joiner getJoiner() {
        return this.joiner;
    }

    Joiner createJoiner() {
        Join join = this.config.getNetworkConfig().getJoin();
        if (join.getMulticastConfig().isEnabled() && this.multicastService != null) {
            return new MulticastJoiner(this);
        }
        if (join.getTcpIpConfig().isEnabled()) {
            return new TcpIpJoiner(this);
        }
        if (join.getAwsConfig().isEnabled()) {
            try {
                Class<?> clazz = Class.forName("com.hazelcast.impl.TcpIpJoinerOverAWS");
                Constructor<?> constructor = clazz.getConstructor(Node.class);
                return (Joiner)constructor.newInstance(this);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, e.getMessage());
                return null;
            }
        }
        return null;
    }

    void setAsMaster() {
        this.logger.log(Level.FINEST, "This node is being set as the master");
        this.masterAddress = this.address;
        this.logger.log(Level.FINEST, "adding member myself");
        this.clusterManager.enqueueAndWait(new Processable(){

            public void process() {
                Node.this.clusterManager.addMember(Node.this.address, Node.this.getLocalNodeType());
                Node.this.clusterImpl.setMembers(Node.this.baseVariables.lsMembers);
            }
        }, 5);
        this.setJoined();
    }

    public Config getConfig() {
        return this.config;
    }

    public ExecutorManager getExecutorManager() {
        return this.executorManager;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isOutOfMemory() {
        return this.outOfMemory;
    }

    public CpuUtilization getCpuUtilization() {
        return this.cpuUtilization;
    }

    public String toString() {
        return "Node[" + this.getName() + "]";
    }

    public class NodeShutdownHookThread
    extends Thread {
        NodeShutdownHookThread(String name) {
            super(name);
        }

        public void run() {
            try {
                if (Node.this.isActive() && !Node.this.completelyShutdown) {
                    Node.this.completelyShutdown = true;
                    if (Node.this.groupProperties.SHUTDOWNHOOK_ENABLED.getBoolean()) {
                        Node.this.shutdown();
                    }
                } else {
                    Node.this.logger.log(Level.FINEST, "shutdown hook - we are not --> active and not completely down so we are not calling shutdown");
                }
            }
            catch (Exception e) {
                Node.this.logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }
}

