/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.logging;

import com.hazelcast.core.Member;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LogEvent;
import com.hazelcast.logging.LogListener;
import com.hazelcast.logging.Logger;
import com.hazelcast.logging.LoggingService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LoggingServiceImpl
implements LoggingService {
    private final Member thisMember;
    private final String groupName;
    private final CopyOnWriteArrayList<LogListenerRegistration> lsListeners = new CopyOnWriteArrayList();
    private final ConcurrentMap<String, ILogger> mapLoggers = new ConcurrentHashMap<String, ILogger>(100);
    private volatile Level minLevel = Level.OFF;

    public LoggingServiceImpl(String groupName, Member thisMember) {
        this.groupName = groupName;
        this.thisMember = thisMember;
    }

    public ILogger getLogger(String name) {
        DefaultLogger newLogger;
        ILogger logger = (ILogger)this.mapLoggers.get(name);
        if (logger == null && (logger = this.mapLoggers.putIfAbsent(name, newLogger = new DefaultLogger(name))) == null) {
            logger = newLogger;
        }
        return logger;
    }

    public void addLogListener(Level level, LogListener logListener) {
        this.lsListeners.add(new LogListenerRegistration(level, logListener));
        if (level.intValue() < this.minLevel.intValue()) {
            this.minLevel = level;
        }
    }

    public void removeLogListener(LogListener logListener) {
        this.lsListeners.remove(new LogListenerRegistration(Level.ALL, logListener));
    }

    void handleLogEvent(LogEvent logEvent) {
        for (LogListenerRegistration logListenerRegistration : this.lsListeners) {
            if (logEvent.getLogRecord().getLevel().intValue() < logListenerRegistration.getLevel().intValue()) continue;
            logListenerRegistration.getLogListener().log(logEvent);
        }
    }

    class DefaultLogger
    implements ILogger {
        final String name;
        final ILogger logger;

        DefaultLogger(String name) {
            this.name = name;
            this.logger = Logger.getLogger(name);
        }

        public void log(Level level, String message) {
            this.log(level, message, null);
        }

        public void log(Level level, String message, Throwable thrown) {
            boolean loggable = this.logger.isLoggable(level);
            if (loggable || level.intValue() >= LoggingServiceImpl.this.minLevel.intValue()) {
                message = LoggingServiceImpl.this.thisMember.getInetSocketAddress() + " [" + LoggingServiceImpl.this.groupName + "] " + message;
                LogRecord logRecord = new LogRecord(level, message);
                logRecord.setThrown(thrown);
                logRecord.setLoggerName(this.name);
                logRecord.setSourceClassName(this.name);
                LogEvent logEvent = new LogEvent(logRecord, LoggingServiceImpl.this.groupName, LoggingServiceImpl.this.thisMember);
                if (loggable) {
                    this.logger.log(logEvent);
                }
                if (LoggingServiceImpl.this.lsListeners.size() > 0) {
                    LoggingServiceImpl.this.handleLogEvent(logEvent);
                }
            }
        }

        public void log(LogEvent logEvent) {
            LoggingServiceImpl.this.handleLogEvent(logEvent);
        }

        public Level getLevel() {
            return this.logger.getLevel();
        }

        public boolean isLoggable(Level level) {
            return this.logger.isLoggable(level);
        }
    }

    class LogListenerRegistration {
        Level level;
        LogListener logListener;

        LogListenerRegistration(Level level, LogListener logListener) {
            this.level = level;
            this.logListener = logListener;
        }

        public Level getLevel() {
            return this.level;
        }

        public LogListener getLogListener() {
            return this.logListener;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LogListenerRegistration other = (LogListenerRegistration)obj;
            return !(this.logListener == null ? other.logListener != null : !this.logListener.equals(other.logListener));
        }
    }
}

