/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.impl.Node;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.SelectionHandler;
import com.hazelcast.util.ThreadWatcher;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public abstract class SelectorBase
implements Runnable {
    protected final ILogger logger;
    protected final Selector selector;
    protected final Queue<Runnable> selectorQueue = new ConcurrentLinkedQueue<Runnable>();
    protected final Node node;
    private final int waitTime;
    protected boolean live = true;
    protected final ThreadWatcher threadWatcher = new ThreadWatcher();
    static final long TEN_SECOND_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    private long lastPublish = 0L;

    public SelectorBase(Node node, int waitTime) {
        this.node = node;
        this.logger = node.getLogger(this.getClass().getName());
        this.waitTime = waitTime;
        Selector selectorTemp = null;
        try {
            selectorTemp = Selector.open();
        }
        catch (IOException e) {
            this.handleSelectorException(e);
        }
        this.selector = selectorTemp;
        this.live = true;
    }

    public void shutdown() {
        if (this.selectorQueue != null) {
            this.selectorQueue.clear();
        }
        try {
            final CountDownLatch l = new CountDownLatch(1);
            this.addTask(new Runnable(){

                public void run() {
                    SelectorBase.this.live = false;
                    SelectorBase.this.threadLocalShutdown();
                    l.countDown();
                }
            });
            l.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void threadLocalShutdown() {
    }

    public void addTask(Runnable runnable) {
        this.selectorQueue.offer(runnable);
    }

    public void processSelectionQueue() {
        while (this.live) {
            Runnable runnable = this.selectorQueue.poll();
            if (runnable == null) {
                return;
            }
            runnable.run();
        }
    }

    public abstract void publishUtilization();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run() {
        try {
            ThreadContext.get().setCurrentFactory(this.node.factory);
            block24: while (true) {
                if (this.live == false) return;
                this.threadWatcher.incrementRunCount();
                currentMillis = System.currentTimeMillis();
                if (currentMillis - this.lastPublish > SelectorBase.TEN_SECOND_MILLIS) {
                    this.publishUtilization();
                    this.lastPublish = currentMillis;
                }
                this.processSelectionQueue();
                if (!this.live) {
                    return;
                }
                startWait = System.nanoTime();
                selectedKeyCount = this.selector.select(this.waitTime);
                now = System.nanoTime();
                this.threadWatcher.addWait(now - startWait, now);
                if (Thread.interrupted()) {
                    this.node.handleInterruptedException(Thread.currentThread(), new RuntimeException());
                    return;
                }
                if (selectedKeyCount == 0) continue;
                setSelectedKeys = this.selector.selectedKeys();
                it = setSelectedKeys.iterator();
                while (true) {
                    if (it.hasNext()) ** break;
                    continue block24;
                    sk = it.next();
                    try {
                        it.remove();
                        if (!sk.isValid()) continue;
                        sk.interestOps(sk.interestOps() & ~sk.readyOps());
                        selectionHandler = (SelectionHandler)sk.attachment();
                        selectionHandler.handle();
                    }
                    catch (Throwable e) {
                        this.handleSelectorException(e);
                    }
                }
                break;
            }
        }
        catch (OutOfMemoryError e) {
            this.node.onOutOfMemory(e);
            return;
        }
        catch (Throwable e) {
            this.logger.log(Level.WARNING, "unhandled exception in " + Thread.currentThread().getName(), e);
            return;
        }
        finally {
            try {
                this.logger.log(Level.FINE, "closing selector " + Thread.currentThread().getName());
                this.selector.close();
            }
            catch (Exception ignored) {}
        }
    }

    protected void handleSelectorException(Throwable e) {
        String msg = "Selector exception at  " + Thread.currentThread().getName() + ", cause= " + e.toString();
        this.logger.log(Level.WARNING, msg, e);
    }

    protected void initSocket(Socket socket) throws Exception {
        socket.setSoLinger(true, 1);
        socket.setKeepAlive(this.node.connectionManager.SOCKET_KEEP_ALIVE);
        socket.setTcpNoDelay(this.node.connectionManager.SOCKET_NO_DELAY);
        socket.setReceiveBufferSize(this.node.connectionManager.SOCKET_RECEIVE_BUFFER_SIZE);
        socket.setSendBufferSize(this.node.connectionManager.SOCKET_SEND_BUFFER_SIZE);
    }

    protected Connection createConnection(SocketChannel socketChannel, boolean acceptor) {
        return this.node.connectionManager.createConnection(socketChannel, acceptor);
    }
}

