/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.nio.Address;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterImpl
implements Cluster {
    final CopyOnWriteArraySet<MembershipListener> listeners = new CopyOnWriteArraySet();
    final AtomicReference<Set<Member>> members = new AtomicReference();
    final AtomicReference<Member> localMember = new AtomicReference();
    final Map<Member, Member> clusterMembers = new ConcurrentHashMap<Member, Member>();
    final Map<Address, Member> mapMembers = new ConcurrentHashMap<Address, Member>();
    volatile long clusterTimeDiff = Long.MAX_VALUE;
    final Node node;

    public ClusterImpl(Node node, MemberImpl thisMember) {
        this.node = node;
        this.setMembers(Arrays.asList(thisMember));
    }

    public void reset() {
        this.mapMembers.clear();
        this.clusterMembers.clear();
        this.members.set(null);
        this.setMembers(Arrays.asList((MemberImpl)this.localMember.get()));
    }

    public void setMembers(List<MemberImpl> lsMembers) {
        LinkedHashSet<Member> setNew = new LinkedHashSet<Member>(lsMembers.size());
        ArrayList<Runnable> notifications = new ArrayList<Runnable>();
        for (MemberImpl memberImpl : lsMembers) {
            if (memberImpl == null) continue;
            final MemberImpl dummy = new MemberImpl(memberImpl.getAddress(), memberImpl.localMember(), memberImpl.getNodeType());
            Member clusterMember = this.clusterMembers.get(dummy);
            if (clusterMember == null) {
                clusterMember = dummy;
                if (this.listeners.size() > 0) {
                    notifications.add(new Runnable(){

                        public void run() {
                            MembershipEvent membershipEvent = new MembershipEvent(ClusterImpl.this, dummy, 1);
                            for (MembershipListener listener : ClusterImpl.this.listeners) {
                                listener.memberAdded(membershipEvent);
                            }
                        }
                    });
                }
            }
            if (clusterMember.localMember()) {
                this.localMember.set(clusterMember);
            }
            setNew.add(clusterMember);
        }
        if (this.listeners.size() > 0) {
            Set<Member> it = this.clusterMembers.keySet();
            for (final Member member : it) {
                if (setNew.contains(member)) continue;
                notifications.add(new Runnable(){

                    public void run() {
                        MembershipEvent membershipEvent = new MembershipEvent(ClusterImpl.this, member, 3);
                        for (MembershipListener listener : ClusterImpl.this.listeners) {
                            listener.memberRemoved(membershipEvent);
                        }
                    }
                });
            }
        }
        this.clusterMembers.clear();
        this.mapMembers.clear();
        for (Member member : setNew) {
            this.mapMembers.put(((MemberImpl)member).getAddress(), member);
            this.clusterMembers.put(member, member);
        }
        this.members.set(Collections.unmodifiableSet(setNew));
        for (Runnable runnable : notifications) {
            this.node.executorManager.getEventExecutorService().execute(runnable);
        }
    }

    @Override
    public void addMembershipListener(MembershipListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeMembershipListener(MembershipListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Member getLocalMember() {
        return this.localMember.get();
    }

    @Override
    public Set<Member> getMembers() {
        return this.members.get();
    }

    @Override
    public long getClusterTime() {
        return System.currentTimeMillis() + (this.clusterTimeDiff == Long.MAX_VALUE ? 0L : this.clusterTimeDiff);
    }

    public void setMasterTime(long masterTime) {
        long diff = masterTime - System.currentTimeMillis();
        if (Math.abs(diff) < Math.abs(this.clusterTimeDiff)) {
            this.clusterTimeDiff = diff;
        }
    }

    public long getClusterTimeFor(long localTime) {
        return localTime + (this.clusterTimeDiff == Long.MAX_VALUE ? 0L : this.clusterTimeDiff);
    }

    public Member getMember(Address address) {
        return this.mapMembers.get(address);
    }

    public String toString() {
        Set<Member> members = this.getMembers();
        StringBuffer sb = new StringBuffer("Cluster [");
        if (members != null) {
            sb.append(members.size());
            sb.append("] {");
            for (Member member : members) {
                sb.append("\n\t").append(member);
            }
        }
        sb.append("\n}\n");
        return sb.toString();
    }
}

