/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.JoinInfo;
import com.hazelcast.config.Config;
import com.hazelcast.core.Member;
import com.hazelcast.impl.Joiner;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.Processable;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJoiner
implements Joiner {
    protected final Config config;
    protected final Node node;
    protected volatile ILogger logger;
    private final AtomicInteger tryCount = new AtomicInteger(0);

    public AbstractJoiner(Node node) {
        this.node = node;
        if (node.loggingService != null) {
            this.logger = node.loggingService.getLogger(this.getClass().getName());
        }
        this.config = node.config;
    }

    public abstract void doJoin(AtomicBoolean var1);

    @Override
    public void join(AtomicBoolean joined) {
        this.doJoin(joined);
        this.postJoin();
    }

    private void postJoin() {
        if (!this.node.isActive()) {
            return;
        }
        if (this.tryCount.incrementAndGet() == 5) {
            this.node.setAsMaster();
        }
        if (!this.node.isMaster()) {
            boolean allConnected = false;
            int checkCount = 0;
            if (this.node.joined()) {
                while (checkCount++ < this.node.groupProperties.CONNECT_ALL_WAIT_SECONDS.getInteger() && !allConnected) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignored) {
                        // empty catch block
                    }
                    Set<Member> members = this.node.getClusterImpl().getMembers();
                    allConnected = true;
                    for (Member member : members) {
                        MemberImpl memberImpl = (MemberImpl)member;
                        if (memberImpl.localMember() || this.node.connectionManager.getConnection(memberImpl.getAddress()) != null) continue;
                        allConnected = false;
                    }
                }
            }
            if (!this.node.joined() || !allConnected) {
                this.logger.log(Level.WARNING, "Failed to connect, node joined= " + this.node.joined() + ", allConnected= " + allConnected + " to all other members after " + checkCount + " seconds.");
                this.logger.log(Level.WARNING, "Rebooting after 10 seconds.");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    this.node.shutdown(false, true);
                }
                this.node.rejoin();
                return;
            }
            this.node.clusterManager.finalizeJoin();
        }
        this.node.clusterManager.enqueueAndWait(new Processable(){

            public void process() {
                if (AbstractJoiner.this.node.baseVariables.lsMembers.size() == 1) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("\n");
                    sb.append(AbstractJoiner.this.node.clusterManager);
                    AbstractJoiner.this.logger.log(Level.INFO, sb.toString());
                }
            }
        }, 5);
    }

    protected void failedJoiningToMaster(boolean multicast, int tryCount) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("===========================");
        sb.append("\n");
        sb.append("Couldn't connect to discovered master! tryCount: ").append(tryCount);
        sb.append("\n");
        sb.append("address: ").append(this.node.address);
        sb.append("\n");
        sb.append("masterAddress: ").append(this.node.getMasterAddress());
        sb.append("\n");
        sb.append("multicast: ").append(multicast);
        sb.append("\n");
        sb.append("connection: ").append(this.node.connectionManager.getConnection(this.node.getMasterAddress()));
        sb.append("===========================");
        sb.append("\n");
        throw new IllegalStateException(sb.toString());
    }

    boolean shouldMerge(JoinInfo joinInfo) {
        boolean shouldMerge = false;
        if (joinInfo != null) {
            try {
                boolean validJoinRequest;
                try {
                    validJoinRequest = this.node.validateJoinRequest(joinInfo);
                }
                catch (Exception e) {
                    validJoinRequest = false;
                }
                if (validJoinRequest) {
                    for (Member member : this.node.getClusterImpl().getMembers()) {
                        MemberImpl memberImpl = (MemberImpl)member;
                        if (!memberImpl.getAddress().equals(joinInfo.address)) continue;
                        return false;
                    }
                    int currentMemberCount = this.node.getClusterImpl().getMembers().size();
                    if (joinInfo.getMemberCount() > currentMemberCount) {
                        this.logger.log(Level.FINEST, this.node.address + "Merging because : joinInfo.getMemberCount() > currentMemberCount" + joinInfo + ", this node member count: " + this.node.getClusterImpl().getMembers().size());
                        shouldMerge = true;
                    } else if (joinInfo.getMemberCount() == currentMemberCount && this.node.getThisAddress().hashCode() > joinInfo.address.hashCode()) {
                        this.logger.log(Level.FINEST, this.node.address + "Merging because : node.getThisAddress().hashCode() > joinInfo.address.hashCode()" + joinInfo + ", this node member count: " + this.node.getClusterImpl().getMembers().size());
                        shouldMerge = true;
                    }
                }
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                return false;
            }
        }
        return shouldMerge;
    }

    protected void connectAndSendJoinRequest(Collection<Address> colPossibleAddresses) {
        if (this.node.getFailedConnections().size() > 0) {
            for (Address possibleAddress : colPossibleAddresses) {
                Connection conn = this.node.connectionManager.getOrConnect(possibleAddress);
                if (conn == null) continue;
                this.logger.log(Level.FINEST, "sending join request for " + possibleAddress);
                this.node.clusterManager.sendJoinRequest(possibleAddress, true);
            }
        }
    }
}

